/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.authority;

import com.netscape.certsrv.authority.AuthorityClient;
import com.netscape.certsrv.authority.AuthorityData;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.authority.AuthorityCreateCLI;
import com.netscape.cmstools.authority.AuthorityDisableCLI;
import com.netscape.cmstools.authority.AuthorityEnableCLI;
import com.netscape.cmstools.authority.AuthorityFindCLI;
import com.netscape.cmstools.authority.AuthorityKeyExportCLI;
import com.netscape.cmstools.authority.AuthorityRemoveCLI;
import com.netscape.cmstools.authority.AuthorityShowCLI;
import com.netscape.cmstools.ca.CACLI;
import com.netscape.cmstools.cli.MainCLI;
import java.math.BigInteger;
import org.dogtagpki.cli.CLI;

public class AuthorityCLI
extends CLI {
    public CACLI caCLI;
    public AuthorityClient authorityClient;

    public AuthorityCLI(CACLI caCLI) {
        super("authority", "CA management commands", (CLI)caCLI);
        this.caCLI = caCLI;
        this.addModule((CLI)new AuthorityFindCLI(this));
        this.addModule((CLI)new AuthorityShowCLI(this));
        this.addModule((CLI)new AuthorityCreateCLI(this));
        this.addModule((CLI)new AuthorityDisableCLI(this));
        this.addModule((CLI)new AuthorityEnableCLI(this));
        this.addModule((CLI)new AuthorityRemoveCLI(this));
        this.addModule((CLI)new AuthorityKeyExportCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public AuthorityClient getAuthorityClient() throws Exception {
        if (this.authorityClient != null) {
            return this.authorityClient;
        }
        PKIClient client = this.getClient();
        this.authorityClient = new AuthorityClient(client, "ca");
        return this.authorityClient;
    }

    protected static void printAuthorityData(AuthorityData data) {
        BigInteger serial;
        String issuerDN;
        Boolean isHostAuthority = data.getIsHostAuthority();
        if (isHostAuthority != null && isHostAuthority.booleanValue()) {
            System.out.println("  Host authority: true");
        }
        System.out.println("  Authority DN:   " + data.getDN());
        System.out.println("  ID:             " + data.getID());
        String parentAID = data.getParentID();
        if (parentAID != null) {
            System.out.println("  Parent ID:      " + parentAID);
        }
        if ((issuerDN = data.getIssuerDN()) != null) {
            System.out.println("  Issuer DN:      " + issuerDN);
        }
        if ((serial = data.getSerial()) != null) {
            CertId certID = new CertId(serial);
            System.out.println("  Serial no:      " + certID.toHexString());
        }
        System.out.println("  Enabled:        " + data.getEnabled());
        System.out.println("  Ready to sign:  " + data.getReady());
        String desc = data.getDescription();
        if (desc != null) {
            System.out.println("  Description:    " + desc);
        }
    }
}

