/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.ca.CACertCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.FileOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.ca.CASystemCertClient;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertSubsystemExportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertSubsystemExportCLI.class);
    public CACertCLI certCLI;

    public CACertSubsystemExportCLI(CACertCLI certCLI) {
        super("subsystem-export", "Export CA subsystem certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output-format", true, "Output format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "output-file", true, "Output file");
        option.setArgName("file");
        this.options.addOption(option);
        this.options.addOption(null, "pkcs7", false, "Export PKCS #7 certificate chain");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(CommandLine cmd) throws Exception {
        byte[] bytes;
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = this.getClient();
        CASystemCertClient certClient = new CASystemCertClient(client, "ca");
        CertData certData = certClient.getSubsystemCert();
        String outputFormat = cmd.getOptionValue("output-format");
        if (cmd.hasOption("pkcs7")) {
            String certChain = certData.getPkcs7CertChain();
            PKCS7 pkcs7 = new PKCS7(Utils.base64decode((String)certChain));
            if (outputFormat == null || "PEM".equalsIgnoreCase(outputFormat)) {
                bytes = pkcs7.toPEMString().getBytes();
            } else {
                if (!"DER".equalsIgnoreCase(outputFormat)) throw new Exception("Unsupported format: " + outputFormat);
                bytes = pkcs7.getBytes();
            }
        } else if (outputFormat == null || "PEM".equalsIgnoreCase(outputFormat)) {
            bytes = certData.getEncoded().getBytes();
        } else {
            if (!"DER".equalsIgnoreCase(outputFormat)) throw new Exception("Unsupported format: " + outputFormat);
            bytes = Cert.parseCertificate((String)certData.getEncoded());
        }
        String outputFile = cmd.getOptionValue("output-file");
        if (outputFile != null) {
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                out.write(bytes);
                return;
            }
        } else {
            System.out.write(bytes);
        }
    }
}

