/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CMCUserSignedRequestSigVerifyEvent;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.pkcs11.PK11ECPublicKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.RevokeRequest;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCUserSignedAuth
extends AuthManager
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMCUserSignedAuth.class);
    boolean selfSigned = false;
    SubjectKeyIdentifierExtension selfsign_skiExtn = null;
    PK11PubKey selfsign_pubK = null;
    byte[] selfsign_digest = null;
    public static final String TOKEN_CERT_SERIAL = "certSerialToRevoke";
    public static final String REASON_CODE = "reasonCode";
    public static final String CRED_CMC = "cmcRequest";
    protected static String[] mRequiredCreds = new String[0];
    protected static Vector<String> mExtendedPluginInfo = null;
    private static final String SIGNED_AUDIT_ENROLLMENT_REQUEST_TYPE = "enrollment";
    private static final String SIGNED_AUDIT_REVOCATION_REQUEST_TYPE = "revocation";

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
    }

    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        String method = "CMCUserSignedAuth: authenticate: ";
        Object msg = "";
        logger.debug(method + "begins");
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.getAuditSubjectID();
        String auditReqType = "$Unidentified$";
        String requestCertSubject = "$Unidentified$";
        String auditSignerInfo = "$Unidentified$";
        SessionContext auditContext = SessionContext.getExistingContext();
        X509Certificate clientCert = (X509Certificate)auditContext.get((Object)"sslClientCert");
        if (clientCert != null) {
            try {
                this.createAuditSubjectFromCert(auditContext, clientCert);
            }
            catch (IOException e) {
                logger.warn("CMSUserSignedAuth: authenticate: after createAuditSubjectFromCert call: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            String cmc;
            ArgBlock argblock = authCred.getArgBlock();
            Object returnVal = null;
            if (argblock == null) {
                returnVal = authCred.get("cert_request");
                if (returnVal == null) {
                    returnVal = authCred.get(CRED_CMC);
                }
            } else {
                returnVal = authCred.get("cert_request");
                if (returnVal == null) {
                    returnVal = authCred.getArgBlock().get(CRED_CMC);
                }
            }
            if ((cmc = (String)returnVal) == null) {
                logger.error(method + " Authentication failed. Missing CMC.");
                throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{CRED_CMC}));
            }
            if (cmc.equals("")) {
                msg = "attempted login with empty cert_request in authCred.";
                logger.error(method + (String)msg);
                throw new EInvalidCredentials((String)msg);
            }
            AuthToken authToken = new AuthToken((AuthManager)this);
            try {
                byte[] cmcBlob = CertUtil.parseCSR((String)cmc);
                ByteArrayInputStream cmcBlobIn = new ByteArrayInputStream(cmcBlob);
                ContentInfo cmcReq = (ContentInfo)ContentInfo.getTemplate().decode((InputStream)cmcBlobIn);
                String userid = "$Unidentified$";
                String uid = "$Unidentified$";
                SignedData cmcFullReq = null;
                OCTET_STRING content = null;
                OBJECT_IDENTIFIER id = null;
                SignerInfo selfsign_signerInfo = null;
                if (cmcReq.getContentType().equals((Object)ContentInfo.SIGNED_DATA)) {
                    logger.debug(method + "cmc request content is signed data");
                    cmcFullReq = (SignedData)cmcReq.getInterpretedContent();
                    boolean checkSignerInfo = cs.getBoolean("cmc.signerInfo.verify", true);
                    if (checkSignerInfo) {
                        AuthToken userToken = this.verifySignerInfo(auditContext, authToken, cmcFullReq);
                        if (userToken == null) {
                            msg = "userToken null; verifySignerInfo failure";
                            logger.error(method + (String)msg);
                            throw new EBaseException((String)msg);
                        }
                        if (this.selfSigned) {
                            logger.debug(method + " self-signed cmc request will not have user identification info at this point.");
                            auditSignerInfo = "selfSigned";
                        } else {
                            logger.debug(method + "signed with user cert");
                            userid = userToken.getInString("userid");
                            uid = userToken.getInString("id");
                            if (userid == null && uid == null) {
                                msg = " verifySignerInfo failure... missing id";
                                logger.error(method + (String)msg);
                                throw new EBaseException((String)msg);
                            }
                            if (uid != null && !uid.equals("$Unidentified$")) {
                                auditSubjectID = uid.trim();
                                authToken.set("userid", auditSubjectID);
                            } else if (userid != null && !userid.equals("$Unidentified$")) {
                                auditSubjectID = userid.trim();
                                authToken.set("userid", auditSubjectID);
                            }
                        }
                    } else {
                        logger.debug(method + " signerInfo verification bypassed");
                    }
                    EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
                    SET sis = cmcFullReq.getSignerInfos();
                    selfsign_signerInfo = (SignerInfo)sis.elementAt(0);
                    id = ci.getContentType();
                    if (!id.equals((Object)OBJECT_IDENTIFIER.id_cct_PKIData) || !ci.hasContent()) {
                        msg = "request EncapsulatedContentInfo content type not OBJECT_IDENTIFIER.id_cct_PKIData";
                        logger.error(method + (String)msg);
                        throw new EBaseException((String)msg);
                    }
                    content = ci.getContent();
                } else if (cmcReq.getContentType().equals((Object)ContentInfo.DATA)) {
                    logger.debug(method + "cmc request content is unsigned data...verifySignerInfo will not be called;");
                    content = (OCTET_STRING)cmcReq.getInterpretedContent();
                } else {
                    cmcBlobIn.close();
                    msg = "unsupported cmc rquest content type; must be either ContentInfo.SIGNED_DATA or ContentInfo.DATA;";
                    logger.error((String)msg);
                    throw new EBaseException((String)msg);
                }
                ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
                PKIData pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
                SEQUENCE reqSequence = pkiData.getReqSequence();
                int numReqs = reqSequence.size();
                if (numReqs == 0) {
                    logger.debug(method + "numReqs 0, assume revocation request");
                    auditReqType = SIGNED_AUDIT_REVOCATION_REQUEST_TYPE;
                    SEQUENCE controlSequence = pkiData.getControlSequence();
                    int controlSize = controlSequence.size();
                    if (controlSize > 0) {
                        for (int i = 0; i < controlSize; ++i) {
                            TaggedAttribute taggedAttribute = (TaggedAttribute)controlSequence.elementAt(i);
                            OBJECT_IDENTIFIER type = taggedAttribute.getType();
                            if (!type.equals((Object)OBJECT_IDENTIFIER.id_cmc_revokeRequest)) continue;
                            SET values = taggedAttribute.getValues();
                            int numVals = values.size();
                            BigInteger[] bigIntArray = null;
                            bigIntArray = new BigInteger[numVals];
                            for (int j = 0; j < numVals; ++j) {
                                byte[] encoded = ASN1Util.encode((ASN1Value)values.elementAt(j));
                                RevokeRequest.Template template = new RevokeRequest.Template();
                                RevokeRequest revRequest = (RevokeRequest)ASN1Util.decode((ASN1Template)template, (byte[])encoded);
                                INTEGER temp = revRequest.getSerialNumber();
                                bigIntArray[j] = temp;
                                authToken.set(TOKEN_CERT_SERIAL, bigIntArray);
                                long reasonCode = revRequest.getReason().getValue();
                                Integer IntObject = (int)reasonCode;
                                authToken.set(REASON_CODE, IntObject);
                                ANY issuerANY = revRequest.getIssuerName();
                                if (issuerANY == null) continue;
                                CertificateAuthority ca = caEngine.getCA();
                                X500Name caName = ca.getX500Name();
                                try {
                                    byte[] issuerBytes = issuerANY.getEncoded();
                                    X500Name reqIssuerName = new X500Name(issuerBytes);
                                    String reqIssuerNameStr = reqIssuerName.getName();
                                    logger.debug(method + "revRequest issuer name = " + reqIssuerNameStr);
                                    if (reqIssuerNameStr.equalsIgnoreCase(caName.getName())) {
                                        reqIssuerName = caName;
                                    } else {
                                        logger.debug(method + "revRequest issuer name doesn't match our CA; will be bumped off later;");
                                    }
                                    auditContext.put((Object)"cmcISSUERPrincipal", (Object)reqIssuerName);
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.warn(method + "failed getting issuer from RevokeRequest: " + e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                } else {
                    logger.debug(method + "numReqs not 0, assume enrollment request");
                    auditReqType = SIGNED_AUDIT_ENROLLMENT_REQUEST_TYPE;
                    X509CertInfo[] certInfoArray = new X509CertInfo[numReqs];
                    String[] reqIdArray = new String[numReqs];
                    for (int i = 0; i < numReqs; ++i) {
                        TaggedRequest taggedRequest = (TaggedRequest)reqSequence.elementAt(i);
                        TaggedRequest.Type type = taggedRequest.getType();
                        if (type.equals(TaggedRequest.PKCS10)) {
                            logger.debug(method + " type is PKCS10");
                            authToken.set("cert_request_type", "cmc-pkcs10");
                            TaggedCertificationRequest tcr = taggedRequest.getTcr();
                            int p10Id = tcr.getBodyPartID().intValue();
                            reqIdArray[i] = String.valueOf(p10Id);
                            CertificationRequest p10 = tcr.getCertificationRequest();
                            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                            p10.encode((OutputStream)ostream);
                            boolean sigver = true;
                            boolean tokenSwitched = false;
                            CryptoManager cm = null;
                            CryptoToken signToken = null;
                            CryptoToken savedToken = null;
                            sigver = cs.getBoolean("ca.requestVerify.enabled", true);
                            try {
                                cm = CryptoManager.getInstance();
                                if (sigver) {
                                    String tokenName = cs.getString("ca.requestVerify.token", "internal");
                                    savedToken = cm.getThreadToken();
                                    signToken = CryptoUtil.getCryptoToken((String)tokenName);
                                    if (!savedToken.getName().equals(signToken.getName())) {
                                        cm.setThreadToken(signToken);
                                        tokenSwitched = true;
                                    }
                                }
                                PKCS10 pkcs10 = new PKCS10(ostream.toByteArray(), sigver);
                                X500Name tempName = pkcs10.getSubjectName();
                                logger.debug(method + "request subject name=" + tempName.toString());
                                if (tempName != null) {
                                    requestCertSubject = tempName.toString().trim();
                                    if (requestCertSubject.equals("")) {
                                        requestCertSubject = "<null>";
                                    }
                                    authToken.set("tokenCertSubject", requestCertSubject);
                                    auditContext.put((Object)"cmcRequestCertSubject", (Object)requestCertSubject);
                                }
                                if (this.selfSigned) {
                                    try {
                                        this.selfsign_skiExtn = (SubjectKeyIdentifierExtension)CryptoUtil.getExtensionFromPKCS10((PKCS10)pkcs10, (String)"SubjectKeyIdentifier");
                                        if (this.selfsign_skiExtn == null) {
                                            msg = "missing SubjectKeyIdentifierExtension in request";
                                            logger.error(method + (String)msg);
                                            throw new EBaseException((String)msg);
                                        }
                                        logger.debug(method + "SubjectKeyIdentifierExtension found:");
                                    }
                                    catch (IOException e) {
                                        msg = method + "SubjectKeyIdentifierExtension not found:" + e;
                                        logger.error((String)msg);
                                        throw new EBaseException((String)msg);
                                    }
                                    catch (Exception e) {
                                        msg = method + "SubjectKeyIdentifierExtension not found: " + e.getMessage();
                                        logger.error((String)msg, (Throwable)e);
                                        throw new EBaseException((String)msg);
                                    }
                                    X509Key pubKey = pkcs10.getSubjectPublicKeyInfo();
                                    PrivateKey.Type keyType = null;
                                    String alg = pubKey.getAlgorithm();
                                    if (alg.equals("RSA")) {
                                        logger.debug(method + "signing key alg=RSA");
                                        keyType = PrivateKey.RSA;
                                        this.selfsign_pubK = PK11PubKey.fromRaw((PrivateKey.Type)keyType, (byte[])pubKey.getKey());
                                    } else if (alg.equals("EC")) {
                                        logger.debug(method + "signing key alg=EC");
                                        keyType = PrivateKey.EC;
                                        byte[] publicKeyData = pubKey.getEncoded();
                                        this.selfsign_pubK = PK11ECPublicKey.fromSPKI((byte[])publicKeyData);
                                    } else {
                                        msg = "unsupported signature algorithm: " + alg;
                                        logger.error(method + (String)msg);
                                        throw new EInvalidCredentials((String)msg);
                                    }
                                    logger.debug(method + "public key retrieved");
                                    this.verifySelfSignedCMC(selfsign_signerInfo, id);
                                }
                                CertInfo certInfo = new CertInfo();
                                certInfoArray[i] = certInfo;
                                if (!sigver || !tokenSwitched) continue;
                            }
                            catch (Exception e) {
                                try {
                                    e.printStackTrace();
                                    throw new EBaseException(e.toString());
                                }
                                catch (Throwable throwable) {
                                    if (sigver && tokenSwitched) {
                                        cm.setThreadToken(savedToken);
                                    }
                                    throw throwable;
                                }
                            }
                            cm.setThreadToken(savedToken);
                            continue;
                        }
                        if (!type.equals(TaggedRequest.CRMF)) continue;
                        logger.debug(method + " type is CRMF");
                        authToken.set("cert_request_type", "cmc-crmf");
                        try {
                            CertReqMsg crm = taggedRequest.getCrm();
                            CertRequest certReq = crm.getCertReq();
                            INTEGER reqID = certReq.getCertReqId();
                            reqIdArray[i] = reqID.toString();
                            CertTemplate template = certReq.getCertTemplate();
                            Name name = template.getSubject();
                            CertInfo certInfo = new CertInfo();
                            if (name != null) {
                                String ss = name.getRFC1485();
                                logger.debug(method + "setting requestCertSubject to: " + ss);
                                requestCertSubject = ss;
                                if (requestCertSubject.equals("")) {
                                    requestCertSubject = "<null>";
                                }
                                authToken.set("tokenCertSubject", ss);
                                auditContext.put((Object)"cmcRequestCertSubject", (Object)requestCertSubject);
                            }
                            certInfoArray[i] = certInfo;
                            if (!this.selfSigned) continue;
                            this.selfsign_skiExtn = (SubjectKeyIdentifierExtension)CryptoUtil.getExtensionFromCertTemplate((CertTemplate)template, (ObjectIdentifier)PKIXExtensions.SubjectKey_Id);
                            if (this.selfsign_skiExtn != null) {
                                logger.debug(method + "SubjectKeyIdentifierExtension found");
                            } else {
                                logger.debug(method + "SubjectKeyIdentifierExtension not found");
                            }
                            SubjectPublicKeyInfo pkinfo = template.getPublicKey();
                            PrivateKey.Type keyType = null;
                            String alg = pkinfo.getAlgorithm();
                            byte[] publicKeyData = null;
                            if (alg.equals("RSA")) {
                                BIT_STRING bitString = pkinfo.getSubjectPublicKey();
                                publicKeyData = bitString.getBits();
                                logger.debug(method + "signing key alg=RSA");
                                keyType = PrivateKey.RSA;
                                this.selfsign_pubK = PK11PubKey.fromRaw((PrivateKey.Type)keyType, (byte[])publicKeyData);
                            } else if (alg.equals("EC")) {
                                logger.debug(method + "signing key alg=EC");
                                keyType = PrivateKey.EC;
                                X509Key pubKey = CryptoUtil.getX509KeyFromCRMFMsg((CertReqMsg)crm);
                                logger.debug(method + "got X509Key ");
                                publicKeyData = pubKey.getEncoded();
                                this.selfsign_pubK = PK11ECPublicKey.fromSPKI((byte[])publicKeyData);
                            } else {
                                msg = "unsupported signature algorithm: " + alg;
                                logger.error(method + (String)msg);
                                throw new EInvalidCredentials((String)msg);
                            }
                            logger.debug(method + "public key retrieved");
                            this.verifySelfSignedCMC(selfsign_signerInfo, id);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            cmcBlobIn.close();
                            s.close();
                            throw new EBaseException(e.toString());
                        }
                    }
                }
                authToken.set("uid", uid);
                authToken.set("userid", userid);
            }
            catch (EMissingCredential e) {
                throw e;
            }
            catch (EInvalidCredentials e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            if (authToken.get("cmcSigningCert") != null || authToken.get("cmcSelfSigned") != null) {
                auditor.log((LogEvent)CMCUserSignedRequestSigVerifyEvent.createSuccessEvent((String)this.getAuditSubjectID(), (String)auditReqType, (String)this.getRequestCertSubject(auditContext), (String)this.getAuditSignerInfo(auditContext)));
            } else {
                logger.warn(method + "successful CMC_USER_SIGNED_REQUEST_SIG_VERIFY audit event not logged due to unsigned data for revocation with shared secret.");
            }
            logger.debug(method + "ends successfully; returning authToken");
            return authToken;
        }
        catch (EMissingCredential eAudit1) {
            logger.error(method + eAudit1.getMessage(), (Throwable)eAudit1);
            throw eAudit1;
        }
        catch (EInvalidCredentials eAudit2) {
            logger.error(method + eAudit2.getMessage(), (Throwable)eAudit2);
            auditor.log((LogEvent)CMCUserSignedRequestSigVerifyEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)auditReqType, (String)this.getRequestCertSubject(auditContext), (String)this.getAuditSignerInfo(auditContext), (String)eAudit2.toString()));
            throw eAudit2;
        }
        catch (EBaseException eAudit3) {
            logger.error(method + eAudit3.getMessage(), (Throwable)eAudit3);
            auditor.log((LogEvent)CMCUserSignedRequestSigVerifyEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)auditReqType, (String)this.getRequestCertSubject(auditContext), (String)this.getAuditSignerInfo(auditContext), (String)eAudit3.toString()));
            throw eAudit3;
        }
        catch (Exception eAudit4) {
            logger.error(method + eAudit4.getMessage(), (Throwable)eAudit4);
            auditor.log((LogEvent)CMCUserSignedRequestSigVerifyEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)auditReqType, (String)this.getRequestCertSubject(auditContext), (String)this.getAuditSignerInfo(auditContext), (String)eAudit4.toString()));
            throw new EBaseException(eAudit4);
        }
    }

    protected void verifySelfSignedCMC(SignerInfo signerInfo, OBJECT_IDENTIFIER id) throws EBaseException {
        String method = "CMCUserSignedAuth: verifySelfSignedCMC: ";
        logger.debug(method + "begins");
        try {
            SignerIdentifier sid = signerInfo.getSignerIdentifier();
            OCTET_STRING subjKeyId = sid.getSubjectKeyIdentifier();
            KeyIdentifier keyIdObj = (KeyIdentifier)this.selfsign_skiExtn.get("key_id");
            boolean match = CryptoUtil.compare((byte[])subjKeyId.toByteArray(), (byte[])keyIdObj.getIdentifier());
            if (!match) {
                logger.error(method + " SignerIdentifier SUBJECT_KEY_IDENTIFIER failed to match");
                throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
            }
            logger.debug(method + " SignerIdentifier SUBJECT_KEY_IDENTIFIER matches SKI of request");
            logger.debug(method + "verifying request signature with public key");
            signerInfo.verify(this.selfsign_digest, id, (PublicKey)this.selfsign_pubK);
            logger.debug(method + " signature verified");
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + e.toString());
        }
    }

    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    public void shutdown() {
    }

    public String[] getExtendedPluginInfo() {
        String method = "CMCUserSignedAuth: getExtendedPluginInfo: ";
        logger.debug(method + " begins");
        String[] s = Utils.getStringArrayFromVector(mExtendedPluginInfo);
        logger.debug(method + " s.length = " + s.length);
        for (int i = 0; i < s.length; ++i) {
            logger.debug(i + " " + s[i]);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AuthToken verifySignerInfo(SessionContext auditContext, AuthToken authToken, SignedData cmcFullReq) throws EBaseException, EInvalidCredentials, EMissingCredential {
        CryptoManager cm;
        CryptoToken savedToken;
        boolean tokenSwitched;
        String method;
        block34: {
            AuthToken authToken2;
            block33: {
                method = "CMCUserSignedAuth: verifySignerInfo: ";
                Object msg = "";
                logger.debug(method + "begins");
                CAEngine caEngine = (CAEngine)this.engine;
                CAEngineConfig cs = caEngine.getConfig();
                EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
                OBJECT_IDENTIFIER id = ci.getContentType();
                OCTET_STRING content = ci.getContent();
                tokenSwitched = false;
                CryptoToken signToken = null;
                savedToken = null;
                cm = null;
                try {
                    cm = CryptoManager.getInstance();
                    ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
                    PKIData pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
                    SET dais = cmcFullReq.getDigestAlgorithmIdentifiers();
                    int numDig = dais.size();
                    Hashtable<String, byte[]> digs = new Hashtable<String, byte[]>();
                    for (int i = 0; i < numDig; ++i) {
                        AlgorithmIdentifier dai = (AlgorithmIdentifier)dais.elementAt(i);
                        String name = DigestAlgorithm.fromOID((OBJECT_IDENTIFIER)dai.getOID()).toString();
                        MessageDigest md = MessageDigest.getInstance(name);
                        byte[] digest = md.digest(content.toByteArray());
                        digs.put(name, digest);
                    }
                    int i = 0;
                    SET sis = cmcFullReq.getSignerInfos();
                    int numSis = sis.size();
                    if (i < numSis) {
                        SignerIdentifier sid;
                        SignerInfo si = (SignerInfo)sis.elementAt(i);
                        String name = si.getDigestAlgorithm().toString();
                        byte[] digest = (byte[])digs.get(name);
                        if (digest == null) {
                            MessageDigest md = MessageDigest.getInstance(name);
                            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                            pkiData.encode((OutputStream)ostream);
                            digest = md.digest(ostream.toByteArray());
                        }
                        if ((sid = si.getSignerIdentifier()).getType().equals(SignerIdentifier.ISSUER_AND_SERIALNUMBER)) {
                            logger.debug(method + "SignerIdentifier type: ISSUER_AND_SERIALNUMBER");
                            this.selfSigned = false;
                            logger.debug(method + "selfSigned is false");
                            IssuerAndSerialNumber issuerAndSerialNumber = sid.getIssuerAndSerialNumber();
                            X509Certificate cert = null;
                            if (!cmcFullReq.hasCertificates()) {
                                msg = "no certificate found in cmcFullReq";
                                logger.error(method + (String)msg);
                                throw new EMissingCredential((String)msg);
                            }
                            SET certs = cmcFullReq.getCertificates();
                            int numCerts = certs.size();
                            X509Certificate[] x509Certs = new X509Certificate[1];
                            for (int j = 0; j < numCerts; ++j) {
                                Certificate certJss = (Certificate)certs.elementAt(j);
                                CertificateInfo certI = certJss.getInfo();
                                Name issuer = certI.getIssuer();
                                byte[] issuerB = ASN1Util.encode((ASN1Value)issuer);
                                INTEGER sn = certI.getSerialNumber();
                                if (!new String(issuerB).equals(new String(ASN1Util.encode((ASN1Value)issuerAndSerialNumber.getIssuer()))) || !sn.toString().equals(issuerAndSerialNumber.getSerialNumber().toString())) continue;
                                ByteArrayOutputStream os = new ByteArrayOutputStream();
                                certJss.encode((OutputStream)os);
                                os.toByteArray();
                                X509CertImpl tempcert = new X509CertImpl(os.toByteArray());
                                x509Certs[0] = cert = tempcert;
                            }
                            logger.debug(method + "start checking signature");
                            if (cert == null) {
                                logger.debug(method + "verifying signature");
                                si.verify(digest, id);
                            } else {
                                logger.debug(method + "found CMC signing cert... verifying");
                                X509Certificate clientCert = (X509Certificate)auditContext.get((Object)"sslClientCert");
                                if (clientCert == null) {
                                    this.createAuditSubjectFromCert(auditContext, x509Certs[0]);
                                    msg = "missing SSL client authentication certificate;";
                                    logger.error(method + (String)msg);
                                    s.close();
                                    throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NO_CERT", (String[])new String[0]));
                                }
                                X500Name clientPrincipal = (X500Name)clientCert.getSubjectDN();
                                X500Name cmcPrincipal = (X500Name)x509Certs[0].getSubjectDN();
                                auditContext.put((Object)"cmcSignerPrincipal", (Object)cmcPrincipal);
                                auditContext.put((Object)"cmcSignerInfo", (Object)cmcPrincipal.toString());
                                if (!clientPrincipal.equals((Object)cmcPrincipal)) {
                                    msg = "SSL client authentication certificate and CMC signer do not match";
                                    logger.error(method + (String)msg);
                                    s.close();
                                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + (String)msg);
                                }
                                logger.debug(method + "ssl client cert principal and cmc signer principal match");
                                PublicKey signKey = cert.getPublicKey();
                                PrivateKey.Type keyType = null;
                                String alg = signKey.getAlgorithm();
                                PK11PubKey pubK = null;
                                if (alg.equals("RSA")) {
                                    logger.debug(method + "signing key alg=RSA");
                                    keyType = PrivateKey.RSA;
                                    pubK = PK11PubKey.fromRaw((PrivateKey.Type)keyType, (byte[])((X509Key)signKey).getKey());
                                } else {
                                    if (!alg.equals("EC")) {
                                        msg = "unsupported signature algorithm: " + alg;
                                        logger.error(method + (String)msg);
                                        s.close();
                                        throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + (String)msg);
                                    }
                                    logger.debug(method + "signing key alg=EC");
                                    keyType = PrivateKey.EC;
                                    byte[] publicKeyData = ((X509Key)signKey).getEncoded();
                                    pubK = PK11ECPublicKey.fromSPKI((byte[])publicKeyData);
                                }
                                String tokenName = cs.getString("ca.requestVerify.token", "internal");
                                if (!CryptoUtil.isInternalToken((String)tokenName)) {
                                    savedToken = cm.getThreadToken();
                                    signToken = CryptoUtil.getCryptoToken((String)tokenName);
                                    if (signToken != null) {
                                        cm.setThreadToken(signToken);
                                        tokenSwitched = true;
                                        logger.debug(method + "verifySignerInfo token switched:" + tokenName);
                                    } else {
                                        logger.debug(method + "verifySignerInfo token not found:" + tokenName + ", trying internal");
                                    }
                                }
                                logger.debug(method + "verifying signature with public key");
                                si.verify(digest, id, (PublicKey)pubK);
                            }
                            logger.debug(method + "finished checking signature");
                            if (this.engine.isRevoked(x509Certs)) {
                                msg = "CMC signing cert is a revoked certificate";
                                logger.error(method + (String)msg);
                                s.close();
                                throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + (String)msg);
                            }
                            try {
                                cert.checkValidity();
                            }
                            catch (CertificateExpiredException e) {
                                msg = "CMC signing cert is an expired certificate";
                                logger.error(method + (String)msg, (Throwable)e);
                                s.close();
                                throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + (String)msg);
                            }
                            catch (Exception e) {
                                logger.error(method + e.getMessage(), (Throwable)e);
                                s.close();
                                throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + e.toString());
                            }
                            AuthToken tempToken = new AuthToken(null);
                            X500Name tempPrincipal = (X500Name)x509Certs[0].getSubjectDN();
                            String ID = tempPrincipal.getName();
                            logger.debug(method + " Principal name = " + ID);
                            authToken.set("tokenAuthenticatedCertSubject", ID);
                            BigInteger certSerial = x509Certs[0].getSerialNumber();
                            logger.debug(method + " verified cert serial=" + certSerial.toString());
                            authToken.set("cmcSigningCert", certSerial.toString());
                            tempToken.set("id", ID);
                            s.close();
                            authToken2 = tempToken;
                            if (!tokenSwitched) return authToken2;
                            if (savedToken == null) return authToken2;
                            break block33;
                        }
                        if (sid.getType().equals(SignerIdentifier.SUBJECT_KEY_IDENTIFIER)) {
                            logger.debug(method + "SignerIdentifier type: SUBJECT_KEY_IDENTIFIER");
                            logger.debug(method + "selfSigned is true");
                            this.selfSigned = true;
                            this.selfsign_digest = digest;
                            AuthToken tempToken = new AuthToken(null);
                            authToken.set("cmcSelfSigned", "true");
                            s.close();
                            AuthToken authToken3 = tempToken;
                            return authToken3;
                        }
                        msg = "unsupported SignerIdentifier type";
                        logger.error(method + (String)msg);
                        throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + (String)msg);
                    }
                    if (!tokenSwitched) return null;
                    break block34;
                }
                catch (EMissingCredential e) {
                    throw e;
                }
                catch (EInvalidCredentials e) {
                    throw e;
                }
                catch (InvalidBERException e) {
                    logger.warn(method + e.getMessage(), (Throwable)e);
                    return null;
                }
                catch (Exception e) {
                    logger.warn(method + e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            cm.setThreadToken(savedToken);
            logger.debug(method + "verifySignerInfo token restored");
            return authToken2;
        }
        if (savedToken == null) return null;
        cm.setThreadToken(savedToken);
        logger.debug(method + "verifySignerInfo token restored");
        return null;
        finally {
            if (tokenSwitched && savedToken != null) {
                cm.setThreadToken(savedToken);
                logger.debug(method + "verifySignerInfo token restored");
            }
        }
    }

    private void createAuditSubjectFromCert(SessionContext auditContext, X509Certificate cert) throws IOException {
        String method = "CMCUserSignedAuth:createAuditSubjectFromCert: ";
        X500Name principal = (X500Name)cert.getSubjectDN();
        logger.debug(method + " Principal name = " + principal.toString());
        auditContext.put((Object)"userid", (Object)principal.toString());
    }

    public void init(ConfigStore config) throws EProfileException {
    }

    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_CMS_SIGN_NAME", (String[])new String[0]);
    }

    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_CMS_SIGN_TEXT", (String[])new String[0]);
    }

    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement("cert_request");
        return v.elements();
    }

    public boolean isValueWriteable(String name) {
        return false;
    }

    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(CRED_CMC)) {
            return new Descriptor("string_list", null, null, "CMC request");
        }
        return null;
    }

    public void populate(AuthToken token, Request request) throws EProfileException {
        String method = "CMCUserSignedAuth: populate: ";
        String authenticatedDN = token.getInString("tokenAuthenticatedCertSubject");
        if (authenticatedDN != null) {
            request.setExtData("authenticatedName", authenticatedDN);
            logger.debug(method + "AuthToken.TOKEN_AUTHENTICATED_CERT_SUBJECT is: " + authenticatedDN);
        } else {
            logger.warn(method + "AuthToken.TOKEN_AUTHENTICATED_CERT_SUBJECT is null; self-signed?");
        }
    }

    public boolean isSSLClientRequired() {
        return false;
    }

    private String getAuditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }

    private String getAuditSignerInfo(SessionContext auditContext) {
        String signerSubject = (String)auditContext.get((Object)"cmcSignerInfo");
        if (signerSubject == null) {
            signerSubject = "$Unidentified$";
        }
        return signerSubject;
    }

    private String getRequestCertSubject(SessionContext auditContext) {
        String certSubject = (String)auditContext.get((Object)"cmcRequestCertSubject");
        if (certSubject == null) {
            certSubject = "$Unidentified$";
        }
        return certSubject;
    }

    static {
        mExtendedPluginInfo = new Vector();
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the CMC request. The \"Authentication Instance ID\" must be named \"CMCUserSignedAuth\"");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authentication");
    }
}

