/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.cert.ImportCertsTemplateFiller;
import com.netscape.cms.servlet.common.CAServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetBySerial", urlPatterns={"/ee/ca/getBySerial"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="successTemplate", value="/ee/ca/ImportCert.template"), @WebInitParam(name="importCertTemplate", value="/ee/ca/ImportAdminCert.template"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caGetBySerial"), @WebInitParam(name="resourceID", value="certServer.ee.certificate")})
public class GetBySerial
extends CAServlet {
    public static Logger logger = LoggerFactory.getLogger(GetBySerial.class);
    private static final long serialVersionUID = -2276677839178370838L;
    private static final String IMPORT_CERT_TEMPLATE = "ImportCert.template";
    private String mImportTemplate = null;
    private String mIETemplate = null;
    private ICMSTemplateFiller mImportTemplateFiller = null;
    RequestQueue mReqQ;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        try {
            this.mImportTemplate = sc.getInitParameter("successTemplate");
            this.mIETemplate = sc.getInitParameter("importCertTemplate");
            if (this.mImportTemplate == null) {
                this.mImportTemplate = IMPORT_CERT_TEMPLATE;
            }
        }
        catch (Exception e) {
            this.mImportTemplate = null;
        }
        this.mImportTemplateFiller = new ImportCertsTemplateFiller();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CAEngine engine = CAEngine.getInstance();
        this.mReqQ = engine.getRequestQueue();
    }

    protected CertRecord getCertRecord(BigInteger serialNo) {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certdb = engine.getCertificateRepository();
        if (certdb == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_CERT_DB_NULL", (Object[])new Object[]{"ca"}));
            return null;
        }
        try {
            return certdb.readCertificateRecord(serialNo);
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_CERT_REC", (Object[])new Object[]{serialNo.toString(16), e.toString()}), (Throwable)e);
            return null;
        }
    }

    protected boolean certIsRevoked(BigInteger serialNum) throws EBaseException {
        CertRecord certRecord = this.getCertRecord(serialNum);
        if (certRecord == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_BAD_CERT_SER_NUM", (Object[])new Object[]{String.valueOf(serialNum)}));
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_INVALID_CERT", (Object[])new Object[0]));
        }
        return certRecord.getStatus().equals("REVOKED");
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        X509CertImpl cert;
        String group;
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        ArgBlock args = cmsReq.getHttpParams();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "import");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String serial = args.getValueAsString("serialNumber", null);
        String browser = args.getValueAsString("browser", null);
        BigInteger serialNo = null;
        try {
            serialNo = new BigInteger(serial, 16);
        }
        catch (NumberFormatException e) {
            serialNo = null;
        }
        CAEngine engine = CAEngine.getInstance();
        if (serial == null || serialNo == null) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_INVALID_SERIAL_NUMBER", (Object[])new Object[0]));
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_SERIAL_NUMBER", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        CertRecord certRecord = this.getCertRecord(serialNo);
        if (certRecord == null) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_CERT_SERIAL_NOT_FOUND_1", (Object[])new Object[]{serialNo.toString(16)}));
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CERT_SERIAL_NOT_FOUND", (String[])new String[]{"0x" + serialNo.toString(16)}))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        if (authToken != null && (group = authToken.getInString("group")) != null && group != "") {
            logger.debug("GetBySerial process: auth group=" + group);
            if (group.equals("Registration Manager Agents")) {
                String reqOwner;
                String reqId;
                RequestId rid;
                Request creq;
                boolean groupMatched = false;
                MetaInfo metai = certRecord.getMetaInfo();
                if (metai != null && (creq = this.requestRepository.readRequest(rid = new RequestId(reqId = (String)metai.get("requestId")))) != null && (reqOwner = creq.getRequestOwner()) != null) {
                    logger.debug("GetBySerial process: req owner=" + reqOwner);
                    if (reqOwner.equals(group)) {
                        groupMatched = true;
                    }
                }
                if (!groupMatched) {
                    logger.warn(CMS.getLogMessage((String)"CMSGW_CERT_SERIAL_NOT_FOUND_1", (Object[])new Object[]{serialNo.toString(16)}));
                    cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CERT_SERIAL_NOT_FOUND", (String[])new String[]{"0x" + serialNo.toString(16)}))));
                    cmsReq.setStatus(CMSRequest.ERROR);
                    return;
                }
            }
        }
        if ((cert = certRecord.getCertificate()) != null) {
            if (browser != null && browser.equals("ie")) {
                byte[] p7Bytes;
                ArgBlock header = new ArgBlock();
                ArgBlock ctx = new ArgBlock();
                Locale[] locale = new Locale[1];
                CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
                CertificateAuthority ca = engine.getCA();
                CertificateChain cachain = ca.getCACertChain();
                X509Certificate[] cacerts = cachain.getChain();
                X509CertImpl[] userChain = new X509CertImpl[cacerts.length + 1];
                int m = 1;
                for (int n = 0; n < cacerts.length; ++n) {
                    userChain[m] = (X509CertImpl)cacerts[n];
                    ++m;
                }
                userChain[0] = cert;
                PKCS7 p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), (X509Certificate[])userChain, new SignerInfo[0]);
                try {
                    p7Bytes = p7.getBytes();
                }
                catch (Exception e) {
                    throw new EBaseException(e);
                }
                String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
                header.addStringValue("pkcs7", CryptoUtil.normalizeCertStr((String)p7Str));
                try {
                    CMSTemplate form = this.getTemplate(this.mIETemplate, req, locale);
                    ServletOutputStream out = response.getOutputStream();
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    response.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    return;
                }
                catch (Exception ee) {
                    logger.warn("GetBySerial process: Exception=" + ee.getMessage(), (Throwable)ee);
                }
            }
            MetaInfo metai = certRecord.getMetaInfo();
            String crmfReqId = null;
            if (metai != null && (crmfReqId = (String)metai.get("crmfReqId")) != null) {
                cmsReq.setResult("crmfReqId", (Object)crmfReqId);
            }
            if (crmfReqId == null && this.checkImportCertToNav(cmsReq.getHttpResp(), cmsReq.getHttpParams(), cert)) {
                cmsReq.setStatus(CMSRequest.SUCCESS);
                return;
            }
            X509CertImpl[] certs = new X509CertImpl[]{cert};
            cmsReq.setResult((Object)certs);
            cmsReq.setStatus(CMSRequest.SUCCESS);
            cmsReq.getHttpParams().set("certType", (Object)"client");
            try {
                this.renderTemplate(cmsReq, this.mImportTemplate, this.mImportTemplateFiller);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
            }
        }
    }
}

