/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.template.ArgList;
import com.netscape.certsrv.template.ArgSet;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.profile.ProfileSubsystem;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caProfileList", urlPatterns={"/ee/ca/profileList"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authorityId", value="ca"), @WebInitParam(name="ID", value="caProfileList"), @WebInitParam(name="templatePath", value="/ee/ca/ProfileList.template"), @WebInitParam(name="resourceID", value="certServer.ee.profiles"), @WebInitParam(name="interface", value="ee")})
public class ProfileListServlet
extends ProfileServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileListServlet.class);
    private static final long serialVersionUID = -5118812083812548395L;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        logger.debug("ProfileListServlet: start serving");
        CAEngine engine = CAEngine.getInstance();
        Locale locale = this.getLocale(request);
        ArgSet args = new ArgSet();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHORIZATION_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        if (this.mProfileSubId == null || this.mProfileSubId.equals("")) {
            this.mProfileSubId = "profile";
        }
        logger.debug("ProfileListServlet: SubId=" + this.mProfileSubId);
        ProfileSubsystem ps = engine.getProfileSubsystem(this.mProfileSubId);
        if (ps == null) {
            logger.warn("ProfileListServlet: ProfileSubsystem " + this.mProfileSubId + " not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        ArgList list = new ArgList();
        Enumeration<String> e = ps.getProfileIds();
        if (e != null) {
            while (e.hasMoreElements()) {
                String id = e.nextElement();
                Profile profile = null;
                try {
                    profile = ps.getProfile(id);
                }
                catch (EBaseException e1) {
                    logger.warn("ProfileListServlet: profile " + id + " not found (skipped) " + e1.getMessage(), e);
                    continue;
                }
                if (profile == null) {
                    logger.warn("ProfileListServlet: profile " + id + " not found (skipped)");
                    continue;
                }
                String name = profile.getName(locale);
                String desc = profile.getDescription(locale);
                ArgSet profileArgs = new ArgSet();
                profileArgs.set("profileIsEnable", Boolean.toString(ps.isProfileEnable(id)));
                profileArgs.set("profileEnableBy", ps.getProfileEnableBy(id));
                profileArgs.set("profileId", id);
                profileArgs.set("profileIsVisible", Boolean.toString(profile.isVisible()));
                profileArgs.set("profileName", name);
                profileArgs.set("profileDesc", desc);
                list.add(profileArgs);
            }
        }
        args.set("record", list);
        args.set("errorCode", "0");
        args.set("errorReason", "");
        this.outputTemplate(request, response, args);
    }
}

