/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.cli;

import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.cert.CertRequestInfoFactory;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.SecureRandomConfig;
import com.netscape.cmscore.security.SecureRandomFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.server.ca.cli.CACertRequestCLI;
import org.dogtagpki.util.logging.PKILogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestImportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestImportCLI.class);

    public CACertRequestImportCLI(CLI parent) {
        super("import", "Import certificate request into CA", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "csr", true, "Certificate request path");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate request format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Certificate request type: pkcs10 (default), crmf");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "profile", true, "Profile ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "dns-names", true, "Comma-separated list of DNS names");
        option.setArgName("names");
        this.options.addOption(option);
        this.options.addOption(null, "adjust-validity", false, "Adjust validity");
        option = new Option(null, "output-format", true, "Output format: text (default), json.");
        option.setArgName("format");
        this.options.addOption(option);
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        block19: {
            byte[] bytes;
            if (cmd.hasOption("debug")) {
                PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
            } else if (cmd.hasOption("verbose")) {
                PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
            }
            String instanceDir = CMS.getInstanceDir();
            TomcatJSS tomcatjss = TomcatJSS.getInstance();
            tomcatjss.loadConfig();
            tomcatjss.init();
            String[] cmdArgs = cmd.getArgs();
            RequestId requestID = null;
            if (cmdArgs.length >= 1) {
                requestID = new RequestId(cmdArgs[0]);
            }
            if (!cmd.hasOption("profile")) {
                throw new Exception("Missing profile ID");
            }
            if (!cmd.hasOption("csr")) {
                throw new Exception("Missing certificate request");
            }
            String requestPath = cmd.getOptionValue("csr");
            String requestFormat = cmd.getOptionValue("format");
            if (requestPath == null) {
                bytes = IOUtils.toByteArray((InputStream)System.in);
            } else {
                logger.info("Importing " + requestPath);
                bytes = Files.readAllBytes(Paths.get(requestPath, new String[0]));
            }
            if (requestFormat == null || "PEM".equalsIgnoreCase(requestFormat)) {
                bytes = CertUtil.parseCSR((String)new String(bytes));
            } else if (!"DER".equalsIgnoreCase(requestFormat)) {
                throw new Exception("Unsupported format: " + requestFormat);
            }
            String subsystem = this.parent.getParent().getParent().getName();
            String confDir = instanceDir + File.separator + subsystem + File.separator + "conf";
            String configFile = confDir + File.separator + "CS.cfg";
            logger.info("Loading " + configFile);
            FileConfigStorage storage = new FileConfigStorage(configFile);
            CAEngineConfig cs = new CAEngineConfig((ConfigStorage)storage);
            cs.load();
            String profileID = cmd.getOptionValue("profile");
            String profilePath = confDir + File.separator + profileID;
            logger.info("Loading " + profilePath);
            FileConfigStorage profileStorage = new FileConfigStorage(profilePath);
            ConfigStore profileConfig = new ConfigStore((ConfigStorage)profileStorage);
            profileConfig.load();
            DatabaseConfig dbConfig = cs.getDatabaseConfig();
            LDAPConfig ldapConfig = dbConfig.getLDAPConfig();
            ldapConfig.putInteger("minConns", 1);
            PKISocketConfig socketConfig = cs.getSocketConfig();
            PasswordStoreConfig psc = cs.getPasswordStoreConfig();
            PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
            String requestType = cmd.getOptionValue("type", "pkcs10");
            String value = cmd.getOptionValue("dns-names");
            String[] dnsNames = null;
            if (value != null) {
                dnsNames = value.split(",");
            }
            value = cmd.getOptionValue("adjust-validity", "false");
            boolean adjustValidity = Boolean.parseBoolean(value);
            SecureRandomConfig secureRandomConfig = cs.getJssSubsystemConfig().getSecureRandomConfig();
            SecureRandom secureRandom = SecureRandomFactory.create((SecureRandomConfig)secureRandomConfig);
            DBSubsystem dbSubsystem = new DBSubsystem();
            dbSubsystem.setEngineConfig((EngineConfig)cs);
            dbSubsystem.init(dbConfig, ldapConfig, socketConfig, passwordStore);
            try {
                CertRequestRepository requestRepository = new CertRequestRepository(secureRandom, dbSubsystem);
                requestRepository.init();
                if (requestID == null) {
                    if (requestRepository.getIDGenerator() != Repository.IDGenerator.RANDOM) {
                        throw new Exception("Unable to generate random request ID");
                    }
                    requestID = requestRepository.createRequestID();
                }
                Request request = requestRepository.createRequest(requestID, "enrollment");
                requestRepository.updateRequest(request, requestType, bytes, dnsNames);
                requestRepository.updateRequest(request, profileConfig.getString("id"), profileConfig.getString("profileIDMapping"), profileConfig.getString("profileSetIDMapping"), adjustValidity);
                requestRepository.updateRequest(request);
                CertRequestInfo info = CertRequestInfoFactory.create(request);
                String outputFormat = cmd.getOptionValue("output-format", "text");
                if (outputFormat.equalsIgnoreCase("json")) {
                    System.out.println(info.toJSON());
                    break block19;
                }
                if (outputFormat.equalsIgnoreCase("text")) {
                    CACertRequestCLI.printCertRequestInfo(info);
                    break block19;
                }
                throw new Exception("Unsupported output format: " + outputFormat);
            }
            finally {
                dbSubsystem.shutdown();
            }
        }
    }
}

