/*-------------------------------------------------------------------------
 *
 * fmgrtab.c
 *    The function manager's table of internal functions.
 *
 * Portions Copyright (c) 1996-2020, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *
 *	******************************
 *	*** DO NOT EDIT THIS FILE! ***
 *	******************************
 *
 *	It has been GENERATED by src/backend/utils/Gen_fmgrtab.pl
 *
 *-------------------------------------------------------------------------
 */

#include "postgres.h"

#include "access/transam.h"
#include "utils/fmgrtab.h"
#include "utils/fmgrprotos.h"


const FmgrBuiltin fmgr_builtins[] = {
  { 3, 1, true, false, "heap_tableam_handler", heap_tableam_handler },
  { 31, 1, true, false, "byteaout", byteaout },
  { 33, 1, true, false, "charout", charout },
  { 34, 1, true, false, "namein", namein },
  { 35, 1, true, false, "nameout", nameout },
  { 38, 1, true, false, "int2in", int2in },
  { 39, 1, true, false, "int2out", int2out },
  { 40, 1, true, false, "int2vectorin", int2vectorin },
  { 41, 1, true, false, "int2vectorout", int2vectorout },
  { 42, 1, true, false, "int4in", int4in },
  { 43, 1, true, false, "int4out", int4out },
  { 44, 1, true, false, "regprocin", regprocin },
  { 45, 1, true, false, "regprocout", regprocout },
  { 46, 1, true, false, "textin", textin },
  { 47, 1, true, false, "textout", textout },
  { 48, 1, true, false, "tidin", tidin },
  { 49, 1, true, false, "tidout", tidout },
  { 50, 1, true, false, "xidin", xidin },
  { 51, 1, true, false, "xidout", xidout },
  { 52, 1, true, false, "cidin", cidin },
  { 53, 1, true, false, "cidout", cidout },
  { 54, 1, true, false, "oidvectorin", oidvectorin },
  { 55, 1, true, false, "oidvectorout", oidvectorout },
  { 56, 2, true, false, "boollt", boollt },
  { 57, 2, true, false, "boolgt", boolgt },
  { 60, 2, true, false, "booleq", booleq },
  { 61, 2, true, false, "chareq", chareq },
  { 62, 2, true, false, "nameeq", nameeq },
  { 63, 2, true, false, "int2eq", int2eq },
  { 64, 2, true, false, "int2lt", int2lt },
  { 65, 2, true, false, "int4eq", int4eq },
  { 66, 2, true, false, "int4lt", int4lt },
  { 67, 2, true, false, "texteq", texteq },
  { 68, 2, true, false, "xideq", xideq },
  { 69, 2, true, false, "cideq", cideq },
  { 70, 2, true, false, "charne", charne },
  { 72, 2, true, false, "charle", charle },
  { 73, 2, true, false, "chargt", chargt },
  { 74, 2, true, false, "charge", charge },
  { 77, 1, true, false, "chartoi4", chartoi4 },
  { 78, 1, true, false, "i4tochar", i4tochar },
  { 79, 2, true, false, "nameregexeq", nameregexeq },
  { 84, 2, true, false, "boolne", boolne },
  { 86, 1, true, false, "pg_ddl_command_in", pg_ddl_command_in },
  { 87, 1, true, false, "pg_ddl_command_out", pg_ddl_command_out },
  { 88, 1, true, false, "pg_ddl_command_recv", pg_ddl_command_recv },
  { 89, 0, true, false, "pgsql_version", pgsql_version },
  { 90, 1, true, false, "pg_ddl_command_send", pg_ddl_command_send },
  { 101, 4, true, false, "eqsel", eqsel },
  { 102, 4, true, false, "neqsel", neqsel },
  { 103, 4, true, false, "scalarltsel", scalarltsel },
  { 104, 4, true, false, "scalargtsel", scalargtsel },
  { 105, 5, true, false, "eqjoinsel", eqjoinsel },
  { 106, 5, true, false, "neqjoinsel", neqjoinsel },
  { 107, 5, true, false, "scalarltjoinsel", scalarltjoinsel },
  { 108, 5, true, false, "scalargtjoinsel", scalargtjoinsel },
  { 109, 1, true, false, "unknownin", unknownin },
  { 110, 1, true, false, "unknownout", unknownout },
  { 111, 1, true, false, "numeric_fac", numeric_fac },
  { 115, 2, true, false, "box_above_eq", box_above_eq },
  { 116, 2, true, false, "box_below_eq", box_below_eq },
  { 117, 1, true, false, "point_in", point_in },
  { 118, 1, true, false, "point_out", point_out },
  { 119, 1, true, false, "lseg_in", lseg_in },
  { 120, 1, true, false, "lseg_out", lseg_out },
  { 121, 1, true, false, "path_in", path_in },
  { 122, 1, true, false, "path_out", path_out },
  { 123, 1, true, false, "box_in", box_in },
  { 124, 1, true, false, "box_out", box_out },
  { 125, 2, true, false, "box_overlap", box_overlap },
  { 126, 2, true, false, "box_ge", box_ge },
  { 127, 2, true, false, "box_gt", box_gt },
  { 128, 2, true, false, "box_eq", box_eq },
  { 129, 2, true, false, "box_lt", box_lt },
  { 130, 2, true, false, "box_le", box_le },
  { 131, 2, true, false, "point_above", point_above },
  { 132, 2, true, false, "point_left", point_left },
  { 133, 2, true, false, "point_right", point_right },
  { 134, 2, true, false, "point_below", point_below },
  { 135, 2, true, false, "point_eq", point_eq },
  { 136, 2, true, false, "on_pb", on_pb },
  { 137, 2, true, false, "on_ppath", on_ppath },
  { 138, 1, true, false, "box_center", box_center },
  { 139, 4, true, false, "areasel", areasel },
  { 140, 5, true, false, "areajoinsel", areajoinsel },
  { 141, 2, true, false, "int4mul", int4mul },
  { 144, 2, true, false, "int4ne", int4ne },
  { 145, 2, true, false, "int2ne", int2ne },
  { 146, 2, true, false, "int2gt", int2gt },
  { 147, 2, true, false, "int4gt", int4gt },
  { 148, 2, true, false, "int2le", int2le },
  { 149, 2, true, false, "int4le", int4le },
  { 150, 2, true, false, "int4ge", int4ge },
  { 151, 2, true, false, "int2ge", int2ge },
  { 152, 2, true, false, "int2mul", int2mul },
  { 153, 2, true, false, "int2div", int2div },
  { 154, 2, true, false, "int4div", int4div },
  { 155, 2, true, false, "int2mod", int2mod },
  { 156, 2, true, false, "int4mod", int4mod },
  { 157, 2, true, false, "textne", textne },
  { 158, 2, true, false, "int24eq", int24eq },
  { 159, 2, true, false, "int42eq", int42eq },
  { 160, 2, true, false, "int24lt", int24lt },
  { 161, 2, true, false, "int42lt", int42lt },
  { 162, 2, true, false, "int24gt", int24gt },
  { 163, 2, true, false, "int42gt", int42gt },
  { 164, 2, true, false, "int24ne", int24ne },
  { 165, 2, true, false, "int42ne", int42ne },
  { 166, 2, true, false, "int24le", int24le },
  { 167, 2, true, false, "int42le", int42le },
  { 168, 2, true, false, "int24ge", int24ge },
  { 169, 2, true, false, "int42ge", int42ge },
  { 170, 2, true, false, "int24mul", int24mul },
  { 171, 2, true, false, "int42mul", int42mul },
  { 172, 2, true, false, "int24div", int24div },
  { 173, 2, true, false, "int42div", int42div },
  { 176, 2, true, false, "int2pl", int2pl },
  { 177, 2, true, false, "int4pl", int4pl },
  { 178, 2, true, false, "int24pl", int24pl },
  { 179, 2, true, false, "int42pl", int42pl },
  { 180, 2, true, false, "int2mi", int2mi },
  { 181, 2, true, false, "int4mi", int4mi },
  { 182, 2, true, false, "int24mi", int24mi },
  { 183, 2, true, false, "int42mi", int42mi },
  { 184, 2, true, false, "oideq", oideq },
  { 185, 2, true, false, "oidne", oidne },
  { 186, 2, true, false, "box_same", box_same },
  { 187, 2, true, false, "box_contain", box_contain },
  { 188, 2, true, false, "box_left", box_left },
  { 189, 2, true, false, "box_overleft", box_overleft },
  { 190, 2, true, false, "box_overright", box_overright },
  { 191, 2, true, false, "box_right", box_right },
  { 192, 2, true, false, "box_contained", box_contained },
  { 193, 2, true, false, "box_contain_pt", box_contain_pt },
  { 195, 1, true, false, "pg_node_tree_in", pg_node_tree_in },
  { 196, 1, true, false, "pg_node_tree_out", pg_node_tree_out },
  { 197, 1, true, false, "pg_node_tree_recv", pg_node_tree_recv },
  { 198, 1, true, false, "pg_node_tree_send", pg_node_tree_send },
  { 200, 1, true, false, "float4in", float4in },
  { 201, 1, true, false, "float4out", float4out },
  { 202, 2, true, false, "float4mul", float4mul },
  { 203, 2, true, false, "float4div", float4div },
  { 204, 2, true, false, "float4pl", float4pl },
  { 205, 2, true, false, "float4mi", float4mi },
  { 206, 1, true, false, "float4um", float4um },
  { 207, 1, true, false, "float4abs", float4abs },
  { 208, 2, true, false, "float4_accum", float4_accum },
  { 209, 2, true, false, "float4larger", float4larger },
  { 211, 2, true, false, "float4smaller", float4smaller },
  { 212, 1, true, false, "int4um", int4um },
  { 213, 1, true, false, "int2um", int2um },
  { 214, 1, true, false, "float8in", float8in },
  { 215, 1, true, false, "float8out", float8out },
  { 216, 2, true, false, "float8mul", float8mul },
  { 217, 2, true, false, "float8div", float8div },
  { 218, 2, true, false, "float8pl", float8pl },
  { 219, 2, true, false, "float8mi", float8mi },
  { 220, 1, true, false, "float8um", float8um },
  { 221, 1, true, false, "float8abs", float8abs },
  { 222, 2, true, false, "float8_accum", float8_accum },
  { 223, 2, true, false, "float8larger", float8larger },
  { 224, 2, true, false, "float8smaller", float8smaller },
  { 225, 1, true, false, "lseg_center", lseg_center },
  { 226, 1, true, false, "path_center", path_center },
  { 227, 1, true, false, "poly_center", poly_center },
  { 228, 1, true, false, "dround", dround },
  { 229, 1, true, false, "dtrunc", dtrunc },
  { 230, 1, true, false, "dsqrt", dsqrt },
  { 231, 1, true, false, "dcbrt", dcbrt },
  { 232, 2, true, false, "dpow", dpow },
  { 233, 1, true, false, "dexp", dexp },
  { 234, 1, true, false, "dlog1", dlog1 },
  { 235, 1, true, false, "i2tod", i2tod },
  { 236, 1, true, false, "i2tof", i2tof },
  { 237, 1, true, false, "dtoi2", dtoi2 },
  { 238, 1, true, false, "ftoi2", ftoi2 },
  { 239, 2, true, false, "line_distance", line_distance },
  { 240, 2, true, false, "nameeqtext", nameeqtext },
  { 241, 2, true, false, "namelttext", namelttext },
  { 242, 2, true, false, "nameletext", nameletext },
  { 243, 2, true, false, "namegetext", namegetext },
  { 244, 2, true, false, "namegttext", namegttext },
  { 245, 2, true, false, "namenetext", namenetext },
  { 246, 2, true, false, "btnametextcmp", btnametextcmp },
  { 247, 2, true, false, "texteqname", texteqname },
  { 248, 2, true, false, "textltname", textltname },
  { 249, 2, true, false, "textlename", textlename },
  { 250, 2, true, false, "textgename", textgename },
  { 251, 2, true, false, "textgtname", textgtname },
  { 252, 2, true, false, "textnename", textnename },
  { 253, 2, true, false, "bttextnamecmp", bttextnamecmp },
  { 266, 2, true, false, "nameconcatoid", nameconcatoid },
  { 267, 1, false, false, "table_am_handler_in", table_am_handler_in },
  { 268, 1, true, false, "table_am_handler_out", table_am_handler_out },
  { 274, 0, true, false, "timeofday", timeofday },
  { 275, 3, true, false, "pg_nextoid", pg_nextoid },
  { 276, 2, true, false, "float8_combine", float8_combine },
  { 277, 2, true, false, "inter_sl", inter_sl },
  { 278, 2, true, false, "inter_lb", inter_lb },
  { 279, 2, true, false, "float48mul", float48mul },
  { 280, 2, true, false, "float48div", float48div },
  { 281, 2, true, false, "float48pl", float48pl },
  { 282, 2, true, false, "float48mi", float48mi },
  { 283, 2, true, false, "float84mul", float84mul },
  { 284, 2, true, false, "float84div", float84div },
  { 285, 2, true, false, "float84pl", float84pl },
  { 286, 2, true, false, "float84mi", float84mi },
  { 287, 2, true, false, "float4eq", float4eq },
  { 288, 2, true, false, "float4ne", float4ne },
  { 289, 2, true, false, "float4lt", float4lt },
  { 290, 2, true, false, "float4le", float4le },
  { 291, 2, true, false, "float4gt", float4gt },
  { 292, 2, true, false, "float4ge", float4ge },
  { 293, 2, true, false, "float8eq", float8eq },
  { 294, 2, true, false, "float8ne", float8ne },
  { 295, 2, true, false, "float8lt", float8lt },
  { 296, 2, true, false, "float8le", float8le },
  { 297, 2, true, false, "float8gt", float8gt },
  { 298, 2, true, false, "float8ge", float8ge },
  { 299, 2, true, false, "float48eq", float48eq },
  { 300, 2, true, false, "float48ne", float48ne },
  { 301, 2, true, false, "float48lt", float48lt },
  { 302, 2, true, false, "float48le", float48le },
  { 303, 2, true, false, "float48gt", float48gt },
  { 304, 2, true, false, "float48ge", float48ge },
  { 305, 2, true, false, "float84eq", float84eq },
  { 306, 2, true, false, "float84ne", float84ne },
  { 307, 2, true, false, "float84lt", float84lt },
  { 308, 2, true, false, "float84le", float84le },
  { 309, 2, true, false, "float84gt", float84gt },
  { 310, 2, true, false, "float84ge", float84ge },
  { 311, 1, true, false, "ftod", ftod },
  { 312, 1, true, false, "dtof", dtof },
  { 313, 1, true, false, "i2toi4", i2toi4 },
  { 314, 1, true, false, "i4toi2", i4toi2 },
  { 315, 0, true, false, "pg_jit_available", pg_jit_available },
  { 316, 1, true, false, "i4tod", i4tod },
  { 317, 1, true, false, "dtoi4", dtoi4 },
  { 318, 1, true, false, "i4tof", i4tof },
  { 319, 1, true, false, "ftoi4", ftoi4 },
  { 320, 4, true, false, "width_bucket_float8", width_bucket_float8 },
  { 321, 1, true, false, "json_in", json_in },
  { 322, 1, true, false, "json_out", json_out },
  { 323, 1, true, false, "json_recv", json_recv },
  { 324, 1, true, false, "json_send", json_send },
  { 326, 1, false, false, "index_am_handler_in", index_am_handler_in },
  { 327, 1, true, false, "index_am_handler_out", index_am_handler_out },
  { 328, 1, true, false, "hashmacaddr8", hashmacaddr8 },
  { 329, 1, true, false, "hash_aclitem", hash_aclitem },
  { 330, 1, true, false, "bthandler", bthandler },
  { 331, 1, true, false, "hashhandler", hashhandler },
  { 332, 1, true, false, "gisthandler", gisthandler },
  { 333, 1, true, false, "ginhandler", ginhandler },
  { 334, 1, true, false, "spghandler", spghandler },
  { 335, 1, true, false, "brinhandler", brinhandler },
  { 336, 4, true, false, "scalarlesel", scalarlesel },
  { 337, 4, true, false, "scalargesel", scalargesel },
  { 338, 1, true, false, "amvalidate", amvalidate },
  { 339, 2, true, false, "poly_same", poly_same },
  { 340, 2, true, false, "poly_contain", poly_contain },
  { 341, 2, true, false, "poly_left", poly_left },
  { 342, 2, true, false, "poly_overleft", poly_overleft },
  { 343, 2, true, false, "poly_overright", poly_overright },
  { 344, 2, true, false, "poly_right", poly_right },
  { 345, 2, true, false, "poly_contained", poly_contained },
  { 346, 2, true, false, "poly_overlap", poly_overlap },
  { 347, 1, true, false, "poly_in", poly_in },
  { 348, 1, true, false, "poly_out", poly_out },
  { 350, 2, true, false, "btint2cmp", btint2cmp },
  { 351, 2, true, false, "btint4cmp", btint4cmp },
  { 354, 2, true, false, "btfloat4cmp", btfloat4cmp },
  { 355, 2, true, false, "btfloat8cmp", btfloat8cmp },
  { 356, 2, true, false, "btoidcmp", btoidcmp },
  { 357, 2, true, false, "dist_bp", dist_bp },
  { 358, 2, true, false, "btcharcmp", btcharcmp },
  { 359, 2, true, false, "btnamecmp", btnamecmp },
  { 360, 2, true, false, "bttextcmp", bttextcmp },
  { 361, 2, true, false, "lseg_distance", lseg_distance },
  { 362, 2, true, false, "lseg_interpt", lseg_interpt },
  { 363, 2, true, false, "dist_ps", dist_ps },
  { 364, 2, true, false, "dist_pb", dist_pb },
  { 365, 2, true, false, "dist_sb", dist_sb },
  { 366, 2, true, false, "close_ps", close_ps },
  { 367, 2, true, false, "close_pb", close_pb },
  { 368, 2, true, false, "close_sb", close_sb },
  { 369, 2, true, false, "on_ps", on_ps },
  { 370, 2, true, false, "path_distance", path_distance },
  { 371, 2, true, false, "dist_ppath", dist_ppath },
  { 372, 2, true, false, "on_sb", on_sb },
  { 373, 2, true, false, "inter_sb", inter_sb },
  { 376, 3, false, false, "text_to_array_null", text_to_array_null },
  { 377, 2, true, false, "cash_cmp", cash_cmp },
  { 378, 2, false, false, "array_append", array_append },
  { 379, 2, false, false, "array_prepend", array_prepend },
  { 380, 2, true, false, "dist_sp", dist_sp },
  { 381, 2, true, false, "dist_bs", dist_bs },
  { 382, 2, true, false, "btarraycmp", btarraycmp },
  { 383, 2, false, false, "array_cat", array_cat },
  { 384, 3, false, false, "array_to_text_null", array_to_text_null },
  { 386, 5, true, false, "scalarlejoinsel", scalarlejoinsel },
  { 390, 2, true, false, "array_ne", array_ne },
  { 391, 2, true, false, "array_lt", array_lt },
  { 392, 2, true, false, "array_gt", array_gt },
  { 393, 2, true, false, "array_le", array_le },
  { 394, 2, false, false, "text_to_array", text_to_array },
  { 395, 2, true, false, "array_to_text", array_to_text },
  { 396, 2, true, false, "array_ge", array_ge },
  { 398, 5, true, false, "scalargejoinsel", scalargejoinsel },
  { 399, 1, true, false, "hashmacaddr", hashmacaddr },
  { 400, 1, true, false, "hashtext", hashtext },
  { 401, 1, true, false, "rtrim1", rtrim1 },
  { 404, 2, true, false, "btoidvectorcmp", btoidvectorcmp },
  { 406, 1, true, false, "name_text", name_text },
  { 407, 1, true, false, "text_name", text_name },
  { 408, 1, true, false, "name_bpchar", name_bpchar },
  { 409, 1, true, false, "bpchar_name", bpchar_name },
  { 421, 2, true, false, "dist_pathp", dist_pathp },
  { 422, 1, true, false, "hashinet", hashinet },
  { 425, 2, true, false, "hashint4extended", hashint4extended },
  { 432, 1, true, false, "hash_numeric", hash_numeric },
  { 436, 1, true, false, "macaddr_in", macaddr_in },
  { 437, 1, true, false, "macaddr_out", macaddr_out },
  { 438, 1, false, false, "pg_num_nulls", pg_num_nulls },
  { 440, 1, false, false, "pg_num_nonnulls", pg_num_nonnulls },
  { 441, 2, true, false, "hashint2extended", hashint2extended },
  { 442, 2, true, false, "hashint8extended", hashint8extended },
  { 443, 2, true, false, "hashfloat4extended", hashfloat4extended },
  { 444, 2, true, false, "hashfloat8extended", hashfloat8extended },
  { 445, 2, true, false, "hashoidextended", hashoidextended },
  { 446, 2, true, false, "hashcharextended", hashcharextended },
  { 447, 2, true, false, "hashnameextended", hashnameextended },
  { 448, 2, true, false, "hashtextextended", hashtextextended },
  { 449, 1, true, false, "hashint2", hashint2 },
  { 450, 1, true, false, "hashint4", hashint4 },
  { 451, 1, true, false, "hashfloat4", hashfloat4 },
  { 452, 1, true, false, "hashfloat8", hashfloat8 },
  { 453, 1, true, false, "hashoid", hashoid },
  { 454, 1, true, false, "hashchar", hashchar },
  { 455, 1, true, false, "hashname", hashname },
  { 456, 1, true, false, "hashvarlena", hashvarlena },
  { 457, 1, true, false, "hashoidvector", hashoidvector },
  { 458, 2, true, false, "text_larger", text_larger },
  { 459, 2, true, false, "text_smaller", text_smaller },
  { 460, 1, true, false, "int8in", int8in },
  { 461, 1, true, false, "int8out", int8out },
  { 462, 1, true, false, "int8um", int8um },
  { 463, 2, true, false, "int8pl", int8pl },
  { 464, 2, true, false, "int8mi", int8mi },
  { 465, 2, true, false, "int8mul", int8mul },
  { 466, 2, true, false, "int8div", int8div },
  { 467, 2, true, false, "int8eq", int8eq },
  { 468, 2, true, false, "int8ne", int8ne },
  { 469, 2, true, false, "int8lt", int8lt },
  { 470, 2, true, false, "int8gt", int8gt },
  { 471, 2, true, false, "int8le", int8le },
  { 472, 2, true, false, "int8ge", int8ge },
  { 474, 2, true, false, "int84eq", int84eq },
  { 475, 2, true, false, "int84ne", int84ne },
  { 476, 2, true, false, "int84lt", int84lt },
  { 477, 2, true, false, "int84gt", int84gt },
  { 478, 2, true, false, "int84le", int84le },
  { 479, 2, true, false, "int84ge", int84ge },
  { 480, 1, true, false, "int84", int84 },
  { 481, 1, true, false, "int48", int48 },
  { 482, 1, true, false, "i8tod", i8tod },
  { 483, 1, true, false, "dtoi8", dtoi8 },
  { 515, 2, true, false, "array_larger", array_larger },
  { 516, 2, true, false, "array_smaller", array_smaller },
  { 598, 1, true, false, "inet_abbrev", inet_abbrev },
  { 599, 1, true, false, "cidr_abbrev", cidr_abbrev },
  { 605, 2, true, false, "inet_set_masklen", inet_set_masklen },
  { 619, 2, true, false, "oidvectorne", oidvectorne },
  { 626, 1, true, false, "hash_array", hash_array },
  { 635, 2, true, false, "cidr_set_masklen", cidr_set_masklen },
  { 636, 2, true, false, "pg_indexam_has_property", pg_indexam_has_property },
  { 637, 2, true, false, "pg_index_has_property", pg_index_has_property },
  { 638, 3, true, false, "pg_index_column_has_property", pg_index_column_has_property },
  { 652, 1, true, false, "i8tof", i8tof },
  { 653, 1, true, false, "ftoi8", ftoi8 },
  { 655, 2, true, false, "namelt", namelt },
  { 656, 2, true, false, "namele", namele },
  { 657, 2, true, false, "namegt", namegt },
  { 658, 2, true, false, "namege", namege },
  { 659, 2, true, false, "namene", namene },
  { 668, 3, true, false, "bpchar", bpchar },
  { 669, 3, true, false, "varchar", varchar },
  { 676, 2, true, false, "pg_indexam_progress_phasename", pg_indexam_progress_phasename },
  { 677, 2, true, false, "oidvectorlt", oidvectorlt },
  { 678, 2, true, false, "oidvectorle", oidvectorle },
  { 679, 2, true, false, "oidvectoreq", oidvectoreq },
  { 680, 2, true, false, "oidvectorge", oidvectorge },
  { 681, 2, true, false, "oidvectorgt", oidvectorgt },
  { 683, 1, true, false, "network_network", network_network },
  { 696, 1, true, false, "network_netmask", network_netmask },
  { 697, 1, true, false, "network_masklen", network_masklen },
  { 698, 1, true, false, "network_broadcast", network_broadcast },
  { 699, 1, true, false, "network_host", network_host },
  { 702, 2, true, false, "dist_lp", dist_lp },
  { 703, 2, true, false, "dist_bl", dist_bl },
  { 704, 2, true, false, "dist_ls", dist_ls },
  { 710, 0, true, false, "current_user", current_user },
  { 711, 1, true, false, "network_family", network_family },
  { 714, 1, true, false, "int82", int82 },
  { 715, 1, true, false, "be_lo_create", be_lo_create },
  { 716, 2, true, false, "oidlt", oidlt },
  { 717, 2, true, false, "oidle", oidle },
  { 720, 1, true, false, "byteaoctetlen", byteaoctetlen },
  { 721, 2, true, false, "byteaGetByte", byteaGetByte },
  { 722, 3, true, false, "byteaSetByte", byteaSetByte },
  { 723, 2, true, false, "byteaGetBit", byteaGetBit },
  { 724, 3, true, false, "byteaSetBit", byteaSetBit },
  { 725, 2, true, false, "dist_pl", dist_pl },
  { 726, 2, true, false, "dist_lb", dist_lb },
  { 727, 2, true, false, "dist_sl", dist_sl },
  { 728, 2, true, false, "dist_cpoly", dist_cpoly },
  { 729, 2, true, false, "poly_distance", poly_distance },
  { 730, 1, true, false, "network_show", network_show },
  { 740, 2, true, false, "text_lt", text_lt },
  { 741, 2, true, false, "text_le", text_le },
  { 742, 2, true, false, "text_gt", text_gt },
  { 743, 2, true, false, "text_ge", text_ge },
  { 744, 2, true, false, "array_eq", array_eq },
  { 745, 0, true, false, "current_user", current_user },
  { 746, 0, true, false, "session_user", session_user },
  { 747, 1, true, false, "array_dims", array_dims },
  { 748, 1, true, false, "array_ndims", array_ndims },
  { 749, 4, true, false, "byteaoverlay", byteaoverlay },
  { 750, 3, true, false, "array_in", array_in },
  { 751, 1, true, false, "array_out", array_out },
  { 752, 3, true, false, "byteaoverlay_no_len", byteaoverlay_no_len },
  { 753, 1, true, false, "macaddr_trunc", macaddr_trunc },
  { 754, 1, true, false, "int28", int28 },
  { 764, 1, true, false, "be_lo_import", be_lo_import },
  { 765, 2, true, false, "be_lo_export", be_lo_export },
  { 766, 1, true, false, "int4inc", int4inc },
  { 767, 2, true, false, "be_lo_import_with_oid", be_lo_import_with_oid },
  { 768, 2, true, false, "int4larger", int4larger },
  { 769, 2, true, false, "int4smaller", int4smaller },
  { 770, 2, true, false, "int2larger", int2larger },
  { 771, 2, true, false, "int2smaller", int2smaller },
  { 772, 2, true, false, "hashvarlenaextended", hashvarlenaextended },
  { 776, 2, true, false, "hashoidvectorextended", hashoidvectorextended },
  { 777, 2, true, false, "hash_aclitem_extended", hash_aclitem_extended },
  { 778, 2, true, false, "hashmacaddrextended", hashmacaddrextended },
  { 779, 2, true, false, "hashinetextended", hashinetextended },
  { 780, 2, true, false, "hash_numeric_extended", hash_numeric_extended },
  { 781, 2, true, false, "hashmacaddr8extended", hashmacaddr8extended },
  { 782, 2, true, false, "hash_array_extended", hash_array_extended },
  { 785, 2, true, false, "dist_polyc", dist_polyc },
  { 810, 0, true, false, "pg_client_encoding", pg_client_encoding },
  { 817, 0, false, false, "current_query", current_query },
  { 830, 2, true, false, "macaddr_eq", macaddr_eq },
  { 831, 2, true, false, "macaddr_lt", macaddr_lt },
  { 832, 2, true, false, "macaddr_le", macaddr_le },
  { 833, 2, true, false, "macaddr_gt", macaddr_gt },
  { 834, 2, true, false, "macaddr_ge", macaddr_ge },
  { 835, 2, true, false, "macaddr_ne", macaddr_ne },
  { 836, 2, true, false, "macaddr_cmp", macaddr_cmp },
  { 837, 2, true, false, "int82pl", int82pl },
  { 838, 2, true, false, "int82mi", int82mi },
  { 839, 2, true, false, "int82mul", int82mul },
  { 840, 2, true, false, "int82div", int82div },
  { 841, 2, true, false, "int28pl", int28pl },
  { 842, 2, true, false, "btint8cmp", btint8cmp },
  { 846, 2, true, false, "cash_mul_flt4", cash_mul_flt4 },
  { 847, 2, true, false, "cash_div_flt4", cash_div_flt4 },
  { 848, 2, true, false, "flt4_mul_cash", flt4_mul_cash },
  { 849, 2, true, false, "textpos", textpos },
  { 850, 2, true, false, "textlike", textlike },
  { 851, 2, true, false, "textnlike", textnlike },
  { 852, 2, true, false, "int48eq", int48eq },
  { 853, 2, true, false, "int48ne", int48ne },
  { 854, 2, true, false, "int48lt", int48lt },
  { 855, 2, true, false, "int48gt", int48gt },
  { 856, 2, true, false, "int48le", int48le },
  { 857, 2, true, false, "int48ge", int48ge },
  { 858, 2, true, false, "namelike", namelike },
  { 859, 2, true, false, "namenlike", namenlike },
  { 860, 1, true, false, "char_bpchar", char_bpchar },
  { 861, 0, true, false, "current_database", current_database },
  { 862, 2, true, false, "int4_mul_cash", int4_mul_cash },
  { 863, 2, true, false, "int2_mul_cash", int2_mul_cash },
  { 864, 2, true, false, "cash_mul_int4", cash_mul_int4 },
  { 865, 2, true, false, "cash_div_int4", cash_div_int4 },
  { 866, 2, true, false, "cash_mul_int2", cash_mul_int2 },
  { 867, 2, true, false, "cash_div_int2", cash_div_int2 },
  { 868, 2, true, false, "textpos", textpos },
  { 870, 1, true, false, "lower", lower },
  { 871, 1, true, false, "upper", upper },
  { 872, 1, true, false, "initcap", initcap },
  { 873, 3, true, false, "lpad", lpad },
  { 874, 3, true, false, "rpad", rpad },
  { 875, 2, true, false, "ltrim", ltrim },
  { 876, 2, true, false, "rtrim", rtrim },
  { 877, 3, true, false, "text_substr", text_substr },
  { 878, 3, true, false, "translate", translate },
  { 881, 1, true, false, "ltrim1", ltrim1 },
  { 882, 1, true, false, "rtrim1", rtrim1 },
  { 883, 2, true, false, "text_substr_no_len", text_substr_no_len },
  { 884, 2, true, false, "btrim", btrim },
  { 885, 1, true, false, "btrim1", btrim1 },
  { 886, 1, true, false, "cash_in", cash_in },
  { 887, 1, true, false, "cash_out", cash_out },
  { 888, 2, true, false, "cash_eq", cash_eq },
  { 889, 2, true, false, "cash_ne", cash_ne },
  { 890, 2, true, false, "cash_lt", cash_lt },
  { 891, 2, true, false, "cash_le", cash_le },
  { 892, 2, true, false, "cash_gt", cash_gt },
  { 893, 2, true, false, "cash_ge", cash_ge },
  { 894, 2, true, false, "cash_pl", cash_pl },
  { 895, 2, true, false, "cash_mi", cash_mi },
  { 896, 2, true, false, "cash_mul_flt8", cash_mul_flt8 },
  { 897, 2, true, false, "cash_div_flt8", cash_div_flt8 },
  { 898, 2, true, false, "cashlarger", cashlarger },
  { 899, 2, true, false, "cashsmaller", cashsmaller },
  { 910, 1, true, false, "inet_in", inet_in },
  { 911, 1, true, false, "inet_out", inet_out },
  { 919, 2, true, false, "flt8_mul_cash", flt8_mul_cash },
  { 920, 2, true, false, "network_eq", network_eq },
  { 921, 2, true, false, "network_lt", network_lt },
  { 922, 2, true, false, "network_le", network_le },
  { 923, 2, true, false, "network_gt", network_gt },
  { 924, 2, true, false, "network_ge", network_ge },
  { 925, 2, true, false, "network_ne", network_ne },
  { 926, 2, true, false, "network_cmp", network_cmp },
  { 927, 2, true, false, "network_sub", network_sub },
  { 928, 2, true, false, "network_subeq", network_subeq },
  { 929, 2, true, false, "network_sup", network_sup },
  { 930, 2, true, false, "network_supeq", network_supeq },
  { 935, 1, true, false, "cash_words", cash_words },
  { 936, 3, true, false, "text_substr", text_substr },
  { 937, 2, true, false, "text_substr_no_len", text_substr_no_len },
  { 938, 3, true, true, "generate_series_timestamp", generate_series_timestamp },
  { 939, 3, true, true, "generate_series_timestamptz", generate_series_timestamptz },
  { 940, 2, true, false, "int2mod", int2mod },
  { 941, 2, true, false, "int4mod", int4mod },
  { 942, 2, true, false, "int28mi", int28mi },
  { 943, 2, true, false, "int28mul", int28mul },
  { 944, 1, true, false, "text_char", text_char },
  { 945, 2, true, false, "int8mod", int8mod },
  { 946, 1, true, false, "char_text", char_text },
  { 947, 2, true, false, "int8mod", int8mod },
  { 948, 2, true, false, "int28div", int28div },
  { 949, 1, true, false, "hashint8", hashint8 },
  { 952, 2, true, false, "be_lo_open", be_lo_open },
  { 953, 1, true, false, "be_lo_close", be_lo_close },
  { 954, 2, true, false, "be_loread", be_loread },
  { 955, 2, true, false, "be_lowrite", be_lowrite },
  { 956, 3, true, false, "be_lo_lseek", be_lo_lseek },
  { 957, 1, true, false, "be_lo_creat", be_lo_creat },
  { 958, 1, true, false, "be_lo_tell", be_lo_tell },
  { 959, 2, true, false, "on_pl", on_pl },
  { 960, 2, true, false, "on_sl", on_sl },
  { 961, 2, true, false, "close_pl", close_pl },
  { 962, 2, true, false, "close_sl", close_sl },
  { 963, 2, true, false, "close_lb", close_lb },
  { 964, 1, true, false, "be_lo_unlink", be_lo_unlink },
  { 972, 2, true, false, "hashbpcharextended", hashbpcharextended },
  { 973, 2, true, false, "path_inter", path_inter },
  { 975, 1, true, false, "box_area", box_area },
  { 976, 1, true, false, "box_width", box_width },
  { 977, 1, true, false, "box_height", box_height },
  { 978, 2, true, false, "box_distance", box_distance },
  { 979, 1, true, false, "path_area", path_area },
  { 980, 2, true, false, "box_intersect", box_intersect },
  { 981, 1, true, false, "box_diagonal", box_diagonal },
  { 982, 2, true, false, "path_n_lt", path_n_lt },
  { 983, 2, true, false, "path_n_gt", path_n_gt },
  { 984, 2, true, false, "path_n_eq", path_n_eq },
  { 985, 2, true, false, "path_n_le", path_n_le },
  { 986, 2, true, false, "path_n_ge", path_n_ge },
  { 987, 1, true, false, "path_length", path_length },
  { 988, 2, true, false, "point_ne", point_ne },
  { 989, 2, true, false, "point_vert", point_vert },
  { 990, 2, true, false, "point_horiz", point_horiz },
  { 991, 2, true, false, "point_distance", point_distance },
  { 992, 2, true, false, "point_slope", point_slope },
  { 993, 2, true, false, "lseg_construct", lseg_construct },
  { 994, 2, true, false, "lseg_intersect", lseg_intersect },
  { 995, 2, true, false, "lseg_parallel", lseg_parallel },
  { 996, 2, true, false, "lseg_perp", lseg_perp },
  { 997, 1, true, false, "lseg_vertical", lseg_vertical },
  { 998, 1, true, false, "lseg_horizontal", lseg_horizontal },
  { 999, 2, true, false, "lseg_eq", lseg_eq },
  { 1004, 2, true, false, "be_lo_truncate", be_lo_truncate },
  { 1023, 1, true, false, "textlike_support", textlike_support },
  { 1024, 1, true, false, "texticregexeq_support", texticregexeq_support },
  { 1025, 1, true, false, "texticlike_support", texticlike_support },
  { 1026, 2, true, false, "timestamptz_izone", timestamptz_izone },
  { 1030, 1, true, false, "gist_point_compress", gist_point_compress },
  { 1031, 1, true, false, "aclitemin", aclitemin },
  { 1032, 1, true, false, "aclitemout", aclitemout },
  { 1035, 2, true, false, "aclinsert", aclinsert },
  { 1036, 2, true, false, "aclremove", aclremove },
  { 1037, 2, true, false, "aclcontains", aclcontains },
  { 1039, 0, true, false, "getdatabaseencoding", getdatabaseencoding },
  { 1044, 3, true, false, "bpcharin", bpcharin },
  { 1045, 1, true, false, "bpcharout", bpcharout },
  { 1046, 3, true, false, "varcharin", varcharin },
  { 1047, 1, true, false, "varcharout", varcharout },
  { 1048, 2, true, false, "bpchareq", bpchareq },
  { 1049, 2, true, false, "bpcharlt", bpcharlt },
  { 1050, 2, true, false, "bpcharle", bpcharle },
  { 1051, 2, true, false, "bpchargt", bpchargt },
  { 1052, 2, true, false, "bpcharge", bpcharge },
  { 1053, 2, true, false, "bpcharne", bpcharne },
  { 1062, 2, true, false, "aclitem_eq", aclitem_eq },
  { 1063, 2, true, false, "bpchar_larger", bpchar_larger },
  { 1064, 2, true, false, "bpchar_smaller", bpchar_smaller },
  { 1065, 0, true, true, "pg_prepared_xact", pg_prepared_xact },
  { 1066, 3, true, true, "generate_series_step_int4", generate_series_step_int4 },
  { 1067, 2, true, true, "generate_series_int4", generate_series_int4 },
  { 1068, 3, true, true, "generate_series_step_int8", generate_series_step_int8 },
  { 1069, 2, true, true, "generate_series_int8", generate_series_int8 },
  { 1078, 2, true, false, "bpcharcmp", bpcharcmp },
  { 1079, 1, true, false, "text_regclass", text_regclass },
  { 1080, 1, true, false, "hashbpchar", hashbpchar },
  { 1081, 2, false, false, "format_type", format_type },
  { 1084, 1, true, false, "date_in", date_in },
  { 1085, 1, true, false, "date_out", date_out },
  { 1086, 2, true, false, "date_eq", date_eq },
  { 1087, 2, true, false, "date_lt", date_lt },
  { 1088, 2, true, false, "date_le", date_le },
  { 1089, 2, true, false, "date_gt", date_gt },
  { 1090, 2, true, false, "date_ge", date_ge },
  { 1091, 2, true, false, "date_ne", date_ne },
  { 1092, 2, true, false, "date_cmp", date_cmp },
  { 1102, 2, true, false, "time_lt", time_lt },
  { 1103, 2, true, false, "time_le", time_le },
  { 1104, 2, true, false, "time_gt", time_gt },
  { 1105, 2, true, false, "time_ge", time_ge },
  { 1106, 2, true, false, "time_ne", time_ne },
  { 1107, 2, true, false, "time_cmp", time_cmp },
  { 1138, 2, true, false, "date_larger", date_larger },
  { 1139, 2, true, false, "date_smaller", date_smaller },
  { 1140, 2, true, false, "date_mi", date_mi },
  { 1141, 2, true, false, "date_pli", date_pli },
  { 1142, 2, true, false, "date_mii", date_mii },
  { 1143, 3, true, false, "time_in", time_in },
  { 1144, 1, true, false, "time_out", time_out },
  { 1145, 2, true, false, "time_eq", time_eq },
  { 1146, 2, true, false, "circle_add_pt", circle_add_pt },
  { 1147, 2, true, false, "circle_sub_pt", circle_sub_pt },
  { 1148, 2, true, false, "circle_mul_pt", circle_mul_pt },
  { 1149, 2, true, false, "circle_div_pt", circle_div_pt },
  { 1150, 3, true, false, "timestamptz_in", timestamptz_in },
  { 1151, 1, true, false, "timestamptz_out", timestamptz_out },
  { 1152, 2, true, false, "timestamp_eq", timestamp_eq },
  { 1153, 2, true, false, "timestamp_ne", timestamp_ne },
  { 1154, 2, true, false, "timestamp_lt", timestamp_lt },
  { 1155, 2, true, false, "timestamp_le", timestamp_le },
  { 1156, 2, true, false, "timestamp_ge", timestamp_ge },
  { 1157, 2, true, false, "timestamp_gt", timestamp_gt },
  { 1158, 1, true, false, "float8_timestamptz", float8_timestamptz },
  { 1159, 2, true, false, "timestamptz_zone", timestamptz_zone },
  { 1160, 3, true, false, "interval_in", interval_in },
  { 1161, 1, true, false, "interval_out", interval_out },
  { 1162, 2, true, false, "interval_eq", interval_eq },
  { 1163, 2, true, false, "interval_ne", interval_ne },
  { 1164, 2, true, false, "interval_lt", interval_lt },
  { 1165, 2, true, false, "interval_le", interval_le },
  { 1166, 2, true, false, "interval_ge", interval_ge },
  { 1167, 2, true, false, "interval_gt", interval_gt },
  { 1168, 1, true, false, "interval_um", interval_um },
  { 1169, 2, true, false, "interval_pl", interval_pl },
  { 1170, 2, true, false, "interval_mi", interval_mi },
  { 1171, 2, true, false, "timestamptz_part", timestamptz_part },
  { 1172, 2, true, false, "interval_part", interval_part },
  { 1173, 1, true, false, "network_subset_support", network_subset_support },
  { 1174, 1, true, false, "date_timestamptz", date_timestamptz },
  { 1175, 1, true, false, "interval_justify_hours", interval_justify_hours },
  { 1177, 4, true, false, "jsonb_path_exists_tz", jsonb_path_exists_tz },
  { 1178, 1, true, false, "timestamptz_date", timestamptz_date },
  { 1179, 4, true, true, "jsonb_path_query_tz", jsonb_path_query_tz },
  { 1180, 4, true, false, "jsonb_path_query_array_tz", jsonb_path_query_array_tz },
  { 1181, 1, true, false, "xid_age", xid_age },
  { 1188, 2, true, false, "timestamp_mi", timestamp_mi },
  { 1189, 2, true, false, "timestamptz_pl_interval", timestamptz_pl_interval },
  { 1190, 2, true, false, "timestamptz_mi_interval", timestamptz_mi_interval },
  { 1191, 3, true, true, "generate_subscripts", generate_subscripts },
  { 1192, 2, true, true, "generate_subscripts_nodir", generate_subscripts_nodir },
  { 1193, 2, false, false, "array_fill", array_fill },
  { 1194, 1, true, false, "dlog10", dlog10 },
  { 1195, 2, true, false, "timestamp_smaller", timestamp_smaller },
  { 1196, 2, true, false, "timestamp_larger", timestamp_larger },
  { 1197, 2, true, false, "interval_smaller", interval_smaller },
  { 1198, 2, true, false, "interval_larger", interval_larger },
  { 1199, 2, true, false, "timestamptz_age", timestamptz_age },
  { 1200, 2, true, false, "interval_scale", interval_scale },
  { 1217, 2, true, false, "timestamptz_trunc", timestamptz_trunc },
  { 1218, 2, true, false, "interval_trunc", interval_trunc },
  { 1219, 1, true, false, "int8inc", int8inc },
  { 1230, 1, true, false, "int8abs", int8abs },
  { 1236, 2, true, false, "int8larger", int8larger },
  { 1237, 2, true, false, "int8smaller", int8smaller },
  { 1238, 2, true, false, "texticregexeq", texticregexeq },
  { 1239, 2, true, false, "texticregexne", texticregexne },
  { 1240, 2, true, false, "nameicregexeq", nameicregexeq },
  { 1241, 2, true, false, "nameicregexne", nameicregexne },
  { 1242, 1, true, false, "boolin", boolin },
  { 1243, 1, true, false, "boolout", boolout },
  { 1244, 1, true, false, "byteain", byteain },
  { 1245, 1, true, false, "charin", charin },
  { 1246, 2, true, false, "charlt", charlt },
  { 1250, 0, true, false, "unique_key_recheck", unique_key_recheck },
  { 1251, 1, true, false, "int4abs", int4abs },
  { 1252, 2, true, false, "nameregexne", nameregexne },
  { 1253, 1, true, false, "int2abs", int2abs },
  { 1254, 2, true, false, "textregexeq", textregexeq },
  { 1256, 2, true, false, "textregexne", textregexne },
  { 1257, 1, true, false, "textlen", textlen },
  { 1258, 2, true, false, "textcat", textcat },
  { 1264, 1, true, false, "PG_char_to_encoding", PG_char_to_encoding },
  { 1265, 2, true, false, "tidne", tidne },
  { 1267, 1, true, false, "cidr_in", cidr_in },
  { 1268, 2, true, false, "parse_ident", parse_ident },
  { 1269, 1, true, false, "pg_column_size", pg_column_size },
  { 1271, 4, false, false, "overlaps_timetz", overlaps_timetz },
  { 1272, 2, true, false, "datetime_timestamp", datetime_timestamp },
  { 1273, 2, true, false, "timetz_part", timetz_part },
  { 1274, 2, true, false, "int84pl", int84pl },
  { 1275, 2, true, false, "int84mi", int84mi },
  { 1276, 2, true, false, "int84mul", int84mul },
  { 1277, 2, true, false, "int84div", int84div },
  { 1278, 2, true, false, "int48pl", int48pl },
  { 1279, 2, true, false, "int48mi", int48mi },
  { 1280, 2, true, false, "int48mul", int48mul },
  { 1281, 2, true, false, "int48div", int48div },
  { 1282, 1, true, false, "quote_ident", quote_ident },
  { 1283, 1, true, false, "quote_literal", quote_literal },
  { 1284, 3, true, false, "timestamptz_trunc_zone", timestamptz_trunc_zone },
  { 1286, 3, false, false, "array_fill_with_lower_bounds", array_fill_with_lower_bounds },
  { 1287, 1, true, false, "i8tooid", i8tooid },
  { 1288, 1, true, false, "oidtoi8", oidtoi8 },
  { 1289, 1, false, false, "quote_nullable", quote_nullable },
  { 1291, 0, true, false, "suppress_redundant_updates_trigger", suppress_redundant_updates_trigger },
  { 1292, 2, true, false, "tideq", tideq },
  { 1293, 2, true, false, "currtid_byreloid", currtid_byreloid },
  { 1294, 2, true, false, "currtid_byrelname", currtid_byrelname },
  { 1295, 1, true, false, "interval_justify_days", interval_justify_days },
  { 1297, 2, true, false, "datetimetz_timestamptz", datetimetz_timestamptz },
  { 1299, 0, true, false, "now", now },
  { 1300, 4, true, false, "positionsel", positionsel },
  { 1301, 5, true, false, "positionjoinsel", positionjoinsel },
  { 1302, 4, true, false, "contsel", contsel },
  { 1303, 5, true, false, "contjoinsel", contjoinsel },
  { 1304, 4, false, false, "overlaps_timestamp", overlaps_timestamp },
  { 1308, 4, false, false, "overlaps_time", overlaps_time },
  { 1312, 3, true, false, "timestamp_in", timestamp_in },
  { 1313, 1, true, false, "timestamp_out", timestamp_out },
  { 1314, 2, true, false, "timestamp_cmp", timestamp_cmp },
  { 1315, 2, true, false, "interval_cmp", interval_cmp },
  { 1316, 1, true, false, "timestamp_time", timestamp_time },
  { 1317, 1, true, false, "textlen", textlen },
  { 1318, 1, true, false, "bpcharlen", bpcharlen },
  { 1319, 2, true, false, "xideq", xideq },
  { 1326, 2, true, false, "interval_div", interval_div },
  { 1339, 1, true, false, "dlog10", dlog10 },
  { 1340, 1, true, false, "dlog10", dlog10 },
  { 1341, 1, true, false, "dlog1", dlog1 },
  { 1342, 1, true, false, "dround", dround },
  { 1343, 1, true, false, "dtrunc", dtrunc },
  { 1344, 1, true, false, "dsqrt", dsqrt },
  { 1345, 1, true, false, "dcbrt", dcbrt },
  { 1346, 2, true, false, "dpow", dpow },
  { 1347, 1, true, false, "dexp", dexp },
  { 1349, 1, true, false, "oidvectortypes", oidvectortypes },
  { 1350, 3, true, false, "timetz_in", timetz_in },
  { 1351, 1, true, false, "timetz_out", timetz_out },
  { 1352, 2, true, false, "timetz_eq", timetz_eq },
  { 1353, 2, true, false, "timetz_ne", timetz_ne },
  { 1354, 2, true, false, "timetz_lt", timetz_lt },
  { 1355, 2, true, false, "timetz_le", timetz_le },
  { 1356, 2, true, false, "timetz_ge", timetz_ge },
  { 1357, 2, true, false, "timetz_gt", timetz_gt },
  { 1358, 2, true, false, "timetz_cmp", timetz_cmp },
  { 1359, 2, true, false, "datetimetz_timestamptz", datetimetz_timestamptz },
  { 1362, 1, true, false, "network_hostmask", network_hostmask },
  { 1364, 1, true, false, "textregexeq_support", textregexeq_support },
  { 1365, 4, true, false, "makeaclitem", makeaclitem },
  { 1367, 1, true, false, "bpcharlen", bpcharlen },
  { 1368, 2, true, false, "dpow", dpow },
  { 1369, 1, true, false, "textlen", textlen },
  { 1370, 1, true, false, "time_interval", time_interval },
  { 1371, 0, true, true, "pg_lock_status", pg_lock_status },
  { 1372, 1, true, false, "bpcharlen", bpcharlen },
  { 1373, 1, true, false, "date_finite", date_finite },
  { 1374, 1, true, false, "textoctetlen", textoctetlen },
  { 1375, 1, true, false, "bpcharoctetlen", bpcharoctetlen },
  { 1376, 1, true, false, "numeric_fac", numeric_fac },
  { 1377, 2, true, false, "time_larger", time_larger },
  { 1378, 2, true, false, "time_smaller", time_smaller },
  { 1379, 2, true, false, "timetz_larger", timetz_larger },
  { 1380, 2, true, false, "timetz_smaller", timetz_smaller },
  { 1381, 1, true, false, "textlen", textlen },
  { 1385, 2, true, false, "time_part", time_part },
  { 1387, 1, true, false, "pg_get_constraintdef", pg_get_constraintdef },
  { 1388, 1, true, false, "timestamptz_timetz", timestamptz_timetz },
  { 1389, 1, true, false, "timestamp_finite", timestamp_finite },
  { 1390, 1, true, false, "interval_finite", interval_finite },
  { 1391, 1, true, false, "pg_stat_get_backend_start", pg_stat_get_backend_start },
  { 1392, 1, true, false, "pg_stat_get_backend_client_addr", pg_stat_get_backend_client_addr },
  { 1393, 1, true, false, "pg_stat_get_backend_client_port", pg_stat_get_backend_client_port },
  { 1394, 1, true, false, "float4abs", float4abs },
  { 1395, 1, true, false, "float8abs", float8abs },
  { 1396, 1, true, false, "int8abs", int8abs },
  { 1397, 1, true, false, "int4abs", int4abs },
  { 1398, 1, true, false, "int2abs", int2abs },
  { 1400, 1, true, false, "text_name", text_name },
  { 1401, 1, true, false, "name_text", name_text },
  { 1402, 0, true, false, "current_schema", current_schema },
  { 1403, 1, true, false, "current_schemas", current_schemas },
  { 1404, 4, true, false, "textoverlay", textoverlay },
  { 1405, 3, true, false, "textoverlay_no_len", textoverlay_no_len },
  { 1406, 2, true, false, "point_vert", point_vert },
  { 1407, 2, true, false, "point_horiz", point_horiz },
  { 1408, 2, true, false, "lseg_parallel", lseg_parallel },
  { 1409, 2, true, false, "lseg_perp", lseg_perp },
  { 1410, 1, true, false, "lseg_vertical", lseg_vertical },
  { 1411, 1, true, false, "lseg_horizontal", lseg_horizontal },
  { 1412, 2, true, false, "line_parallel", line_parallel },
  { 1413, 2, true, false, "line_perp", line_perp },
  { 1414, 1, true, false, "line_vertical", line_vertical },
  { 1415, 1, true, false, "line_horizontal", line_horizontal },
  { 1416, 1, true, false, "circle_center", circle_center },
  { 1419, 1, true, false, "interval_time", interval_time },
  { 1421, 2, true, false, "points_box", points_box },
  { 1422, 2, true, false, "box_add", box_add },
  { 1423, 2, true, false, "box_sub", box_sub },
  { 1424, 2, true, false, "box_mul", box_mul },
  { 1425, 2, true, false, "box_div", box_div },
  { 1427, 1, true, false, "cidr_out", cidr_out },
  { 1428, 2, true, false, "poly_contain_pt", poly_contain_pt },
  { 1429, 2, true, false, "pt_contained_poly", pt_contained_poly },
  { 1430, 1, true, false, "path_isclosed", path_isclosed },
  { 1431, 1, true, false, "path_isopen", path_isopen },
  { 1432, 1, true, false, "path_npoints", path_npoints },
  { 1433, 1, true, false, "path_close", path_close },
  { 1434, 1, true, false, "path_open", path_open },
  { 1435, 2, true, false, "path_add", path_add },
  { 1436, 2, true, false, "path_add_pt", path_add_pt },
  { 1437, 2, true, false, "path_sub_pt", path_sub_pt },
  { 1438, 2, true, false, "path_mul_pt", path_mul_pt },
  { 1439, 2, true, false, "path_div_pt", path_div_pt },
  { 1440, 2, true, false, "construct_point", construct_point },
  { 1441, 2, true, false, "point_add", point_add },
  { 1442, 2, true, false, "point_sub", point_sub },
  { 1443, 2, true, false, "point_mul", point_mul },
  { 1444, 2, true, false, "point_div", point_div },
  { 1445, 1, true, false, "poly_npoints", poly_npoints },
  { 1446, 1, true, false, "poly_box", poly_box },
  { 1447, 1, true, false, "poly_path", poly_path },
  { 1448, 1, true, false, "box_poly", box_poly },
  { 1449, 1, true, false, "path_poly", path_poly },
  { 1450, 1, true, false, "circle_in", circle_in },
  { 1451, 1, true, false, "circle_out", circle_out },
  { 1452, 2, true, false, "circle_same", circle_same },
  { 1453, 2, true, false, "circle_contain", circle_contain },
  { 1454, 2, true, false, "circle_left", circle_left },
  { 1455, 2, true, false, "circle_overleft", circle_overleft },
  { 1456, 2, true, false, "circle_overright", circle_overright },
  { 1457, 2, true, false, "circle_right", circle_right },
  { 1458, 2, true, false, "circle_contained", circle_contained },
  { 1459, 2, true, false, "circle_overlap", circle_overlap },
  { 1460, 2, true, false, "circle_below", circle_below },
  { 1461, 2, true, false, "circle_above", circle_above },
  { 1462, 2, true, false, "circle_eq", circle_eq },
  { 1463, 2, true, false, "circle_ne", circle_ne },
  { 1464, 2, true, false, "circle_lt", circle_lt },
  { 1465, 2, true, false, "circle_gt", circle_gt },
  { 1466, 2, true, false, "circle_le", circle_le },
  { 1467, 2, true, false, "circle_ge", circle_ge },
  { 1468, 1, true, false, "circle_area", circle_area },
  { 1469, 1, true, false, "circle_diameter", circle_diameter },
  { 1470, 1, true, false, "circle_radius", circle_radius },
  { 1471, 2, true, false, "circle_distance", circle_distance },
  { 1472, 1, true, false, "circle_center", circle_center },
  { 1473, 2, true, false, "cr_circle", cr_circle },
  { 1474, 1, true, false, "poly_circle", poly_circle },
  { 1475, 2, true, false, "circle_poly", circle_poly },
  { 1476, 2, true, false, "dist_pc", dist_pc },
  { 1477, 2, true, false, "circle_contain_pt", circle_contain_pt },
  { 1478, 2, true, false, "pt_contained_circle", pt_contained_circle },
  { 1479, 1, true, false, "box_circle", box_circle },
  { 1480, 1, true, false, "circle_box", circle_box },
  { 1482, 2, true, false, "lseg_ne", lseg_ne },
  { 1483, 2, true, false, "lseg_lt", lseg_lt },
  { 1484, 2, true, false, "lseg_le", lseg_le },
  { 1485, 2, true, false, "lseg_gt", lseg_gt },
  { 1486, 2, true, false, "lseg_ge", lseg_ge },
  { 1487, 1, true, false, "lseg_length", lseg_length },
  { 1488, 2, true, false, "close_ls", close_ls },
  { 1489, 2, true, false, "close_lseg", close_lseg },
  { 1490, 1, true, false, "line_in", line_in },
  { 1491, 1, true, false, "line_out", line_out },
  { 1492, 2, true, false, "line_eq", line_eq },
  { 1493, 2, true, false, "line_construct_pp", line_construct_pp },
  { 1494, 2, true, false, "line_interpt", line_interpt },
  { 1495, 2, true, false, "line_intersect", line_intersect },
  { 1496, 2, true, false, "line_parallel", line_parallel },
  { 1497, 2, true, false, "line_perp", line_perp },
  { 1498, 1, true, false, "line_vertical", line_vertical },
  { 1499, 1, true, false, "line_horizontal", line_horizontal },
  { 1530, 1, true, false, "lseg_length", lseg_length },
  { 1531, 1, true, false, "path_length", path_length },
  { 1532, 1, true, false, "lseg_center", lseg_center },
  { 1533, 1, true, false, "path_center", path_center },
  { 1534, 1, true, false, "box_center", box_center },
  { 1540, 1, true, false, "poly_center", poly_center },
  { 1541, 1, true, false, "box_diagonal", box_diagonal },
  { 1542, 1, true, false, "box_center", box_center },
  { 1543, 1, true, false, "circle_center", circle_center },
  { 1545, 1, true, false, "path_npoints", path_npoints },
  { 1556, 1, true, false, "poly_npoints", poly_npoints },
  { 1564, 3, true, false, "bit_in", bit_in },
  { 1565, 1, true, false, "bit_out", bit_out },
  { 1569, 2, true, false, "textlike", textlike },
  { 1570, 2, true, false, "textnlike", textnlike },
  { 1571, 2, true, false, "namelike", namelike },
  { 1572, 2, true, false, "namenlike", namenlike },
  { 1573, 1, true, false, "pg_get_ruledef", pg_get_ruledef },
  { 1574, 1, true, false, "nextval_oid", nextval_oid },
  { 1575, 1, true, false, "currval_oid", currval_oid },
  { 1576, 2, true, false, "setval_oid", setval_oid },
  { 1579, 3, true, false, "varbit_in", varbit_in },
  { 1580, 1, true, false, "varbit_out", varbit_out },
  { 1581, 2, true, false, "biteq", biteq },
  { 1582, 2, true, false, "bitne", bitne },
  { 1592, 2, true, false, "bitge", bitge },
  { 1593, 2, true, false, "bitgt", bitgt },
  { 1594, 2, true, false, "bitle", bitle },
  { 1595, 2, true, false, "bitlt", bitlt },
  { 1596, 2, true, false, "bitcmp", bitcmp },
  { 1597, 1, true, false, "PG_encoding_to_char", PG_encoding_to_char },
  { 1598, 0, true, false, "drandom", drandom },
  { 1599, 1, true, false, "setseed", setseed },
  { 1600, 1, true, false, "dasin", dasin },
  { 1601, 1, true, false, "dacos", dacos },
  { 1602, 1, true, false, "datan", datan },
  { 1603, 2, true, false, "datan2", datan2 },
  { 1604, 1, true, false, "dsin", dsin },
  { 1605, 1, true, false, "dcos", dcos },
  { 1606, 1, true, false, "dtan", dtan },
  { 1607, 1, true, false, "dcot", dcot },
  { 1608, 1, true, false, "degrees", degrees },
  { 1609, 1, true, false, "radians", radians },
  { 1610, 0, true, false, "dpi", dpi },
  { 1618, 2, true, false, "interval_mul", interval_mul },
  { 1619, 1, false, false, "pg_typeof", pg_typeof },
  { 1620, 1, true, false, "ascii", ascii },
  { 1621, 1, true, false, "chr", chr },
  { 1622, 2, true, false, "repeat", repeat },
  { 1623, 2, false, false, "similar_escape", similar_escape },
  { 1624, 2, true, false, "mul_d_interval", mul_d_interval },
  { 1631, 2, true, false, "textlike", textlike },
  { 1632, 2, true, false, "textnlike", textnlike },
  { 1633, 2, true, false, "texticlike", texticlike },
  { 1634, 2, true, false, "texticnlike", texticnlike },
  { 1635, 2, true, false, "nameiclike", nameiclike },
  { 1636, 2, true, false, "nameicnlike", nameicnlike },
  { 1637, 2, true, false, "like_escape", like_escape },
  { 1638, 2, true, false, "oidgt", oidgt },
  { 1639, 2, true, false, "oidge", oidge },
  { 1640, 1, true, false, "pg_get_viewdef_name", pg_get_viewdef_name },
  { 1641, 1, true, false, "pg_get_viewdef", pg_get_viewdef },
  { 1642, 1, true, false, "pg_get_userbyid", pg_get_userbyid },
  { 1643, 1, true, false, "pg_get_indexdef", pg_get_indexdef },
  { 1644, 0, true, false, "RI_FKey_check_ins", RI_FKey_check_ins },
  { 1645, 0, true, false, "RI_FKey_check_upd", RI_FKey_check_upd },
  { 1646, 0, true, false, "RI_FKey_cascade_del", RI_FKey_cascade_del },
  { 1647, 0, true, false, "RI_FKey_cascade_upd", RI_FKey_cascade_upd },
  { 1648, 0, true, false, "RI_FKey_restrict_del", RI_FKey_restrict_del },
  { 1649, 0, true, false, "RI_FKey_restrict_upd", RI_FKey_restrict_upd },
  { 1650, 0, true, false, "RI_FKey_setnull_del", RI_FKey_setnull_del },
  { 1651, 0, true, false, "RI_FKey_setnull_upd", RI_FKey_setnull_upd },
  { 1652, 0, true, false, "RI_FKey_setdefault_del", RI_FKey_setdefault_del },
  { 1653, 0, true, false, "RI_FKey_setdefault_upd", RI_FKey_setdefault_upd },
  { 1654, 0, true, false, "RI_FKey_noaction_del", RI_FKey_noaction_del },
  { 1655, 0, true, false, "RI_FKey_noaction_upd", RI_FKey_noaction_upd },
  { 1656, 2, true, false, "texticregexeq", texticregexeq },
  { 1657, 2, true, false, "texticregexne", texticregexne },
  { 1658, 2, true, false, "textregexeq", textregexeq },
  { 1659, 2, true, false, "textregexne", textregexne },
  { 1660, 2, true, false, "texticlike", texticlike },
  { 1661, 2, true, false, "texticnlike", texticnlike },
  { 1662, 1, true, false, "pg_get_triggerdef", pg_get_triggerdef },
  { 1665, 2, true, false, "pg_get_serial_sequence", pg_get_serial_sequence },
  { 1666, 2, true, false, "biteq", biteq },
  { 1667, 2, true, false, "bitne", bitne },
  { 1668, 2, true, false, "bitge", bitge },
  { 1669, 2, true, false, "bitgt", bitgt },
  { 1670, 2, true, false, "bitle", bitle },
  { 1671, 2, true, false, "bitlt", bitlt },
  { 1672, 2, true, false, "bitcmp", bitcmp },
  { 1673, 2, true, false, "bit_and", bit_and },
  { 1674, 2, true, false, "bit_or", bit_or },
  { 1675, 2, true, false, "bitxor", bitxor },
  { 1676, 1, true, false, "bitnot", bitnot },
  { 1677, 2, true, false, "bitshiftleft", bitshiftleft },
  { 1678, 2, true, false, "bitshiftright", bitshiftright },
  { 1679, 2, true, false, "bitcat", bitcat },
  { 1680, 3, true, false, "bitsubstr", bitsubstr },
  { 1681, 1, true, false, "bitlength", bitlength },
  { 1682, 1, true, false, "bitoctetlength", bitoctetlength },
  { 1683, 2, true, false, "bitfromint4", bitfromint4 },
  { 1684, 1, true, false, "bittoint4", bittoint4 },
  { 1685, 3, true, false, "bit", bit },
  { 1686, 0, true, true, "pg_get_keywords", pg_get_keywords },
  { 1687, 3, true, false, "varbit", varbit },
  { 1688, 1, true, false, "time_hash", time_hash },
  { 1689, 1, true, true, "aclexplode", aclexplode },
  { 1690, 2, true, false, "time_mi_time", time_mi_time },
  { 1691, 2, true, false, "boolle", boolle },
  { 1692, 2, true, false, "boolge", boolge },
  { 1693, 2, true, false, "btboolcmp", btboolcmp },
  { 1696, 1, true, false, "timetz_hash", timetz_hash },
  { 1697, 1, true, false, "interval_hash", interval_hash },
  { 1698, 2, true, false, "bitposition", bitposition },
  { 1699, 2, true, false, "bitsubstr_no_len", bitsubstr_no_len },
  { 1701, 3, true, false, "numeric_in", numeric_in },
  { 1702, 1, true, false, "numeric_out", numeric_out },
  { 1703, 2, true, false, "numeric", numeric },
  { 1704, 1, true, false, "numeric_abs", numeric_abs },
  { 1705, 1, true, false, "numeric_abs", numeric_abs },
  { 1706, 1, true, false, "numeric_sign", numeric_sign },
  { 1707, 2, true, false, "numeric_round", numeric_round },
  { 1709, 2, true, false, "numeric_trunc", numeric_trunc },
  { 1711, 1, true, false, "numeric_ceil", numeric_ceil },
  { 1712, 1, true, false, "numeric_floor", numeric_floor },
  { 1713, 2, true, false, "length_in_encoding", length_in_encoding },
  { 1714, 2, true, false, "pg_convert_from", pg_convert_from },
  { 1715, 1, true, false, "inet_to_cidr", inet_to_cidr },
  { 1716, 2, true, false, "pg_get_expr", pg_get_expr },
  { 1717, 2, true, false, "pg_convert_to", pg_convert_to },
  { 1718, 2, true, false, "numeric_eq", numeric_eq },
  { 1719, 2, true, false, "numeric_ne", numeric_ne },
  { 1720, 2, true, false, "numeric_gt", numeric_gt },
  { 1721, 2, true, false, "numeric_ge", numeric_ge },
  { 1722, 2, true, false, "numeric_lt", numeric_lt },
  { 1723, 2, true, false, "numeric_le", numeric_le },
  { 1724, 2, true, false, "numeric_add", numeric_add },
  { 1725, 2, true, false, "numeric_sub", numeric_sub },
  { 1726, 2, true, false, "numeric_mul", numeric_mul },
  { 1727, 2, true, false, "numeric_div", numeric_div },
  { 1728, 2, true, false, "numeric_mod", numeric_mod },
  { 1729, 2, true, false, "numeric_mod", numeric_mod },
  { 1730, 1, true, false, "numeric_sqrt", numeric_sqrt },
  { 1731, 1, true, false, "numeric_sqrt", numeric_sqrt },
  { 1732, 1, true, false, "numeric_exp", numeric_exp },
  { 1733, 1, true, false, "numeric_exp", numeric_exp },
  { 1734, 1, true, false, "numeric_ln", numeric_ln },
  { 1735, 1, true, false, "numeric_ln", numeric_ln },
  { 1736, 2, true, false, "numeric_log", numeric_log },
  { 1737, 2, true, false, "numeric_log", numeric_log },
  { 1738, 2, true, false, "numeric_power", numeric_power },
  { 1739, 2, true, false, "numeric_power", numeric_power },
  { 1740, 1, true, false, "int4_numeric", int4_numeric },
  { 1742, 1, true, false, "float4_numeric", float4_numeric },
  { 1743, 1, true, false, "float8_numeric", float8_numeric },
  { 1744, 1, true, false, "numeric_int4", numeric_int4 },
  { 1745, 1, true, false, "numeric_float4", numeric_float4 },
  { 1746, 1, true, false, "numeric_float8", numeric_float8 },
  { 1747, 2, true, false, "time_pl_interval", time_pl_interval },
  { 1748, 2, true, false, "time_mi_interval", time_mi_interval },
  { 1749, 2, true, false, "timetz_pl_interval", timetz_pl_interval },
  { 1750, 2, true, false, "timetz_mi_interval", timetz_mi_interval },
  { 1764, 1, true, false, "numeric_inc", numeric_inc },
  { 1765, 3, true, false, "setval3_oid", setval3_oid },
  { 1766, 2, true, false, "numeric_smaller", numeric_smaller },
  { 1767, 2, true, false, "numeric_larger", numeric_larger },
  { 1768, 2, true, false, "interval_to_char", interval_to_char },
  { 1769, 2, true, false, "numeric_cmp", numeric_cmp },
  { 1770, 2, true, false, "timestamptz_to_char", timestamptz_to_char },
  { 1771, 1, true, false, "numeric_uminus", numeric_uminus },
  { 1772, 2, true, false, "numeric_to_char", numeric_to_char },
  { 1773, 2, true, false, "int4_to_char", int4_to_char },
  { 1774, 2, true, false, "int8_to_char", int8_to_char },
  { 1775, 2, true, false, "float4_to_char", float4_to_char },
  { 1776, 2, true, false, "float8_to_char", float8_to_char },
  { 1777, 2, true, false, "numeric_to_number", numeric_to_number },
  { 1778, 2, true, false, "to_timestamp", to_timestamp },
  { 1779, 1, true, false, "numeric_int8", numeric_int8 },
  { 1780, 2, true, false, "to_date", to_date },
  { 1781, 1, true, false, "int8_numeric", int8_numeric },
  { 1782, 1, true, false, "int2_numeric", int2_numeric },
  { 1783, 1, true, false, "numeric_int2", numeric_int2 },
  { 1798, 1, true, false, "oidin", oidin },
  { 1799, 1, true, false, "oidout", oidout },
  { 1813, 3, true, false, "pg_convert", pg_convert },
  { 1814, 4, true, false, "iclikesel", iclikesel },
  { 1815, 4, true, false, "icnlikesel", icnlikesel },
  { 1816, 5, true, false, "iclikejoinsel", iclikejoinsel },
  { 1817, 5, true, false, "icnlikejoinsel", icnlikejoinsel },
  { 1818, 4, true, false, "regexeqsel", regexeqsel },
  { 1819, 4, true, false, "likesel", likesel },
  { 1820, 4, true, false, "icregexeqsel", icregexeqsel },
  { 1821, 4, true, false, "regexnesel", regexnesel },
  { 1822, 4, true, false, "nlikesel", nlikesel },
  { 1823, 4, true, false, "icregexnesel", icregexnesel },
  { 1824, 5, true, false, "regexeqjoinsel", regexeqjoinsel },
  { 1825, 5, true, false, "likejoinsel", likejoinsel },
  { 1826, 5, true, false, "icregexeqjoinsel", icregexeqjoinsel },
  { 1827, 5, true, false, "regexnejoinsel", regexnejoinsel },
  { 1828, 5, true, false, "nlikejoinsel", nlikejoinsel },
  { 1829, 5, true, false, "icregexnejoinsel", icregexnejoinsel },
  { 1830, 1, true, false, "float8_avg", float8_avg },
  { 1831, 1, true, false, "float8_var_samp", float8_var_samp },
  { 1832, 1, true, false, "float8_stddev_samp", float8_stddev_samp },
  { 1833, 2, false, false, "numeric_accum", numeric_accum },
  { 1834, 2, false, false, "int2_accum", int2_accum },
  { 1835, 2, false, false, "int4_accum", int4_accum },
  { 1836, 2, false, false, "int8_accum", int8_accum },
  { 1837, 1, false, false, "numeric_avg", numeric_avg },
  { 1838, 1, false, false, "numeric_var_samp", numeric_var_samp },
  { 1839, 1, false, false, "numeric_stddev_samp", numeric_stddev_samp },
  { 1840, 2, false, false, "int2_sum", int2_sum },
  { 1841, 2, false, false, "int4_sum", int4_sum },
  { 1842, 2, false, false, "int8_sum", int8_sum },
  { 1843, 2, true, false, "interval_accum", interval_accum },
  { 1844, 1, true, false, "interval_avg", interval_avg },
  { 1845, 1, true, false, "to_ascii_default", to_ascii_default },
  { 1846, 2, true, false, "to_ascii_enc", to_ascii_enc },
  { 1847, 2, true, false, "to_ascii_encname", to_ascii_encname },
  { 1850, 2, true, false, "int28eq", int28eq },
  { 1851, 2, true, false, "int28ne", int28ne },
  { 1852, 2, true, false, "int28lt", int28lt },
  { 1853, 2, true, false, "int28gt", int28gt },
  { 1854, 2, true, false, "int28le", int28le },
  { 1855, 2, true, false, "int28ge", int28ge },
  { 1856, 2, true, false, "int82eq", int82eq },
  { 1857, 2, true, false, "int82ne", int82ne },
  { 1858, 2, true, false, "int82lt", int82lt },
  { 1859, 2, true, false, "int82gt", int82gt },
  { 1860, 2, true, false, "int82le", int82le },
  { 1861, 2, true, false, "int82ge", int82ge },
  { 1892, 2, true, false, "int2and", int2and },
  { 1893, 2, true, false, "int2or", int2or },
  { 1894, 2, true, false, "int2xor", int2xor },
  { 1895, 1, true, false, "int2not", int2not },
  { 1896, 2, true, false, "int2shl", int2shl },
  { 1897, 2, true, false, "int2shr", int2shr },
  { 1898, 2, true, false, "int4and", int4and },
  { 1899, 2, true, false, "int4or", int4or },
  { 1900, 2, true, false, "int4xor", int4xor },
  { 1901, 1, true, false, "int4not", int4not },
  { 1902, 2, true, false, "int4shl", int4shl },
  { 1903, 2, true, false, "int4shr", int4shr },
  { 1904, 2, true, false, "int8and", int8and },
  { 1905, 2, true, false, "int8or", int8or },
  { 1906, 2, true, false, "int8xor", int8xor },
  { 1907, 1, true, false, "int8not", int8not },
  { 1908, 2, true, false, "int8shl", int8shl },
  { 1909, 2, true, false, "int8shr", int8shr },
  { 1910, 1, true, false, "int8up", int8up },
  { 1911, 1, true, false, "int2up", int2up },
  { 1912, 1, true, false, "int4up", int4up },
  { 1913, 1, true, false, "float4up", float4up },
  { 1914, 1, true, false, "float8up", float8up },
  { 1915, 1, true, false, "numeric_uplus", numeric_uplus },
  { 1922, 3, true, false, "has_table_privilege_name_name", has_table_privilege_name_name },
  { 1923, 3, true, false, "has_table_privilege_name_id", has_table_privilege_name_id },
  { 1924, 3, true, false, "has_table_privilege_id_name", has_table_privilege_id_name },
  { 1925, 3, true, false, "has_table_privilege_id_id", has_table_privilege_id_id },
  { 1926, 2, true, false, "has_table_privilege_name", has_table_privilege_name },
  { 1927, 2, true, false, "has_table_privilege_id", has_table_privilege_id },
  { 1928, 1, true, false, "pg_stat_get_numscans", pg_stat_get_numscans },
  { 1929, 1, true, false, "pg_stat_get_tuples_returned", pg_stat_get_tuples_returned },
  { 1930, 1, true, false, "pg_stat_get_tuples_fetched", pg_stat_get_tuples_fetched },
  { 1931, 1, true, false, "pg_stat_get_tuples_inserted", pg_stat_get_tuples_inserted },
  { 1932, 1, true, false, "pg_stat_get_tuples_updated", pg_stat_get_tuples_updated },
  { 1933, 1, true, false, "pg_stat_get_tuples_deleted", pg_stat_get_tuples_deleted },
  { 1934, 1, true, false, "pg_stat_get_blocks_fetched", pg_stat_get_blocks_fetched },
  { 1935, 1, true, false, "pg_stat_get_blocks_hit", pg_stat_get_blocks_hit },
  { 1936, 0, true, true, "pg_stat_get_backend_idset", pg_stat_get_backend_idset },
  { 1937, 1, true, false, "pg_stat_get_backend_pid", pg_stat_get_backend_pid },
  { 1938, 1, true, false, "pg_stat_get_backend_dbid", pg_stat_get_backend_dbid },
  { 1939, 1, true, false, "pg_stat_get_backend_userid", pg_stat_get_backend_userid },
  { 1940, 1, true, false, "pg_stat_get_backend_activity", pg_stat_get_backend_activity },
  { 1941, 1, true, false, "pg_stat_get_db_numbackends", pg_stat_get_db_numbackends },
  { 1942, 1, true, false, "pg_stat_get_db_xact_commit", pg_stat_get_db_xact_commit },
  { 1943, 1, true, false, "pg_stat_get_db_xact_rollback", pg_stat_get_db_xact_rollback },
  { 1944, 1, true, false, "pg_stat_get_db_blocks_fetched", pg_stat_get_db_blocks_fetched },
  { 1945, 1, true, false, "pg_stat_get_db_blocks_hit", pg_stat_get_db_blocks_hit },
  { 1946, 2, true, false, "binary_encode", binary_encode },
  { 1947, 2, true, false, "binary_decode", binary_decode },
  { 1948, 2, true, false, "byteaeq", byteaeq },
  { 1949, 2, true, false, "bytealt", bytealt },
  { 1950, 2, true, false, "byteale", byteale },
  { 1951, 2, true, false, "byteagt", byteagt },
  { 1952, 2, true, false, "byteage", byteage },
  { 1953, 2, true, false, "byteane", byteane },
  { 1954, 2, true, false, "byteacmp", byteacmp },
  { 1961, 2, true, false, "timestamp_scale", timestamp_scale },
  { 1962, 2, true, false, "int2_avg_accum", int2_avg_accum },
  { 1963, 2, true, false, "int4_avg_accum", int4_avg_accum },
  { 1964, 1, true, false, "int8_avg", int8_avg },
  { 1965, 2, true, false, "oidlarger", oidlarger },
  { 1966, 2, true, false, "oidsmaller", oidsmaller },
  { 1967, 2, true, false, "timestamptz_scale", timestamptz_scale },
  { 1968, 2, true, false, "time_scale", time_scale },
  { 1969, 2, true, false, "timetz_scale", timetz_scale },
  { 1972, 1, true, false, "pg_stat_get_tuples_hot_updated", pg_stat_get_tuples_hot_updated },
  { 1973, 2, true, false, "numeric_div_trunc", numeric_div_trunc },
  { 1980, 2, true, false, "numeric_div_trunc", numeric_div_trunc },
  { 1986, 2, true, false, "similar_to_escape_2", similar_to_escape_2 },
  { 1987, 1, true, false, "similar_to_escape_1", similar_to_escape_1 },
  { 2005, 2, true, false, "bytealike", bytealike },
  { 2006, 2, true, false, "byteanlike", byteanlike },
  { 2007, 2, true, false, "bytealike", bytealike },
  { 2008, 2, true, false, "byteanlike", byteanlike },
  { 2009, 2, true, false, "like_escape_bytea", like_escape_bytea },
  { 2010, 1, true, false, "byteaoctetlen", byteaoctetlen },
  { 2011, 2, true, false, "byteacat", byteacat },
  { 2012, 3, true, false, "bytea_substr", bytea_substr },
  { 2013, 2, true, false, "bytea_substr_no_len", bytea_substr_no_len },
  { 2014, 2, true, false, "byteapos", byteapos },
  { 2015, 2, true, false, "byteatrim", byteatrim },
  { 2019, 1, true, false, "timestamptz_time", timestamptz_time },
  { 2020, 2, true, false, "timestamp_trunc", timestamp_trunc },
  { 2021, 2, true, false, "timestamp_part", timestamp_part },
  { 2022, 1, false, true, "pg_stat_get_activity", pg_stat_get_activity },
  { 2023, 4, true, false, "jsonb_path_query_first_tz", jsonb_path_query_first_tz },
  { 2024, 1, true, false, "date_timestamp", date_timestamp },
  { 2025, 2, true, false, "datetime_timestamp", datetime_timestamp },
  { 2026, 0, true, false, "pg_backend_pid", pg_backend_pid },
  { 2027, 1, true, false, "timestamptz_timestamp", timestamptz_timestamp },
  { 2028, 1, true, false, "timestamp_timestamptz", timestamp_timestamptz },
  { 2029, 1, true, false, "timestamp_date", timestamp_date },
  { 2030, 4, true, false, "jsonb_path_match_tz", jsonb_path_match_tz },
  { 2031, 2, true, false, "timestamp_mi", timestamp_mi },
  { 2032, 2, true, false, "timestamp_pl_interval", timestamp_pl_interval },
  { 2033, 2, true, false, "timestamp_mi_interval", timestamp_mi_interval },
  { 2034, 0, true, false, "pg_conf_load_time", pg_conf_load_time },
  { 2035, 2, true, false, "timestamp_smaller", timestamp_smaller },
  { 2036, 2, true, false, "timestamp_larger", timestamp_larger },
  { 2037, 2, true, false, "timetz_zone", timetz_zone },
  { 2038, 2, true, false, "timetz_izone", timetz_izone },
  { 2039, 1, true, false, "timestamp_hash", timestamp_hash },
  { 2041, 4, false, false, "overlaps_timestamp", overlaps_timestamp },
  { 2045, 2, true, false, "timestamp_cmp", timestamp_cmp },
  { 2046, 1, true, false, "timetz_time", timetz_time },
  { 2047, 1, true, false, "time_timetz", time_timetz },
  { 2048, 1, true, false, "timestamp_finite", timestamp_finite },
  { 2049, 2, true, false, "timestamp_to_char", timestamp_to_char },
  { 2050, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2051, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2052, 2, true, false, "timestamp_eq", timestamp_eq },
  { 2053, 2, true, false, "timestamp_ne", timestamp_ne },
  { 2054, 2, true, false, "timestamp_lt", timestamp_lt },
  { 2055, 2, true, false, "timestamp_le", timestamp_le },
  { 2056, 2, true, false, "timestamp_ge", timestamp_ge },
  { 2057, 2, true, false, "timestamp_gt", timestamp_gt },
  { 2058, 2, true, false, "timestamp_age", timestamp_age },
  { 2069, 2, true, false, "timestamp_zone", timestamp_zone },
  { 2070, 2, true, false, "timestamp_izone", timestamp_izone },
  { 2071, 2, true, false, "date_pl_interval", date_pl_interval },
  { 2072, 2, true, false, "date_mi_interval", date_mi_interval },
  { 2073, 2, true, false, "textregexsubstr", textregexsubstr },
  { 2075, 2, true, false, "bitfromint8", bitfromint8 },
  { 2076, 1, true, false, "bittoint8", bittoint8 },
  { 2077, 1, true, false, "show_config_by_name", show_config_by_name },
  { 2078, 3, false, false, "set_config_by_name", set_config_by_name },
  { 2079, 1, true, false, "pg_table_is_visible", pg_table_is_visible },
  { 2080, 1, true, false, "pg_type_is_visible", pg_type_is_visible },
  { 2081, 1, true, false, "pg_function_is_visible", pg_function_is_visible },
  { 2082, 1, true, false, "pg_operator_is_visible", pg_operator_is_visible },
  { 2083, 1, true, false, "pg_opclass_is_visible", pg_opclass_is_visible },
  { 2084, 0, true, true, "show_all_settings", show_all_settings },
  { 2085, 3, true, false, "bytea_substr", bytea_substr },
  { 2086, 2, true, false, "bytea_substr_no_len", bytea_substr_no_len },
  { 2087, 3, true, false, "replace_text", replace_text },
  { 2088, 3, true, false, "split_text", split_text },
  { 2089, 1, true, false, "to_hex32", to_hex32 },
  { 2090, 1, true, false, "to_hex64", to_hex64 },
  { 2091, 2, true, false, "array_lower", array_lower },
  { 2092, 2, true, false, "array_upper", array_upper },
  { 2093, 1, true, false, "pg_conversion_is_visible", pg_conversion_is_visible },
  { 2094, 1, true, false, "pg_stat_get_backend_activity_start", pg_stat_get_backend_activity_start },
  { 2096, 1, true, false, "pg_terminate_backend", pg_terminate_backend },
  { 2098, 1, true, false, "pg_get_functiondef", pg_get_functiondef },
  { 2100, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2101, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2102, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2103, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2104, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2105, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2106, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2107, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2108, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2109, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2110, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2111, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2112, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2113, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2114, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2115, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2116, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2117, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2118, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2119, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2120, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2122, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2123, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2124, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2125, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2126, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2127, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2128, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2129, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2130, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2131, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2132, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2133, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2134, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2135, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2136, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2138, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2139, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2140, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2141, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2142, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2143, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2144, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2145, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2146, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2147, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2148, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2149, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2150, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2151, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2152, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2153, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2154, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2155, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2156, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2157, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2158, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2159, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2160, 2, true, false, "text_pattern_lt", text_pattern_lt },
  { 2161, 2, true, false, "text_pattern_le", text_pattern_le },
  { 2162, 1, true, false, "pg_get_function_arguments", pg_get_function_arguments },
  { 2163, 2, true, false, "text_pattern_ge", text_pattern_ge },
  { 2164, 2, true, false, "text_pattern_gt", text_pattern_gt },
  { 2165, 1, true, false, "pg_get_function_result", pg_get_function_result },
  { 2166, 2, true, false, "bttext_pattern_cmp", bttext_pattern_cmp },
  { 2167, 1, true, false, "numeric_ceil", numeric_ceil },
  { 2168, 1, true, false, "pg_database_size_name", pg_database_size_name },
  { 2169, 2, true, false, "numeric_power", numeric_power },
  { 2170, 4, true, false, "width_bucket_numeric", width_bucket_numeric },
  { 2171, 1, true, false, "pg_cancel_backend", pg_cancel_backend },
  { 2172, 3, true, false, "pg_start_backup", pg_start_backup },
  { 2173, 0, true, false, "pg_stop_backup", pg_stop_backup },
  { 2174, 2, true, false, "bpchar_pattern_lt", bpchar_pattern_lt },
  { 2175, 2, true, false, "bpchar_pattern_le", bpchar_pattern_le },
  { 2176, 2, true, false, "array_length", array_length },
  { 2177, 2, true, false, "bpchar_pattern_ge", bpchar_pattern_ge },
  { 2178, 2, true, false, "bpchar_pattern_gt", bpchar_pattern_gt },
  { 2179, 5, true, false, "gist_point_consistent", gist_point_consistent },
  { 2180, 2, true, false, "btbpchar_pattern_cmp", btbpchar_pattern_cmp },
  { 2181, 3, true, false, "has_sequence_privilege_name_name", has_sequence_privilege_name_name },
  { 2182, 3, true, false, "has_sequence_privilege_name_id", has_sequence_privilege_name_id },
  { 2183, 3, true, false, "has_sequence_privilege_id_name", has_sequence_privilege_id_name },
  { 2184, 3, true, false, "has_sequence_privilege_id_id", has_sequence_privilege_id_id },
  { 2185, 2, true, false, "has_sequence_privilege_name", has_sequence_privilege_name },
  { 2186, 2, true, false, "has_sequence_privilege_id", has_sequence_privilege_id },
  { 2188, 2, true, false, "btint48cmp", btint48cmp },
  { 2189, 2, true, false, "btint84cmp", btint84cmp },
  { 2190, 2, true, false, "btint24cmp", btint24cmp },
  { 2191, 2, true, false, "btint42cmp", btint42cmp },
  { 2192, 2, true, false, "btint28cmp", btint28cmp },
  { 2193, 2, true, false, "btint82cmp", btint82cmp },
  { 2194, 2, true, false, "btfloat48cmp", btfloat48cmp },
  { 2195, 2, true, false, "btfloat84cmp", btfloat84cmp },
  { 2196, 0, false, false, "inet_client_addr", inet_client_addr },
  { 2197, 0, false, false, "inet_client_port", inet_client_port },
  { 2198, 0, false, false, "inet_server_addr", inet_server_addr },
  { 2199, 0, false, false, "inet_server_port", inet_server_port },
  { 2212, 1, true, false, "regprocedurein", regprocedurein },
  { 2213, 1, true, false, "regprocedureout", regprocedureout },
  { 2214, 1, true, false, "regoperin", regoperin },
  { 2215, 1, true, false, "regoperout", regoperout },
  { 2216, 1, true, false, "regoperatorin", regoperatorin },
  { 2217, 1, true, false, "regoperatorout", regoperatorout },
  { 2218, 1, true, false, "regclassin", regclassin },
  { 2219, 1, true, false, "regclassout", regclassout },
  { 2220, 1, true, false, "regtypein", regtypein },
  { 2221, 1, true, false, "regtypeout", regtypeout },
  { 2230, 0, false, false, "pg_stat_clear_snapshot", pg_stat_clear_snapshot },
  { 2232, 1, true, false, "pg_get_function_identity_arguments", pg_get_function_identity_arguments },
  { 2233, 1, true, false, "hashtid", hashtid },
  { 2234, 2, true, false, "hashtidextended", hashtidextended },
  { 2236, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2237, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2238, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2239, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2240, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2241, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2242, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2243, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2244, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2245, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2246, 1, true, false, "fmgr_internal_validator", fmgr_internal_validator },
  { 2247, 1, true, false, "fmgr_c_validator", fmgr_c_validator },
  { 2248, 1, true, false, "fmgr_sql_validator", fmgr_sql_validator },
  { 2250, 3, true, false, "has_database_privilege_name_name", has_database_privilege_name_name },
  { 2251, 3, true, false, "has_database_privilege_name_id", has_database_privilege_name_id },
  { 2252, 3, true, false, "has_database_privilege_id_name", has_database_privilege_id_name },
  { 2253, 3, true, false, "has_database_privilege_id_id", has_database_privilege_id_id },
  { 2254, 2, true, false, "has_database_privilege_name", has_database_privilege_name },
  { 2255, 2, true, false, "has_database_privilege_id", has_database_privilege_id },
  { 2256, 3, true, false, "has_function_privilege_name_name", has_function_privilege_name_name },
  { 2257, 3, true, false, "has_function_privilege_name_id", has_function_privilege_name_id },
  { 2258, 3, true, false, "has_function_privilege_id_name", has_function_privilege_id_name },
  { 2259, 3, true, false, "has_function_privilege_id_id", has_function_privilege_id_id },
  { 2260, 2, true, false, "has_function_privilege_name", has_function_privilege_name },
  { 2261, 2, true, false, "has_function_privilege_id", has_function_privilege_id },
  { 2262, 3, true, false, "has_language_privilege_name_name", has_language_privilege_name_name },
  { 2263, 3, true, false, "has_language_privilege_name_id", has_language_privilege_name_id },
  { 2264, 3, true, false, "has_language_privilege_id_name", has_language_privilege_id_name },
  { 2265, 3, true, false, "has_language_privilege_id_id", has_language_privilege_id_id },
  { 2266, 2, true, false, "has_language_privilege_name", has_language_privilege_name },
  { 2267, 2, true, false, "has_language_privilege_id", has_language_privilege_id },
  { 2268, 3, true, false, "has_schema_privilege_name_name", has_schema_privilege_name_name },
  { 2269, 3, true, false, "has_schema_privilege_name_id", has_schema_privilege_name_id },
  { 2270, 3, true, false, "has_schema_privilege_id_name", has_schema_privilege_id_name },
  { 2271, 3, true, false, "has_schema_privilege_id_id", has_schema_privilege_id_id },
  { 2272, 2, true, false, "has_schema_privilege_name", has_schema_privilege_name },
  { 2273, 2, true, false, "has_schema_privilege_id", has_schema_privilege_id },
  { 2274, 0, false, false, "pg_stat_reset", pg_stat_reset },
  { 2284, 3, true, false, "textregexreplace_noopt", textregexreplace_noopt },
  { 2285, 4, true, false, "textregexreplace", textregexreplace },
  { 2286, 1, true, false, "pg_total_relation_size", pg_total_relation_size },
  { 2288, 1, true, false, "pg_size_pretty", pg_size_pretty },
  { 2289, 1, true, true, "pg_options_to_table", pg_options_to_table },
  { 2290, 3, true, false, "record_in", record_in },
  { 2291, 1, true, false, "record_out", record_out },
  { 2292, 1, true, false, "cstring_in", cstring_in },
  { 2293, 1, true, false, "cstring_out", cstring_out },
  { 2294, 1, true, false, "any_in", any_in },
  { 2295, 1, true, false, "any_out", any_out },
  { 2296, 1, true, false, "anyarray_in", anyarray_in },
  { 2297, 1, true, false, "anyarray_out", anyarray_out },
  { 2298, 1, true, false, "void_in", void_in },
  { 2299, 1, true, false, "void_out", void_out },
  { 2300, 1, false, false, "trigger_in", trigger_in },
  { 2301, 1, true, false, "trigger_out", trigger_out },
  { 2302, 1, false, false, "language_handler_in", language_handler_in },
  { 2303, 1, true, false, "language_handler_out", language_handler_out },
  { 2304, 1, false, false, "internal_in", internal_in },
  { 2305, 1, true, false, "internal_out", internal_out },
  { 2306, 0, false, true, "pg_stat_get_slru", pg_stat_get_slru },
  { 2307, 1, false, false, "pg_stat_reset_slru", pg_stat_reset_slru },
  { 2308, 1, true, false, "dceil", dceil },
  { 2309, 1, true, false, "dfloor", dfloor },
  { 2310, 1, true, false, "dsign", dsign },
  { 2311, 1, true, false, "md5_text", md5_text },
  { 2312, 1, true, false, "anyelement_in", anyelement_in },
  { 2313, 1, true, false, "anyelement_out", anyelement_out },
  { 2316, 2, true, false, "postgresql_fdw_validator", postgresql_fdw_validator },
  { 2319, 1, true, false, "pg_encoding_max_length_sql", pg_encoding_max_length_sql },
  { 2320, 1, true, false, "dceil", dceil },
  { 2321, 1, true, false, "md5_bytea", md5_bytea },
  { 2322, 1, true, false, "pg_tablespace_size_oid", pg_tablespace_size_oid },
  { 2323, 1, true, false, "pg_tablespace_size_name", pg_tablespace_size_name },
  { 2324, 1, true, false, "pg_database_size_oid", pg_database_size_oid },
  { 2331, 1, true, true, "array_unnest", array_unnest },
  { 2332, 2, true, false, "pg_relation_size", pg_relation_size },
  { 2333, 2, false, false, "array_agg_transfn", array_agg_transfn },
  { 2334, 2, false, false, "array_agg_finalfn", array_agg_finalfn },
  { 2335, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2338, 2, true, false, "date_lt_timestamp", date_lt_timestamp },
  { 2339, 2, true, false, "date_le_timestamp", date_le_timestamp },
  { 2340, 2, true, false, "date_eq_timestamp", date_eq_timestamp },
  { 2341, 2, true, false, "date_gt_timestamp", date_gt_timestamp },
  { 2342, 2, true, false, "date_ge_timestamp", date_ge_timestamp },
  { 2343, 2, true, false, "date_ne_timestamp", date_ne_timestamp },
  { 2344, 2, true, false, "date_cmp_timestamp", date_cmp_timestamp },
  { 2351, 2, true, false, "date_lt_timestamptz", date_lt_timestamptz },
  { 2352, 2, true, false, "date_le_timestamptz", date_le_timestamptz },
  { 2353, 2, true, false, "date_eq_timestamptz", date_eq_timestamptz },
  { 2354, 2, true, false, "date_gt_timestamptz", date_gt_timestamptz },
  { 2355, 2, true, false, "date_ge_timestamptz", date_ge_timestamptz },
  { 2356, 2, true, false, "date_ne_timestamptz", date_ne_timestamptz },
  { 2357, 2, true, false, "date_cmp_timestamptz", date_cmp_timestamptz },
  { 2364, 2, true, false, "timestamp_lt_date", timestamp_lt_date },
  { 2365, 2, true, false, "timestamp_le_date", timestamp_le_date },
  { 2366, 2, true, false, "timestamp_eq_date", timestamp_eq_date },
  { 2367, 2, true, false, "timestamp_gt_date", timestamp_gt_date },
  { 2368, 2, true, false, "timestamp_ge_date", timestamp_ge_date },
  { 2369, 2, true, false, "timestamp_ne_date", timestamp_ne_date },
  { 2370, 2, true, false, "timestamp_cmp_date", timestamp_cmp_date },
  { 2377, 2, true, false, "timestamptz_lt_date", timestamptz_lt_date },
  { 2378, 2, true, false, "timestamptz_le_date", timestamptz_le_date },
  { 2379, 2, true, false, "timestamptz_eq_date", timestamptz_eq_date },
  { 2380, 2, true, false, "timestamptz_gt_date", timestamptz_gt_date },
  { 2381, 2, true, false, "timestamptz_ge_date", timestamptz_ge_date },
  { 2382, 2, true, false, "timestamptz_ne_date", timestamptz_ne_date },
  { 2383, 2, true, false, "timestamptz_cmp_date", timestamptz_cmp_date },
  { 2390, 3, true, false, "has_tablespace_privilege_name_name", has_tablespace_privilege_name_name },
  { 2391, 3, true, false, "has_tablespace_privilege_name_id", has_tablespace_privilege_name_id },
  { 2392, 3, true, false, "has_tablespace_privilege_id_name", has_tablespace_privilege_id_name },
  { 2393, 3, true, false, "has_tablespace_privilege_id_id", has_tablespace_privilege_id_id },
  { 2394, 2, true, false, "has_tablespace_privilege_name", has_tablespace_privilege_name },
  { 2395, 2, true, false, "has_tablespace_privilege_id", has_tablespace_privilege_id },
  { 2398, 1, false, false, "shell_in", shell_in },
  { 2399, 1, true, false, "shell_out", shell_out },
  { 2400, 3, true, false, "array_recv", array_recv },
  { 2401, 1, true, false, "array_send", array_send },
  { 2402, 3, true, false, "record_recv", record_recv },
  { 2403, 1, true, false, "record_send", record_send },
  { 2404, 1, true, false, "int2recv", int2recv },
  { 2405, 1, true, false, "int2send", int2send },
  { 2406, 1, true, false, "int4recv", int4recv },
  { 2407, 1, true, false, "int4send", int4send },
  { 2408, 1, true, false, "int8recv", int8recv },
  { 2409, 1, true, false, "int8send", int8send },
  { 2410, 1, true, false, "int2vectorrecv", int2vectorrecv },
  { 2411, 1, true, false, "int2vectorsend", int2vectorsend },
  { 2412, 1, true, false, "bytearecv", bytearecv },
  { 2413, 1, true, false, "byteasend", byteasend },
  { 2414, 1, true, false, "textrecv", textrecv },
  { 2415, 1, true, false, "textsend", textsend },
  { 2416, 1, true, false, "unknownrecv", unknownrecv },
  { 2417, 1, true, false, "unknownsend", unknownsend },
  { 2418, 1, true, false, "oidrecv", oidrecv },
  { 2419, 1, true, false, "oidsend", oidsend },
  { 2420, 1, true, false, "oidvectorrecv", oidvectorrecv },
  { 2421, 1, true, false, "oidvectorsend", oidvectorsend },
  { 2422, 1, true, false, "namerecv", namerecv },
  { 2423, 1, true, false, "namesend", namesend },
  { 2424, 1, true, false, "float4recv", float4recv },
  { 2425, 1, true, false, "float4send", float4send },
  { 2426, 1, true, false, "float8recv", float8recv },
  { 2427, 1, true, false, "float8send", float8send },
  { 2428, 1, true, false, "point_recv", point_recv },
  { 2429, 1, true, false, "point_send", point_send },
  { 2430, 3, true, false, "bpcharrecv", bpcharrecv },
  { 2431, 1, true, false, "bpcharsend", bpcharsend },
  { 2432, 3, true, false, "varcharrecv", varcharrecv },
  { 2433, 1, true, false, "varcharsend", varcharsend },
  { 2434, 1, true, false, "charrecv", charrecv },
  { 2435, 1, true, false, "charsend", charsend },
  { 2436, 1, true, false, "boolrecv", boolrecv },
  { 2437, 1, true, false, "boolsend", boolsend },
  { 2438, 1, true, false, "tidrecv", tidrecv },
  { 2439, 1, true, false, "tidsend", tidsend },
  { 2440, 1, true, false, "xidrecv", xidrecv },
  { 2441, 1, true, false, "xidsend", xidsend },
  { 2442, 1, true, false, "cidrecv", cidrecv },
  { 2443, 1, true, false, "cidsend", cidsend },
  { 2444, 1, true, false, "regprocrecv", regprocrecv },
  { 2445, 1, true, false, "regprocsend", regprocsend },
  { 2446, 1, true, false, "regprocedurerecv", regprocedurerecv },
  { 2447, 1, true, false, "regproceduresend", regproceduresend },
  { 2448, 1, true, false, "regoperrecv", regoperrecv },
  { 2449, 1, true, false, "regopersend", regopersend },
  { 2450, 1, true, false, "regoperatorrecv", regoperatorrecv },
  { 2451, 1, true, false, "regoperatorsend", regoperatorsend },
  { 2452, 1, true, false, "regclassrecv", regclassrecv },
  { 2453, 1, true, false, "regclasssend", regclasssend },
  { 2454, 1, true, false, "regtyperecv", regtyperecv },
  { 2455, 1, true, false, "regtypesend", regtypesend },
  { 2456, 3, true, false, "bit_recv", bit_recv },
  { 2457, 1, true, false, "bit_send", bit_send },
  { 2458, 3, true, false, "varbit_recv", varbit_recv },
  { 2459, 1, true, false, "varbit_send", varbit_send },
  { 2460, 3, true, false, "numeric_recv", numeric_recv },
  { 2461, 1, true, false, "numeric_send", numeric_send },
  { 2462, 1, true, false, "dsinh", dsinh },
  { 2463, 1, true, false, "dcosh", dcosh },
  { 2464, 1, true, false, "dtanh", dtanh },
  { 2465, 1, true, false, "dasinh", dasinh },
  { 2466, 1, true, false, "dacosh", dacosh },
  { 2467, 1, true, false, "datanh", datanh },
  { 2468, 1, true, false, "date_recv", date_recv },
  { 2469, 1, true, false, "date_send", date_send },
  { 2470, 3, true, false, "time_recv", time_recv },
  { 2471, 1, true, false, "time_send", time_send },
  { 2472, 3, true, false, "timetz_recv", timetz_recv },
  { 2473, 1, true, false, "timetz_send", timetz_send },
  { 2474, 3, true, false, "timestamp_recv", timestamp_recv },
  { 2475, 1, true, false, "timestamp_send", timestamp_send },
  { 2476, 3, true, false, "timestamptz_recv", timestamptz_recv },
  { 2477, 1, true, false, "timestamptz_send", timestamptz_send },
  { 2478, 3, true, false, "interval_recv", interval_recv },
  { 2479, 1, true, false, "interval_send", interval_send },
  { 2480, 1, true, false, "lseg_recv", lseg_recv },
  { 2481, 1, true, false, "lseg_send", lseg_send },
  { 2482, 1, true, false, "path_recv", path_recv },
  { 2483, 1, true, false, "path_send", path_send },
  { 2484, 1, true, false, "box_recv", box_recv },
  { 2485, 1, true, false, "box_send", box_send },
  { 2486, 1, true, false, "poly_recv", poly_recv },
  { 2487, 1, true, false, "poly_send", poly_send },
  { 2488, 1, true, false, "line_recv", line_recv },
  { 2489, 1, true, false, "line_send", line_send },
  { 2490, 1, true, false, "circle_recv", circle_recv },
  { 2491, 1, true, false, "circle_send", circle_send },
  { 2492, 1, true, false, "cash_recv", cash_recv },
  { 2493, 1, true, false, "cash_send", cash_send },
  { 2494, 1, true, false, "macaddr_recv", macaddr_recv },
  { 2495, 1, true, false, "macaddr_send", macaddr_send },
  { 2496, 1, true, false, "inet_recv", inet_recv },
  { 2497, 1, true, false, "inet_send", inet_send },
  { 2498, 1, true, false, "cidr_recv", cidr_recv },
  { 2499, 1, true, false, "cidr_send", cidr_send },
  { 2500, 1, true, false, "cstring_recv", cstring_recv },
  { 2501, 1, true, false, "cstring_send", cstring_send },
  { 2502, 1, true, false, "anyarray_recv", anyarray_recv },
  { 2503, 1, true, false, "anyarray_send", anyarray_send },
  { 2504, 2, true, false, "pg_get_ruledef_ext", pg_get_ruledef_ext },
  { 2505, 2, true, false, "pg_get_viewdef_name_ext", pg_get_viewdef_name_ext },
  { 2506, 2, true, false, "pg_get_viewdef_ext", pg_get_viewdef_ext },
  { 2507, 3, true, false, "pg_get_indexdef_ext", pg_get_indexdef_ext },
  { 2508, 2, true, false, "pg_get_constraintdef_ext", pg_get_constraintdef_ext },
  { 2509, 3, true, false, "pg_get_expr_ext", pg_get_expr_ext },
  { 2510, 0, true, true, "pg_prepared_statement", pg_prepared_statement },
  { 2511, 0, true, true, "pg_cursor", pg_cursor },
  { 2512, 1, true, false, "float8_var_pop", float8_var_pop },
  { 2513, 1, true, false, "float8_stddev_pop", float8_stddev_pop },
  { 2514, 1, false, false, "numeric_var_pop", numeric_var_pop },
  { 2515, 2, true, false, "booland_statefunc", booland_statefunc },
  { 2516, 2, true, false, "boolor_statefunc", boolor_statefunc },
  { 2517, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2518, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2519, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2520, 2, true, false, "timestamp_lt_timestamptz", timestamp_lt_timestamptz },
  { 2521, 2, true, false, "timestamp_le_timestamptz", timestamp_le_timestamptz },
  { 2522, 2, true, false, "timestamp_eq_timestamptz", timestamp_eq_timestamptz },
  { 2523, 2, true, false, "timestamp_gt_timestamptz", timestamp_gt_timestamptz },
  { 2524, 2, true, false, "timestamp_ge_timestamptz", timestamp_ge_timestamptz },
  { 2525, 2, true, false, "timestamp_ne_timestamptz", timestamp_ne_timestamptz },
  { 2526, 2, true, false, "timestamp_cmp_timestamptz", timestamp_cmp_timestamptz },
  { 2527, 2, true, false, "timestamptz_lt_timestamp", timestamptz_lt_timestamp },
  { 2528, 2, true, false, "timestamptz_le_timestamp", timestamptz_le_timestamp },
  { 2529, 2, true, false, "timestamptz_eq_timestamp", timestamptz_eq_timestamp },
  { 2530, 2, true, false, "timestamptz_gt_timestamp", timestamptz_gt_timestamp },
  { 2531, 2, true, false, "timestamptz_ge_timestamp", timestamptz_ge_timestamp },
  { 2532, 2, true, false, "timestamptz_ne_timestamp", timestamptz_ne_timestamp },
  { 2533, 2, true, false, "timestamptz_cmp_timestamp", timestamptz_cmp_timestamp },
  { 2556, 1, true, true, "pg_tablespace_databases", pg_tablespace_databases },
  { 2557, 1, true, false, "int4_bool", int4_bool },
  { 2558, 1, true, false, "bool_int4", bool_int4 },
  { 2559, 0, true, false, "lastval", lastval },
  { 2560, 0, true, false, "pg_postmaster_start_time", pg_postmaster_start_time },
  { 2561, 1, true, false, "pg_blocking_pids", pg_blocking_pids },
  { 2562, 2, true, false, "box_below", box_below },
  { 2563, 2, true, false, "box_overbelow", box_overbelow },
  { 2564, 2, true, false, "box_overabove", box_overabove },
  { 2565, 2, true, false, "box_above", box_above },
  { 2566, 2, true, false, "poly_below", poly_below },
  { 2567, 2, true, false, "poly_overbelow", poly_overbelow },
  { 2568, 2, true, false, "poly_overabove", poly_overabove },
  { 2569, 2, true, false, "poly_above", poly_above },
  { 2578, 5, true, false, "gist_box_consistent", gist_box_consistent },
  { 2580, 1, true, false, "jsonb_float8", jsonb_float8 },
  { 2581, 3, true, false, "gist_box_penalty", gist_box_penalty },
  { 2582, 2, true, false, "gist_box_picksplit", gist_box_picksplit },
  { 2583, 2, true, false, "gist_box_union", gist_box_union },
  { 2584, 3, true, false, "gist_box_same", gist_box_same },
  { 2585, 5, true, false, "gist_poly_consistent", gist_poly_consistent },
  { 2586, 1, true, false, "gist_poly_compress", gist_poly_compress },
  { 2587, 2, true, false, "circle_overbelow", circle_overbelow },
  { 2588, 2, true, false, "circle_overabove", circle_overabove },
  { 2591, 5, true, false, "gist_circle_consistent", gist_circle_consistent },
  { 2592, 1, true, false, "gist_circle_compress", gist_circle_compress },
  { 2596, 1, false, false, "numeric_stddev_pop", numeric_stddev_pop },
  { 2597, 3, false, false, "domain_in", domain_in },
  { 2598, 3, false, false, "domain_recv", domain_recv },
  { 2599, 0, true, true, "pg_timezone_abbrevs", pg_timezone_abbrevs },
  { 2614, 2, true, false, "xmlexists", xmlexists },
  { 2621, 0, true, false, "pg_reload_conf", pg_reload_conf },
  { 2622, 0, true, false, "pg_rotate_logfile_v2", pg_rotate_logfile_v2 },
  { 2623, 1, true, false, "pg_stat_file_1arg", pg_stat_file_1arg },
  { 2624, 3, true, false, "pg_read_file_off_len", pg_read_file_off_len },
  { 2625, 1, true, true, "pg_ls_dir_1arg", pg_ls_dir_1arg },
  { 2626, 1, true, false, "pg_sleep", pg_sleep },
  { 2627, 1, true, false, "inetnot", inetnot },
  { 2628, 2, true, false, "inetand", inetand },
  { 2629, 2, true, false, "inetor", inetor },
  { 2630, 2, true, false, "inetpl", inetpl },
  { 2632, 2, true, false, "inetmi_int8", inetmi_int8 },
  { 2633, 2, true, false, "inetmi", inetmi },
  { 2641, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2642, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2643, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2644, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2645, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2646, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2647, 0, true, false, "now", now },
  { 2648, 0, true, false, "statement_timestamp", statement_timestamp },
  { 2649, 0, true, false, "clock_timestamp", clock_timestamp },
  { 2700, 4, true, false, "gin_cmp_prefix", gin_cmp_prefix },
  { 2705, 3, true, false, "pg_has_role_name_name", pg_has_role_name_name },
  { 2706, 3, true, false, "pg_has_role_name_id", pg_has_role_name_id },
  { 2707, 3, true, false, "pg_has_role_id_name", pg_has_role_id_name },
  { 2708, 3, true, false, "pg_has_role_id_id", pg_has_role_id_id },
  { 2709, 2, true, false, "pg_has_role_name", pg_has_role_name },
  { 2710, 2, true, false, "pg_has_role_id", pg_has_role_id },
  { 2711, 1, true, false, "interval_justify_interval", interval_justify_interval },
  { 2712, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2713, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2714, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2715, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2716, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2717, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2718, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2719, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2720, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2721, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2722, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2723, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2724, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2725, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2726, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2727, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2728, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2729, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2730, 2, true, false, "pg_get_triggerdef_ext", pg_get_triggerdef_ext },
  { 2731, 1, true, false, "dasind", dasind },
  { 2732, 1, true, false, "dacosd", dacosd },
  { 2733, 1, true, false, "datand", datand },
  { 2734, 2, true, false, "datan2d", datan2d },
  { 2735, 1, true, false, "dsind", dsind },
  { 2736, 1, true, false, "dcosd", dcosd },
  { 2737, 1, true, false, "dtand", dtand },
  { 2738, 1, true, false, "dcotd", dcotd },
  { 2739, 2, true, true, "pg_stop_backup_v2", pg_stop_backup_v2 },
  { 2740, 1, true, false, "numeric_avg_serialize", numeric_avg_serialize },
  { 2741, 2, true, false, "numeric_avg_deserialize", numeric_avg_deserialize },
  { 2743, 3, true, false, "ginarrayextract", ginarrayextract },
  { 2744, 8, true, false, "ginarrayconsistent", ginarrayconsistent },
  { 2746, 2, false, false, "int8_avg_accum", int8_avg_accum },
  { 2747, 2, true, false, "arrayoverlap", arrayoverlap },
  { 2748, 2, true, false, "arraycontains", arraycontains },
  { 2749, 2, true, false, "arraycontained", arraycontained },
  { 2758, 1, true, false, "pg_stat_get_db_tuples_returned", pg_stat_get_db_tuples_returned },
  { 2759, 1, true, false, "pg_stat_get_db_tuples_fetched", pg_stat_get_db_tuples_fetched },
  { 2760, 1, true, false, "pg_stat_get_db_tuples_inserted", pg_stat_get_db_tuples_inserted },
  { 2761, 1, true, false, "pg_stat_get_db_tuples_updated", pg_stat_get_db_tuples_updated },
  { 2762, 1, true, false, "pg_stat_get_db_tuples_deleted", pg_stat_get_db_tuples_deleted },
  { 2763, 2, true, true, "regexp_matches_no_flags", regexp_matches_no_flags },
  { 2764, 3, true, true, "regexp_matches", regexp_matches },
  { 2765, 2, true, true, "regexp_split_to_table_no_flags", regexp_split_to_table_no_flags },
  { 2766, 3, true, true, "regexp_split_to_table", regexp_split_to_table },
  { 2767, 2, true, false, "regexp_split_to_array_no_flags", regexp_split_to_array_no_flags },
  { 2768, 3, true, false, "regexp_split_to_array", regexp_split_to_array },
  { 2769, 0, true, false, "pg_stat_get_bgwriter_timed_checkpoints", pg_stat_get_bgwriter_timed_checkpoints },
  { 2770, 0, true, false, "pg_stat_get_bgwriter_requested_checkpoints", pg_stat_get_bgwriter_requested_checkpoints },
  { 2771, 0, true, false, "pg_stat_get_bgwriter_buf_written_checkpoints", pg_stat_get_bgwriter_buf_written_checkpoints },
  { 2772, 0, true, false, "pg_stat_get_bgwriter_buf_written_clean", pg_stat_get_bgwriter_buf_written_clean },
  { 2773, 0, true, false, "pg_stat_get_bgwriter_maxwritten_clean", pg_stat_get_bgwriter_maxwritten_clean },
  { 2774, 7, true, false, "ginqueryarrayextract", ginqueryarrayextract },
  { 2775, 0, true, false, "pg_stat_get_buf_written_backend", pg_stat_get_buf_written_backend },
  { 2777, 1, true, false, "anynonarray_in", anynonarray_in },
  { 2778, 1, true, false, "anynonarray_out", anynonarray_out },
  { 2781, 1, true, false, "pg_stat_get_last_vacuum_time", pg_stat_get_last_vacuum_time },
  { 2782, 1, true, false, "pg_stat_get_last_autovacuum_time", pg_stat_get_last_autovacuum_time },
  { 2783, 1, true, false, "pg_stat_get_last_analyze_time", pg_stat_get_last_analyze_time },
  { 2784, 1, true, false, "pg_stat_get_last_autoanalyze_time", pg_stat_get_last_autoanalyze_time },
  { 2785, 2, false, false, "int8_avg_combine", int8_avg_combine },
  { 2786, 1, true, false, "int8_avg_serialize", int8_avg_serialize },
  { 2787, 2, true, false, "int8_avg_deserialize", int8_avg_deserialize },
  { 2788, 1, true, false, "pg_stat_get_backend_wait_event_type", pg_stat_get_backend_wait_event_type },
  { 2790, 2, true, false, "tidgt", tidgt },
  { 2791, 2, true, false, "tidlt", tidlt },
  { 2792, 2, true, false, "tidge", tidge },
  { 2793, 2, true, false, "tidle", tidle },
  { 2794, 2, true, false, "bttidcmp", bttidcmp },
  { 2795, 2, true, false, "tidlarger", tidlarger },
  { 2796, 2, true, false, "tidsmaller", tidsmaller },
  { 2797, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2798, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2803, 0, false, false, "aggregate_dummy", aggregate_dummy },
  { 2804, 2, true, false, "int8inc_any", int8inc_any },
  { 2805, 3, true, false, "int8inc_float8_float8", int8inc_float8_float8 },
  { 2806, 3, true, false, "float8_regr_accum", float8_regr_accum },
  { 2807, 1, true, false, "float8_regr_sxx", float8_regr_sxx },
  { 2808, 1, true, false, "float8_regr_syy", float8_regr_syy },
  { 2809, 1, true, false, "float8_regr_sxy", float8_regr_sxy },
  { 2810, 1, true, false, "float8_regr_avgx", float8_regr_avgx },
  { 2811, 1, true, false, "float8_regr_avgy", float8_regr_avgy },
  { 2812, 1, true, false, "float8_regr_r2", float8_regr_r2 },
  { 2813, 1, true, false, "float8_regr_slope", float8_regr_slope },
  { 2814, 1, true, false, "float8_regr_intercept", float8_regr_intercept },
  { 2815, 1, true, false, "float8_covar_pop", float8_covar_pop },
  { 2816, 1, true, false, "float8_covar_samp", float8_covar_samp },
  { 2817, 1, true, false, "float8_corr", float8_corr },
  { 2818, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2819, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2820, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2821, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2822, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2823, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2824, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2825, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2826, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2827, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2828, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2829, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 2844, 1, true, false, "pg_stat_get_db_blk_read_time", pg_stat_get_db_blk_read_time },
  { 2845, 1, true, false, "pg_stat_get_db_blk_write_time", pg_stat_get_db_blk_write_time },
  { 2848, 0, true, false, "pg_switch_wal", pg_switch_wal },
  { 2849, 0, true, false, "pg_current_wal_lsn", pg_current_wal_lsn },
  { 2850, 1, true, false, "pg_walfile_name_offset", pg_walfile_name_offset },
  { 2851, 1, true, false, "pg_walfile_name", pg_walfile_name },
  { 2852, 0, true, false, "pg_current_wal_insert_lsn", pg_current_wal_insert_lsn },
  { 2853, 1, true, false, "pg_stat_get_backend_wait_event", pg_stat_get_backend_wait_event },
  { 2854, 0, true, false, "pg_my_temp_schema", pg_my_temp_schema },
  { 2855, 1, true, false, "pg_is_other_temp_schema", pg_is_other_temp_schema },
  { 2856, 0, true, true, "pg_timezone_names", pg_timezone_names },
  { 2857, 1, true, false, "pg_stat_get_backend_xact_start", pg_stat_get_backend_xact_start },
  { 2858, 2, false, false, "numeric_avg_accum", numeric_avg_accum },
  { 2859, 0, true, false, "pg_stat_get_buf_alloc", pg_stat_get_buf_alloc },
  { 2878, 1, true, false, "pg_stat_get_live_tuples", pg_stat_get_live_tuples },
  { 2879, 1, true, false, "pg_stat_get_dead_tuples", pg_stat_get_dead_tuples },
  { 2880, 1, true, false, "pg_advisory_lock_int8", pg_advisory_lock_int8 },
  { 2881, 1, true, false, "pg_advisory_lock_shared_int8", pg_advisory_lock_shared_int8 },
  { 2882, 1, true, false, "pg_try_advisory_lock_int8", pg_try_advisory_lock_int8 },
  { 2883, 1, true, false, "pg_try_advisory_lock_shared_int8", pg_try_advisory_lock_shared_int8 },
  { 2884, 1, true, false, "pg_advisory_unlock_int8", pg_advisory_unlock_int8 },
  { 2885, 1, true, false, "pg_advisory_unlock_shared_int8", pg_advisory_unlock_shared_int8 },
  { 2886, 2, true, false, "pg_advisory_lock_int4", pg_advisory_lock_int4 },
  { 2887, 2, true, false, "pg_advisory_lock_shared_int4", pg_advisory_lock_shared_int4 },
  { 2888, 2, true, false, "pg_try_advisory_lock_int4", pg_try_advisory_lock_int4 },
  { 2889, 2, true, false, "pg_try_advisory_lock_shared_int4", pg_try_advisory_lock_shared_int4 },
  { 2890, 2, true, false, "pg_advisory_unlock_int4", pg_advisory_unlock_int4 },
  { 2891, 2, true, false, "pg_advisory_unlock_shared_int4", pg_advisory_unlock_shared_int4 },
  { 2892, 0, true, false, "pg_advisory_unlock_all", pg_advisory_unlock_all },
  { 2893, 1, true, false, "xml_in", xml_in },
  { 2894, 1, true, false, "xml_out", xml_out },
  { 2895, 1, true, false, "xmlcomment", xmlcomment },
  { 2896, 1, true, false, "texttoxml", texttoxml },
  { 2897, 2, true, false, "xmlvalidate", xmlvalidate },
  { 2898, 1, true, false, "xml_recv", xml_recv },
  { 2899, 1, true, false, "xml_send", xml_send },
  { 2900, 2, false, false, "xmlconcat2", xmlconcat2 },
  { 2901, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 2902, 1, true, false, "varbittypmodin", varbittypmodin },
  { 2903, 1, true, false, "intervaltypmodin", intervaltypmodin },
  { 2904, 1, true, false, "intervaltypmodout", intervaltypmodout },
  { 2905, 1, true, false, "timestamptypmodin", timestamptypmodin },
  { 2906, 1, true, false, "timestamptypmodout", timestamptypmodout },
  { 2907, 1, true, false, "timestamptztypmodin", timestamptztypmodin },
  { 2908, 1, true, false, "timestamptztypmodout", timestamptztypmodout },
  { 2909, 1, true, false, "timetypmodin", timetypmodin },
  { 2910, 1, true, false, "timetypmodout", timetypmodout },
  { 2911, 1, true, false, "timetztypmodin", timetztypmodin },
  { 2912, 1, true, false, "timetztypmodout", timetztypmodout },
  { 2913, 1, true, false, "bpchartypmodin", bpchartypmodin },
  { 2914, 1, true, false, "bpchartypmodout", bpchartypmodout },
  { 2915, 1, true, false, "varchartypmodin", varchartypmodin },
  { 2916, 1, true, false, "varchartypmodout", varchartypmodout },
  { 2917, 1, true, false, "numerictypmodin", numerictypmodin },
  { 2918, 1, true, false, "numerictypmodout", numerictypmodout },
  { 2919, 1, true, false, "bittypmodin", bittypmodin },
  { 2920, 1, true, false, "bittypmodout", bittypmodout },
  { 2921, 1, true, false, "varbittypmodout", varbittypmodout },
  { 2922, 1, true, false, "xmltotext", xmltotext },
  { 2923, 4, true, false, "table_to_xml", table_to_xml },
  { 2924, 4, true, false, "query_to_xml", query_to_xml },
  { 2925, 5, true, false, "cursor_to_xml", cursor_to_xml },
  { 2926, 4, true, false, "table_to_xmlschema", table_to_xmlschema },
  { 2927, 4, true, false, "query_to_xmlschema", query_to_xmlschema },
  { 2928, 4, true, false, "cursor_to_xmlschema", cursor_to_xmlschema },
  { 2929, 4, true, false, "table_to_xml_and_xmlschema", table_to_xml_and_xmlschema },
  { 2930, 4, true, false, "query_to_xml_and_xmlschema", query_to_xml_and_xmlschema },
  { 2931, 3, true, false, "xpath", xpath },
  { 2933, 4, true, false, "schema_to_xml", schema_to_xml },
  { 2934, 4, true, false, "schema_to_xmlschema", schema_to_xmlschema },
  { 2935, 4, true, false, "schema_to_xml_and_xmlschema", schema_to_xml_and_xmlschema },
  { 2936, 3, true, false, "database_to_xml", database_to_xml },
  { 2937, 3, true, false, "database_to_xmlschema", database_to_xmlschema },
  { 2938, 3, true, false, "database_to_xml_and_xmlschema", database_to_xml_and_xmlschema },
  { 2939, 1, true, false, "pg_snapshot_in", pg_snapshot_in },
  { 2940, 1, true, false, "pg_snapshot_out", pg_snapshot_out },
  { 2941, 1, true, false, "pg_snapshot_recv", pg_snapshot_recv },
  { 2942, 1, true, false, "pg_snapshot_send", pg_snapshot_send },
  { 2943, 0, true, false, "pg_current_xact_id", pg_current_xact_id },
  { 2944, 0, true, false, "pg_current_snapshot", pg_current_snapshot },
  { 2945, 1, true, false, "pg_snapshot_xmin", pg_snapshot_xmin },
  { 2946, 1, true, false, "pg_snapshot_xmax", pg_snapshot_xmax },
  { 2947, 1, true, true, "pg_snapshot_xip", pg_snapshot_xip },
  { 2948, 2, true, false, "pg_visible_in_snapshot", pg_visible_in_snapshot },
  { 2952, 1, true, false, "uuid_in", uuid_in },
  { 2953, 1, true, false, "uuid_out", uuid_out },
  { 2954, 2, true, false, "uuid_lt", uuid_lt },
  { 2955, 2, true, false, "uuid_le", uuid_le },
  { 2956, 2, true, false, "uuid_eq", uuid_eq },
  { 2957, 2, true, false, "uuid_ge", uuid_ge },
  { 2958, 2, true, false, "uuid_gt", uuid_gt },
  { 2959, 2, true, false, "uuid_ne", uuid_ne },
  { 2960, 2, true, false, "uuid_cmp", uuid_cmp },
  { 2961, 1, true, false, "uuid_recv", uuid_recv },
  { 2962, 1, true, false, "uuid_send", uuid_send },
  { 2963, 1, true, false, "uuid_hash", uuid_hash },
  { 2971, 1, true, false, "booltext", booltext },
  { 2978, 1, true, false, "pg_stat_get_function_calls", pg_stat_get_function_calls },
  { 2979, 1, true, false, "pg_stat_get_function_total_time", pg_stat_get_function_total_time },
  { 2980, 1, true, false, "pg_stat_get_function_self_time", pg_stat_get_function_self_time },
  { 2981, 2, true, false, "record_eq", record_eq },
  { 2982, 2, true, false, "record_ne", record_ne },
  { 2983, 2, true, false, "record_lt", record_lt },
  { 2984, 2, true, false, "record_gt", record_gt },
  { 2985, 2, true, false, "record_le", record_le },
  { 2986, 2, true, false, "record_ge", record_ge },
  { 2987, 2, true, false, "btrecordcmp", btrecordcmp },
  { 2997, 1, true, false, "pg_table_size", pg_table_size },
  { 2998, 1, true, false, "pg_indexes_size", pg_indexes_size },
  { 2999, 1, true, false, "pg_relation_filenode", pg_relation_filenode },
  { 3000, 3, true, false, "has_foreign_data_wrapper_privilege_name_name", has_foreign_data_wrapper_privilege_name_name },
  { 3001, 3, true, false, "has_foreign_data_wrapper_privilege_name_id", has_foreign_data_wrapper_privilege_name_id },
  { 3002, 3, true, false, "has_foreign_data_wrapper_privilege_id_name", has_foreign_data_wrapper_privilege_id_name },
  { 3003, 3, true, false, "has_foreign_data_wrapper_privilege_id_id", has_foreign_data_wrapper_privilege_id_id },
  { 3004, 2, true, false, "has_foreign_data_wrapper_privilege_name", has_foreign_data_wrapper_privilege_name },
  { 3005, 2, true, false, "has_foreign_data_wrapper_privilege_id", has_foreign_data_wrapper_privilege_id },
  { 3006, 3, true, false, "has_server_privilege_name_name", has_server_privilege_name_name },
  { 3007, 3, true, false, "has_server_privilege_name_id", has_server_privilege_name_id },
  { 3008, 3, true, false, "has_server_privilege_id_name", has_server_privilege_id_name },
  { 3009, 3, true, false, "has_server_privilege_id_id", has_server_privilege_id_id },
  { 3010, 2, true, false, "has_server_privilege_name", has_server_privilege_name },
  { 3011, 2, true, false, "has_server_privilege_id", has_server_privilege_id },
  { 3012, 4, true, false, "has_column_privilege_name_name_name", has_column_privilege_name_name_name },
  { 3013, 4, true, false, "has_column_privilege_name_name_attnum", has_column_privilege_name_name_attnum },
  { 3014, 4, true, false, "has_column_privilege_name_id_name", has_column_privilege_name_id_name },
  { 3015, 4, true, false, "has_column_privilege_name_id_attnum", has_column_privilege_name_id_attnum },
  { 3016, 4, true, false, "has_column_privilege_id_name_name", has_column_privilege_id_name_name },
  { 3017, 4, true, false, "has_column_privilege_id_name_attnum", has_column_privilege_id_name_attnum },
  { 3018, 4, true, false, "has_column_privilege_id_id_name", has_column_privilege_id_id_name },
  { 3019, 4, true, false, "has_column_privilege_id_id_attnum", has_column_privilege_id_id_attnum },
  { 3020, 3, true, false, "has_column_privilege_name_name", has_column_privilege_name_name },
  { 3021, 3, true, false, "has_column_privilege_name_attnum", has_column_privilege_name_attnum },
  { 3022, 3, true, false, "has_column_privilege_id_name", has_column_privilege_id_name },
  { 3023, 3, true, false, "has_column_privilege_id_attnum", has_column_privilege_id_attnum },
  { 3024, 3, true, false, "has_any_column_privilege_name_name", has_any_column_privilege_name_name },
  { 3025, 3, true, false, "has_any_column_privilege_name_id", has_any_column_privilege_name_id },
  { 3026, 3, true, false, "has_any_column_privilege_id_name", has_any_column_privilege_id_name },
  { 3027, 3, true, false, "has_any_column_privilege_id_id", has_any_column_privilege_id_id },
  { 3028, 2, true, false, "has_any_column_privilege_name", has_any_column_privilege_name },
  { 3029, 2, true, false, "has_any_column_privilege_id", has_any_column_privilege_id },
  { 3030, 4, true, false, "bitoverlay", bitoverlay },
  { 3031, 3, true, false, "bitoverlay_no_len", bitoverlay_no_len },
  { 3032, 2, true, false, "bitgetbit", bitgetbit },
  { 3033, 3, true, false, "bitsetbit", bitsetbit },
  { 3034, 1, true, false, "pg_relation_filepath", pg_relation_filepath },
  { 3035, 0, true, true, "pg_listening_channels", pg_listening_channels },
  { 3036, 2, false, false, "pg_notify", pg_notify },
  { 3037, 1, true, false, "pg_stat_get_xact_numscans", pg_stat_get_xact_numscans },
  { 3038, 1, true, false, "pg_stat_get_xact_tuples_returned", pg_stat_get_xact_tuples_returned },
  { 3039, 1, true, false, "pg_stat_get_xact_tuples_fetched", pg_stat_get_xact_tuples_fetched },
  { 3040, 1, true, false, "pg_stat_get_xact_tuples_inserted", pg_stat_get_xact_tuples_inserted },
  { 3041, 1, true, false, "pg_stat_get_xact_tuples_updated", pg_stat_get_xact_tuples_updated },
  { 3042, 1, true, false, "pg_stat_get_xact_tuples_deleted", pg_stat_get_xact_tuples_deleted },
  { 3043, 1, true, false, "pg_stat_get_xact_tuples_hot_updated", pg_stat_get_xact_tuples_hot_updated },
  { 3044, 1, true, false, "pg_stat_get_xact_blocks_fetched", pg_stat_get_xact_blocks_fetched },
  { 3045, 1, true, false, "pg_stat_get_xact_blocks_hit", pg_stat_get_xact_blocks_hit },
  { 3046, 1, true, false, "pg_stat_get_xact_function_calls", pg_stat_get_xact_function_calls },
  { 3047, 1, true, false, "pg_stat_get_xact_function_total_time", pg_stat_get_xact_function_total_time },
  { 3048, 1, true, false, "pg_stat_get_xact_function_self_time", pg_stat_get_xact_function_self_time },
  { 3049, 3, true, false, "xpath_exists", xpath_exists },
  { 3051, 1, true, false, "xml_is_well_formed", xml_is_well_formed },
  { 3052, 1, true, false, "xml_is_well_formed_document", xml_is_well_formed_document },
  { 3053, 1, true, false, "xml_is_well_formed_content", xml_is_well_formed_content },
  { 3054, 1, true, false, "pg_stat_get_vacuum_count", pg_stat_get_vacuum_count },
  { 3055, 1, true, false, "pg_stat_get_autovacuum_count", pg_stat_get_autovacuum_count },
  { 3056, 1, true, false, "pg_stat_get_analyze_count", pg_stat_get_analyze_count },
  { 3057, 1, true, false, "pg_stat_get_autoanalyze_count", pg_stat_get_autoanalyze_count },
  { 3058, 1, false, false, "text_concat", text_concat },
  { 3059, 2, false, false, "text_concat_ws", text_concat_ws },
  { 3060, 2, true, false, "text_left", text_left },
  { 3061, 2, true, false, "text_right", text_right },
  { 3062, 1, true, false, "text_reverse", text_reverse },
  { 3063, 0, true, false, "pg_stat_get_buf_fsync_backend", pg_stat_get_buf_fsync_backend },
  { 3064, 5, true, false, "gist_point_distance", gist_point_distance },
  { 3065, 1, true, false, "pg_stat_get_db_conflict_tablespace", pg_stat_get_db_conflict_tablespace },
  { 3066, 1, true, false, "pg_stat_get_db_conflict_lock", pg_stat_get_db_conflict_lock },
  { 3067, 1, true, false, "pg_stat_get_db_conflict_snapshot", pg_stat_get_db_conflict_snapshot },
  { 3068, 1, true, false, "pg_stat_get_db_conflict_bufferpin", pg_stat_get_db_conflict_bufferpin },
  { 3069, 1, true, false, "pg_stat_get_db_conflict_startup_deadlock", pg_stat_get_db_conflict_startup_deadlock },
  { 3070, 1, true, false, "pg_stat_get_db_conflict_all", pg_stat_get_db_conflict_all },
  { 3071, 0, true, false, "pg_wal_replay_pause", pg_wal_replay_pause },
  { 3072, 0, true, false, "pg_wal_replay_resume", pg_wal_replay_resume },
  { 3073, 0, true, false, "pg_is_wal_replay_paused", pg_is_wal_replay_paused },
  { 3074, 1, true, false, "pg_stat_get_db_stat_reset_time", pg_stat_get_db_stat_reset_time },
  { 3075, 0, true, false, "pg_stat_get_bgwriter_stat_reset_time", pg_stat_get_bgwriter_stat_reset_time },
  { 3076, 2, true, false, "ginarrayextract_2args", ginarrayextract_2args },
  { 3077, 2, true, false, "gin_extract_tsvector_2args", gin_extract_tsvector_2args },
  { 3078, 1, true, false, "pg_sequence_parameters", pg_sequence_parameters },
  { 3082, 0, true, true, "pg_available_extensions", pg_available_extensions },
  { 3083, 0, true, true, "pg_available_extension_versions", pg_available_extension_versions },
  { 3084, 1, true, true, "pg_extension_update_paths", pg_extension_update_paths },
  { 3086, 2, true, false, "pg_extension_config_dump", pg_extension_config_dump },
  { 3087, 5, true, false, "gin_extract_tsquery_5args", gin_extract_tsquery_5args },
  { 3088, 6, true, false, "gin_tsquery_consistent_6args", gin_tsquery_consistent_6args },
  { 3089, 1, true, false, "pg_advisory_xact_lock_int8", pg_advisory_xact_lock_int8 },
  { 3090, 1, true, false, "pg_advisory_xact_lock_shared_int8", pg_advisory_xact_lock_shared_int8 },
  { 3091, 1, true, false, "pg_try_advisory_xact_lock_int8", pg_try_advisory_xact_lock_int8 },
  { 3092, 1, true, false, "pg_try_advisory_xact_lock_shared_int8", pg_try_advisory_xact_lock_shared_int8 },
  { 3093, 2, true, false, "pg_advisory_xact_lock_int4", pg_advisory_xact_lock_int4 },
  { 3094, 2, true, false, "pg_advisory_xact_lock_shared_int4", pg_advisory_xact_lock_shared_int4 },
  { 3095, 2, true, false, "pg_try_advisory_xact_lock_int4", pg_try_advisory_xact_lock_int4 },
  { 3096, 2, true, false, "pg_try_advisory_xact_lock_shared_int4", pg_try_advisory_xact_lock_shared_int4 },
  { 3097, 1, true, false, "varchar_support", varchar_support },
  { 3098, 1, true, false, "pg_create_restore_point", pg_create_restore_point },
  { 3099, 0, false, true, "pg_stat_get_wal_senders", pg_stat_get_wal_senders },
  { 3100, 0, false, false, "window_row_number", window_row_number },
  { 3101, 0, false, false, "window_rank", window_rank },
  { 3102, 0, false, false, "window_dense_rank", window_dense_rank },
  { 3103, 0, false, false, "window_percent_rank", window_percent_rank },
  { 3104, 0, false, false, "window_cume_dist", window_cume_dist },
  { 3105, 1, true, false, "window_ntile", window_ntile },
  { 3106, 1, true, false, "window_lag", window_lag },
  { 3107, 2, true, false, "window_lag_with_offset", window_lag_with_offset },
  { 3108, 3, true, false, "window_lag_with_offset_and_default", window_lag_with_offset_and_default },
  { 3109, 1, true, false, "window_lead", window_lead },
  { 3110, 2, true, false, "window_lead_with_offset", window_lead_with_offset },
  { 3111, 3, true, false, "window_lead_with_offset_and_default", window_lead_with_offset_and_default },
  { 3112, 1, true, false, "window_first_value", window_first_value },
  { 3113, 1, true, false, "window_last_value", window_last_value },
  { 3114, 2, true, false, "window_nth_value", window_nth_value },
  { 3116, 1, false, false, "fdw_handler_in", fdw_handler_in },
  { 3117, 1, true, false, "fdw_handler_out", fdw_handler_out },
  { 3120, 1, true, false, "void_recv", void_recv },
  { 3121, 1, true, false, "void_send", void_send },
  { 3129, 1, true, false, "btint2sortsupport", btint2sortsupport },
  { 3130, 1, true, false, "btint4sortsupport", btint4sortsupport },
  { 3131, 1, true, false, "btint8sortsupport", btint8sortsupport },
  { 3132, 1, true, false, "btfloat4sortsupport", btfloat4sortsupport },
  { 3133, 1, true, false, "btfloat8sortsupport", btfloat8sortsupport },
  { 3134, 1, true, false, "btoidsortsupport", btoidsortsupport },
  { 3135, 1, true, false, "btnamesortsupport", btnamesortsupport },
  { 3136, 1, true, false, "date_sortsupport", date_sortsupport },
  { 3137, 1, true, false, "timestamp_sortsupport", timestamp_sortsupport },
  { 3138, 3, true, false, "has_type_privilege_name_name", has_type_privilege_name_name },
  { 3139, 3, true, false, "has_type_privilege_name_id", has_type_privilege_name_id },
  { 3140, 3, true, false, "has_type_privilege_id_name", has_type_privilege_id_name },
  { 3141, 3, true, false, "has_type_privilege_id_id", has_type_privilege_id_id },
  { 3142, 2, true, false, "has_type_privilege_name", has_type_privilege_name },
  { 3143, 2, true, false, "has_type_privilege_id", has_type_privilege_id },
  { 3144, 1, true, false, "macaddr_not", macaddr_not },
  { 3145, 2, true, false, "macaddr_and", macaddr_and },
  { 3146, 2, true, false, "macaddr_or", macaddr_or },
  { 3150, 1, true, false, "pg_stat_get_db_temp_files", pg_stat_get_db_temp_files },
  { 3151, 1, true, false, "pg_stat_get_db_temp_bytes", pg_stat_get_db_temp_bytes },
  { 3152, 1, true, false, "pg_stat_get_db_deadlocks", pg_stat_get_db_deadlocks },
  { 3153, 1, true, false, "array_to_json", array_to_json },
  { 3154, 2, true, false, "array_to_json_pretty", array_to_json_pretty },
  { 3155, 1, true, false, "row_to_json", row_to_json },
  { 3156, 2, true, false, "row_to_json_pretty", row_to_json_pretty },
  { 3157, 1, true, false, "numeric_support", numeric_support },
  { 3158, 1, true, false, "varbit_support", varbit_support },
  { 3159, 2, true, false, "pg_get_viewdef_wrap", pg_get_viewdef_wrap },
  { 3160, 0, true, false, "pg_stat_get_checkpoint_write_time", pg_stat_get_checkpoint_write_time },
  { 3161, 0, true, false, "pg_stat_get_checkpoint_sync_time", pg_stat_get_checkpoint_sync_time },
  { 3162, 1, false, false, "pg_collation_for", pg_collation_for },
  { 3163, 0, true, false, "pg_trigger_depth", pg_trigger_depth },
  { 3165, 2, true, false, "pg_wal_lsn_diff", pg_wal_lsn_diff },
  { 3166, 1, true, false, "pg_size_pretty_numeric", pg_size_pretty_numeric },
  { 3167, 2, false, false, "array_remove", array_remove },
  { 3168, 3, false, false, "array_replace", array_replace },
  { 3169, 4, true, false, "rangesel", rangesel },
  { 3170, 3, true, false, "be_lo_lseek64", be_lo_lseek64 },
  { 3171, 1, true, false, "be_lo_tell64", be_lo_tell64 },
  { 3172, 2, true, false, "be_lo_truncate64", be_lo_truncate64 },
  { 3173, 2, false, false, "json_agg_transfn", json_agg_transfn },
  { 3174, 1, false, false, "json_agg_finalfn", json_agg_finalfn },
  { 3175, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3176, 1, true, false, "to_json", to_json },
  { 3177, 1, true, false, "pg_stat_get_mod_since_analyze", pg_stat_get_mod_since_analyze },
  { 3178, 1, false, false, "numeric_sum", numeric_sum },
  { 3179, 1, true, false, "array_cardinality", array_cardinality },
  { 3180, 3, false, false, "json_object_agg_transfn", json_object_agg_transfn },
  { 3181, 2, true, false, "record_image_eq", record_image_eq },
  { 3182, 2, true, false, "record_image_ne", record_image_ne },
  { 3183, 2, true, false, "record_image_lt", record_image_lt },
  { 3184, 2, true, false, "record_image_gt", record_image_gt },
  { 3185, 2, true, false, "record_image_le", record_image_le },
  { 3186, 2, true, false, "record_image_ge", record_image_ge },
  { 3187, 2, true, false, "btrecordimagecmp", btrecordimagecmp },
  { 3195, 0, false, false, "pg_stat_get_archiver", pg_stat_get_archiver },
  { 3196, 1, false, false, "json_object_agg_finalfn", json_object_agg_finalfn },
  { 3197, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3198, 1, false, false, "json_build_array", json_build_array },
  { 3199, 0, false, false, "json_build_array_noargs", json_build_array_noargs },
  { 3200, 1, false, false, "json_build_object", json_build_object },
  { 3201, 0, false, false, "json_build_object_noargs", json_build_object_noargs },
  { 3202, 1, true, false, "json_object", json_object },
  { 3203, 2, true, false, "json_object_two_arg", json_object_two_arg },
  { 3204, 1, true, false, "json_to_record", json_to_record },
  { 3205, 1, false, true, "json_to_recordset", json_to_recordset },
  { 3207, 1, true, false, "jsonb_array_length", jsonb_array_length },
  { 3208, 1, true, true, "jsonb_each", jsonb_each },
  { 3209, 2, false, false, "jsonb_populate_record", jsonb_populate_record },
  { 3210, 1, true, false, "jsonb_typeof", jsonb_typeof },
  { 3214, 2, true, false, "jsonb_object_field_text", jsonb_object_field_text },
  { 3215, 2, true, false, "jsonb_array_element", jsonb_array_element },
  { 3216, 2, true, false, "jsonb_array_element_text", jsonb_array_element_text },
  { 3217, 2, true, false, "jsonb_extract_path", jsonb_extract_path },
  { 3218, 2, true, false, "width_bucket_array", width_bucket_array },
  { 3219, 1, true, true, "jsonb_array_elements", jsonb_array_elements },
  { 3229, 1, true, false, "pg_lsn_in", pg_lsn_in },
  { 3230, 1, true, false, "pg_lsn_out", pg_lsn_out },
  { 3231, 2, true, false, "pg_lsn_lt", pg_lsn_lt },
  { 3232, 2, true, false, "pg_lsn_le", pg_lsn_le },
  { 3233, 2, true, false, "pg_lsn_eq", pg_lsn_eq },
  { 3234, 2, true, false, "pg_lsn_ge", pg_lsn_ge },
  { 3235, 2, true, false, "pg_lsn_gt", pg_lsn_gt },
  { 3236, 2, true, false, "pg_lsn_ne", pg_lsn_ne },
  { 3237, 2, true, false, "pg_lsn_mi", pg_lsn_mi },
  { 3238, 1, true, false, "pg_lsn_recv", pg_lsn_recv },
  { 3239, 1, true, false, "pg_lsn_send", pg_lsn_send },
  { 3251, 2, true, false, "pg_lsn_cmp", pg_lsn_cmp },
  { 3252, 1, true, false, "pg_lsn_hash", pg_lsn_hash },
  { 3255, 1, true, false, "bttextsortsupport", bttextsortsupport },
  { 3259, 3, true, true, "generate_series_step_numeric", generate_series_step_numeric },
  { 3260, 2, true, true, "generate_series_numeric", generate_series_numeric },
  { 3261, 1, true, false, "json_strip_nulls", json_strip_nulls },
  { 3262, 1, true, false, "jsonb_strip_nulls", jsonb_strip_nulls },
  { 3263, 1, true, false, "jsonb_object", jsonb_object },
  { 3264, 2, true, false, "jsonb_object_two_arg", jsonb_object_two_arg },
  { 3265, 2, false, false, "jsonb_agg_transfn", jsonb_agg_transfn },
  { 3266, 1, false, false, "jsonb_agg_finalfn", jsonb_agg_finalfn },
  { 3267, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3268, 3, false, false, "jsonb_object_agg_transfn", jsonb_object_agg_transfn },
  { 3269, 1, false, false, "jsonb_object_agg_finalfn", jsonb_object_agg_finalfn },
  { 3270, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3271, 1, false, false, "jsonb_build_array", jsonb_build_array },
  { 3272, 0, false, false, "jsonb_build_array_noargs", jsonb_build_array_noargs },
  { 3273, 1, false, false, "jsonb_build_object", jsonb_build_object },
  { 3274, 0, false, false, "jsonb_build_object_noargs", jsonb_build_object_noargs },
  { 3275, 2, true, false, "dist_ppoly", dist_ppoly },
  { 3277, 2, false, false, "array_position", array_position },
  { 3278, 3, false, false, "array_position_start", array_position_start },
  { 3279, 2, false, false, "array_positions", array_positions },
  { 3280, 5, true, false, "gist_circle_distance", gist_circle_distance },
  { 3281, 1, true, false, "numeric_scale", numeric_scale },
  { 3282, 1, true, false, "gist_point_fetch", gist_point_fetch },
  { 3283, 1, true, false, "numeric_sortsupport", numeric_sortsupport },
  { 3288, 5, true, false, "gist_poly_distance", gist_poly_distance },
  { 3290, 2, true, false, "dist_cpoint", dist_cpoint },
  { 3292, 2, true, false, "dist_polyp", dist_polyp },
  { 3293, 4, true, false, "pg_read_file_v2", pg_read_file_v2 },
  { 3294, 2, true, false, "show_config_by_name_missing_ok", show_config_by_name_missing_ok },
  { 3295, 4, true, false, "pg_read_binary_file", pg_read_binary_file },
  { 3296, 0, true, false, "pg_notification_queue_usage", pg_notification_queue_usage },
  { 3297, 3, true, true, "pg_ls_dir", pg_ls_dir },
  { 3298, 1, true, false, "row_security_active", row_security_active },
  { 3299, 1, true, false, "row_security_active_name", row_security_active_name },
  { 3300, 1, true, false, "uuid_sortsupport", uuid_sortsupport },
  { 3301, 2, true, false, "jsonb_concat", jsonb_concat },
  { 3302, 2, true, false, "jsonb_delete", jsonb_delete },
  { 3303, 2, true, false, "jsonb_delete_idx", jsonb_delete_idx },
  { 3304, 2, true, false, "jsonb_delete_path", jsonb_delete_path },
  { 3305, 4, true, false, "jsonb_set", jsonb_set },
  { 3306, 1, true, false, "jsonb_pretty", jsonb_pretty },
  { 3307, 2, true, false, "pg_stat_file", pg_stat_file },
  { 3308, 2, true, false, "xidneq", xidneq },
  { 3309, 2, true, false, "xidneq", xidneq },
  { 3311, 1, false, false, "tsm_handler_in", tsm_handler_in },
  { 3312, 1, true, false, "tsm_handler_out", tsm_handler_out },
  { 3313, 1, true, false, "tsm_bernoulli_handler", tsm_bernoulli_handler },
  { 3314, 1, true, false, "tsm_system_handler", tsm_system_handler },
  { 3317, 0, false, false, "pg_stat_get_wal_receiver", pg_stat_get_wal_receiver },
  { 3318, 1, true, true, "pg_stat_get_progress_info", pg_stat_get_progress_info },
  { 3319, 2, true, false, "tsvector_filter", tsvector_filter },
  { 3320, 3, true, false, "tsvector_setweight_by_filter", tsvector_setweight_by_filter },
  { 3321, 2, true, false, "tsvector_delete_str", tsvector_delete_str },
  { 3322, 1, true, true, "tsvector_unnest", tsvector_unnest },
  { 3323, 2, true, false, "tsvector_delete_arr", tsvector_delete_arr },
  { 3324, 2, true, false, "int4_avg_combine", int4_avg_combine },
  { 3325, 2, true, false, "interval_combine", interval_combine },
  { 3326, 1, true, false, "tsvector_to_array", tsvector_to_array },
  { 3327, 1, true, false, "array_to_tsvector", array_to_tsvector },
  { 3328, 1, true, false, "bpchar_sortsupport", bpchar_sortsupport },
  { 3329, 0, true, true, "show_all_file_settings", show_all_file_settings },
  { 3330, 0, true, false, "pg_current_wal_flush_lsn", pg_current_wal_flush_lsn },
  { 3331, 1, true, false, "bytea_sortsupport", bytea_sortsupport },
  { 3332, 1, true, false, "bttext_pattern_sortsupport", bttext_pattern_sortsupport },
  { 3333, 1, true, false, "btbpchar_pattern_sortsupport", btbpchar_pattern_sortsupport },
  { 3334, 1, true, false, "pg_size_bytes", pg_size_bytes },
  { 3335, 1, true, false, "numeric_serialize", numeric_serialize },
  { 3336, 2, true, false, "numeric_deserialize", numeric_deserialize },
  { 3337, 2, false, false, "numeric_avg_combine", numeric_avg_combine },
  { 3338, 2, false, false, "numeric_poly_combine", numeric_poly_combine },
  { 3339, 1, true, false, "numeric_poly_serialize", numeric_poly_serialize },
  { 3340, 2, true, false, "numeric_poly_deserialize", numeric_poly_deserialize },
  { 3341, 2, false, false, "numeric_combine", numeric_combine },
  { 3342, 2, true, false, "float8_regr_combine", float8_regr_combine },
  { 3343, 2, true, false, "jsonb_delete_array", jsonb_delete_array },
  { 3344, 2, true, false, "cash_mul_int8", cash_mul_int8 },
  { 3345, 2, true, false, "cash_div_int8", cash_div_int8 },
  { 3348, 0, true, false, "pg_current_xact_id_if_assigned", pg_current_xact_id_if_assigned },
  { 3352, 1, true, false, "pg_get_partkeydef", pg_get_partkeydef },
  { 3353, 0, true, true, "pg_ls_logdir", pg_ls_logdir },
  { 3354, 0, true, true, "pg_ls_waldir", pg_ls_waldir },
  { 3355, 1, true, false, "pg_ndistinct_in", pg_ndistinct_in },
  { 3356, 1, true, false, "pg_ndistinct_out", pg_ndistinct_out },
  { 3357, 1, true, false, "pg_ndistinct_recv", pg_ndistinct_recv },
  { 3358, 1, true, false, "pg_ndistinct_send", pg_ndistinct_send },
  { 3359, 1, true, false, "macaddr_sortsupport", macaddr_sortsupport },
  { 3360, 1, true, false, "pg_xact_status", pg_xact_status },
  { 3376, 1, true, false, "pg_safe_snapshot_blocking_pids", pg_safe_snapshot_blocking_pids },
  { 3378, 2, true, false, "pg_isolation_test_session_is_blocked", pg_isolation_test_session_is_blocked },
  { 3382, 3, true, false, "pg_identify_object_as_address", pg_identify_object_as_address },
  { 3383, 1, true, false, "brin_minmax_opcinfo", brin_minmax_opcinfo },
  { 3384, 4, true, false, "brin_minmax_add_value", brin_minmax_add_value },
  { 3385, 3, true, false, "brin_minmax_consistent", brin_minmax_consistent },
  { 3386, 3, true, false, "brin_minmax_union", brin_minmax_union },
  { 3387, 2, false, false, "int8_avg_accum_inv", int8_avg_accum_inv },
  { 3388, 1, false, false, "numeric_poly_sum", numeric_poly_sum },
  { 3389, 1, false, false, "numeric_poly_avg", numeric_poly_avg },
  { 3390, 1, false, false, "numeric_poly_var_pop", numeric_poly_var_pop },
  { 3391, 1, false, false, "numeric_poly_var_samp", numeric_poly_var_samp },
  { 3392, 1, false, false, "numeric_poly_stddev_pop", numeric_poly_stddev_pop },
  { 3393, 1, false, false, "numeric_poly_stddev_samp", numeric_poly_stddev_samp },
  { 3396, 2, true, false, "regexp_match_no_flags", regexp_match_no_flags },
  { 3397, 3, true, false, "regexp_match", regexp_match },
  { 3399, 2, true, false, "int8_mul_cash", int8_mul_cash },
  { 3400, 0, true, true, "pg_config", pg_config },
  { 3401, 0, true, true, "pg_hba_file_rules", pg_hba_file_rules },
  { 3403, 1, true, false, "pg_statistics_obj_is_visible", pg_statistics_obj_is_visible },
  { 3404, 1, true, false, "pg_dependencies_in", pg_dependencies_in },
  { 3405, 1, true, false, "pg_dependencies_out", pg_dependencies_out },
  { 3406, 1, true, false, "pg_dependencies_recv", pg_dependencies_recv },
  { 3407, 1, true, false, "pg_dependencies_send", pg_dependencies_send },
  { 3408, 1, true, false, "pg_get_partition_constraintdef", pg_get_partition_constraintdef },
  { 3409, 2, true, false, "time_hash_extended", time_hash_extended },
  { 3410, 2, true, false, "timetz_hash_extended", timetz_hash_extended },
  { 3411, 2, true, false, "timestamp_hash_extended", timestamp_hash_extended },
  { 3412, 2, true, false, "uuid_hash_extended", uuid_hash_extended },
  { 3413, 2, true, false, "pg_lsn_hash_extended", pg_lsn_hash_extended },
  { 3414, 2, true, false, "hashenumextended", hashenumextended },
  { 3415, 1, true, false, "pg_get_statisticsobjdef", pg_get_statisticsobjdef },
  { 3416, 2, true, false, "jsonb_hash_extended", jsonb_hash_extended },
  { 3417, 2, true, false, "hash_range_extended", hash_range_extended },
  { 3418, 2, true, false, "interval_hash_extended", interval_hash_extended },
  { 3419, 1, true, false, "sha224_bytea", sha224_bytea },
  { 3420, 1, true, false, "sha256_bytea", sha256_bytea },
  { 3421, 1, true, false, "sha384_bytea", sha384_bytea },
  { 3422, 1, true, false, "sha512_bytea", sha512_bytea },
  { 3423, 1, true, true, "pg_partition_tree", pg_partition_tree },
  { 3424, 1, true, false, "pg_partition_root", pg_partition_root },
  { 3425, 1, true, true, "pg_partition_ancestors", pg_partition_ancestors },
  { 3426, 1, true, false, "pg_stat_get_db_checksum_failures", pg_stat_get_db_checksum_failures },
  { 3427, 1, true, true, "pg_stats_ext_mcvlist_items", pg_stats_ext_mcvlist_items },
  { 3428, 1, true, false, "pg_stat_get_db_checksum_last_failure", pg_stat_get_db_checksum_last_failure },
  { 3432, 0, true, false, "gen_random_uuid", gen_random_uuid },
  { 3434, 1, false, false, "gtsvector_options", gtsvector_options },
  { 3436, 2, true, false, "pg_promote", pg_promote },
  { 3437, 4, true, false, "prefixsel", prefixsel },
  { 3438, 5, true, false, "prefixjoinsel", prefixjoinsel },
  { 3441, 0, true, false, "pg_control_system", pg_control_system },
  { 3442, 0, true, false, "pg_control_checkpoint", pg_control_checkpoint },
  { 3443, 0, true, false, "pg_control_recovery", pg_control_recovery },
  { 3444, 0, true, false, "pg_control_init", pg_control_init },
  { 3445, 1, true, false, "pg_import_system_collations", pg_import_system_collations },
  { 3446, 1, true, false, "macaddr8_recv", macaddr8_recv },
  { 3447, 1, true, false, "macaddr8_send", macaddr8_send },
  { 3448, 1, true, false, "pg_collation_actual_version", pg_collation_actual_version },
  { 3449, 1, true, false, "jsonb_numeric", jsonb_numeric },
  { 3450, 1, true, false, "jsonb_int2", jsonb_int2 },
  { 3451, 1, true, false, "jsonb_int4", jsonb_int4 },
  { 3452, 1, true, false, "jsonb_int8", jsonb_int8 },
  { 3453, 1, true, false, "jsonb_float4", jsonb_float4 },
  { 3454, 2, true, false, "pg_filenode_relation", pg_filenode_relation },
  { 3457, 2, true, false, "be_lo_from_bytea", be_lo_from_bytea },
  { 3458, 1, true, false, "be_lo_get", be_lo_get },
  { 3459, 3, true, false, "be_lo_get_fragment", be_lo_get_fragment },
  { 3460, 3, true, false, "be_lo_put", be_lo_put },
  { 3461, 6, true, false, "make_timestamp", make_timestamp },
  { 3462, 6, true, false, "make_timestamptz", make_timestamptz },
  { 3463, 7, true, false, "make_timestamptz_at_timezone", make_timestamptz_at_timezone },
  { 3464, 7, true, false, "make_interval", make_interval },
  { 3465, 1, true, true, "jsonb_array_elements_text", jsonb_array_elements_text },
  { 3469, 2, true, false, "spg_range_quad_config", spg_range_quad_config },
  { 3470, 2, true, false, "spg_range_quad_choose", spg_range_quad_choose },
  { 3471, 2, true, false, "spg_range_quad_picksplit", spg_range_quad_picksplit },
  { 3472, 2, true, false, "spg_range_quad_inner_consistent", spg_range_quad_inner_consistent },
  { 3473, 2, true, false, "spg_range_quad_leaf_consistent", spg_range_quad_leaf_consistent },
  { 3475, 2, false, true, "jsonb_populate_recordset", jsonb_populate_recordset },
  { 3476, 1, true, false, "to_regoperator", to_regoperator },
  { 3478, 2, true, false, "jsonb_object_field", jsonb_object_field },
  { 3479, 1, true, false, "to_regprocedure", to_regprocedure },
  { 3480, 2, true, false, "gin_compare_jsonb", gin_compare_jsonb },
  { 3482, 3, true, false, "gin_extract_jsonb", gin_extract_jsonb },
  { 3483, 7, true, false, "gin_extract_jsonb_query", gin_extract_jsonb_query },
  { 3484, 8, true, false, "gin_consistent_jsonb", gin_consistent_jsonb },
  { 3485, 3, true, false, "gin_extract_jsonb_path", gin_extract_jsonb_path },
  { 3486, 7, true, false, "gin_extract_jsonb_query_path", gin_extract_jsonb_query_path },
  { 3487, 8, true, false, "gin_consistent_jsonb_path", gin_consistent_jsonb_path },
  { 3488, 7, true, false, "gin_triconsistent_jsonb", gin_triconsistent_jsonb },
  { 3489, 7, true, false, "gin_triconsistent_jsonb_path", gin_triconsistent_jsonb_path },
  { 3490, 1, true, false, "jsonb_to_record", jsonb_to_record },
  { 3491, 1, false, true, "jsonb_to_recordset", jsonb_to_recordset },
  { 3492, 1, true, false, "to_regoper", to_regoper },
  { 3493, 1, true, false, "to_regtype", to_regtype },
  { 3494, 1, true, false, "to_regproc", to_regproc },
  { 3495, 1, true, false, "to_regclass", to_regclass },
  { 3496, 2, false, false, "bool_accum", bool_accum },
  { 3497, 2, false, false, "bool_accum_inv", bool_accum_inv },
  { 3498, 1, true, false, "bool_alltrue", bool_alltrue },
  { 3499, 1, true, false, "bool_anytrue", bool_anytrue },
  { 3504, 1, true, false, "anyenum_in", anyenum_in },
  { 3505, 1, true, false, "anyenum_out", anyenum_out },
  { 3506, 2, true, false, "enum_in", enum_in },
  { 3507, 1, true, false, "enum_out", enum_out },
  { 3508, 2, true, false, "enum_eq", enum_eq },
  { 3509, 2, true, false, "enum_ne", enum_ne },
  { 3510, 2, true, false, "enum_lt", enum_lt },
  { 3511, 2, true, false, "enum_gt", enum_gt },
  { 3512, 2, true, false, "enum_le", enum_le },
  { 3513, 2, true, false, "enum_ge", enum_ge },
  { 3514, 2, true, false, "enum_cmp", enum_cmp },
  { 3515, 1, true, false, "hashenum", hashenum },
  { 3524, 2, true, false, "enum_smaller", enum_smaller },
  { 3525, 2, true, false, "enum_larger", enum_larger },
  { 3526, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3527, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3528, 1, false, false, "enum_first", enum_first },
  { 3529, 1, false, false, "enum_last", enum_last },
  { 3530, 2, false, false, "enum_range_bounds", enum_range_bounds },
  { 3531, 1, false, false, "enum_range_all", enum_range_all },
  { 3532, 2, true, false, "enum_recv", enum_recv },
  { 3533, 1, true, false, "enum_send", enum_send },
  { 3535, 3, false, false, "string_agg_transfn", string_agg_transfn },
  { 3536, 1, false, false, "string_agg_finalfn", string_agg_finalfn },
  { 3537, 3, true, false, "pg_describe_object", pg_describe_object },
  { 3538, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3539, 2, false, false, "text_format", text_format },
  { 3540, 1, false, false, "text_format_nv", text_format_nv },
  { 3543, 3, false, false, "bytea_string_agg_transfn", bytea_string_agg_transfn },
  { 3544, 1, false, false, "bytea_string_agg_finalfn", bytea_string_agg_finalfn },
  { 3545, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3546, 1, true, false, "int8dec", int8dec },
  { 3547, 2, true, false, "int8dec_any", int8dec_any },
  { 3548, 2, false, false, "numeric_accum_inv", numeric_accum_inv },
  { 3549, 2, true, false, "interval_accum_inv", interval_accum_inv },
  { 3551, 2, true, false, "network_overlap", network_overlap },
  { 3553, 5, true, false, "inet_gist_consistent", inet_gist_consistent },
  { 3554, 2, true, false, "inet_gist_union", inet_gist_union },
  { 3555, 1, true, false, "inet_gist_compress", inet_gist_compress },
  { 3556, 1, true, false, "jsonb_bool", jsonb_bool },
  { 3557, 3, true, false, "inet_gist_penalty", inet_gist_penalty },
  { 3558, 2, true, false, "inet_gist_picksplit", inet_gist_picksplit },
  { 3559, 3, true, false, "inet_gist_same", inet_gist_same },
  { 3560, 4, true, false, "networksel", networksel },
  { 3561, 5, true, false, "networkjoinsel", networkjoinsel },
  { 3562, 2, true, false, "network_larger", network_larger },
  { 3563, 2, true, false, "network_smaller", network_smaller },
  { 3564, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3565, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3566, 0, true, true, "pg_event_trigger_dropped_objects", pg_event_trigger_dropped_objects },
  { 3567, 2, false, false, "int2_accum_inv", int2_accum_inv },
  { 3568, 2, false, false, "int4_accum_inv", int4_accum_inv },
  { 3569, 2, false, false, "int8_accum_inv", int8_accum_inv },
  { 3570, 2, true, false, "int2_avg_accum_inv", int2_avg_accum_inv },
  { 3571, 2, true, false, "int4_avg_accum_inv", int4_avg_accum_inv },
  { 3572, 1, true, false, "int2int4_sum", int2int4_sum },
  { 3573, 1, true, false, "inet_gist_fetch", inet_gist_fetch },
  { 3577, 3, true, false, "pg_logical_emit_message_text", pg_logical_emit_message_text },
  { 3578, 3, true, false, "pg_logical_emit_message_bytea", pg_logical_emit_message_bytea },
  { 3579, 4, true, false, "jsonb_insert", jsonb_insert },
  { 3581, 1, true, false, "pg_xact_commit_timestamp", pg_xact_commit_timestamp },
  { 3582, 1, true, false, "binary_upgrade_set_next_pg_type_oid", binary_upgrade_set_next_pg_type_oid },
  { 3583, 0, true, false, "pg_last_committed_xact", pg_last_committed_xact },
  { 3584, 1, true, false, "binary_upgrade_set_next_array_pg_type_oid", binary_upgrade_set_next_array_pg_type_oid },
  { 3585, 1, true, false, "binary_upgrade_set_next_toast_pg_type_oid", binary_upgrade_set_next_toast_pg_type_oid },
  { 3586, 1, true, false, "binary_upgrade_set_next_heap_pg_class_oid", binary_upgrade_set_next_heap_pg_class_oid },
  { 3587, 1, true, false, "binary_upgrade_set_next_index_pg_class_oid", binary_upgrade_set_next_index_pg_class_oid },
  { 3588, 1, true, false, "binary_upgrade_set_next_toast_pg_class_oid", binary_upgrade_set_next_toast_pg_class_oid },
  { 3589, 1, true, false, "binary_upgrade_set_next_pg_enum_oid", binary_upgrade_set_next_pg_enum_oid },
  { 3590, 1, true, false, "binary_upgrade_set_next_pg_authid_oid", binary_upgrade_set_next_pg_authid_oid },
  { 3591, 7, false, false, "binary_upgrade_create_empty_extension", binary_upgrade_create_empty_extension },
  { 3594, 1, false, false, "event_trigger_in", event_trigger_in },
  { 3595, 1, true, false, "event_trigger_out", event_trigger_out },
  { 3610, 1, true, false, "tsvectorin", tsvectorin },
  { 3611, 1, true, false, "tsvectorout", tsvectorout },
  { 3612, 1, true, false, "tsqueryin", tsqueryin },
  { 3613, 1, true, false, "tsqueryout", tsqueryout },
  { 3616, 2, true, false, "tsvector_lt", tsvector_lt },
  { 3617, 2, true, false, "tsvector_le", tsvector_le },
  { 3618, 2, true, false, "tsvector_eq", tsvector_eq },
  { 3619, 2, true, false, "tsvector_ne", tsvector_ne },
  { 3620, 2, true, false, "tsvector_ge", tsvector_ge },
  { 3621, 2, true, false, "tsvector_gt", tsvector_gt },
  { 3622, 2, true, false, "tsvector_cmp", tsvector_cmp },
  { 3623, 1, true, false, "tsvector_strip", tsvector_strip },
  { 3624, 2, true, false, "tsvector_setweight", tsvector_setweight },
  { 3625, 2, true, false, "tsvector_concat", tsvector_concat },
  { 3634, 2, true, false, "ts_match_vq", ts_match_vq },
  { 3635, 2, true, false, "ts_match_qv", ts_match_qv },
  { 3638, 1, true, false, "tsvectorsend", tsvectorsend },
  { 3639, 1, true, false, "tsvectorrecv", tsvectorrecv },
  { 3640, 1, true, false, "tsquerysend", tsquerysend },
  { 3641, 1, true, false, "tsqueryrecv", tsqueryrecv },
  { 3646, 1, true, false, "gtsvectorin", gtsvectorin },
  { 3647, 1, true, false, "gtsvectorout", gtsvectorout },
  { 3648, 1, true, false, "gtsvector_compress", gtsvector_compress },
  { 3649, 1, true, false, "gtsvector_decompress", gtsvector_decompress },
  { 3650, 2, true, false, "gtsvector_picksplit", gtsvector_picksplit },
  { 3651, 2, true, false, "gtsvector_union", gtsvector_union },
  { 3652, 3, true, false, "gtsvector_same", gtsvector_same },
  { 3653, 3, true, false, "gtsvector_penalty", gtsvector_penalty },
  { 3654, 5, true, false, "gtsvector_consistent", gtsvector_consistent },
  { 3656, 3, true, false, "gin_extract_tsvector", gin_extract_tsvector },
  { 3657, 7, true, false, "gin_extract_tsquery", gin_extract_tsquery },
  { 3658, 8, true, false, "gin_tsquery_consistent", gin_tsquery_consistent },
  { 3662, 2, true, false, "tsquery_lt", tsquery_lt },
  { 3663, 2, true, false, "tsquery_le", tsquery_le },
  { 3664, 2, true, false, "tsquery_eq", tsquery_eq },
  { 3665, 2, true, false, "tsquery_ne", tsquery_ne },
  { 3666, 2, true, false, "tsquery_ge", tsquery_ge },
  { 3667, 2, true, false, "tsquery_gt", tsquery_gt },
  { 3668, 2, true, false, "tsquery_cmp", tsquery_cmp },
  { 3669, 2, true, false, "tsquery_and", tsquery_and },
  { 3670, 2, true, false, "tsquery_or", tsquery_or },
  { 3671, 1, true, false, "tsquery_not", tsquery_not },
  { 3672, 1, true, false, "tsquery_numnode", tsquery_numnode },
  { 3673, 1, true, false, "tsquerytree", tsquerytree },
  { 3684, 3, true, false, "tsquery_rewrite", tsquery_rewrite },
  { 3685, 2, true, false, "tsquery_rewrite_query", tsquery_rewrite_query },
  { 3686, 4, true, false, "tsmatchsel", tsmatchsel },
  { 3687, 5, true, false, "tsmatchjoinsel", tsmatchjoinsel },
  { 3688, 1, true, false, "ts_typanalyze", ts_typanalyze },
  { 3689, 1, true, true, "ts_stat1", ts_stat1 },
  { 3690, 2, true, true, "ts_stat2", ts_stat2 },
  { 3691, 2, true, false, "tsq_mcontains", tsq_mcontains },
  { 3692, 2, true, false, "tsq_mcontained", tsq_mcontained },
  { 3695, 1, true, false, "gtsquery_compress", gtsquery_compress },
  { 3696, 2, true, false, "text_starts_with", text_starts_with },
  { 3697, 2, true, false, "gtsquery_picksplit", gtsquery_picksplit },
  { 3698, 2, true, false, "gtsquery_union", gtsquery_union },
  { 3699, 3, true, false, "gtsquery_same", gtsquery_same },
  { 3700, 3, true, false, "gtsquery_penalty", gtsquery_penalty },
  { 3701, 5, true, false, "gtsquery_consistent", gtsquery_consistent },
  { 3703, 4, true, false, "ts_rank_wttf", ts_rank_wttf },
  { 3704, 3, true, false, "ts_rank_wtt", ts_rank_wtt },
  { 3705, 3, true, false, "ts_rank_ttf", ts_rank_ttf },
  { 3706, 2, true, false, "ts_rank_tt", ts_rank_tt },
  { 3707, 4, true, false, "ts_rankcd_wttf", ts_rankcd_wttf },
  { 3708, 3, true, false, "ts_rankcd_wtt", ts_rankcd_wtt },
  { 3709, 3, true, false, "ts_rankcd_ttf", ts_rankcd_ttf },
  { 3710, 2, true, false, "ts_rankcd_tt", ts_rankcd_tt },
  { 3711, 1, true, false, "tsvector_length", tsvector_length },
  { 3713, 1, true, true, "ts_token_type_byid", ts_token_type_byid },
  { 3714, 1, true, true, "ts_token_type_byname", ts_token_type_byname },
  { 3715, 2, true, true, "ts_parse_byid", ts_parse_byid },
  { 3716, 2, true, true, "ts_parse_byname", ts_parse_byname },
  { 3717, 2, true, false, "prsd_start", prsd_start },
  { 3718, 3, true, false, "prsd_nexttoken", prsd_nexttoken },
  { 3719, 1, true, false, "prsd_end", prsd_end },
  { 3720, 3, true, false, "prsd_headline", prsd_headline },
  { 3721, 1, true, false, "prsd_lextype", prsd_lextype },
  { 3723, 2, true, false, "ts_lexize", ts_lexize },
  { 3724, 2, true, false, "gin_cmp_tslexeme", gin_cmp_tslexeme },
  { 3725, 1, true, false, "dsimple_init", dsimple_init },
  { 3726, 4, true, false, "dsimple_lexize", dsimple_lexize },
  { 3728, 1, true, false, "dsynonym_init", dsynonym_init },
  { 3729, 4, true, false, "dsynonym_lexize", dsynonym_lexize },
  { 3731, 1, true, false, "dispell_init", dispell_init },
  { 3732, 4, true, false, "dispell_lexize", dispell_lexize },
  { 3736, 1, true, false, "regconfigin", regconfigin },
  { 3737, 1, true, false, "regconfigout", regconfigout },
  { 3738, 1, true, false, "regconfigrecv", regconfigrecv },
  { 3739, 1, true, false, "regconfigsend", regconfigsend },
  { 3740, 1, true, false, "thesaurus_init", thesaurus_init },
  { 3741, 4, true, false, "thesaurus_lexize", thesaurus_lexize },
  { 3743, 4, true, false, "ts_headline_byid_opt", ts_headline_byid_opt },
  { 3744, 3, true, false, "ts_headline_byid", ts_headline_byid },
  { 3745, 2, true, false, "to_tsvector_byid", to_tsvector_byid },
  { 3746, 2, true, false, "to_tsquery_byid", to_tsquery_byid },
  { 3747, 2, true, false, "plainto_tsquery_byid", plainto_tsquery_byid },
  { 3749, 1, true, false, "to_tsvector", to_tsvector },
  { 3750, 1, true, false, "to_tsquery", to_tsquery },
  { 3751, 1, true, false, "plainto_tsquery", plainto_tsquery },
  { 3752, 0, false, false, "tsvector_update_trigger_byid", tsvector_update_trigger_byid },
  { 3753, 0, false, false, "tsvector_update_trigger_bycolumn", tsvector_update_trigger_bycolumn },
  { 3754, 3, true, false, "ts_headline_opt", ts_headline_opt },
  { 3755, 2, true, false, "ts_headline", ts_headline },
  { 3756, 1, true, false, "pg_ts_parser_is_visible", pg_ts_parser_is_visible },
  { 3757, 1, true, false, "pg_ts_dict_is_visible", pg_ts_dict_is_visible },
  { 3758, 1, true, false, "pg_ts_config_is_visible", pg_ts_config_is_visible },
  { 3759, 0, true, false, "get_current_ts_config", get_current_ts_config },
  { 3760, 2, true, false, "ts_match_tt", ts_match_tt },
  { 3761, 2, true, false, "ts_match_tq", ts_match_tq },
  { 3768, 1, true, false, "pg_ts_template_is_visible", pg_ts_template_is_visible },
  { 3771, 1, true, false, "regdictionaryin", regdictionaryin },
  { 3772, 1, true, false, "regdictionaryout", regdictionaryout },
  { 3773, 1, true, false, "regdictionaryrecv", regdictionaryrecv },
  { 3774, 1, true, false, "regdictionarysend", regdictionarysend },
  { 3775, 1, true, false, "pg_stat_reset_shared", pg_stat_reset_shared },
  { 3776, 1, true, false, "pg_stat_reset_single_table_counters", pg_stat_reset_single_table_counters },
  { 3777, 1, true, false, "pg_stat_reset_single_function_counters", pg_stat_reset_single_function_counters },
  { 3778, 1, true, false, "pg_tablespace_location", pg_tablespace_location },
  { 3779, 3, true, false, "pg_create_physical_replication_slot", pg_create_physical_replication_slot },
  { 3780, 1, true, false, "pg_drop_replication_slot", pg_drop_replication_slot },
  { 3781, 0, false, true, "pg_get_replication_slots", pg_get_replication_slots },
  { 3782, 4, false, true, "pg_logical_slot_get_changes", pg_logical_slot_get_changes },
  { 3783, 4, false, true, "pg_logical_slot_get_binary_changes", pg_logical_slot_get_binary_changes },
  { 3784, 4, false, true, "pg_logical_slot_peek_changes", pg_logical_slot_peek_changes },
  { 3785, 4, false, true, "pg_logical_slot_peek_binary_changes", pg_logical_slot_peek_binary_changes },
  { 3786, 3, true, false, "pg_create_logical_replication_slot", pg_create_logical_replication_slot },
  { 3787, 1, true, false, "to_jsonb", to_jsonb },
  { 3788, 0, true, false, "pg_stat_get_snapshot_timestamp", pg_stat_get_snapshot_timestamp },
  { 3789, 1, true, false, "gin_clean_pending_list", gin_clean_pending_list },
  { 3790, 5, true, false, "gtsvector_consistent_oldsig", gtsvector_consistent_oldsig },
  { 3791, 7, true, false, "gin_extract_tsquery_oldsig", gin_extract_tsquery_oldsig },
  { 3792, 8, true, false, "gin_tsquery_consistent_oldsig", gin_tsquery_consistent_oldsig },
  { 3793, 5, true, false, "gtsquery_consistent_oldsig", gtsquery_consistent_oldsig },
  { 3795, 2, true, false, "inet_spg_config", inet_spg_config },
  { 3796, 2, true, false, "inet_spg_choose", inet_spg_choose },
  { 3797, 2, true, false, "inet_spg_picksplit", inet_spg_picksplit },
  { 3798, 2, true, false, "inet_spg_inner_consistent", inet_spg_inner_consistent },
  { 3799, 2, true, false, "inet_spg_leaf_consistent", inet_spg_leaf_consistent },
  { 3800, 0, false, false, "pg_current_logfile", pg_current_logfile },
  { 3801, 1, false, false, "pg_current_logfile_1arg", pg_current_logfile_1arg },
  { 3803, 1, true, false, "jsonb_send", jsonb_send },
  { 3804, 1, true, false, "jsonb_out", jsonb_out },
  { 3805, 1, true, false, "jsonb_recv", jsonb_recv },
  { 3806, 1, true, false, "jsonb_in", jsonb_in },
  { 3808, 2, true, false, "pg_get_function_arg_default", pg_get_function_arg_default },
  { 3809, 0, true, false, "pg_export_snapshot", pg_export_snapshot },
  { 3810, 0, true, false, "pg_is_in_recovery", pg_is_in_recovery },
  { 3811, 1, true, false, "int4_cash", int4_cash },
  { 3812, 1, true, false, "int8_cash", int8_cash },
  { 3813, 0, true, false, "pg_is_in_backup", pg_is_in_backup },
  { 3814, 0, true, false, "pg_backup_start_time", pg_backup_start_time },
  { 3815, 1, true, false, "pg_collation_is_visible", pg_collation_is_visible },
  { 3816, 1, true, false, "array_typanalyze", array_typanalyze },
  { 3817, 4, true, false, "arraycontsel", arraycontsel },
  { 3818, 5, true, false, "arraycontjoinsel", arraycontjoinsel },
  { 3819, 1, true, true, "pg_get_multixact_members", pg_get_multixact_members },
  { 3820, 0, true, false, "pg_last_wal_receive_lsn", pg_last_wal_receive_lsn },
  { 3821, 0, true, false, "pg_last_wal_replay_lsn", pg_last_wal_replay_lsn },
  { 3822, 2, true, false, "cash_div_cash", cash_div_cash },
  { 3823, 1, true, false, "cash_numeric", cash_numeric },
  { 3824, 1, true, false, "numeric_cash", numeric_cash },
  { 3826, 1, true, false, "pg_read_file_all", pg_read_file_all },
  { 3827, 3, true, false, "pg_read_binary_file_off_len", pg_read_binary_file_off_len },
  { 3828, 1, true, false, "pg_read_binary_file_all", pg_read_binary_file_all },
  { 3829, 1, true, false, "pg_opfamily_is_visible", pg_opfamily_is_visible },
  { 3830, 0, true, false, "pg_last_xact_replay_timestamp", pg_last_xact_replay_timestamp },
  { 3832, 3, true, false, "anyrange_in", anyrange_in },
  { 3833, 1, true, false, "anyrange_out", anyrange_out },
  { 3834, 3, true, false, "range_in", range_in },
  { 3835, 1, true, false, "range_out", range_out },
  { 3836, 3, true, false, "range_recv", range_recv },
  { 3837, 1, true, false, "range_send", range_send },
  { 3839, 3, true, false, "pg_identify_object", pg_identify_object },
  { 3840, 2, false, false, "range_constructor2", range_constructor2 },
  { 3841, 3, false, false, "range_constructor3", range_constructor3 },
  { 3842, 2, true, false, "pg_relation_is_updatable", pg_relation_is_updatable },
  { 3843, 3, true, false, "pg_column_is_updatable", pg_column_is_updatable },
  { 3844, 2, false, false, "range_constructor2", range_constructor2 },
  { 3845, 3, false, false, "range_constructor3", range_constructor3 },
  { 3846, 3, true, false, "make_date", make_date },
  { 3847, 3, true, false, "make_time", make_time },
  { 3848, 1, true, false, "range_lower", range_lower },
  { 3849, 1, true, false, "range_upper", range_upper },
  { 3850, 1, true, false, "range_empty", range_empty },
  { 3851, 1, true, false, "range_lower_inc", range_lower_inc },
  { 3852, 1, true, false, "range_upper_inc", range_upper_inc },
  { 3853, 1, true, false, "range_lower_inf", range_lower_inf },
  { 3854, 1, true, false, "range_upper_inf", range_upper_inf },
  { 3855, 2, true, false, "range_eq", range_eq },
  { 3856, 2, true, false, "range_ne", range_ne },
  { 3857, 2, true, false, "range_overlaps", range_overlaps },
  { 3858, 2, true, false, "range_contains_elem", range_contains_elem },
  { 3859, 2, true, false, "range_contains", range_contains },
  { 3860, 2, true, false, "elem_contained_by_range", elem_contained_by_range },
  { 3861, 2, true, false, "range_contained_by", range_contained_by },
  { 3862, 2, true, false, "range_adjacent", range_adjacent },
  { 3863, 2, true, false, "range_before", range_before },
  { 3864, 2, true, false, "range_after", range_after },
  { 3865, 2, true, false, "range_overleft", range_overleft },
  { 3866, 2, true, false, "range_overright", range_overright },
  { 3867, 2, true, false, "range_union", range_union },
  { 3868, 2, true, false, "range_intersect", range_intersect },
  { 3869, 2, true, false, "range_minus", range_minus },
  { 3870, 2, true, false, "range_cmp", range_cmp },
  { 3871, 2, true, false, "range_lt", range_lt },
  { 3872, 2, true, false, "range_le", range_le },
  { 3873, 2, true, false, "range_ge", range_ge },
  { 3874, 2, true, false, "range_gt", range_gt },
  { 3875, 5, true, false, "range_gist_consistent", range_gist_consistent },
  { 3876, 2, true, false, "range_gist_union", range_gist_union },
  { 3878, 2, true, false, "pg_replication_slot_advance", pg_replication_slot_advance },
  { 3879, 3, true, false, "range_gist_penalty", range_gist_penalty },
  { 3880, 2, true, false, "range_gist_picksplit", range_gist_picksplit },
  { 3881, 3, true, false, "range_gist_same", range_gist_same },
  { 3902, 1, true, false, "hash_range", hash_range },
  { 3914, 1, true, false, "int4range_canonical", int4range_canonical },
  { 3915, 1, true, false, "daterange_canonical", daterange_canonical },
  { 3916, 1, true, false, "range_typanalyze", range_typanalyze },
  { 3917, 1, true, false, "timestamp_support", timestamp_support },
  { 3918, 1, true, false, "interval_support", interval_support },
  { 3920, 7, true, false, "ginarraytriconsistent", ginarraytriconsistent },
  { 3921, 7, true, false, "gin_tsquery_triconsistent", gin_tsquery_triconsistent },
  { 3922, 2, true, false, "int4range_subdiff", int4range_subdiff },
  { 3923, 2, true, false, "int8range_subdiff", int8range_subdiff },
  { 3924, 2, true, false, "numrange_subdiff", numrange_subdiff },
  { 3925, 2, true, false, "daterange_subdiff", daterange_subdiff },
  { 3928, 1, true, false, "int8range_canonical", int8range_canonical },
  { 3929, 2, true, false, "tsrange_subdiff", tsrange_subdiff },
  { 3930, 2, true, false, "tstzrange_subdiff", tstzrange_subdiff },
  { 3931, 1, true, true, "jsonb_object_keys", jsonb_object_keys },
  { 3932, 1, true, true, "jsonb_each_text", jsonb_each_text },
  { 3933, 2, false, false, "range_constructor2", range_constructor2 },
  { 3934, 3, false, false, "range_constructor3", range_constructor3 },
  { 3937, 2, false, false, "range_constructor2", range_constructor2 },
  { 3938, 3, false, false, "range_constructor3", range_constructor3 },
  { 3939, 1, true, false, "mxid_age", mxid_age },
  { 3940, 2, true, false, "jsonb_extract_path_text", jsonb_extract_path_text },
  { 3941, 2, false, false, "range_constructor2", range_constructor2 },
  { 3942, 3, false, false, "range_constructor3", range_constructor3 },
  { 3943, 2, true, false, "acldefault_sql", acldefault_sql },
  { 3944, 1, true, false, "time_support", time_support },
  { 3945, 2, false, false, "range_constructor2", range_constructor2 },
  { 3946, 3, false, false, "range_constructor3", range_constructor3 },
  { 3947, 2, true, false, "json_object_field", json_object_field },
  { 3948, 2, true, false, "json_object_field_text", json_object_field_text },
  { 3949, 2, true, false, "json_array_element", json_array_element },
  { 3950, 2, true, false, "json_array_element_text", json_array_element_text },
  { 3951, 2, true, false, "json_extract_path", json_extract_path },
  { 3952, 1, true, false, "brin_summarize_new_values", brin_summarize_new_values },
  { 3953, 2, true, false, "json_extract_path_text", json_extract_path_text },
  { 3954, 3, true, false, "pg_get_object_address", pg_get_object_address },
  { 3955, 1, true, true, "json_array_elements", json_array_elements },
  { 3956, 1, true, false, "json_array_length", json_array_length },
  { 3957, 1, true, true, "json_object_keys", json_object_keys },
  { 3958, 1, true, true, "json_each", json_each },
  { 3959, 1, true, true, "json_each_text", json_each_text },
  { 3960, 3, false, false, "json_populate_record", json_populate_record },
  { 3961, 3, false, true, "json_populate_recordset", json_populate_recordset },
  { 3968, 1, true, false, "json_typeof", json_typeof },
  { 3969, 1, true, true, "json_array_elements_text", json_array_elements_text },
  { 3970, 2, false, false, "ordered_set_transition", ordered_set_transition },
  { 3971, 2, false, false, "ordered_set_transition_multi", ordered_set_transition_multi },
  { 3972, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3973, 3, false, false, "percentile_disc_final", percentile_disc_final },
  { 3974, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3975, 2, false, false, "percentile_cont_float8_final", percentile_cont_float8_final },
  { 3976, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3977, 2, false, false, "percentile_cont_interval_final", percentile_cont_interval_final },
  { 3978, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3979, 3, false, false, "percentile_disc_multi_final", percentile_disc_multi_final },
  { 3980, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3981, 2, false, false, "percentile_cont_float8_multi_final", percentile_cont_float8_multi_final },
  { 3982, 2, false, false, "aggregate_dummy", aggregate_dummy },
  { 3983, 2, false, false, "percentile_cont_interval_multi_final", percentile_cont_interval_multi_final },
  { 3984, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3985, 2, false, false, "mode_final", mode_final },
  { 3986, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3987, 2, false, false, "hypothetical_rank_final", hypothetical_rank_final },
  { 3988, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3989, 2, false, false, "hypothetical_percent_rank_final", hypothetical_percent_rank_final },
  { 3990, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3991, 2, false, false, "hypothetical_cume_dist_final", hypothetical_cume_dist_final },
  { 3992, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 3993, 2, false, false, "hypothetical_dense_rank_final", hypothetical_dense_rank_final },
  { 3994, 1, true, false, "generate_series_int4_support", generate_series_int4_support },
  { 3995, 1, true, false, "generate_series_int8_support", generate_series_int8_support },
  { 3996, 1, true, false, "array_unnest_support", array_unnest_support },
  { 3998, 5, true, false, "gist_box_distance", gist_box_distance },
  { 3999, 2, true, false, "brin_summarize_range", brin_summarize_range },
  { 4001, 1, true, false, "jsonpath_in", jsonpath_in },
  { 4002, 1, true, false, "jsonpath_recv", jsonpath_recv },
  { 4003, 1, true, false, "jsonpath_out", jsonpath_out },
  { 4004, 1, true, false, "jsonpath_send", jsonpath_send },
  { 4005, 4, true, false, "jsonb_path_exists", jsonb_path_exists },
  { 4006, 4, true, true, "jsonb_path_query", jsonb_path_query },
  { 4007, 4, true, false, "jsonb_path_query_array", jsonb_path_query_array },
  { 4008, 4, true, false, "jsonb_path_query_first", jsonb_path_query_first },
  { 4009, 4, true, false, "jsonb_path_match", jsonb_path_match },
  { 4010, 2, true, false, "jsonb_path_exists_opr", jsonb_path_exists_opr },
  { 4011, 2, true, false, "jsonb_path_match_opr", jsonb_path_match_opr },
  { 4014, 2, true, false, "brin_desummarize_range", brin_desummarize_range },
  { 4018, 2, true, false, "spg_quad_config", spg_quad_config },
  { 4019, 2, true, false, "spg_quad_choose", spg_quad_choose },
  { 4020, 2, true, false, "spg_quad_picksplit", spg_quad_picksplit },
  { 4021, 2, true, false, "spg_quad_inner_consistent", spg_quad_inner_consistent },
  { 4022, 2, true, false, "spg_quad_leaf_consistent", spg_quad_leaf_consistent },
  { 4023, 2, true, false, "spg_kd_config", spg_kd_config },
  { 4024, 2, true, false, "spg_kd_choose", spg_kd_choose },
  { 4025, 2, true, false, "spg_kd_picksplit", spg_kd_picksplit },
  { 4026, 2, true, false, "spg_kd_inner_consistent", spg_kd_inner_consistent },
  { 4027, 2, true, false, "spg_text_config", spg_text_config },
  { 4028, 2, true, false, "spg_text_choose", spg_text_choose },
  { 4029, 2, true, false, "spg_text_picksplit", spg_text_picksplit },
  { 4030, 2, true, false, "spg_text_inner_consistent", spg_text_inner_consistent },
  { 4031, 2, true, false, "spg_text_leaf_consistent", spg_text_leaf_consistent },
  { 4032, 1, true, false, "pg_sequence_last_value", pg_sequence_last_value },
  { 4038, 2, true, false, "jsonb_ne", jsonb_ne },
  { 4039, 2, true, false, "jsonb_lt", jsonb_lt },
  { 4040, 2, true, false, "jsonb_gt", jsonb_gt },
  { 4041, 2, true, false, "jsonb_le", jsonb_le },
  { 4042, 2, true, false, "jsonb_ge", jsonb_ge },
  { 4043, 2, true, false, "jsonb_eq", jsonb_eq },
  { 4044, 2, true, false, "jsonb_cmp", jsonb_cmp },
  { 4045, 1, true, false, "jsonb_hash", jsonb_hash },
  { 4046, 2, true, false, "jsonb_contains", jsonb_contains },
  { 4047, 2, true, false, "jsonb_exists", jsonb_exists },
  { 4048, 2, true, false, "jsonb_exists_any", jsonb_exists_any },
  { 4049, 2, true, false, "jsonb_exists_all", jsonb_exists_all },
  { 4050, 2, true, false, "jsonb_contained", jsonb_contained },
  { 4051, 2, false, false, "array_agg_array_transfn", array_agg_array_transfn },
  { 4052, 2, false, false, "array_agg_array_finalfn", array_agg_array_finalfn },
  { 4053, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 4057, 2, true, false, "range_merge", range_merge },
  { 4063, 2, true, false, "inet_merge", inet_merge },
  { 4067, 2, true, false, "boxes_bound_box", boxes_bound_box },
  { 4071, 2, true, false, "inet_same_family", inet_same_family },
  { 4083, 1, true, false, "binary_upgrade_set_record_init_privs", binary_upgrade_set_record_init_privs },
  { 4084, 1, true, false, "regnamespacein", regnamespacein },
  { 4085, 1, true, false, "regnamespaceout", regnamespaceout },
  { 4086, 1, true, false, "to_regnamespace", to_regnamespace },
  { 4087, 1, true, false, "regnamespacerecv", regnamespacerecv },
  { 4088, 1, true, false, "regnamespacesend", regnamespacesend },
  { 4091, 1, true, false, "point_box", point_box },
  { 4092, 1, true, false, "regroleout", regroleout },
  { 4093, 1, true, false, "to_regrole", to_regrole },
  { 4094, 1, true, false, "regrolerecv", regrolerecv },
  { 4095, 1, true, false, "regrolesend", regrolesend },
  { 4098, 1, true, false, "regrolein", regrolein },
  { 4099, 0, true, false, "pg_rotate_logfile", pg_rotate_logfile },
  { 4100, 3, true, false, "pg_read_file", pg_read_file },
  { 4101, 3, true, false, "binary_upgrade_set_missing_value", binary_upgrade_set_missing_value },
  { 4105, 1, true, false, "brin_inclusion_opcinfo", brin_inclusion_opcinfo },
  { 4106, 4, true, false, "brin_inclusion_add_value", brin_inclusion_add_value },
  { 4107, 3, true, false, "brin_inclusion_consistent", brin_inclusion_consistent },
  { 4108, 3, true, false, "brin_inclusion_union", brin_inclusion_union },
  { 4110, 1, true, false, "macaddr8_in", macaddr8_in },
  { 4111, 1, true, false, "macaddr8_out", macaddr8_out },
  { 4112, 1, true, false, "macaddr8_trunc", macaddr8_trunc },
  { 4113, 2, true, false, "macaddr8_eq", macaddr8_eq },
  { 4114, 2, true, false, "macaddr8_lt", macaddr8_lt },
  { 4115, 2, true, false, "macaddr8_le", macaddr8_le },
  { 4116, 2, true, false, "macaddr8_gt", macaddr8_gt },
  { 4117, 2, true, false, "macaddr8_ge", macaddr8_ge },
  { 4118, 2, true, false, "macaddr8_ne", macaddr8_ne },
  { 4119, 2, true, false, "macaddr8_cmp", macaddr8_cmp },
  { 4120, 1, true, false, "macaddr8_not", macaddr8_not },
  { 4121, 2, true, false, "macaddr8_and", macaddr8_and },
  { 4122, 2, true, false, "macaddr8_or", macaddr8_or },
  { 4123, 1, true, false, "macaddrtomacaddr8", macaddrtomacaddr8 },
  { 4124, 1, true, false, "macaddr8tomacaddr", macaddr8tomacaddr },
  { 4125, 1, true, false, "macaddr8_set7bit", macaddr8_set7bit },
  { 4126, 5, true, false, "in_range_int8_int8", in_range_int8_int8 },
  { 4127, 5, true, false, "in_range_int4_int8", in_range_int4_int8 },
  { 4128, 5, true, false, "in_range_int4_int4", in_range_int4_int4 },
  { 4129, 5, true, false, "in_range_int4_int2", in_range_int4_int2 },
  { 4130, 5, true, false, "in_range_int2_int8", in_range_int2_int8 },
  { 4131, 5, true, false, "in_range_int2_int4", in_range_int2_int4 },
  { 4132, 5, true, false, "in_range_int2_int2", in_range_int2_int2 },
  { 4133, 5, true, false, "in_range_date_interval", in_range_date_interval },
  { 4134, 5, true, false, "in_range_timestamp_interval", in_range_timestamp_interval },
  { 4135, 5, true, false, "in_range_timestamptz_interval", in_range_timestamptz_interval },
  { 4136, 5, true, false, "in_range_interval_interval", in_range_interval_interval },
  { 4137, 5, true, false, "in_range_time_interval", in_range_time_interval },
  { 4138, 5, true, false, "in_range_timetz_interval", in_range_timetz_interval },
  { 4139, 5, true, false, "in_range_float8_float8", in_range_float8_float8 },
  { 4140, 5, true, false, "in_range_float4_float8", in_range_float4_float8 },
  { 4141, 5, true, false, "in_range_numeric_numeric", in_range_numeric_numeric },
  { 4187, 2, true, false, "pg_lsn_larger", pg_lsn_larger },
  { 4188, 2, true, false, "pg_lsn_smaller", pg_lsn_smaller },
  { 4189, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 4190, 1, false, false, "aggregate_dummy", aggregate_dummy },
  { 4193, 1, true, false, "regcollationin", regcollationin },
  { 4194, 1, true, false, "regcollationout", regcollationout },
  { 4195, 1, true, false, "to_regcollation", to_regcollation },
  { 4196, 1, true, false, "regcollationrecv", regcollationrecv },
  { 4197, 1, true, false, "regcollationsend", regcollationsend },
  { 4201, 4, true, false, "ts_headline_jsonb_byid_opt", ts_headline_jsonb_byid_opt },
  { 4202, 3, true, false, "ts_headline_jsonb_byid", ts_headline_jsonb_byid },
  { 4203, 3, true, false, "ts_headline_jsonb_opt", ts_headline_jsonb_opt },
  { 4204, 2, true, false, "ts_headline_jsonb", ts_headline_jsonb },
  { 4205, 4, true, false, "ts_headline_json_byid_opt", ts_headline_json_byid_opt },
  { 4206, 3, true, false, "ts_headline_json_byid", ts_headline_json_byid },
  { 4207, 3, true, false, "ts_headline_json_opt", ts_headline_json_opt },
  { 4208, 2, true, false, "ts_headline_json", ts_headline_json },
  { 4209, 1, true, false, "jsonb_string_to_tsvector", jsonb_string_to_tsvector },
  { 4210, 1, true, false, "json_string_to_tsvector", json_string_to_tsvector },
  { 4211, 2, true, false, "jsonb_string_to_tsvector_byid", jsonb_string_to_tsvector_byid },
  { 4212, 2, true, false, "json_string_to_tsvector_byid", json_string_to_tsvector_byid },
  { 4213, 2, true, false, "jsonb_to_tsvector", jsonb_to_tsvector },
  { 4214, 3, true, false, "jsonb_to_tsvector_byid", jsonb_to_tsvector_byid },
  { 4215, 2, true, false, "json_to_tsvector", json_to_tsvector },
  { 4216, 3, true, false, "json_to_tsvector_byid", json_to_tsvector_byid },
  { 4220, 3, true, false, "pg_copy_physical_replication_slot_a", pg_copy_physical_replication_slot_a },
  { 4221, 2, true, false, "pg_copy_physical_replication_slot_b", pg_copy_physical_replication_slot_b },
  { 4222, 4, true, false, "pg_copy_logical_replication_slot_a", pg_copy_logical_replication_slot_a },
  { 4223, 3, true, false, "pg_copy_logical_replication_slot_b", pg_copy_logical_replication_slot_b },
  { 4224, 2, true, false, "pg_copy_logical_replication_slot_c", pg_copy_logical_replication_slot_c },
  { 4350, 2, true, false, "unicode_normalize_func", unicode_normalize_func },
  { 4351, 2, true, false, "unicode_is_normalized", unicode_is_normalized },
  { 4566, 0, true, false, "pg_event_trigger_table_rewrite_oid", pg_event_trigger_table_rewrite_oid },
  { 4567, 0, true, false, "pg_event_trigger_table_rewrite_reason", pg_event_trigger_table_rewrite_reason },
  { 4568, 0, true, true, "pg_event_trigger_ddl_commands", pg_event_trigger_ddl_commands },
  { 5001, 1, true, false, "phraseto_tsquery", phraseto_tsquery },
  { 5003, 2, true, false, "tsquery_phrase", tsquery_phrase },
  { 5004, 3, true, false, "tsquery_phrase_distance", tsquery_phrase_distance },
  { 5006, 2, true, false, "phraseto_tsquery_byid", phraseto_tsquery_byid },
  { 5007, 2, true, false, "websearch_to_tsquery_byid", websearch_to_tsquery_byid },
  { 5009, 1, true, false, "websearch_to_tsquery", websearch_to_tsquery },
  { 5010, 2, true, false, "spg_bbox_quad_config", spg_bbox_quad_config },
  { 5011, 1, true, false, "spg_poly_quad_compress", spg_poly_quad_compress },
  { 5012, 2, true, false, "spg_box_quad_config", spg_box_quad_config },
  { 5013, 2, true, false, "spg_box_quad_choose", spg_box_quad_choose },
  { 5014, 2, true, false, "spg_box_quad_picksplit", spg_box_quad_picksplit },
  { 5015, 2, true, false, "spg_box_quad_inner_consistent", spg_box_quad_inner_consistent },
  { 5016, 2, true, false, "spg_box_quad_leaf_consistent", spg_box_quad_leaf_consistent },
  { 5018, 1, true, false, "pg_mcv_list_in", pg_mcv_list_in },
  { 5019, 1, true, false, "pg_mcv_list_out", pg_mcv_list_out },
  { 5020, 1, true, false, "pg_mcv_list_recv", pg_mcv_list_recv },
  { 5021, 1, true, false, "pg_mcv_list_send", pg_mcv_list_send },
  { 5028, 4, false, false, "satisfies_hash_partition", satisfies_hash_partition },
  { 5029, 0, true, true, "pg_ls_tmpdir_noargs", pg_ls_tmpdir_noargs },
  { 5030, 1, true, true, "pg_ls_tmpdir_1arg", pg_ls_tmpdir_1arg },
  { 5031, 0, true, true, "pg_ls_archive_statusdir", pg_ls_archive_statusdir },
  { 5033, 1, true, false, "network_sortsupport", network_sortsupport },
  { 5034, 2, true, false, "xid8lt", xid8lt },
  { 5035, 2, true, false, "xid8gt", xid8gt },
  { 5036, 2, true, false, "xid8le", xid8le },
  { 5037, 2, true, false, "xid8ge", xid8ge },
  { 5040, 4, true, false, "matchingsel", matchingsel },
  { 5041, 5, true, false, "matchingjoinsel", matchingjoinsel },
  { 5042, 1, true, false, "numeric_min_scale", numeric_min_scale },
  { 5043, 1, true, false, "numeric_trim_scale", numeric_trim_scale },
  { 5044, 2, true, false, "int4gcd", int4gcd },
  { 5045, 2, true, false, "int8gcd", int8gcd },
  { 5046, 2, true, false, "int4lcm", int4lcm },
  { 5047, 2, true, false, "int8lcm", int8lcm },
  { 5048, 2, true, false, "numeric_gcd", numeric_gcd },
  { 5049, 2, true, false, "numeric_lcm", numeric_lcm },
  { 5050, 1, true, false, "btvarstrequalimage", btvarstrequalimage },
  { 5051, 1, true, false, "btequalimage", btequalimage },
  { 5052, 0, true, true, "pg_get_shmem_allocations", pg_get_shmem_allocations },
  { 5053, 1, true, false, "pg_stat_get_ins_since_vacuum", pg_stat_get_ins_since_vacuum },
  { 5054, 5, false, false, "jsonb_set_lax", jsonb_set_lax },
  { 5055, 1, true, false, "pg_snapshot_in", pg_snapshot_in },
  { 5056, 1, true, false, "pg_snapshot_out", pg_snapshot_out },
  { 5057, 1, true, false, "pg_snapshot_recv", pg_snapshot_recv },
  { 5058, 1, true, false, "pg_snapshot_send", pg_snapshot_send },
  { 5059, 0, true, false, "pg_current_xact_id", pg_current_xact_id },
  { 5060, 0, true, false, "pg_current_xact_id_if_assigned", pg_current_xact_id_if_assigned },
  { 5061, 0, true, false, "pg_current_snapshot", pg_current_snapshot },
  { 5062, 1, true, false, "pg_snapshot_xmin", pg_snapshot_xmin },
  { 5063, 1, true, false, "pg_snapshot_xmax", pg_snapshot_xmax },
  { 5064, 1, true, true, "pg_snapshot_xip", pg_snapshot_xip },
  { 5065, 2, true, false, "pg_visible_in_snapshot", pg_visible_in_snapshot },
  { 5066, 1, true, false, "pg_xact_status", pg_xact_status },
  { 5070, 1, true, false, "xid8in", xid8in },
  { 5071, 1, true, false, "xid8toxid", xid8toxid },
  { 5081, 1, true, false, "xid8out", xid8out },
  { 5082, 1, true, false, "xid8recv", xid8recv },
  { 5083, 1, true, false, "xid8send", xid8send },
  { 5084, 2, true, false, "xid8eq", xid8eq },
  { 5085, 2, true, false, "xid8ne", xid8ne },
  { 5086, 1, true, false, "anycompatible_in", anycompatible_in },
  { 5087, 1, true, false, "anycompatible_out", anycompatible_out },
  { 5088, 1, true, false, "anycompatiblearray_in", anycompatiblearray_in },
  { 5089, 1, true, false, "anycompatiblearray_out", anycompatiblearray_out },
  { 5090, 1, true, false, "anycompatiblearray_recv", anycompatiblearray_recv },
  { 5091, 1, true, false, "anycompatiblearray_send", anycompatiblearray_send },
  { 5092, 1, true, false, "anycompatiblenonarray_in", anycompatiblenonarray_in },
  { 5093, 1, true, false, "anycompatiblenonarray_out", anycompatiblenonarray_out },
  { 5094, 3, true, false, "anycompatiblerange_in", anycompatiblerange_in },
  { 5095, 1, true, false, "anycompatiblerange_out", anycompatiblerange_out },
  { 5096, 2, true, false, "xid8cmp", xid8cmp },
  { 6003, 1, true, false, "pg_replication_origin_create", pg_replication_origin_create },
  { 6004, 1, true, false, "pg_replication_origin_drop", pg_replication_origin_drop },
  { 6005, 1, true, false, "pg_replication_origin_oid", pg_replication_origin_oid },
  { 6006, 1, true, false, "pg_replication_origin_session_setup", pg_replication_origin_session_setup },
  { 6007, 0, true, false, "pg_replication_origin_session_reset", pg_replication_origin_session_reset },
  { 6008, 0, true, false, "pg_replication_origin_session_is_setup", pg_replication_origin_session_is_setup },
  { 6009, 1, true, false, "pg_replication_origin_session_progress", pg_replication_origin_session_progress },
  { 6010, 2, true, false, "pg_replication_origin_xact_setup", pg_replication_origin_xact_setup },
  { 6011, 0, true, false, "pg_replication_origin_xact_reset", pg_replication_origin_xact_reset },
  { 6012, 2, true, false, "pg_replication_origin_advance", pg_replication_origin_advance },
  { 6013, 2, true, false, "pg_replication_origin_progress", pg_replication_origin_progress },
  { 6014, 0, false, true, "pg_show_replication_origin_status", pg_show_replication_origin_status },
  { 6118, 1, false, false, "pg_stat_get_subscription", pg_stat_get_subscription },
  { 6119, 1, true, true, "pg_get_publication_tables", pg_get_publication_tables },
  { 6120, 1, true, false, "pg_get_replica_identity_index", pg_get_replica_identity_index },
  { 6121, 1, true, false, "pg_relation_is_publishable", pg_relation_is_publishable }
};

const int fmgr_nbuiltins = (sizeof(fmgr_builtins) / sizeof(FmgrBuiltin));

const Oid fmgr_last_builtin_oid = 6121;

const uint16 fmgr_builtin_oid_index[6122] = {
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  0,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1,
  InvalidOidBuiltinMapping,
  2,
  3,
  4,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  5,
  6,
  7,
  8,
  9,
  10,
  11,
  12,
  13,
  14,
  15,
  16,
  17,
  18,
  19,
  20,
  21,
  22,
  23,
  24,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  25,
  26,
  27,
  28,
  29,
  30,
  31,
  32,
  33,
  34,
  35,
  InvalidOidBuiltinMapping,
  36,
  37,
  38,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  39,
  40,
  41,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  42,
  InvalidOidBuiltinMapping,
  43,
  44,
  45,
  46,
  47,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  48,
  49,
  50,
  51,
  52,
  53,
  54,
  55,
  56,
  57,
  58,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  59,
  60,
  61,
  62,
  63,
  64,
  65,
  66,
  67,
  68,
  69,
  70,
  71,
  72,
  73,
  74,
  75,
  76,
  77,
  78,
  79,
  80,
  81,
  82,
  83,
  84,
  85,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  86,
  87,
  88,
  89,
  90,
  91,
  92,
  93,
  94,
  95,
  96,
  97,
  98,
  99,
  100,
  101,
  102,
  103,
  104,
  105,
  106,
  107,
  108,
  109,
  110,
  111,
  112,
  113,
  114,
  115,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  116,
  117,
  118,
  119,
  120,
  121,
  122,
  123,
  124,
  125,
  126,
  127,
  128,
  129,
  130,
  131,
  132,
  133,
  InvalidOidBuiltinMapping,
  134,
  135,
  136,
  137,
  InvalidOidBuiltinMapping,
  138,
  139,
  140,
  141,
  142,
  143,
  144,
  145,
  146,
  147,
  InvalidOidBuiltinMapping,
  148,
  149,
  150,
  151,
  152,
  153,
  154,
  155,
  156,
  157,
  158,
  159,
  160,
  161,
  162,
  163,
  164,
  165,
  166,
  167,
  168,
  169,
  170,
  171,
  172,
  173,
  174,
  175,
  176,
  177,
  178,
  179,
  180,
  181,
  182,
  183,
  184,
  185,
  186,
  187,
  188,
  189,
  190,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  191,
  192,
  193,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  194,
  195,
  196,
  197,
  198,
  199,
  200,
  201,
  202,
  203,
  204,
  205,
  206,
  207,
  208,
  209,
  210,
  211,
  212,
  213,
  214,
  215,
  216,
  217,
  218,
  219,
  220,
  221,
  222,
  223,
  224,
  225,
  226,
  227,
  228,
  229,
  230,
  231,
  232,
  233,
  234,
  235,
  236,
  237,
  238,
  239,
  240,
  241,
  242,
  243,
  244,
  InvalidOidBuiltinMapping,
  245,
  246,
  247,
  248,
  249,
  250,
  251,
  252,
  253,
  254,
  255,
  256,
  257,
  258,
  259,
  260,
  261,
  262,
  263,
  264,
  265,
  266,
  267,
  InvalidOidBuiltinMapping,
  268,
  269,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  270,
  271,
  272,
  273,
  274,
  275,
  276,
  277,
  278,
  279,
  280,
  281,
  282,
  283,
  284,
  285,
  286,
  287,
  288,
  289,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  290,
  291,
  292,
  293,
  294,
  295,
  296,
  297,
  298,
  InvalidOidBuiltinMapping,
  299,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  300,
  301,
  302,
  303,
  304,
  305,
  306,
  InvalidOidBuiltinMapping,
  307,
  308,
  309,
  310,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  311,
  InvalidOidBuiltinMapping,
  312,
  313,
  314,
  315,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  316,
  317,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  318,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  319,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  320,
  321,
  322,
  InvalidOidBuiltinMapping,
  323,
  324,
  325,
  326,
  327,
  328,
  329,
  330,
  331,
  332,
  333,
  334,
  335,
  336,
  337,
  338,
  339,
  340,
  341,
  342,
  343,
  344,
  345,
  346,
  347,
  348,
  349,
  350,
  351,
  352,
  353,
  354,
  355,
  InvalidOidBuiltinMapping,
  356,
  357,
  358,
  359,
  360,
  361,
  362,
  363,
  364,
  365,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  366,
  367,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  368,
  369,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  370,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  371,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  372,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  373,
  374,
  375,
  376,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  377,
  378,
  InvalidOidBuiltinMapping,
  379,
  380,
  381,
  382,
  383,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  384,
  385,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  386,
  387,
  388,
  389,
  390,
  391,
  InvalidOidBuiltinMapping,
  392,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  393,
  394,
  395,
  396,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  397,
  398,
  399,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  400,
  401,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  402,
  403,
  404,
  405,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  406,
  407,
  408,
  409,
  410,
  411,
  412,
  413,
  414,
  415,
  416,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  417,
  418,
  419,
  420,
  421,
  422,
  423,
  424,
  425,
  426,
  427,
  428,
  429,
  430,
  431,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  432,
  433,
  434,
  435,
  436,
  437,
  438,
  439,
  440,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  441,
  442,
  443,
  444,
  445,
  446,
  447,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  448,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  449,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  450,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  451,
  452,
  453,
  454,
  455,
  456,
  457,
  458,
  459,
  460,
  461,
  462,
  463,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  464,
  465,
  466,
  467,
  468,
  469,
  470,
  471,
  472,
  473,
  474,
  475,
  476,
  477,
  478,
  479,
  480,
  481,
  482,
  483,
  484,
  485,
  486,
  InvalidOidBuiltinMapping,
  487,
  488,
  489,
  490,
  491,
  492,
  493,
  494,
  495,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  496,
  497,
  498,
  499,
  500,
  501,
  502,
  503,
  504,
  505,
  506,
  507,
  508,
  509,
  510,
  511,
  512,
  513,
  514,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  515,
  516,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  517,
  518,
  519,
  520,
  521,
  522,
  523,
  524,
  525,
  526,
  527,
  528,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  529,
  530,
  531,
  532,
  533,
  534,
  535,
  536,
  537,
  538,
  539,
  540,
  541,
  542,
  543,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  544,
  545,
  546,
  547,
  548,
  549,
  550,
  551,
  552,
  553,
  554,
  555,
  556,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  557,
  558,
  InvalidOidBuiltinMapping,
  559,
  560,
  561,
  562,
  563,
  564,
  565,
  566,
  567,
  568,
  569,
  570,
  571,
  572,
  573,
  574,
  575,
  576,
  577,
  578,
  579,
  580,
  581,
  582,
  583,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  584,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  585,
  586,
  587,
  588,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  589,
  590,
  591,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  592,
  593,
  594,
  InvalidOidBuiltinMapping,
  595,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  596,
  597,
  598,
  599,
  600,
  601,
  602,
  603,
  604,
  605,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  606,
  607,
  608,
  609,
  610,
  611,
  612,
  613,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  614,
  615,
  616,
  617,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  618,
  619,
  620,
  621,
  622,
  623,
  624,
  625,
  626,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  627,
  628,
  629,
  630,
  631,
  632,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  633,
  634,
  635,
  636,
  637,
  638,
  639,
  640,
  641,
  642,
  643,
  644,
  645,
  646,
  647,
  648,
  649,
  650,
  651,
  652,
  653,
  654,
  655,
  656,
  657,
  658,
  659,
  660,
  661,
  662,
  663,
  664,
  665,
  666,
  667,
  668,
  669,
  670,
  InvalidOidBuiltinMapping,
  671,
  672,
  673,
  674,
  675,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  676,
  677,
  678,
  679,
  680,
  681,
  682,
  683,
  684,
  685,
  686,
  687,
  688,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  689,
  690,
  691,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  692,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  693,
  694,
  695,
  696,
  697,
  698,
  699,
  700,
  701,
  702,
  703,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  704,
  705,
  706,
  707,
  708,
  InvalidOidBuiltinMapping,
  709,
  710,
  711,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  712,
  713,
  InvalidOidBuiltinMapping,
  714,
  715,
  716,
  InvalidOidBuiltinMapping,
  717,
  718,
  719,
  720,
  721,
  722,
  723,
  724,
  725,
  726,
  727,
  728,
  729,
  730,
  InvalidOidBuiltinMapping,
  731,
  732,
  733,
  734,
  InvalidOidBuiltinMapping,
  735,
  736,
  737,
  738,
  739,
  InvalidOidBuiltinMapping,
  740,
  InvalidOidBuiltinMapping,
  741,
  742,
  743,
  744,
  745,
  746,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  747,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  748,
  749,
  750,
  751,
  752,
  753,
  754,
  755,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  756,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  757,
  758,
  759,
  760,
  761,
  762,
  763,
  764,
  765,
  InvalidOidBuiltinMapping,
  766,
  767,
  768,
  769,
  770,
  771,
  772,
  773,
  774,
  775,
  776,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  777,
  InvalidOidBuiltinMapping,
  778,
  779,
  InvalidOidBuiltinMapping,
  780,
  781,
  782,
  783,
  784,
  785,
  786,
  787,
  788,
  789,
  790,
  791,
  792,
  793,
  794,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  795,
  InvalidOidBuiltinMapping,
  796,
  797,
  798,
  799,
  800,
  801,
  802,
  803,
  804,
  805,
  806,
  807,
  InvalidOidBuiltinMapping,
  808,
  809,
  810,
  811,
  812,
  813,
  814,
  815,
  816,
  817,
  818,
  819,
  820,
  821,
  822,
  823,
  824,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  825,
  InvalidOidBuiltinMapping,
  826,
  827,
  828,
  829,
  830,
  InvalidOidBuiltinMapping,
  831,
  832,
  833,
  834,
  835,
  836,
  837,
  838,
  839,
  840,
  841,
  842,
  843,
  844,
  845,
  846,
  847,
  848,
  849,
  850,
  851,
  852,
  853,
  854,
  855,
  856,
  857,
  858,
  859,
  860,
  861,
  862,
  863,
  864,
  865,
  866,
  867,
  868,
  869,
  870,
  871,
  872,
  873,
  874,
  875,
  876,
  877,
  878,
  879,
  880,
  881,
  882,
  883,
  884,
  InvalidOidBuiltinMapping,
  885,
  886,
  887,
  888,
  889,
  890,
  891,
  892,
  893,
  894,
  895,
  896,
  897,
  898,
  899,
  900,
  901,
  902,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  903,
  904,
  905,
  906,
  907,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  908,
  909,
  910,
  911,
  InvalidOidBuiltinMapping,
  912,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  913,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  914,
  915,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  916,
  917,
  918,
  919,
  920,
  921,
  922,
  923,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  924,
  925,
  926,
  927,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  928,
  929,
  930,
  931,
  932,
  933,
  934,
  935,
  936,
  937,
  938,
  939,
  940,
  941,
  942,
  943,
  944,
  945,
  946,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  947,
  948,
  949,
  950,
  951,
  952,
  953,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  954,
  955,
  956,
  957,
  958,
  959,
  960,
  961,
  962,
  963,
  964,
  965,
  966,
  967,
  968,
  969,
  970,
  971,
  972,
  973,
  974,
  975,
  976,
  977,
  978,
  979,
  980,
  981,
  982,
  983,
  984,
  985,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  986,
  987,
  988,
  989,
  990,
  991,
  992,
  993,
  994,
  995,
  996,
  997,
  998,
  999,
  1000,
  1001,
  1002,
  1003,
  1004,
  1005,
  1006,
  1007,
  1008,
  1009,
  1010,
  1011,
  1012,
  1013,
  1014,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1015,
  1016,
  1017,
  1018,
  InvalidOidBuiltinMapping,
  1019,
  1020,
  1021,
  1022,
  1023,
  1024,
  1025,
  InvalidOidBuiltinMapping,
  1026,
  InvalidOidBuiltinMapping,
  1027,
  1028,
  1029,
  1030,
  1031,
  1032,
  1033,
  1034,
  1035,
  1036,
  1037,
  1038,
  1039,
  1040,
  1041,
  1042,
  1043,
  1044,
  1045,
  1046,
  1047,
  1048,
  1049,
  1050,
  1051,
  1052,
  1053,
  1054,
  1055,
  1056,
  InvalidOidBuiltinMapping,
  1057,
  1058,
  1059,
  1060,
  1061,
  1062,
  1063,
  1064,
  1065,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1066,
  1067,
  1068,
  1069,
  1070,
  1071,
  1072,
  1073,
  1074,
  1075,
  1076,
  1077,
  1078,
  1079,
  1080,
  1081,
  1082,
  1083,
  1084,
  1085,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1086,
  1087,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1088,
  1089,
  1090,
  1091,
  1092,
  1093,
  1094,
  1095,
  1096,
  1097,
  1098,
  1099,
  1100,
  1101,
  1102,
  1103,
  1104,
  1105,
  1106,
  1107,
  1108,
  1109,
  1110,
  1111,
  1112,
  1113,
  1114,
  1115,
  1116,
  1117,
  1118,
  1119,
  1120,
  1121,
  1122,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1123,
  1124,
  1125,
  1126,
  1127,
  1128,
  1129,
  1130,
  1131,
  1132,
  1133,
  1134,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1135,
  1136,
  1137,
  1138,
  1139,
  1140,
  1141,
  1142,
  1143,
  1144,
  1145,
  1146,
  1147,
  1148,
  1149,
  1150,
  1151,
  1152,
  1153,
  1154,
  1155,
  1156,
  1157,
  1158,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1159,
  1160,
  1161,
  1162,
  1163,
  1164,
  1165,
  1166,
  1167,
  1168,
  1169,
  1170,
  1171,
  1172,
  1173,
  1174,
  1175,
  1176,
  1177,
  1178,
  1179,
  1180,
  1181,
  1182,
  1183,
  1184,
  1185,
  1186,
  1187,
  1188,
  1189,
  1190,
  1191,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1192,
  1193,
  1194,
  1195,
  1196,
  1197,
  1198,
  1199,
  1200,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1201,
  1202,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1203,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1204,
  1205,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1206,
  1207,
  1208,
  1209,
  1210,
  1211,
  1212,
  1213,
  1214,
  1215,
  1216,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1217,
  1218,
  1219,
  1220,
  1221,
  1222,
  1223,
  1224,
  1225,
  1226,
  1227,
  1228,
  1229,
  1230,
  1231,
  1232,
  1233,
  1234,
  1235,
  1236,
  1237,
  InvalidOidBuiltinMapping,
  1238,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1239,
  1240,
  1241,
  1242,
  1243,
  1244,
  1245,
  1246,
  1247,
  1248,
  1249,
  1250,
  1251,
  1252,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1253,
  1254,
  1255,
  1256,
  1257,
  InvalidOidBuiltinMapping,
  1258,
  1259,
  1260,
  1261,
  1262,
  1263,
  1264,
  1265,
  1266,
  1267,
  1268,
  1269,
  1270,
  1271,
  1272,
  1273,
  1274,
  1275,
  1276,
  1277,
  InvalidOidBuiltinMapping,
  1278,
  InvalidOidBuiltinMapping,
  1279,
  InvalidOidBuiltinMapping,
  1280,
  1281,
  1282,
  1283,
  1284,
  1285,
  1286,
  1287,
  1288,
  1289,
  1290,
  1291,
  1292,
  1293,
  1294,
  1295,
  1296,
  1297,
  1298,
  1299,
  1300,
  InvalidOidBuiltinMapping,
  1301,
  1302,
  1303,
  1304,
  1305,
  1306,
  1307,
  1308,
  1309,
  1310,
  1311,
  1312,
  1313,
  1314,
  1315,
  InvalidOidBuiltinMapping,
  1316,
  1317,
  1318,
  1319,
  1320,
  1321,
  1322,
  1323,
  1324,
  1325,
  1326,
  1327,
  1328,
  1329,
  1330,
  1331,
  1332,
  1333,
  1334,
  1335,
  1336,
  1337,
  1338,
  1339,
  1340,
  1341,
  1342,
  1343,
  1344,
  1345,
  1346,
  1347,
  1348,
  1349,
  1350,
  1351,
  1352,
  1353,
  1354,
  1355,
  1356,
  1357,
  1358,
  1359,
  1360,
  1361,
  1362,
  1363,
  1364,
  InvalidOidBuiltinMapping,
  1365,
  1366,
  1367,
  1368,
  1369,
  1370,
  1371,
  1372,
  1373,
  1374,
  1375,
  1376,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1377,
  1378,
  1379,
  1380,
  1381,
  1382,
  1383,
  1384,
  1385,
  1386,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1387,
  InvalidOidBuiltinMapping,
  1388,
  1389,
  1390,
  InvalidOidBuiltinMapping,
  1391,
  1392,
  1393,
  1394,
  1395,
  1396,
  1397,
  1398,
  1399,
  1400,
  1401,
  1402,
  1403,
  InvalidOidBuiltinMapping,
  1404,
  1405,
  1406,
  1407,
  1408,
  1409,
  1410,
  1411,
  1412,
  1413,
  1414,
  1415,
  1416,
  1417,
  1418,
  1419,
  1420,
  1421,
  1422,
  1423,
  1424,
  1425,
  1426,
  1427,
  1428,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1429,
  1430,
  1431,
  InvalidOidBuiltinMapping,
  1432,
  1433,
  1434,
  1435,
  1436,
  1437,
  1438,
  1439,
  1440,
  1441,
  1442,
  1443,
  1444,
  1445,
  1446,
  1447,
  1448,
  1449,
  1450,
  1451,
  1452,
  1453,
  1454,
  1455,
  1456,
  1457,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1458,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1459,
  1460,
  1461,
  1462,
  1463,
  1464,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1465,
  1466,
  1467,
  1468,
  1469,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1470,
  1471,
  1472,
  1473,
  1474,
  1475,
  1476,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1477,
  1478,
  1479,
  1480,
  1481,
  1482,
  1483,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1484,
  1485,
  1486,
  1487,
  1488,
  1489,
  1490,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1491,
  1492,
  1493,
  1494,
  1495,
  1496,
  1497,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1498,
  1499,
  1500,
  1501,
  1502,
  1503,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1504,
  1505,
  1506,
  1507,
  1508,
  1509,
  1510,
  1511,
  1512,
  1513,
  1514,
  1515,
  1516,
  1517,
  1518,
  1519,
  1520,
  1521,
  1522,
  1523,
  1524,
  1525,
  1526,
  1527,
  1528,
  1529,
  1530,
  1531,
  1532,
  1533,
  1534,
  1535,
  1536,
  1537,
  1538,
  1539,
  1540,
  1541,
  1542,
  1543,
  1544,
  1545,
  1546,
  1547,
  1548,
  1549,
  1550,
  1551,
  1552,
  1553,
  1554,
  1555,
  1556,
  1557,
  1558,
  1559,
  1560,
  1561,
  1562,
  1563,
  1564,
  1565,
  1566,
  1567,
  1568,
  1569,
  1570,
  1571,
  1572,
  1573,
  1574,
  1575,
  1576,
  1577,
  1578,
  1579,
  1580,
  1581,
  1582,
  1583,
  1584,
  1585,
  1586,
  1587,
  1588,
  1589,
  1590,
  1591,
  1592,
  1593,
  1594,
  1595,
  1596,
  1597,
  1598,
  1599,
  1600,
  1601,
  1602,
  1603,
  1604,
  1605,
  1606,
  1607,
  1608,
  1609,
  1610,
  1611,
  1612,
  1613,
  1614,
  1615,
  1616,
  1617,
  1618,
  1619,
  1620,
  1621,
  1622,
  1623,
  1624,
  1625,
  1626,
  1627,
  1628,
  1629,
  1630,
  1631,
  1632,
  1633,
  1634,
  1635,
  1636,
  1637,
  1638,
  1639,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1640,
  1641,
  1642,
  1643,
  1644,
  1645,
  1646,
  1647,
  1648,
  1649,
  1650,
  1651,
  1652,
  1653,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1654,
  InvalidOidBuiltinMapping,
  1655,
  1656,
  1657,
  1658,
  1659,
  1660,
  1661,
  1662,
  1663,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1664,
  1665,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1666,
  1667,
  1668,
  1669,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1670,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1671,
  1672,
  1673,
  1674,
  1675,
  1676,
  1677,
  1678,
  1679,
  1680,
  InvalidOidBuiltinMapping,
  1681,
  1682,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1683,
  1684,
  1685,
  1686,
  1687,
  1688,
  1689,
  1690,
  1691,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1692,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1693,
  1694,
  1695,
  1696,
  1697,
  1698,
  1699,
  1700,
  1701,
  1702,
  1703,
  1704,
  1705,
  1706,
  1707,
  1708,
  1709,
  1710,
  1711,
  1712,
  1713,
  1714,
  1715,
  1716,
  1717,
  1718,
  1719,
  1720,
  1721,
  1722,
  1723,
  1724,
  1725,
  1726,
  1727,
  1728,
  1729,
  InvalidOidBuiltinMapping,
  1730,
  1731,
  InvalidOidBuiltinMapping,
  1732,
  1733,
  1734,
  1735,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1736,
  1737,
  1738,
  1739,
  1740,
  1741,
  1742,
  1743,
  1744,
  1745,
  1746,
  1747,
  1748,
  1749,
  1750,
  1751,
  1752,
  1753,
  InvalidOidBuiltinMapping,
  1754,
  1755,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1756,
  1757,
  1758,
  1759,
  1760,
  1761,
  1762,
  1763,
  InvalidOidBuiltinMapping,
  1764,
  1765,
  1766,
  1767,
  1768,
  1769,
  1770,
  1771,
  1772,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1773,
  1774,
  1775,
  1776,
  1777,
  1778,
  1779,
  1780,
  1781,
  1782,
  1783,
  1784,
  1785,
  1786,
  1787,
  1788,
  1789,
  1790,
  1791,
  1792,
  1793,
  1794,
  1795,
  1796,
  1797,
  1798,
  1799,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1800,
  1801,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1802,
  1803,
  1804,
  1805,
  1806,
  1807,
  1808,
  1809,
  1810,
  1811,
  1812,
  1813,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1814,
  1815,
  1816,
  1817,
  1818,
  1819,
  1820,
  1821,
  1822,
  1823,
  1824,
  1825,
  1826,
  1827,
  1828,
  1829,
  1830,
  1831,
  1832,
  1833,
  1834,
  1835,
  1836,
  1837,
  1838,
  1839,
  1840,
  1841,
  1842,
  1843,
  1844,
  1845,
  1846,
  1847,
  1848,
  1849,
  1850,
  1851,
  1852,
  1853,
  1854,
  1855,
  1856,
  1857,
  1858,
  1859,
  1860,
  1861,
  1862,
  1863,
  1864,
  1865,
  1866,
  1867,
  InvalidOidBuiltinMapping,
  1868,
  1869,
  1870,
  1871,
  1872,
  1873,
  1874,
  1875,
  1876,
  1877,
  1878,
  1879,
  1880,
  1881,
  1882,
  1883,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1884,
  1885,
  1886,
  1887,
  1888,
  1889,
  1890,
  1891,
  1892,
  1893,
  1894,
  1895,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1896,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1897,
  1898,
  1899,
  1900,
  1901,
  1902,
  1903,
  1904,
  1905,
  1906,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1907,
  1908,
  1909,
  1910,
  1911,
  1912,
  1913,
  1914,
  1915,
  1916,
  1917,
  1918,
  1919,
  1920,
  1921,
  1922,
  1923,
  1924,
  1925,
  1926,
  1927,
  1928,
  1929,
  1930,
  1931,
  1932,
  1933,
  1934,
  1935,
  1936,
  1937,
  1938,
  1939,
  1940,
  1941,
  1942,
  1943,
  1944,
  1945,
  1946,
  1947,
  1948,
  1949,
  1950,
  1951,
  1952,
  1953,
  1954,
  1955,
  1956,
  1957,
  1958,
  1959,
  InvalidOidBuiltinMapping,
  1960,
  1961,
  1962,
  1963,
  1964,
  1965,
  1966,
  1967,
  1968,
  1969,
  1970,
  1971,
  1972,
  1973,
  1974,
  1975,
  1976,
  1977,
  1978,
  1979,
  1980,
  1981,
  1982,
  1983,
  1984,
  1985,
  1986,
  1987,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  1988,
  1989,
  1990,
  InvalidOidBuiltinMapping,
  1991,
  1992,
  1993,
  1994,
  1995,
  1996,
  1997,
  1998,
  1999,
  2000,
  2001,
  2002,
  2003,
  2004,
  2005,
  2006,
  2007,
  2008,
  2009,
  2010,
  2011,
  2012,
  2013,
  2014,
  2015,
  2016,
  2017,
  2018,
  2019,
  InvalidOidBuiltinMapping,
  2020,
  2021,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2022,
  2023,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2024,
  2025,
  2026,
  2027,
  2028,
  2029,
  2030,
  2031,
  2032,
  2033,
  2034,
  2035,
  2036,
  2037,
  2038,
  2039,
  2040,
  2041,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2042,
  2043,
  2044,
  2045,
  2046,
  2047,
  2048,
  2049,
  2050,
  2051,
  2052,
  2053,
  2054,
  2055,
  InvalidOidBuiltinMapping,
  2056,
  2057,
  2058,
  2059,
  2060,
  2061,
  2062,
  2063,
  2064,
  2065,
  2066,
  2067,
  2068,
  2069,
  2070,
  2071,
  2072,
  2073,
  2074,
  2075,
  2076,
  2077,
  2078,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2079,
  2080,
  2081,
  2082,
  2083,
  2084,
  2085,
  2086,
  2087,
  2088,
  2089,
  InvalidOidBuiltinMapping,
  2090,
  2091,
  2092,
  2093,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2094,
  2095,
  2096,
  2097,
  2098,
  2099,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2100,
  2101,
  2102,
  2103,
  2104,
  2105,
  2106,
  2107,
  2108,
  2109,
  2110,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2111,
  2112,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2113,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2114,
  2115,
  2116,
  2117,
  2118,
  2119,
  2120,
  2121,
  2122,
  2123,
  2124,
  2125,
  2126,
  2127,
  2128,
  2129,
  2130,
  InvalidOidBuiltinMapping,
  2131,
  2132,
  2133,
  2134,
  2135,
  2136,
  2137,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2138,
  InvalidOidBuiltinMapping,
  2139,
  InvalidOidBuiltinMapping,
  2140,
  2141,
  2142,
  2143,
  2144,
  2145,
  2146,
  2147,
  2148,
  2149,
  2150,
  2151,
  2152,
  2153,
  2154,
  2155,
  2156,
  2157,
  InvalidOidBuiltinMapping,
  2158,
  2159,
  2160,
  2161,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2162,
  2163,
  2164,
  2165,
  2166,
  2167,
  2168,
  2169,
  2170,
  2171,
  2172,
  2173,
  2174,
  2175,
  2176,
  2177,
  2178,
  2179,
  2180,
  2181,
  2182,
  2183,
  2184,
  2185,
  2186,
  2187,
  2188,
  2189,
  2190,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2191,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2192,
  2193,
  2194,
  2195,
  2196,
  2197,
  2198,
  2199,
  2200,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2201,
  InvalidOidBuiltinMapping,
  2202,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2203,
  2204,
  2205,
  2206,
  2207,
  2208,
  2209,
  2210,
  2211,
  2212,
  2213,
  2214,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2215,
  2216,
  InvalidOidBuiltinMapping,
  2217,
  2218,
  2219,
  InvalidOidBuiltinMapping,
  2220,
  2221,
  2222,
  2223,
  2224,
  2225,
  2226,
  2227,
  2228,
  2229,
  2230,
  2231,
  2232,
  2233,
  2234,
  2235,
  2236,
  2237,
  2238,
  2239,
  2240,
  2241,
  2242,
  2243,
  2244,
  2245,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2246,
  InvalidOidBuiltinMapping,
  2247,
  InvalidOidBuiltinMapping,
  2248,
  2249,
  2250,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2251,
  2252,
  2253,
  2254,
  2255,
  2256,
  2257,
  2258,
  2259,
  2260,
  2261,
  2262,
  2263,
  2264,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2265,
  2266,
  2267,
  2268,
  2269,
  2270,
  2271,
  2272,
  2273,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2274,
  2275,
  2276,
  2277,
  2278,
  InvalidOidBuiltinMapping,
  2279,
  2280,
  InvalidOidBuiltinMapping,
  2281,
  2282,
  2283,
  InvalidOidBuiltinMapping,
  2284,
  2285,
  2286,
  2287,
  2288,
  2289,
  2290,
  2291,
  2292,
  2293,
  2294,
  2295,
  2296,
  2297,
  2298,
  2299,
  2300,
  2301,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2302,
  2303,
  2304,
  2305,
  2306,
  2307,
  2308,
  2309,
  2310,
  2311,
  2312,
  2313,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2314,
  2315,
  2316,
  2317,
  2318,
  2319,
  2320,
  2321,
  2322,
  2323,
  InvalidOidBuiltinMapping,
  2324,
  2325,
  2326,
  2327,
  2328,
  2329,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2330,
  2331,
  2332,
  2333,
  2334,
  2335,
  2336,
  InvalidOidBuiltinMapping,
  2337,
  InvalidOidBuiltinMapping,
  2338,
  2339,
  2340,
  2341,
  2342,
  2343,
  2344,
  2345,
  2346,
  2347,
  2348,
  2349,
  2350,
  2351,
  2352,
  2353,
  2354,
  2355,
  2356,
  2357,
  2358,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2359,
  2360,
  2361,
  InvalidOidBuiltinMapping,
  2362,
  2363,
  2364,
  2365,
  2366,
  2367,
  2368,
  2369,
  2370,
  2371,
  2372,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2373,
  2374,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2375,
  2376,
  2377,
  2378,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2379,
  2380,
  2381,
  2382,
  2383,
  2384,
  2385,
  2386,
  2387,
  2388,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2389,
  2390,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2391,
  2392,
  2393,
  2394,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2395,
  2396,
  2397,
  2398,
  2399,
  2400,
  2401,
  2402,
  2403,
  InvalidOidBuiltinMapping,
  2404,
  2405,
  2406,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2407,
  2408,
  2409,
  2410,
  2411,
  2412,
  2413,
  2414,
  2415,
  2416,
  2417,
  2418,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2419,
  2420,
  2421,
  2422,
  2423,
  2424,
  2425,
  2426,
  2427,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2428,
  2429,
  2430,
  2431,
  2432,
  2433,
  2434,
  InvalidOidBuiltinMapping,
  2435,
  2436,
  2437,
  2438,
  2439,
  2440,
  2441,
  2442,
  2443,
  InvalidOidBuiltinMapping,
  2444,
  2445,
  2446,
  2447,
  2448,
  2449,
  2450,
  2451,
  2452,
  InvalidOidBuiltinMapping,
  2453,
  2454,
  2455,
  2456,
  InvalidOidBuiltinMapping,
  2457,
  2458,
  InvalidOidBuiltinMapping,
  2459,
  2460,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2461,
  2462,
  2463,
  2464,
  2465,
  2466,
  InvalidOidBuiltinMapping,
  2467,
  2468,
  2469,
  2470,
  2471,
  InvalidOidBuiltinMapping,
  2472,
  2473,
  2474,
  2475,
  2476,
  2477,
  2478,
  2479,
  2480,
  2481,
  2482,
  2483,
  2484,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2485,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2486,
  2487,
  2488,
  2489,
  2490,
  2491,
  2492,
  2493,
  2494,
  2495,
  2496,
  2497,
  2498,
  2499,
  2500,
  2501,
  2502,
  2503,
  2504,
  2505,
  2506,
  2507,
  2508,
  InvalidOidBuiltinMapping,
  2509,
  2510,
  2511,
  2512,
  2513,
  2514,
  2515,
  InvalidOidBuiltinMapping,
  2516,
  2517,
  2518,
  2519,
  InvalidOidBuiltinMapping,
  2520,
  2521,
  2522,
  2523,
  2524,
  2525,
  2526,
  2527,
  2528,
  2529,
  2530,
  2531,
  2532,
  2533,
  2534,
  2535,
  2536,
  InvalidOidBuiltinMapping,
  2537,
  2538,
  2539,
  2540,
  2541,
  InvalidOidBuiltinMapping,
  2542,
  2543,
  2544,
  2545,
  2546,
  2547,
  InvalidOidBuiltinMapping,
  2548,
  2549,
  2550,
  2551,
  2552,
  2553,
  2554,
  2555,
  2556,
  2557,
  2558,
  2559,
  2560,
  2561,
  2562,
  2563,
  2564,
  2565,
  2566,
  2567,
  2568,
  2569,
  2570,
  2571,
  2572,
  2573,
  2574,
  2575,
  2576,
  2577,
  2578,
  2579,
  2580,
  2581,
  2582,
  2583,
  2584,
  2585,
  InvalidOidBuiltinMapping,
  2586,
  2587,
  2588,
  2589,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2590,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2591,
  2592,
  2593,
  2594,
  2595,
  InvalidOidBuiltinMapping,
  2596,
  2597,
  2598,
  2599,
  2600,
  2601,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2602,
  2603,
  2604,
  2605,
  2606,
  2607,
  2608,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2609,
  2610,
  2611,
  2612,
  2613,
  2614,
  2615,
  2616,
  2617,
  2618,
  2619,
  2620,
  2621,
  2622,
  2623,
  2624,
  2625,
  2626,
  2627,
  2628,
  2629,
  2630,
  2631,
  2632,
  2633,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2634,
  2635,
  2636,
  2637,
  2638,
  2639,
  2640,
  2641,
  2642,
  2643,
  2644,
  2645,
  2646,
  2647,
  2648,
  2649,
  2650,
  2651,
  2652,
  2653,
  2654,
  2655,
  2656,
  2657,
  2658,
  2659,
  2660,
  2661,
  2662,
  InvalidOidBuiltinMapping,
  2663,
  2664,
  InvalidOidBuiltinMapping,
  2665,
  2666,
  2667,
  2668,
  2669,
  2670,
  2671,
  2672,
  2673,
  2674,
  2675,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2676,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2677,
  2678,
  2679,
  2680,
  2681,
  2682,
  2683,
  2684,
  2685,
  2686,
  2687,
  2688,
  2689,
  2690,
  2691,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2692,
  2693,
  2694,
  2695,
  2696,
  2697,
  2698,
  2699,
  2700,
  2701,
  2702,
  2703,
  2704,
  2705,
  2706,
  2707,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2708,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2709,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2710,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2711,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2712,
  2713,
  2714,
  2715,
  2716,
  2717,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2718,
  2719,
  2720,
  2721,
  2722,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2723,
  2724,
  2725,
  2726,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2727,
  2728,
  2729,
  2730,
  InvalidOidBuiltinMapping,
  2731,
  2732,
  2733,
  2734,
  2735,
  2736,
  2737,
  2738,
  2739,
  2740,
  2741,
  2742,
  2743,
  2744,
  2745,
  2746,
  2747,
  2748,
  2749,
  2750,
  2751,
  2752,
  2753,
  2754,
  2755,
  2756,
  2757,
  2758,
  2759,
  2760,
  2761,
  2762,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2763,
  2764,
  2765,
  2766,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2767,
  2768,
  2769,
  2770,
  2771,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2772,
  2773,
  2774,
  2775,
  2776,
  2777,
  2778,
  2779,
  2780,
  2781,
  2782,
  2783,
  2784,
  2785,
  2786,
  2787,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2788,
  2789,
  2790,
  2791,
  2792,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2793,
  2794,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2795,
  2796,
  2797,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2798,
  InvalidOidBuiltinMapping,
  2799,
  2800,
  InvalidOidBuiltinMapping,
  2801,
  2802,
  InvalidOidBuiltinMapping,
  2803,
  2804,
  2805,
  2806,
  2807,
  2808,
  2809,
  2810,
  InvalidOidBuiltinMapping,
  2811,
  2812,
  2813,
  2814,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2815,
  2816,
  2817,
  2818,
  InvalidOidBuiltinMapping,
  2819,
  2820,
  2821,
  2822,
  2823,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2824,
  2825,
  2826,
  2827,
  2828,
  2829,
  2830,
  2831,
  2832,
  2833,
  2834,
  2835,
  2836,
  2837,
  2838,
  2839,
  2840,
  2841,
  2842,
  2843,
  2844,
  2845,
  2846,
  2847,
  2848,
  2849,
  2850,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2851,
  2852,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2853,
  2854,
  2855,
  2856,
  2857,
  2858,
  2859,
  2860,
  2861,
  2862,
  2863,
  2864,
  2865,
  2866,
  2867,
  2868,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2869,
  2870,
  2871,
  2872,
  2873,
  2874,
  2875,
  2876,
  2877,
  2878,
  2879,
  2880,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  InvalidOidBuiltinMapping,
  2881,
  2882,
  2883,
  2884
};
