/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
// IWYU pragma: private, include "nsDisplayList.h"
DECLARE_DISPLAY_ITEM_TYPE(ALT_FEEDBACK, 0)
DECLARE_DISPLAY_ITEM_TYPE(ASYNC_ZOOM,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(BACKDROP_FILTER, TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(BACKDROP_ROOT_CONTAINER, TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(BACKGROUND, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(BACKGROUND_COLOR, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(BLEND_CONTAINER,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(BLEND_MODE,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(BORDER, 0)
DECLARE_DISPLAY_ITEM_TYPE(BOX_SHADOW_INNER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(BOX_SHADOW_OUTER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(BULLET, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(BUTTON_BORDER_BACKGROUND, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(BUTTON_BOX_SHADOW_OUTER,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(BUTTON_FOREGROUND, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(CANVAS, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(CANVAS_BACKGROUND_COLOR, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(CANVAS_BACKGROUND_IMAGE, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(CANVAS_FOCUS, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(CANVAS_THEMED_BACKGROUND,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(CARET, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(CHECKED_CHECKBOX,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(CHECKED_RADIOBUTTON,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(CLEAR_BACKGROUND, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(COLUMN_RULE, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(COMBOBOX_FOCUS, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(COMPOSITOR_HITTEST_INFO, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(CONTAINER, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(EVENT_RECEIVER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(FIELDSET_BORDER_BACKGROUND, 0)
DECLARE_DISPLAY_ITEM_TYPE(FILTER, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(FIXED_POSITION,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(FOREIGN_OBJECT,
                          TYPE_IS_CONTENTFUL | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(FRAMESET_BLANK, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(FRAMESET_BORDER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(GENERIC, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(HEADER_FOOTER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(IMAGE, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(LIST_FOCUS, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MASK, TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(OPACITY, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(OPTION_EVENT_GRABBER,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(OUTLINE, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(OWN_LAYER, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(PERSPECTIVE,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(PLUGIN, 0)
DECLARE_DISPLAY_ITEM_TYPE(PLUGIN_READBACK, 0)
DECLARE_DISPLAY_ITEM_TYPE(PRINT_PLUGIN, 0)
DECLARE_DISPLAY_ITEM_TYPE(RANGE_FOCUS_RING, 0)
DECLARE_DISPLAY_ITEM_TYPE(REMOTE, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(SCROLL_INFO_LAYER,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(SELECTION_OVERLAY, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(SOLID_COLOR, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(SOLID_COLOR_REGION, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(SUBDOCUMENT,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(STICKY_POSITION,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(SVG_OUTER_SVG, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(SVG_GEOMETRY, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(SVG_TEXT, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(SVG_WRAPPER, TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_BACKGROUND_COLOR, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_BACKGROUND_IMAGE, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_BLEND_CONTAINER,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_BLEND_MODE,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_BORDER_COLLAPSE, 0)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_CELL_BACKGROUND, 0)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_CELL_SELECTION, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_THEMED_BACKGROUND_IMAGE, TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(TABLE_FIXED_POSITION,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(TEXT, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(TEXT_OVERFLOW,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(THEMED_BACKGROUND, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(TRANSFORM, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(VIDEO, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTENTFUL)
DECLARE_DISPLAY_ITEM_TYPE(WRAP_LIST, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(ZOOM, TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)

#if defined(MOZ_REFLOW_PERF_DSP) && defined(MOZ_REFLOW_PERF)
DECLARE_DISPLAY_ITEM_TYPE(REFLOW_COUNT, TYPE_RENDERS_NO_IMAGES)
#endif

#ifdef MOZ_XUL
DECLARE_DISPLAY_ITEM_TYPE(XUL_EVENT_REDIRECTOR,
                          TYPE_RENDERS_NO_IMAGES | TYPE_IS_CONTAINER)
DECLARE_DISPLAY_ITEM_TYPE(XUL_GROUP_BACKGROUND, 0)
DECLARE_DISPLAY_ITEM_TYPE(XUL_IMAGE, 0)
DECLARE_DISPLAY_ITEM_TYPE(XUL_TEXT_BOX, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(XUL_TREE_BODY, 0)
DECLARE_DISPLAY_ITEM_TYPE(XUL_TREE_COL_SPLITTER_TARGET, TYPE_RENDERS_NO_IMAGES)
#  ifdef DEBUG_LAYOUT
DECLARE_DISPLAY_ITEM_TYPE(XUL_DEBUG, TYPE_RENDERS_NO_IMAGES)
#  endif
#endif

DECLARE_DISPLAY_ITEM_TYPE(MATHML_BAR, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MATHML_CHAR_FOREGROUND, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MATHML_ERROR, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MATHML_MENCLOSE_NOTATION, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MATHML_SELECTION_RECT, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MATHML_SLASH, TYPE_RENDERS_NO_IMAGES)
#ifdef DEBUG
DECLARE_DISPLAY_ITEM_TYPE(MATHML_BOUNDING_METRICS, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(MATHML_CHAR_DEBUG, TYPE_RENDERS_NO_IMAGES)

DECLARE_DISPLAY_ITEM_TYPE(DEBUG_BORDER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(DEBUG_IMAGE_MAP, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(DEBUG_PLACEHOLDER, TYPE_RENDERS_NO_IMAGES)
DECLARE_DISPLAY_ITEM_TYPE(EVENT_TARGET_BORDER, TYPE_RENDERS_NO_IMAGES)
#endif
