﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/DataSourceFreeTrial.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Provides details about Malware Protection when it is enabled as a data
   * source.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionDataSourceFreeTrial">AWS
   * API Reference</a></p>
   */
  class MalwareProtectionDataSourceFreeTrial
  {
  public:
    AWS_GUARDDUTY_API MalwareProtectionDataSourceFreeTrial();
    AWS_GUARDDUTY_API MalwareProtectionDataSourceFreeTrial(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API MalwareProtectionDataSourceFreeTrial& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Describes whether Malware Protection for EC2 instances with findings is
     * enabled as a data source.</p>
     */
    inline const DataSourceFreeTrial& GetScanEc2InstanceWithFindings() const{ return m_scanEc2InstanceWithFindings; }

    /**
     * <p>Describes whether Malware Protection for EC2 instances with findings is
     * enabled as a data source.</p>
     */
    inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }

    /**
     * <p>Describes whether Malware Protection for EC2 instances with findings is
     * enabled as a data source.</p>
     */
    inline void SetScanEc2InstanceWithFindings(const DataSourceFreeTrial& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = value; }

    /**
     * <p>Describes whether Malware Protection for EC2 instances with findings is
     * enabled as a data source.</p>
     */
    inline void SetScanEc2InstanceWithFindings(DataSourceFreeTrial&& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = std::move(value); }

    /**
     * <p>Describes whether Malware Protection for EC2 instances with findings is
     * enabled as a data source.</p>
     */
    inline MalwareProtectionDataSourceFreeTrial& WithScanEc2InstanceWithFindings(const DataSourceFreeTrial& value) { SetScanEc2InstanceWithFindings(value); return *this;}

    /**
     * <p>Describes whether Malware Protection for EC2 instances with findings is
     * enabled as a data source.</p>
     */
    inline MalwareProtectionDataSourceFreeTrial& WithScanEc2InstanceWithFindings(DataSourceFreeTrial&& value) { SetScanEc2InstanceWithFindings(std::move(value)); return *this;}

  private:

    DataSourceFreeTrial m_scanEc2InstanceWithFindings;
    bool m_scanEc2InstanceWithFindingsHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
