// This file is needed because it is used by vscode and other tools that
// call `jest` directly.  However, unless you are doing anything special
// do not edit this file

const standard = require('@grafana/toolkit/src/config/jest.plugin.config');

// This process will use the same config that `yarn test` is using
const defaultConfig = standard.jestConfig();
module.exports = {
    ...defaultConfig,
    moduleNameMapper: {
        ...defaultConfig.moduleNameMapper,
        // workaround for:
        // @grafana/toolkit/src/config/react-inlinesvg.tsx:5
        // SyntaxError: Cannot use import statement outside a module
        'react-inlinesvg': undefined,
    },
    transformIgnorePatterns: [
        ...defaultConfig.transformIgnorePatterns,
        // required for d3-flame-graph (uses ES6 syntax)
        '<rootDir>/node_modules/(?!d3-flame-graph/)',
    ],
};
