/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.ParsingException;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class PKCS7 {
    public static final String HEADER = "-----BEGIN PKCS7-----";
    public static final String FOOTER = "-----END PKCS7-----";
    private ObjectIdentifier contentType;
    private BigInt version;
    private AlgorithmId[] digestAlgorithmIds;
    private ContentInfo contentInfo;
    private X509Certificate[] certificates;
    private SignerInfo[] signerInfos;

    public PKCS7(InputStream in) throws ParsingException, IOException {
        DataInputStream dis = new DataInputStream(in);
        int len = 0;
        byte[] newbuf = new byte[len];
        byte[] oldbuf = new byte[len];
        byte[] data = new byte[len];
        do {
            newbuf = new byte[dis.available()];
            dis.readFully(newbuf);
            data = new byte[len += dis.available()];
            System.arraycopy(oldbuf, 0, data, 0, oldbuf.length);
            System.arraycopy(newbuf, 0, data, oldbuf.length, newbuf.length);
            oldbuf = new byte[len];
            System.arraycopy(data, 0, oldbuf, 0, data.length);
        } while (dis.available() > 0);
        this.parse(new DerInputStream(data));
    }

    public PKCS7(DerInputStream derin) throws ParsingException {
        this.parse(derin);
    }

    public PKCS7(byte[] bytes) throws ParsingException {
        DerInputStream derin = new DerInputStream(bytes);
        this.parse(derin);
    }

    public PKCS7(String input) throws ParsingException, IOException {
        StringBuilder sb = new StringBuilder();
        try (StringReader sr = new StringReader(input.trim());
             BufferedReader in = new BufferedReader(sr);){
            String line;
            String header = null;
            while ((line = in.readLine()) != null) {
                if (!HEADER.equals(line)) continue;
                header = line;
                break;
            }
            if (header == null) {
                throw new ParsingException("Missing PKCS #7 header");
            }
            String footer = null;
            while ((line = in.readLine()) != null) {
                if (FOOTER.equals(line)) {
                    footer = line;
                    break;
                }
                sb.append(line);
            }
            if (footer == null) {
                throw new ParsingException("Missing PKCS #7 footer");
            }
        }
        byte[] bytes = Utils.base64decode(sb.toString());
        this.parse(new DerInputStream(bytes));
    }

    private void parse(DerInputStream derin) throws ParsingException {
        try {
            ContentInfo contentInfo = new ContentInfo(derin);
            this.contentType = contentInfo.contentType;
            if (!this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
                throw new ParsingException("content type " + this.contentType + " not supported.");
            }
            this.parseSignedData(contentInfo.getContent());
        }
        catch (IOException e) {
            ParsingException pe = new ParsingException("IOException: " + e.getMessage());
            pe.fillInStackTrace();
            throw pe;
        }
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, SignerInfo[] signerInfos) {
        this.version = new BigInt(1);
        this.digestAlgorithmIds = digestAlgorithmIds;
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.signerInfos = signerInfos;
    }

    public PKCS7(X509Certificate[] certs) {
        this(new AlgorithmId[0], new ContentInfo(new byte[0]), certs, new SignerInfo[0]);
    }

    private void parseSignedData(DerValue val) throws ParsingException, IOException {
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i = 0; i < len; ++i) {
                DerValue oid = digestAlgorithmIdVals[i];
                this.digestAlgorithmIds[i] = AlgorithmId.parse(oid);
            }
        }
        catch (IOException e) {
            ParsingException pe = new ParsingException("Error parsing digest AlgorithmId IDs: " + e.getMessage());
            pe.fillInStackTrace();
            throw pe;
        }
        this.contentInfo = new ContentInfo(dis);
        if ((byte)dis.peekByte() == -96) {
            DerValue[] certificateVals = dis.getSet(2, true);
            len = certificateVals.length;
            this.certificates = new X509Certificate[len];
            for (int i = 0; i < len; ++i) {
                try {
                    X509CertImpl cert = new X509CertImpl(certificateVals[i]);
                    this.certificates[i] = cert;
                    continue;
                }
                catch (CertificateException e) {
                    ParsingException pe = new ParsingException("CertificateException: " + e.getMessage());
                    pe.fillInStackTrace();
                    throw pe;
                }
            }
        }
        if ((byte)dis.peekByte() == -95) {
            dis.getSet(0, true);
        }
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (int i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in);
        }
    }

    public void encodeSignedData(OutputStream out) throws IOException {
        DerOutputStream derout = new DerOutputStream();
        this.encodeSignedData(derout, true);
        out.write(derout.toByteArray());
    }

    public void encodeSignedData(OutputStream out, boolean sort) throws IOException {
        DerOutputStream derout = new DerOutputStream();
        this.encodeSignedData(derout, sort);
        out.write(derout.toByteArray());
    }

    public void encodeSignedData(DerOutputStream out) throws IOException {
        this.encodeSignedData(out, true);
    }

    public void encodeSignedData(DerOutputStream out, boolean sort) throws IOException {
        DerOutputStream signedData = new DerOutputStream();
        signedData.putInteger(this.version);
        signedData.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(signedData);
        DerEncoder[] implCerts = new X509CertImpl[this.certificates.length];
        try {
            for (int i = 0; i < this.certificates.length; ++i) {
                implCerts[i] = (X509CertImpl)this.certificates[i];
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Certificates in PKCS7 must be of class org.mozilla.jss.netscape.security.X509CertImpl: " + e.getMessage(), e);
        }
        if (sort) {
            signedData.putOrderedSetOf((byte)-96, implCerts);
        } else {
            signedData.putSet((byte)-96, implCerts);
        }
        signedData.putOrderedSetOf((byte)49, this.signerInfos);
        DerValue signedDataSeq = new DerValue(48, signedData.toByteArray());
        ContentInfo block = new ContentInfo(ContentInfo.SIGNED_DATA_OID, signedDataSeq);
        block.encode(out);
    }

    public SignerInfo verify(SignerInfo info, byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        return info.verify(this, bytes);
    }

    public SignerInfo[] verify(byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        Vector<SignerInfo> intResult = new Vector<SignerInfo>();
        for (int i = 0; i < this.signerInfos.length; ++i) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i], bytes);
            if (signerInfo == null) continue;
            intResult.addElement(signerInfo);
        }
        if (intResult.size() != 0) {
            Object[] result = new SignerInfo[intResult.size()];
            intResult.copyInto(result);
            return result;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInt getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInt serial, X500Name name) {
        for (int i = 0; i < this.certificates.length; ++i) {
            X509Certificate cert = this.certificates[i];
            X500Name thisName = (X500Name)cert.getIssuerDN();
            BigInteger tmpSerial = cert.getSerialNumber();
            BigInt thisSerial = new BigInt(tmpSerial);
            if (!serial.equals(thisSerial) || !name.equals(thisName)) continue;
            return cert;
        }
        return null;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encodeSignedData(out);
        return out.toByteArray();
    }

    public String toPEMString() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println(HEADER);
        pw.print(Utils.base64encode(this.getBytes(), true));
        pw.println(FOOTER);
        return sw.toString();
    }

    public String toString() {
        int i;
        StringBuffer out = new StringBuffer("PKCS7 :: version: " + this.version + "\n");
        out.append("PKCS7 :: digest AlgorithmIds: \n");
        for (i = 0; i < this.digestAlgorithmIds.length; ++i) {
            out.append("\t" + this.digestAlgorithmIds[i] + "\n");
        }
        out.append(this.contentInfo + "\n");
        out.append("PKCS7 :: certificates: \n");
        for (i = 0; i < this.certificates.length; ++i) {
            out.append("\t" + i + ".   " + this.certificates[i] + "\n");
        }
        out.append("PKCS7 :: signer infos: \n");
        for (i = 0; i < this.signerInfos.length; ++i) {
            out.append("\t" + i + ".  " + this.signerInfos[i] + "\n");
        }
        return out.toString();
    }
}

