/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public abstract class BERConstruct
extends BERElement {
    private Vector<BERElement> m_elements = new Vector();

    public BERConstruct() {
    }

    public BERConstruct(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length;
        int[] component_length = new int[1];
        if (contents_length == -1) {
            BERElement element = null;
            component_length[0] = 0;
            element = BERConstruct.getElement(decoder, stream, component_length);
            if (element != null) {
                this.addElement(element);
            }
            while (element != null) {
            }
        } else {
            bytes_read[0] = bytes_read[0] + contents_length;
            for (contents_length = BERElement.readLengthOctets(stream, bytes_read); contents_length > 0; contents_length -= component_length[0]) {
                component_length[0] = 0;
                this.addElement(BERConstruct.getElement(decoder, stream, component_length));
            }
        }
    }

    public void addElement(BERElement element) {
        this.m_elements.addElement(element);
    }

    public int size() {
        return this.m_elements.size();
    }

    public BERElement elementAt(int index) {
        return this.m_elements.elementAt(index);
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        stream.write(this.getType());
        ByteArrayOutputStream contents_stream = new ByteArrayOutputStream();
        for (int i = 0; i < this.m_elements.size(); ++i) {
            BERElement e = this.elementAt(i);
            e.write(contents_stream);
        }
        byte[] contents_buffer = contents_stream.toByteArray();
        BERConstruct.sendDefiniteLength(stream, contents_buffer.length);
        stream.write(contents_buffer);
    }

    @Override
    public abstract int getType();

    @Override
    public abstract String toString();
}

