/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.IVParameterSpec;

public class EncryptionAlgorithm
extends Algorithm {
    private int blockSize;
    private Alg alg;
    private Mode mode;
    private Padding padding;
    private int keyStrength;
    private static Hashtable<OBJECT_IDENTIFIER, EncryptionAlgorithm> oidMap = new Hashtable();
    private static Hashtable<String, EncryptionAlgorithm> nameMap = new Hashtable();
    private static Vector<EncryptionAlgorithm> algList = new Vector();
    private static Class<?>[] IVParameterSpecClasses = null;
    public static final EncryptionAlgorithm RC4;
    public static final EncryptionAlgorithm DES_ECB;
    public static final EncryptionAlgorithm DES_CBC;
    public static final EncryptionAlgorithm DES_CBC_PAD;
    public static final EncryptionAlgorithm DES3_ECB;
    public static final EncryptionAlgorithm DES3_CBC;
    public static final EncryptionAlgorithm DES3_CBC_PAD;
    public static final EncryptionAlgorithm RC2_CBC;
    public static final EncryptionAlgorithm RC2_CBC_PAD;
    public static final OBJECT_IDENTIFIER AES_ROOT_OID;
    public static final EncryptionAlgorithm AES_128_ECB;
    public static final EncryptionAlgorithm AES_128_CBC;
    public static final EncryptionAlgorithm AES_128_CBC_PAD;
    public static final EncryptionAlgorithm AES_192_ECB;
    public static final EncryptionAlgorithm AES_192_CBC;
    public static final EncryptionAlgorithm AES_192_CBC_PAD;
    public static final EncryptionAlgorithm AES_256_ECB;
    public static final EncryptionAlgorithm AES_256_CBC;
    public static final EncryptionAlgorithm AES_CBC_PAD;
    public static final EncryptionAlgorithm AES_256_CBC_PAD;
    public static final EncryptionAlgorithm AES_128_KEY_WRAP_KWP;
    public static final EncryptionAlgorithm AES_192_KEY_WRAP_KWP;
    public static final EncryptionAlgorithm AES_256_KEY_WRAP_KWP;

    private static String makeName(Alg alg, Mode mode, Padding padding) {
        StringBuffer buf = new StringBuffer();
        buf.append(alg.toString());
        buf.append('/');
        buf.append(mode.toString());
        buf.append('/');
        buf.append(padding.toString());
        return buf.toString();
    }

    protected EncryptionAlgorithm(int oidTag, Alg alg, Mode mode, Padding padding, Class<?> paramClass, int blockSize, OBJECT_IDENTIFIER oid, int keyStrength) {
        super(oidTag, EncryptionAlgorithm.makeName(alg, mode, padding), oid, paramClass);
        this.alg = alg;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = blockSize;
        if (oid != null) {
            oidMap.put(oid, this);
        }
        if (this.name != null) {
            nameMap.put(this.name.toLowerCase(), this);
        }
        this.keyStrength = keyStrength;
        algList.addElement(this);
    }

    protected EncryptionAlgorithm(int oidTag, Alg alg, Mode mode, Padding padding, Class<?>[] paramClasses, int blockSize, OBJECT_IDENTIFIER oid, int keyStrength) {
        super(oidTag, EncryptionAlgorithm.makeName(alg, mode, padding), oid, paramClasses);
        this.alg = alg;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = blockSize;
        if (oid != null) {
            oidMap.put(oid, this);
        }
        if (this.name != null) {
            nameMap.put(this.name.toLowerCase(), this);
        }
        this.keyStrength = keyStrength;
        algList.addElement(this);
    }

    protected EncryptionAlgorithm(int oidTag, Alg alg, Mode mode, Padding padding, Class<?> paramClass, int blockSize, OBJECT_IDENTIFIER oid, int keyStrength, String name) {
        super(oidTag, name, oid, paramClass);
        this.alg = alg;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = blockSize;
        if (oid != null) {
            oidMap.put(oid, this);
        }
        if (name != null) {
            nameMap.put(name.toLowerCase(), this);
        }
        this.keyStrength = keyStrength;
        algList.addElement(this);
    }

    protected EncryptionAlgorithm(int oidTag, Alg alg, Mode mode, Padding padding, Class<?>[] paramClasses, int blockSize, OBJECT_IDENTIFIER oid, int keyStrength, String name) {
        super(oidTag, name, oid, paramClasses);
        this.alg = alg;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = blockSize;
        if (oid != null) {
            oidMap.put(oid, this);
        }
        if (name != null) {
            nameMap.put(name.toLowerCase(), this);
        }
        this.keyStrength = keyStrength;
        algList.addElement(this);
    }

    public Alg getAlg() {
        return this.alg;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public int getKeyStrength() {
        return this.keyStrength;
    }

    public static EncryptionAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        EncryptionAlgorithm alg = oidMap.get(oid);
        if (alg == null) {
            throw new NoSuchAlgorithmException("OID: " + oid.toString());
        }
        return alg;
    }

    @Deprecated
    public static EncryptionAlgorithm fromString(String name) throws NoSuchAlgorithmException {
        EncryptionAlgorithm alg = nameMap.get(name.toLowerCase());
        if (alg == null) {
            throw new NoSuchAlgorithmException();
        }
        return alg;
    }

    public static EncryptionAlgorithm lookup(String algName, String modeName, String paddingName, int keyStrength) throws NoSuchAlgorithmException {
        int i;
        int len = algList.size();
        Alg alg = Alg.fromString(algName);
        Mode mode = Mode.fromString(modeName);
        Padding padding = paddingName == null || paddingName.equals("") ? Padding.NONE : Padding.fromString(paddingName);
        for (i = 0; i < len; ++i) {
            EncryptionAlgorithm cur = algList.elementAt(i);
            if (cur.alg == alg && cur.mode == mode && cur.padding == padding && (cur.keyStrength == 0 || cur.keyStrength == keyStrength)) break;
        }
        if (i == len) {
            throw new NoSuchAlgorithmException(algName + "/" + modeName + "/" + paddingName + " with key strength " + keyStrength + " not found");
        }
        return algList.elementAt(i);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isPadded() {
        return !Padding.NONE.equals(this.padding);
    }

    public Padding getPaddingType() {
        return this.padding;
    }

    public native int getIVLength();

    static {
        IVParameterSpecClasses = new Class[2];
        EncryptionAlgorithm.IVParameterSpecClasses[0] = IVParameterSpec.class;
        EncryptionAlgorithm.IVParameterSpecClasses[1] = IvParameterSpec.class;
        RC4 = new EncryptionAlgorithm(8, Alg.RC4, Mode.NONE, Padding.NONE, (Class)null, 1, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(4L), 0);
        DES_ECB = new EncryptionAlgorithm(9, Alg.DES, Mode.ECB, Padding.NONE, (Class)null, 8, OBJECT_IDENTIFIER.ALGORITHM.subBranch(6L), 56);
        DES_CBC = new EncryptionAlgorithm(10, Alg.DES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 8, OBJECT_IDENTIFIER.ALGORITHM.subBranch(7L), 56);
        DES_CBC_PAD = new EncryptionAlgorithm(11, Alg.DES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 8, null, 56);
        DES3_ECB = new EncryptionAlgorithm(12, Alg.DESede, Mode.ECB, Padding.NONE, (Class)null, 8, null, 168);
        DES3_CBC = new EncryptionAlgorithm(13, Alg.DESede, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 8, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(7L), 168);
        DES3_CBC_PAD = new EncryptionAlgorithm(14, Alg.DESede, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 8, null, 168);
        RC2_CBC = new EncryptionAlgorithm(30, Alg.RC2, Mode.CBC, Padding.NONE, RC2ParameterSpec.class, 8, null, 0);
        RC2_CBC_PAD = new EncryptionAlgorithm(36, Alg.RC2, Mode.CBC, Padding.PKCS5, RC2ParameterSpec.class, 8, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(2L), 0);
        AES_ROOT_OID = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 1L});
        AES_128_ECB = new EncryptionAlgorithm(59, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(1L), 128);
        AES_128_CBC = new EncryptionAlgorithm(60, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(2L), 128);
        AES_128_CBC_PAD = new EncryptionAlgorithm(60, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(2L), 128);
        AES_192_ECB = new EncryptionAlgorithm(61, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(21L), 192);
        AES_192_CBC = new EncryptionAlgorithm(62, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(22L), 192);
        AES_192_CBC_PAD = new EncryptionAlgorithm(62, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(22L), 192);
        AES_256_ECB = new EncryptionAlgorithm(63, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(41L), 256);
        AES_256_CBC = new EncryptionAlgorithm(64, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(42L), 256);
        AES_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 256);
        AES_256_CBC_PAD = new EncryptionAlgorithm(64, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(42L), 256);
        AES_128_KEY_WRAP_KWP = new EncryptionAlgorithm(81, Alg.AES, Mode.NONE, Padding.PKCS5, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(8L), 128, "AES/None/PKCS5Padding/Kwp/128");
        AES_192_KEY_WRAP_KWP = new EncryptionAlgorithm(82, Alg.AES, Mode.NONE, Padding.PKCS5, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(28L), 192, "AES/None/PKCSPadding/Kwp/192");
        AES_256_KEY_WRAP_KWP = new EncryptionAlgorithm(83, Alg.AES, Mode.NONE, Padding.PKCS5, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(48L), 256, "AES/None/PKCS5Padding/Kwp/256");
    }

    public static class Alg {
        private String name;
        private static Hashtable<String, Alg> nameHash = new Hashtable();
        public static final Alg RC4 = new Alg("RC4");
        public static final Alg DES = new Alg("DES");
        public static final Alg DESede = new Alg("DESede");
        public static final Alg AES = new Alg("AES");
        public static final Alg RC2 = new Alg("RC2");

        private Alg() {
        }

        private Alg(String name) {
            this.name = name;
            nameHash.put(name.toLowerCase(), this);
        }

        private static Alg fromString(String name) throws NoSuchAlgorithmException {
            Alg a = nameHash.get(name.toLowerCase());
            if (a == null) {
                throw new NoSuchAlgorithmException("Unrecognized algorithm \"" + name + "\"");
            }
            return a;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Mode {
        private String name;
        private static Hashtable<String, Mode> nameHash = new Hashtable();
        public static final Mode NONE = new Mode("NONE");
        public static final Mode ECB = new Mode("ECB");
        public static final Mode CBC = new Mode("CBC");

        private Mode() {
        }

        private Mode(String name) {
            this.name = name;
            nameHash.put(name.toLowerCase(), this);
        }

        public static Mode fromString(String name) throws NoSuchAlgorithmException {
            Mode m = nameHash.get(name.toLowerCase());
            if (m == null) {
                throw new NoSuchAlgorithmException("Unrecognized mode \"" + name + "\"");
            }
            return m;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Padding {
        private String name;
        private static Hashtable<String, Padding> nameHash = new Hashtable();
        public static final Padding NONE = new Padding("NoPadding");
        public static final Padding PKCS5 = new Padding("PKCS5Padding");

        private Padding() {
        }

        private Padding(String name) {
            this.name = name;
            nameHash.put(name.toLowerCase(), this);
        }

        public String toString() {
            return this.name;
        }

        public static Padding fromString(String name) throws NoSuchAlgorithmException {
            Padding p = nameHash.get(name.toLowerCase());
            if (p == null) {
                throw new NoSuchAlgorithmException("Unrecognized Padding type \"" + name + "\"");
            }
            return p;
        }
    }
}

