/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// RepositoriesContainerPushAPIService RepositoriesContainerPushAPI service
type RepositoriesContainerPushAPIService service

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushAddRoleExecute(r)
}

/*
RepositoriesContainerContainerPushAddRole Method for RepositoriesContainerContainerPushAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushAddRole(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushAddRoleExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) LatestWithContent(latestWithContent string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Limit(limit int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Name(name string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) NameContains(nameContains string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) NameIcontains(nameIcontains string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) NameIn(nameIn []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) NameStartswith(nameStartswith string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Offset(offset int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Ordering(ordering []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) PulpIdIn(pulpIdIn []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Remote(remote string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) WithContent(withContent string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Fields(fields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) ExcludeFields(excludeFields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) Execute() (*PaginatedcontainerContainerPushRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushListExecute(r)
}

/*
RepositoriesContainerContainerPushList List container push repositorys

ViewSet for a container push repository.

POST and DELETE are disallowed because a push repository is tightly coupled with a
ContainerDistribution which handles it automatically.
Created - during push operation, removed - with ContainerDistribution removal.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushList(ctx context.Context) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedcontainerContainerPushRepositoryResponseList
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushListExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRequest) (*PaginatedcontainerContainerPushRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedcontainerContainerPushRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/container/container-push/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest) Fields(fields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest) ExcludeFields(excludeFields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushListRolesExecute(r)
}

/*
RepositoriesContainerContainerPushListRoles Method for RepositoriesContainerContainerPushListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushListRoles(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushListRolesExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest) Fields(fields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest) ExcludeFields(excludeFields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushMyPermissionsExecute(r)
}

/*
RepositoriesContainerContainerPushMyPermissions Method for RepositoriesContainerContainerPushMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushMyPermissions(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushMyPermissionsExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	patchedcontainerContainerPushRepository *PatchedcontainerContainerPushRepository
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest) PatchedcontainerContainerPushRepository(patchedcontainerContainerPushRepository PatchedcontainerContainerPushRepository) RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest {
	r.patchedcontainerContainerPushRepository = &patchedcontainerContainerPushRepository
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushPartialUpdateExecute(r)
}

/*
RepositoriesContainerContainerPushPartialUpdate Update a container push repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushPartialUpdate(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushPartialUpdateExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedcontainerContainerPushRepository == nil {
		return localVarReturnValue, nil, reportError("patchedcontainerContainerPushRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedcontainerContainerPushRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest) Fields(fields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest) ExcludeFields(excludeFields []string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest) Execute() (*ContainerContainerPushRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushReadExecute(r)
}

/*
RepositoriesContainerContainerPushRead Inspect a container push repository

ViewSet for a container push repository.

POST and DELETE are disallowed because a push repository is tightly coupled with a
ContainerDistribution which handles it automatically.
Created - during push operation, removed - with ContainerDistribution removal.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRead(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return ContainerContainerPushRepositoryResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushReadExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushReadRequest) (*ContainerContainerPushRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerContainerPushRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	removeImage *RemoveImage
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest) RemoveImage(removeImage RemoveImage) RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest {
	r.removeImage = &removeImage
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushRemoveImageExecute(r)
}

/*
RepositoriesContainerContainerPushRemoveImage Delete an image from a repository

Trigger an asynchronous task to remove a manifest and all its associated data by a digest

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRemoveImage(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRemoveImageExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveImageRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushRemoveImage")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}remove_image/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.removeImage == nil {
		return localVarReturnValue, nil, reportError("removeImage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.removeImage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushRemoveRoleExecute(r)
}

/*
RepositoriesContainerContainerPushRemoveRole Method for RepositoriesContainerContainerPushRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRemoveRole(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRemoveRoleExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	removeSignatures *RemoveSignatures
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest) RemoveSignatures(removeSignatures RemoveSignatures) RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest {
	r.removeSignatures = &removeSignatures
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest) Execute() (*RemoveSignaturesResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushRemoveSignaturesExecute(r)
}

/*
RepositoriesContainerContainerPushRemoveSignatures Method for RepositoriesContainerContainerPushRemoveSignatures

Create a task which deletes signatures by the passed key_id.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRemoveSignatures(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return RemoveSignaturesResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushRemoveSignaturesExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushRemoveSignaturesRequest) (*RemoveSignaturesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RemoveSignaturesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushRemoveSignatures")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}remove_signatures/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.removeSignatures == nil {
		return localVarReturnValue, nil, reportError("removeSignatures is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.removeSignatures
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	repositorySign *RepositorySign
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest) RepositorySign(repositorySign RepositorySign) RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest {
	r.repositorySign = &repositorySign
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushSignExecute(r)
}

/*
RepositoriesContainerContainerPushSign Sign images in the repo

Trigger an asynchronous task to sign content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushSign(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushSignExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushSignRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushSign")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}sign/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositorySign == nil {
		return localVarReturnValue, nil, reportError("repositorySign is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositorySign
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	tagImage *TagImage
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest) TagImage(tagImage TagImage) RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest {
	r.tagImage = &tagImage
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushTagExecute(r)
}

/*
RepositoriesContainerContainerPushTag Create a Tag

Trigger an asynchronous task to tag an image in the repository

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushTag(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushTagExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushTagRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushTag")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}tag/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.tagImage == nil {
		return localVarReturnValue, nil, reportError("tagImage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.tagImage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	unTagImage *UnTagImage
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest) UnTagImage(unTagImage UnTagImage) RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest {
	r.unTagImage = &unTagImage
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushUntagExecute(r)
}

/*
RepositoriesContainerContainerPushUntag Delete a tag

Trigger an asynchronous task to untag an image in the repository

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushUntag(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushUntagExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushUntagRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushUntag")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}untag/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.unTagImage == nil {
		return localVarReturnValue, nil, reportError("unTagImage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.unTagImage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerPushAPIService
	containerContainerPushRepositoryHref string
	containerContainerPushRepository *ContainerContainerPushRepository
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest) ContainerContainerPushRepository(containerContainerPushRepository ContainerContainerPushRepository) RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest {
	r.containerContainerPushRepository = &containerContainerPushRepository
	return r
}

func (r RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPushUpdateExecute(r)
}

/*
RepositoriesContainerContainerPushUpdate Update a container push repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerPushRepositoryHref
 @return RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest
*/
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushUpdate(ctx context.Context, containerContainerPushRepositoryHref string) RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest {
	return RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerPushRepositoryHref: containerContainerPushRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerPushAPIService) RepositoriesContainerContainerPushUpdateExecute(r RepositoriesContainerPushAPIRepositoriesContainerContainerPushUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerPushAPIService.RepositoriesContainerContainerPushUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_push_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_push_repository_href"+"}", parameterValueToString(r.containerContainerPushRepositoryHref, "containerContainerPushRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerContainerPushRepository == nil {
		return localVarReturnValue, nil, reportError("containerContainerPushRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerContainerPushRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
