/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the DebReleaseFileResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebReleaseFileResponse{}

// DebReleaseFileResponse A serializer for ReleaseFile.
type DebReleaseFileResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// A dict mapping relative paths inside the Content to the correspondingArtifact URLs. E.g.: {'relative/path': '/artifacts/1/'
	Artifacts map[string]interface{} `json:"artifacts"`
	// Codename of the release, i.e. \"buster\".
	Codename *string `json:"codename,omitempty"`
	// Suite of the release, i.e. \"stable\".
	Suite *string `json:"suite,omitempty"`
	// Distribution of the release, i.e. \"stable/updates\".
	Distribution string `json:"distribution"`
	// Path of file relative to url.
	RelativePath *string `json:"relative_path,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _DebReleaseFileResponse DebReleaseFileResponse

// NewDebReleaseFileResponse instantiates a new DebReleaseFileResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebReleaseFileResponse(artifacts map[string]interface{}, distribution string) *DebReleaseFileResponse {
	this := DebReleaseFileResponse{}
	this.Artifacts = artifacts
	this.Distribution = distribution
	return &this
}

// NewDebReleaseFileResponseWithDefaults instantiates a new DebReleaseFileResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebReleaseFileResponseWithDefaults() *DebReleaseFileResponse {
	this := DebReleaseFileResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *DebReleaseFileResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *DebReleaseFileResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *DebReleaseFileResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *DebReleaseFileResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *DebReleaseFileResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *DebReleaseFileResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetArtifacts returns the Artifacts field value
func (o *DebReleaseFileResponse) GetArtifacts() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.Artifacts
}

// GetArtifactsOk returns a tuple with the Artifacts field value
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetArtifactsOk() (map[string]interface{}, bool) {
	if o == nil {
		return map[string]interface{}{}, false
	}
	return o.Artifacts, true
}

// SetArtifacts sets field value
func (o *DebReleaseFileResponse) SetArtifacts(v map[string]interface{}) {
	o.Artifacts = v
}

// GetCodename returns the Codename field value if set, zero value otherwise.
func (o *DebReleaseFileResponse) GetCodename() string {
	if o == nil || IsNil(o.Codename) {
		var ret string
		return ret
	}
	return *o.Codename
}

// GetCodenameOk returns a tuple with the Codename field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetCodenameOk() (*string, bool) {
	if o == nil || IsNil(o.Codename) {
		return nil, false
	}
	return o.Codename, true
}

// HasCodename returns a boolean if a field has been set.
func (o *DebReleaseFileResponse) HasCodename() bool {
	if o != nil && !IsNil(o.Codename) {
		return true
	}

	return false
}

// SetCodename gets a reference to the given string and assigns it to the Codename field.
func (o *DebReleaseFileResponse) SetCodename(v string) {
	o.Codename = &v
}

// GetSuite returns the Suite field value if set, zero value otherwise.
func (o *DebReleaseFileResponse) GetSuite() string {
	if o == nil || IsNil(o.Suite) {
		var ret string
		return ret
	}
	return *o.Suite
}

// GetSuiteOk returns a tuple with the Suite field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetSuiteOk() (*string, bool) {
	if o == nil || IsNil(o.Suite) {
		return nil, false
	}
	return o.Suite, true
}

// HasSuite returns a boolean if a field has been set.
func (o *DebReleaseFileResponse) HasSuite() bool {
	if o != nil && !IsNil(o.Suite) {
		return true
	}

	return false
}

// SetSuite gets a reference to the given string and assigns it to the Suite field.
func (o *DebReleaseFileResponse) SetSuite(v string) {
	o.Suite = &v
}

// GetDistribution returns the Distribution field value
func (o *DebReleaseFileResponse) GetDistribution() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Distribution
}

// GetDistributionOk returns a tuple with the Distribution field value
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetDistributionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Distribution, true
}

// SetDistribution sets field value
func (o *DebReleaseFileResponse) SetDistribution(v string) {
	o.Distribution = v
}

// GetRelativePath returns the RelativePath field value if set, zero value otherwise.
func (o *DebReleaseFileResponse) GetRelativePath() string {
	if o == nil || IsNil(o.RelativePath) {
		var ret string
		return ret
	}
	return *o.RelativePath
}

// GetRelativePathOk returns a tuple with the RelativePath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseFileResponse) GetRelativePathOk() (*string, bool) {
	if o == nil || IsNil(o.RelativePath) {
		return nil, false
	}
	return o.RelativePath, true
}

// HasRelativePath returns a boolean if a field has been set.
func (o *DebReleaseFileResponse) HasRelativePath() bool {
	if o != nil && !IsNil(o.RelativePath) {
		return true
	}

	return false
}

// SetRelativePath gets a reference to the given string and assigns it to the RelativePath field.
func (o *DebReleaseFileResponse) SetRelativePath(v string) {
	o.RelativePath = &v
}

func (o DebReleaseFileResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebReleaseFileResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["artifacts"] = o.Artifacts
	if !IsNil(o.Codename) {
		toSerialize["codename"] = o.Codename
	}
	if !IsNil(o.Suite) {
		toSerialize["suite"] = o.Suite
	}
	toSerialize["distribution"] = o.Distribution
	if !IsNil(o.RelativePath) {
		toSerialize["relative_path"] = o.RelativePath
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebReleaseFileResponse) UnmarshalJSON(bytes []byte) (err error) {
	varDebReleaseFileResponse := _DebReleaseFileResponse{}

	if err = json.Unmarshal(bytes, &varDebReleaseFileResponse); err == nil {
		*o = DebReleaseFileResponse(varDebReleaseFileResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "artifacts")
		delete(additionalProperties, "codename")
		delete(additionalProperties, "suite")
		delete(additionalProperties, "distribution")
		delete(additionalProperties, "relative_path")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebReleaseFileResponse struct {
	value *DebReleaseFileResponse
	isSet bool
}

func (v NullableDebReleaseFileResponse) Get() *DebReleaseFileResponse {
	return v.value
}

func (v *NullableDebReleaseFileResponse) Set(val *DebReleaseFileResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDebReleaseFileResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDebReleaseFileResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebReleaseFileResponse(val *DebReleaseFileResponse) *NullableDebReleaseFileResponse {
	return &NullableDebReleaseFileResponse{value: val, isSet: true}
}

func (v NullableDebReleaseFileResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebReleaseFileResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


