/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

class WagonExcluder
implements DependencySelector {
    private final boolean coreArtifact;

    WagonExcluder() {
        this(false);
    }

    private WagonExcluder(boolean coreArtifact) {
        this.coreArtifact = coreArtifact;
    }

    public boolean selectDependency(Dependency dependency) {
        return !this.coreArtifact || !this.isWagonProvider(dependency.getArtifact());
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.coreArtifact || !this.isLegacyCoreArtifact(context.getDependency().getArtifact())) {
            return this;
        }
        return new WagonExcluder(true);
    }

    private boolean isLegacyCoreArtifact(Artifact artifact) {
        String version = artifact.getVersion();
        return version != null && version.startsWith("2.") && artifact.getArtifactId().startsWith("maven-") && artifact.getGroupId().equals("org.apache.maven");
    }

    private boolean isWagonProvider(Artifact artifact) {
        if ("org.apache.maven.wagon".equals(artifact.getGroupId())) {
            return artifact.getArtifactId().startsWith("wagon-");
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        WagonExcluder that = (WagonExcluder)obj;
        return this.coreArtifact == that.coreArtifact;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + (this.coreArtifact ? 1 : 0);
        return hash;
    }
}

