// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TUFV001Schema TUF v0.0.1 Schema
//
// # Schema for TUF metadata entries
//
// swagger:model tufV001Schema
type TUFV001Schema struct {

	// metadata
	// Required: true
	Metadata *TUFV001SchemaMetadata `json:"metadata"`

	// root
	// Required: true
	Root *TUFV001SchemaRoot `json:"root"`

	// TUF specification version
	// Read Only: true
	SpecVersion string `json:"spec_version,omitempty"`
}

// Validate validates this tuf v001 schema
func (m *TUFV001Schema) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMetadata(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRoot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TUFV001Schema) validateMetadata(formats strfmt.Registry) error {

	if err := validate.Required("metadata", "body", m.Metadata); err != nil {
		return err
	}

	if m.Metadata != nil {
		if err := m.Metadata.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("metadata")
			}
			return err
		}
	}

	return nil
}

func (m *TUFV001Schema) validateRoot(formats strfmt.Registry) error {

	if err := validate.Required("root", "body", m.Root); err != nil {
		return err
	}

	if m.Root != nil {
		if err := m.Root.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("root")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("root")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this tuf v001 schema based on the context it is used
func (m *TUFV001Schema) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRoot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpecVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TUFV001Schema) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if m.Metadata != nil {
		if err := m.Metadata.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("metadata")
			}
			return err
		}
	}

	return nil
}

func (m *TUFV001Schema) contextValidateRoot(ctx context.Context, formats strfmt.Registry) error {

	if m.Root != nil {
		if err := m.Root.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("root")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("root")
			}
			return err
		}
	}

	return nil
}

func (m *TUFV001Schema) contextValidateSpecVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "spec_version", "body", string(m.SpecVersion)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TUFV001Schema) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TUFV001Schema) UnmarshalBinary(b []byte) error {
	var res TUFV001Schema
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TUFV001SchemaMetadata TUF metadata
//
// swagger:model TUFV001SchemaMetadata
type TUFV001SchemaMetadata struct {

	// Specifies the metadata inline within the document
	// Required: true
	Content interface{} `json:"content"`
}

// Validate validates this TUF v001 schema metadata
func (m *TUFV001SchemaMetadata) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TUFV001SchemaMetadata) validateContent(formats strfmt.Registry) error {

	if m.Content == nil {
		return errors.Required("metadata"+"."+"content", "body", nil)
	}

	return nil
}

// ContextValidate validates this TUF v001 schema metadata based on context it is used
func (m *TUFV001SchemaMetadata) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TUFV001SchemaMetadata) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TUFV001SchemaMetadata) UnmarshalBinary(b []byte) error {
	var res TUFV001SchemaMetadata
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// TUFV001SchemaRoot root metadata containing about the public keys used to sign the manifest
//
// swagger:model TUFV001SchemaRoot
type TUFV001SchemaRoot struct {

	// Specifies the metadata inline within the document
	// Required: true
	Content interface{} `json:"content"`
}

// Validate validates this TUF v001 schema root
func (m *TUFV001SchemaRoot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TUFV001SchemaRoot) validateContent(formats strfmt.Registry) error {

	if m.Content == nil {
		return errors.Required("root"+"."+"content", "body", nil)
	}

	return nil
}

// ContextValidate validates this TUF v001 schema root based on context it is used
func (m *TUFV001SchemaRoot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TUFV001SchemaRoot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TUFV001SchemaRoot) UnmarshalBinary(b []byte) error {
	var res TUFV001SchemaRoot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
