+++
title = "Calculations list"
weight = 300
+++

# List of calculations

This topic lists and defines calculations used in Grafana.

Among other places, these calculations are used in the Transform tab and the bar gauge, gauge, and stat visualizations.

| Calculation   | Description   |
|:---|:---|
| All nulls | true when all values are null|
| All zeros | true when all values are 0 |
| Change count | number of times the field's value changes |
| Count | number of values in a field|
| Delta | cumulative change in value |
| Difference | difference between first and last value of a field|
| Difference percent | percentage change between first and last value of a field |
| Distinct count | number of unique values in a field |
| First (not null) | first, not null value in a field|
| Max | maximum value of a field |
| Mean | mean value of all values in a field |
| Min | minimum value of a field|
| Min (above zero) | minimum, positive value of a field|
| Range | difference between maximum and minimum values of a field|
| Step | minimal interval between values of a field |
| Total | sum of all values in a field |
