import React from 'react';
import PropTypes from 'prop-types';

const UilFileTimesAlt = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M14,12H8a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm5.41,7,1.3-1.29a1,1,0,0,0-1.42-1.42L18,17.59l-1.29-1.3a1,1,0,0,0-1.42,1.42L16.59,19l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L18,20.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM12,20H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v3a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0A1.1,1.1,0,0,0,12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h6a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM8,8a1,1,0,0,0,0,2H9A1,1,0,0,0,9,8Zm4,8H8a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Z'
  }));
};

UilFileTimesAlt.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilFileTimesAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilFileTimesAlt;