![React Table Header](https://github.com/tannerlinsley/react-table/raw/master/media/header.png)

<img src='https://github.com/tannerlinsley/react-table/raw/master/media/logo.png' width='300'/>

Hooks for building **lightweight, fast and extendable datagrids** for React

<a href="https://twitter.com/intent/tweet?button_hashtag=TanStack" target="\_parent">
  <img alt="#TanStack" src="https://img.shields.io/twitter/url?color=%2308a0e9&label=%23TanStack&style=social&url=https%3A%2F%2Ftwitter.com%2Fintent%2Ftweet%3Fbutton_hashtag%3DTanStack">
</a><a href="https://github.com/tannerlinsley/react-table/actions?table=workflow%3A%22react-table+tests%22">
<img src="https://github.com/tannerlinsley/react-table/workflows/react-table%20tests/badge.svg" />
</a><a href="https://npmjs.com/package/react-table" target="\_parent">
  <img alt="" src="https://img.shields.io/npm/dm/react-table.svg" />
</a><a href="https://bundlephobia.com/result?p=react-table@latest" target="\_parent">
  <img alt="" src="https://badgen.net/bundlephobia/minzip/react-table@latest" />
</a><a href="https://spectrum.chat/react-table">
  <img alt="Join the community on Spectrum" src="https://withspectrum.github.io/badge/badge.svg" />
</a><a href="https://github.com/tannerlinsley/react-table" target="\_parent">
  <img alt="" src="https://img.shields.io/github/stars/tannerlinsley/react-table.svg?style=social&label=Star" />
</a><a href="https://twitter.com/tannerlinsley" target="\_parent">
  <img alt="" src="https://img.shields.io/twitter/follow/tannerlinsley.svg?style=social&label=Follow" />
</a>

Enjoy this library? Try them all! [React Query](https://github.com/tannerlinsley/react-query), [React Form](https://github.com/tannerlinsley/react-form), [React Charts](https://github.com/tannerlinsley/react-charts)

### [Become a Sponsor](https://github.com/sponsors/tannerlinsley/)

## Features

- Lightweight (5kb - 14kb+ depending on features used and tree-shaking)
- Headless (100% customizable, Bring-your-own-UI)
- Auto out of the box, fully controllable API
- Sorting (Multi and Stable)
- Filters
- Pivoting & Aggregation
- Row Selection
- Row Expansion
- Column Ordering
- Animatable
- Virtualizable
- Resizable
- Server-side/controlled data/state
- Extensible via hook-based plugin system

## Documentation

- [Installation](./docs/installation.md) - Walk through how to install React Table
- [Concepts](./docs/concepts.md) - Read how React Table works and how you can use it better
- [Examples](./docs/examples.md) - Experience and learn from some examples and guides of how to use React Table and implement common patterns
- [API](./docs/api/README.md) - Get to know React Table's API
- [FAQ](./docs/faq.md) - Learn how to use React Table for specific challenges and tasks
- [Previous Versions](#previous-versions)
- [Contributing](./CONTRIBUTING.md) - Become familiar with how to contribute back to React Table
- [Code of Conduct](./CODE_OF_CONDUCT.md) - Be a good React Table citizen by following these repository rules

## Sponsors

This library is being built and maintained by me, @tannerlinsley and I am always in need of more support to keep this project afloat. If you would like to get additional support, add your logo or name on this README, or simply just contribute to my open source Sponsorship goal, [visit my Github Sponsors page!](https://github.com/sponsors/tannerlinsley/)

<table>
  <tbody>
    <tr>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          <img width='150' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/diamond.png">
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          Become a Sponsor!
        </a>
      </td>
    </tr>
  </tbody>
</table>

<table>
  <tbody>
    <tr>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley/" target="_blank">
          <img width='150' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/platinum.png">
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="https://tryretool.com/?utm_source=sponsor&utm_campaign=react_table" target="_blank">
          <img width='225' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/sponsor-retool.png">
        </a>
      </td>
      <td align="center" valign="middle">
       <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          Become a Sponsor!
        </a>
      </td>
    </tr>
  </tbody>
</table>

<table>
  <tbody>
    <tr>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley/" target="_blank">
          <img width='150' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/gold.png">
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="https://nozzle.io" target="_blank">
          <img width='225' src="https://nozzle.io/img/logo-blue.png">
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          Become a Sponsor!
        </a>
      </td>
    </tr>
  </tbody>
</table>

<table>
  <tbody>
    <tr>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley/" target="_blank">
          <img width='150' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/silver.png">
        </a>
      </td>
       <td align="center" valign="middle">
        <a href="https://tripwire.com" target="_blank">
          <img width='225' src="https://www.tripwire.com/-/media/tripwiredotcom/icons/tripwire-logo-footer.svg">
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          Become a Sponsor!
        </a>
      </td>
    </tr>
  </tbody>
</table>

<table>
  <tbody>
    <tr>
      <td valign="top">
        <a href="https://github.com/sponsors/tannerlinsley/">
          <img width='150' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/supporters.png" />
        </a>
      </td>
      <td>
        <ul>
        <li>Jon Eickmeier</li>
          <li><a href="https://github.com/rhefner">Richard Hefner (@rhefner)</a></li>
          <li><a href="https://gitHub.com/snorkypie"> Steeve Lennmark (@snorkypie)</a></li>
        </ul>
      </td>
      <td>
        <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          Become a Supporter!
        </a>
      </td>
    </tr>
  </tbody>
</table>

<table>
  <tbody>
    <tr>
      <td valign="top">
        <a href="https://github.com/sponsors/tannerlinsley/">
          <img width='150' src="https://raw.githubusercontent.com/tannerlinsley/files/master/images/patreon/fans.png" />
        </a>
      </td>
      <td>
        <ul>
          <li>Hugo Meissner</li>
          <li>Benoit Leger-Derville</li>
          <li>Thomas Funk</li>
          <li>David Pickut</li>
          <li>Jordan Soltman</li>
          <li>Robert Tajnšek</li>
          <li>Eric Lanehart (@pushred)</li>
          <li>Anish P Patel (@anishpatelyaadada)</li>
          <li>Alin Porumb (@alinporumb)</li>
          <li>Janus Reith (@janus-reith)</li>
          <li>Timo Mämecke (@timomeh)</li>
          <li>Tyler Reiff (@reiff12)</li>
        </ul>
      </td>
      <td>
        <a href="https://github.com/sponsors/tannerlinsley" target="_blank">
          Become a Fan!
        </a>
      </td>
    </tr>
  </tbody>
</table>

### [Become a Sponsor](https://github.com/sponsors/tannerlinsley/)

## Previous Versions

### Version 6

v6 is a great library and while it is still available to install and use, I am no longer offering any long-term support for it. If you intend to keep using v6, I recommend maintaining your own fork of the library and keeping it up to date for your version of React.

#### Where are the docs for the older v6 version?

Please [visit the v6 branch](https://github.com/tannerlinsley/react-table/tree/v6)

#### I want to migrate from v6 to v7. How do I do that?

The differences between the 2 versions are incredibly massive. Unfortunately, I cannot write a one-to-one upgrade guide for any of v6's API, simply because much of it is irrelevant with v7's headless approach. The best approach for migrating to v7 is to learn its API by reading the documentation and then following some of the examples to begin building your own table component.

In case you would need to have both v6 and v7 in one app during the migration process (large codebase, complex use cases), you can either (1) fork and maintain your own local version of React Table v6 or (2) install the [`react-table-6` alias package](https://www.npmjs.com/package/react-table-6) for use alongside the `react-table` package.
