"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var initialize_1 = require("./initialize");
var tests_1 = require("./utils/tests");
describe('agent', function () {
    it("can be started paused and doesn't ingest events until unpaused", function () {
        var transport = new tests_1.MockTransport();
        var config = (0, tests_1.mockConfig)({
            paused: true,
            transports: [transport],
        });
        var agent = (0, initialize_1.initializeAgent)(config);
        agent.api.pushLog(['test']);
        expect(transport.items).toHaveLength(0);
        agent.unpause();
        agent.api.pushLog(['test2']);
        expect(transport.items).toHaveLength(1);
        var item = transport.items[0];
        expect(item.payload.message).toEqual('test2');
    });
    it('can be started unpaused, then paused and unpaused again', function () {
        var _a, _b;
        var transport = new tests_1.MockTransport();
        var config = (0, tests_1.mockConfig)({
            transports: [transport],
        });
        var agent = (0, initialize_1.initializeAgent)(config);
        agent.api.pushLog(['test1']);
        expect(transport.items).toHaveLength(1);
        agent.pause();
        agent.api.pushLog(['test2']);
        expect(transport.items).toHaveLength(1);
        agent.unpause();
        agent.api.pushLog(['test3']);
        var items = transport.items;
        expect((_a = items[0]) === null || _a === void 0 ? void 0 : _a.payload.message).toEqual('test1');
        expect((_b = items[1]) === null || _b === void 0 ? void 0 : _b.payload.message).toEqual('test3');
    });
});
//# sourceMappingURL=agent.test.js.map