"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeMeasurementsAPI = void 0;
var transports_1 = require("../../transports");
function initializeMeasurementsAPI(transports, metas, tracesApi) {
    var pushMeasurement = function (payload) {
        try {
            var item = {
                type: transports_1.TransportItemType.MEASUREMENT,
                payload: __assign(__assign({}, payload), { trace: tracesApi.getTraceContext() }),
                meta: metas.value,
            };
            transports.execute(item);
        }
        catch (err) {
            // TODO: Add proper logging when debug is enabled
        }
    };
    return {
        pushMeasurement: pushMeasurement,
    };
}
exports.initializeMeasurementsAPI = initializeMeasurementsAPI;
//# sourceMappingURL=initialize.js.map