"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mockStacktraceParser = exports.mockConfig = exports.MockTransport = void 0;
var MockTransport = /** @class */ (function () {
    function MockTransport(ignoreURLs) {
        if (ignoreURLs === void 0) { ignoreURLs = []; }
        this.ignoreURLs = ignoreURLs;
        this.items = [];
    }
    MockTransport.prototype.send = function (item) {
        this.items.push(item);
    };
    MockTransport.prototype.getIgnoreUrls = function () {
        return this.ignoreURLs;
    };
    return MockTransport;
}());
exports.MockTransport = MockTransport;
function mockConfig(overrides) {
    if (overrides === void 0) { overrides = {}; }
    return __assign({ globalObjectKey: 'grafanaAgent', instrumentations: [], preventGlobalExposure: true, transports: [], metas: [], app: {
            name: 'test',
            version: '1.0.0',
        }, parseStacktrace: exports.mockStacktraceParser, paused: false }, overrides);
}
exports.mockConfig = mockConfig;
var mockStacktraceParser = function (err) {
    var _a;
    var frames = [];
    var stack = (_a = err.stack) !== null && _a !== void 0 ? _a : err.stacktrace;
    if (stack) {
        stack.split('\n').forEach(function (line) {
            frames.push({
                filename: line,
                function: '',
            });
        });
    }
    return {
        frames: frames,
    };
};
exports.mockStacktraceParser = mockStacktraceParser;
//# sourceMappingURL=tests.js.map