var __extends =
  (this && this.__extends) ||
  (function () {
    var extendStatics = function (d, b) {
      extendStatics =
        Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array &&
          function (d, b) {
            d.__proto__ = b;
          }) ||
        function (d, b) {
          for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
        };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== 'function' && b !== null)
        throw new TypeError('Class extends value ' + String(b) + ' is not a constructor or null');
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : ((__.prototype = b.prototype), new __());
    };
  })();
import { BaseInstrumentation, VERSION } from '@grafana/agent-core';
import { getCLS, getFCP, getFID, getLCP, getTTFB } from 'web-vitals';
var map = {
  cls: getCLS,
  fcp: getFCP,
  fid: getFID,
  lcp: getLCP,
  ttfb: getTTFB,
};
var WebVitalsInstrumentation = /** @class */ (function (_super) {
  __extends(WebVitalsInstrumentation, _super);
  function WebVitalsInstrumentation() {
    var _this = (_super !== null && _super.apply(this, arguments)) || this;
    _this.name = '@grafana/agent-web:instrumentation-web-vitals';
    _this.version = VERSION;
    return _this;
  }
  WebVitalsInstrumentation.prototype.initialize = function () {
    var _this = this;
    Object.entries(map).forEach(function (_a) {
      var indicator = _a[0],
        executor = _a[1];
      executor(function (metric) {
        var _a;
        _this.agent.api.pushMeasurement({
          type: 'web-vitals',
          values: ((_a = {}), (_a[indicator] = metric.value), _a),
        });
      });
    });
  };
  return WebVitalsInstrumentation;
})(BaseInstrumentation);
export { WebVitalsInstrumentation };
//# sourceMappingURL=index.js.map
