"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginCreateTask = void 0;
const tslib_1 = require("tslib");
const inquirer_1 = require("inquirer");
const path_1 = tslib_1.__importDefault(require("path"));
const prompt_1 = require("../utils/prompt");
const create_1 = require("./plugin/create");
const task_1 = require("./task");
const pluginCreateRunner = ({ name }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const destPath = path_1.default.resolve(process.cwd(), (0, create_1.getPluginIdFromName)(name || ''));
    let pluginDetails;
    // 1. Verifying if git exists in user's env as templates are cloned from git templates
    yield (0, create_1.verifyGitExists)();
    // 2. Prompt plugin template
    const { type } = yield (0, create_1.promptPluginType)();
    // 3. Fetch plugin template from GitHub
    yield (0, create_1.fetchTemplate)({ type, dest: destPath });
    // 4. Prompt plugin details
    do {
        pluginDetails = yield (0, create_1.promptPluginDetails)(name);
        (0, create_1.formatPluginDetails)(pluginDetails);
    } while ((yield (0, inquirer_1.prompt)((0, prompt_1.promptConfirm)('confirm', 'Is that ok?'))).confirm === false);
    // 5. Update json files (package.json, src/plugin.json)
    yield (0, create_1.prepareJsonFiles)({ type: type, pluginDetails, pluginPath: destPath });
    // 6. Starter templates include `yarn.lock` files which will rarely (if ever) be in sync with `latest` dist-tag
    // so best to remove it after cloning.
    (0, create_1.removeLockFile)({ pluginPath: destPath });
    // 7. Remove cloned repository .git dir
    yield (0, create_1.removeGitFiles)(destPath);
    // 8. Promote Grafana Tutorials :)
    (0, create_1.printGrafanaTutorialsDetails)(type);
});
exports.pluginCreateTask = new task_1.Task('plugin:create task', pluginCreateRunner);
//# sourceMappingURL=plugin.create.js.map