# Contributing

When contributing to this repository, please first discuss the change you wish to make via
[discussion](https://github.com/kulshekhar/ts-jest/discussions) or [issue](https://github.com/kulshekhar/ts-jest/issues)
with the owners of this repository before making a change.

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Workflow and Pull Requests

The team will monitor pull requests. We'll do our best to provide updates and feedback throughout the process.

_Before_ submitting a pull request, please make sure the following is done…

1. Fork the repo and create your branch from `main`. A guide on how to fork a repository: https://help.github.com/articles/fork-a-repo/

   Open terminal (e.g. Terminal, iTerm, Git Bash or Git Shell) and type:

   ```sh-session
   $ git clone https://github.com/<your_username>/ts-jest
   $ cd ts-jest
   $ git checkout -b my_branch
   ```

   Note: Replace `<your_username>` with your GitHub username

2. `ts-jest` uses `npm` for running development scripts. If you haven't already done so, please [install npm](https://docs.npmjs.com/downloading-and-installing-node-js-and-npm).

3. Make sure you have a compatible version of `node` installed (As of April 14th 2021, `v14.x` is recommended).

   ```sh
   node -v
   ```

4. Run `npm ci`. `ts-jest` will automatically build source files into `dist/` after installing dependencies.

5. Ensure the test suite passes via `npm run test`.

### Testing

Code that is written needs to be tested to ensure that it achieves the desired behaviour. Tests either fall into a unit
test or an integration test.

##### Unit tests

The unit test files are associated with source files which are in `src/`. If the scope of your work only requires a unit test,
this is where you will write it in. Tests here usually don't require much if any setup.

##### Integration tests

There will be situations however where the work you have done cannot be tested alone using unit tests. In situations like this,
you should write an integration test for your code. The integration tests reside within the `e2e` directory.
Within this directory, there is a `__tests__` directory. This is where you will write the integration test itself.
The tests within this directory execute jest itself using `run-jest.ts` and assertions are usually made on one if not all
the output of the following `status`, `stdout` and `stderr`. The other subdirectories within the `e2e` directory are
where you will write the files that jest will run for your integration tests. Feel free to take a look at any of the tests
in the `__tests__` directory within `e2e` to have a better sense of how it is currently being done.

It is possible to run the integration test itself manually to inspect that the new behaviour is indeed correct.
Here is a small code snippet of how to do just that. This is useful when debugging a failing test.

```bash
$ cd e2e/test-utils
$ node ../../node_modules/jest/bin/jest.js # It is possible to use node --inspect or ndb
PASS  __tests__/test-utils.spec.ts
✓ stub (3ms)

Test Suites: 1 passed, 1 total
Tests:       1 passed, 1 total
Snapshots:   0 total
Time:        0.232 s, estimated 1 s
Ran all test suites.
```

### Additional Workflow for any changes made to website or docs

If you are making changes to the website or documentation, test the `website` folder and run the server to check if your
changes are being displayed accurately.

1. Locate to the `website` directory and install any website specific dependencies by typing in `npm ci`.
2. Following steps are to be followed for this purpose from the root directory.
   ```sh-session
   $ cd website       # Only needed if you are not already in the website directory
   $ npm ci
   $ npm run start
   ```
3. You can run a development server to check if the changes you made are being displayed accurately by running `npm run start` in the website directory.

The `ts-jest` website also offers documentation for older versions of `ts-jest`, which you can edit in `website/versioned_docs`.
After making changes to the current documentation in `docs`, please check if any older versions of the documentation
have a copy of the file where the change is also relevant and apply the changes to the `versioned_docs` as well.

## Bugs

### Where to Find Known Issues

We will be using GitHub Issues for our public bugs. We will keep a close eye on this and try to make it clear when we
have an internal fix in progress. Before filing a new issue, try to make sure your problem doesn't already exist.

### Reporting New Issues

The best way to get your bug fixed is to provide a reduced test case. Please provide a public repository with a runnable example.

## How to Get in Touch

[`#testing` on Reactiflux](https://discord.gg/j6FKKQQrW9) or [our GitHub discussion](https://github.com/kulshekhar/ts-jest/discussions)

## Code Conventions

- 2 spaces for indentation (no tabs).
- 120 character line length strongly preferred.
- Prefer `'` over `"`.
- ES6 syntax when possible.
- Use [TypeScript](https://www.typescriptlang.org/).
- No semicolon (`;`) required
- Trailing commas,

## License

By contributing to `ts-jest`, you agree that your contributions will be licensed under its MIT license.
