/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;

public class EDIPartyName
implements GeneralNameInterface {
    private static final long serialVersionUID = -8669257424766789063L;
    private static final byte TAG_ASSIGNER = 0;
    private static final byte TAG_PARTYNAME = 1;
    private String assigner = null;
    private String party = null;

    public EDIPartyName(String assignerName, String partyName) {
        this.assigner = assignerName;
        this.party = partyName;
    }

    public EDIPartyName(String partyName) {
        this.party = partyName;
    }

    public EDIPartyName(DerValue derValue) throws IOException {
        DerInputStream in = new DerInputStream(derValue.toByteArray());
        DerValue[] seq = in.getSequence(2);
        int len = seq.length;
        if (len < 1 || len > 2) {
            throw new IOException("Invalid encoding of EDIPartyName");
        }
        for (int i = 0; i < len; ++i) {
            DerValue opt = seq[i];
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                if (this.assigner != null) {
                    throw new IOException("Duplicate nameAssigner found in EDIPartyName");
                }
                opt = opt.data.getDerValue();
                this.assigner = opt.getAsString();
            }
            if (!opt.isContextSpecific((byte)1) || opt.isConstructed()) continue;
            if (this.party != null) {
                throw new IOException("Duplicate partyName found in EDIPartyName");
            }
            opt = opt.data.getDerValue();
            this.party = opt.getAsString();
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tagged = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (this.assigner != null) {
            DerOutputStream tmp2 = new DerOutputStream();
            tmp2.putPrintableString(this.assigner);
            tagged.write(DerValue.createTag((byte)-128, false, (byte)0), tmp2);
        }
        if (this.party == null) {
            tagged.close();
            tmp.close();
            throw new IOException("Cannot have null partyName");
        }
        tmp.putPrintableString(this.party);
        tagged.write(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        out.write((byte)48, tagged);
    }

    public String toString() {
        return "EDIPartyName: " + (String)(this.assigner == null ? "" : "  nameAssigner = " + this.assigner + ",") + "  partyName = " + this.party;
    }
}

