/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.jss.netscape.security.util.ASN1CharsetProvider;

public class ASN1CharStrConvMap {
    private Map<Byte, Charset> charsets = new HashMap<Byte, Charset>();
    private static ASN1CharStrConvMap defaultMap;

    public CharsetEncoder getEncoder(byte tag) {
        Charset charset = this.charsets.get(tag);
        if (charset == null) {
            return null;
        }
        return charset.newEncoder();
    }

    public CharsetDecoder getDecoder(byte tag) {
        Charset charset = this.charsets.get(tag);
        if (charset == null) {
            return null;
        }
        return charset.newDecoder();
    }

    public void addEntry(byte tag, Charset charset) {
        Charset currentCharset = this.charsets.get(tag);
        if (currentCharset != null) {
            if (currentCharset != charset) {
                throw new IllegalArgumentException("a DER tag to converter entry already exists.");
            }
            return;
        }
        this.charsets.put(tag, charset);
    }

    public Iterator<Byte> getTags() {
        return this.charsets.keySet().iterator();
    }

    public static ASN1CharStrConvMap getDefault() {
        return defaultMap;
    }

    public static void setDefault(ASN1CharStrConvMap newDefault) {
        if (newDefault == null) {
            throw new IllegalArgumentException("Cannot set a null default Der Tag Converter map");
        }
        defaultMap = newDefault;
    }

    static {
        ASN1CharsetProvider provider = new ASN1CharsetProvider();
        defaultMap = new ASN1CharStrConvMap();
        defaultMap.addEntry((byte)19, provider.charsetForName("ASN.1-Printable"));
        defaultMap.addEntry((byte)26, provider.charsetForName("ASN.1-Printable"));
        defaultMap.addEntry((byte)22, provider.charsetForName("ASN.1-IA5"));
        defaultMap.addEntry((byte)30, Charset.forName("UnicodeBig"));
        defaultMap.addEntry((byte)28, provider.charsetForName("ASN.1-Universal"));
        defaultMap.addEntry((byte)20, Charset.forName("ISO-8859-1"));
        defaultMap.addEntry((byte)12, Charset.forName("UTF-8"));
        defaultMap.addEntry((byte)27, Charset.forName("UTF-8"));
    }
}

