/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.EDIPartyName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.IPAddressName;
import org.mozilla.jss.netscape.security.x509.OIDName;
import org.mozilla.jss.netscape.security.x509.OtherName;
import org.mozilla.jss.netscape.security.x509.RFC822Name;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class GeneralName
implements GeneralNameInterface {
    private static final long serialVersionUID = 2244101501095555042L;
    private GeneralNameInterface name = null;

    public GeneralName(GeneralNameInterface name) {
        this.name = name;
    }

    public GeneralName(DerValue encName) throws IOException {
        short tag = (byte)(encName.tag & 0x1F);
        switch (tag) {
            case 1: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new RFC822Name(encName);
                    break;
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new DNSName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of DNS name");
            }
            case 6: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new URIName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)4);
                    this.name = new IPAddressName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 0: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)4);
                    this.name = new OtherName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of other name");
            }
            case 8: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)6);
                    this.name = new OIDName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)4);
                    byte[] content = encName.getOctetString();
                    this.name = new X500Name(content);
                    break;
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new EDIPartyName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of EDI name");
            }
            default: {
                throw new IOException("Unrecognized GeneralName tag, (" + tag + ")");
            }
        }
    }

    @Override
    public int getType() {
        return this.name.getType();
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.name.encode(tmp);
        int nameType = this.name.getType();
        boolean constructedForm = nameType == 0 || nameType == 3 || nameType == 4 || nameType == 5;
        if (nameType == 4) {
            out.write(DerValue.createTag((byte)-128, constructedForm, (byte)nameType), tmp);
        } else {
            out.writeImplicit(DerValue.createTag((byte)-128, constructedForm, (byte)nameType), tmp);
        }
    }

    @Override
    public boolean validSingle() {
        if (this == this.name) {
            return false;
        }
        return this.name.validSingle();
    }

    @Override
    public boolean validSubtree() {
        if (this == this.name) {
            return false;
        }
        return this.name.validSubtree();
    }

    public GeneralNameInterface unwrap() {
        if (this == this.name) {
            return null;
        }
        if (this.name instanceof GeneralName) {
            return ((GeneralName)this.name).unwrap();
        }
        return this.name;
    }
}

