/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.CertParseError;
import org.mozilla.jss.netscape.security.x509.LdapDNStrConverter;

public class RDN {
    private AVA[] assertion;

    public RDN(String rdnString) throws IOException {
        RDN rdn = LdapDNStrConverter.getDefault().parseRDN(rdnString);
        this.assertion = rdn.getAssertion();
    }

    public RDN(String rdnString, byte[] tags) throws IOException {
        RDN rdn = LdapDNStrConverter.getDefault().parseRDN(rdnString, tags);
        this.assertion = rdn.getAssertion();
    }

    public RDN(String rdnString, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        RDN rdn = ldapDNStrConverter.parseRDN(rdnString);
        this.assertion = rdn.getAssertion();
    }

    public RDN(DerValue set) throws IOException {
        int j;
        if (set.tag != 49) {
            throw new CertParseError("X500 RDN");
        }
        int j_max = 50;
        AVA[] avas = new AVA[j_max];
        for (j = 0; j < j_max; ++j) {
            avas[j] = new AVA(set.data);
            if (set.data.available() == 0) break;
        }
        if (j >= j_max - 1) {
            this.assertion = new AVA[j + 1];
        } else {
            this.assertion = new AVA[j + 1];
            for (int i = 0; i < j + 1; ++i) {
                this.assertion[i] = avas[i];
            }
        }
    }

    public RDN(DerInputStream in) throws IOException {
        DerValue[] avaset = in.getSet(1);
        this.assertion = new AVA[avaset.length];
        for (int i = 0; i < this.assertion.length; ++i) {
            this.assertion[i] = new AVA(avaset[i].data);
        }
    }

    public RDN(AVA[] avas) {
        this.assertion = (AVA[])avas.clone();
    }

    public RDN(Vector<AVA> avaVector) {
        int size = avaVector.size();
        this.assertion = new AVA[size];
        for (int i = 0; i < size; ++i) {
            this.assertion[i] = avaVector.elementAt(i);
        }
    }

    public AVA[] getAssertion() {
        return (AVA[])this.assertion.clone();
    }

    public int getAssertionLength() {
        return this.assertion.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.assertion);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDN other = (RDN)obj;
        return Arrays.equals(this.assertion, other.assertion);
    }

    DerValue findAttribute(ObjectIdentifier oid) {
        for (int i = 0; i < this.assertion.length; ++i) {
            if (!this.assertion[i].oid.equals(oid)) continue;
            return this.assertion[i].value;
        }
        return null;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.assertion.length; ++i) {
            this.assertion[i].encode(tmp);
        }
        out.write((byte)49, tmp);
    }

    public Enumeration<AVA> getAVAs() {
        return new AVAEnumerator();
    }

    public String toLdapDNString() throws IOException {
        return LdapDNStrConverter.getDefault().encodeRDN(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeRDN(this);
    }

    public String toString() {
        String s;
        try {
            s = this.toLdapDNString();
        }
        catch (IOException e) {
            return "";
        }
        return s;
    }

    private class AVAEnumerator
    implements Enumeration<AVA> {
        private int index = 0;

        @Override
        public boolean hasMoreElements() {
            return this.index < RDN.this.assertion.length;
        }

        @Override
        public AVA nextElement() {
            if (this.index >= RDN.this.assertion.length) {
                return null;
            }
            return RDN.this.assertion[this.index++];
        }
    }
}

