/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __PS3_EVTCODE_TRANS_H__
#define __PS3_EVTCODE_TRANS_H__

#if !(defined(PS3_PRODUCT_EXPANDER) || defined(PS3_PRODUCT_SWITCH))
#include "ps3_htp_mgr_evt_raidhba.h"

#define PS3_EVT_EXT_NR (PS3_EVT_MAX_TYPE_LOCAL - MGR_EVT_EXTEND_TYPE_START)

static inline char const *mgrEvtCodeTrans(unsigned int opCode)
{
	unsigned int typeIndex = 0;
	unsigned int codeIndex = 0;
	const char *pEvtTransStr = NULL;
	static const char *pEvtCodeInfo[MGR_EVT_EXTEND_TYPE_START][MGR_EVT_TYPE_OFFSET] = {
		{
			"MGR_EVT_SAS_START",
			"MGR_EVT_SAS_EXPANDER_IN",
			"MGR_EVT_SAS_EXPANDER_OUT",
			"MGR_EVT_SAS_EXPANDER_UPDATE",
			"MGR_EVT_SAS_EXPANDER_CHANGE",
			"MGR_EVT_ENCL_TEMP_NORMAL",
			"MGR_EVT_ENCL_TEMP_WARNING",
			"MGR_EVT_ENCL_TEMP_CRITICAL",
			"MGR_EVT_TOPO_LOOP",
			"MGR_EVT_LOOP_RESOLUTION",
			"MGR_EVT_CASCADED_SCAN_SMP_FAIL",
			"MGR_EVT_ENCL_EXCEED",
			"MGR_EVT_TRI_MODE_SWITCH",
			"MGR_EVT_CHANGE_PHY_BY_USER",
			"MGR_EVT_REV_HIBERNATE_CMD",
			"MGR_EVT_PHY_CHANGE",
			"MGR_EVT_INQUIRY_INFO",
			"MGR_EVT_SAS_SATA_LINK_SPEED_NOMATCH",
			"MGR_EVT_SAS_SATA_LN_EXCEPTION",
			"MGR_EVT_SAS_SATA_DRIVER_INFO",
		},
		{
			"MGR_EVT_PD_COUNT_START",
			"MGR_EVT_DEVM_DISK_IN",
			"MGR_EVT_DEVM_DISK_OUT",
			"MGR_EVT_MULITPILE_PD_IN",
			"MGR_EVT_MULITPILE_PD_OUT",
			"MGR_EVT_DEVM_JBOD",
			"MGR_EVT_DEVM_READY",
			"MGR_EVT_MULITPILE_JBOD",
			"MGR_EVT_MULITPILE_READY",
			"MGR_EVT_BACKPLANE_ON",
			"MGR_EVT_BACKPLANE_OFF",
			"MGR_EVT_MULITPILE_PD_STATE_CHANGE",
			"MGR_EVT_DEVM_DISK_CHANGE",
			"MGR_EVT_DEFAULT_UNUSED",
			"MGR_EVT_PD_PRE_READY",
		},
		{
			"MGR_EVT_VD_COUNT_START",
			"MGR_EVT_VD_OPTIMAL",
			"MGR_EVT_VD_PARTIAL_DEGRADE",
			"MGR_EVT_VD_DEGRADE",
			"MGR_EVT_VD_CREATED",
			"MGR_EVT_VD_DELETED",
			"MGR_EVT_VD_HIDDEN_CHANGE",
			"MGR_EVT_MULITPILE_VD_IN",
			"MGR_EVT_MULITPILE_VD_OUT",
			"MGR_EVT_VD_UNLOCK",
			"MGR_EVT_VD_OFFLINE",
		},
		{
			"MGR_EVT_CTRL_INFO_START",
			"MGR_EVT_CTRL_REBOOT",
			"MGR_EVT_CTRL_SHUTDOWN",
			"MGR_EVT_CTRL_TIME_CHANGE",
			"MGR_EVT_CTRL_EVENT_LOG_CLEARED",
			"MGR_EVT_CTRL_RBLD_RATE_CHANGED",
			"MGR_EVT_CTRL_ENABLEMOVEBACK_CHANGED",
			"MGR_EVT_CTRL_ENABLENCQ_CHANGED",
			"MGR_EVT_CTRL_AUTO_REBUILD_CHANGED",
			"MGR_EVT_CTRL_EGHS_READY_CHANGED",
			"MGR_EVT_CTRL_EGHS_SPARE_CHANGED",
			"MGR_EVT_CTRL_BGI_RATE_CHANGED",
			"MGR_EVT_CTRL_MIGRATE_RATE_CHANGED",
			"MGR_EVT_CTRL_CC_RATE_CHANGED",
			"MGR_EVT_CTRL_DIRECT_CHANGE",
			"MGR_EVT_CTRL_PR_START",
			"MGR_EVT_CTRL_PR_PAUSE",
			"MGR_EVT_CTRL_PR_REMINDER_PAUSE",
			"MGR_EVT_CTRL_PR_RESUME",
			"MGR_EVT_CTRL_PR_DONE",
			"MGR_EVT_CTRL_PR_RATE_CHANGED",
			"MGR_EVT_CTRL_PR_CANT_START",
			"MGR_EVT_CTRL_PR_PROP_CHANGED",
			"MGR_EVT_CTRL_PARAM_CHANGE",
			"MGR_EVT_CTRL_AUTO_CC_PARAM_CHANGE",
			"MGR_EVT_CTRL_RECOVERY_FACTORY",
			"MGR_EVT_CTRL_PROFILEID_CHANGED",
			"MGR_EVT_CTRL_SANPSHOT_CREATE",
			"MGR_EVT_CTRL_SANPSHOT_DELETE",
			"MGR_EVT_CTRL_ENABLEPDM_CHANGED",
			"MGR_EVT_CTRL_PDMSUPPORTREADYPD",
			"MGR_EVT_CTRL_PDMTIMERINTERVAL",
			"MGR_EVT_CTRL_SECURITY_KEY_CHANGE",
			"MGR_EVT_CTRL_SECURITY_KEY_CREATE",
			"MGR_EVT_CTRL_SECURITY_KEY_DESTROY",
			"MGR_EVT_CTRL_SECURITY_KEY_ESCROW",
			"MGR_EVT_CTRL_SECURITY_KEY_FAILED",
			"MGR_EVT_CTRL_SECURITY_KEY_INVALID",
			"MGR_EVT_AUTOCONFIG",
			"MGR_EVT_CTRL_FOREIGN_IMPORTED_ALL",
			"MGR_EVT_CTRL_FOREIGN_CLEAR",
			"MGR_EVT_CTRL_FOREIGN_IMPORT_FAIL",
			"MGR_EVT_CTRL_FOREIGN_IMPORT_PART_FAIL",
			"MGR_EVT_CTRL_FOREIGN_IMPORT_FAIL_PDS",
			"MGR_EVT_CTRL_FOREIGN_PD_DETECTED",
			"MGR_EVT_PD_INSERT_TO_DG",
			"MGR_EVT_PD_IMPORT_TO_DG",
			"MGR_EVT_HARD_RESET",
			"MGR_EVT_DPF_CFG_MODIFY",
			"MGR_EVT_SPOR",
			"MGR_EVT_ONF_ABNORMAL",
			"MGR_EVT_CTRL_LOADED",
			"MGR_EVT_CACHE_PROTECTION_CMPT_READY",
			"MGR_EVT_CACHE_PROTECTION_CMPT_NOT_READY",
			"MGR_EVT_CACHE_PROTECTION_CMPT_INSTABLE",
			"MGR_EVT_MAIN_MEDIUM_NOT_AVAILABLE",
			"MGR_EVT_BACKUP_MEDIUM_NOT_AVAILABLE",
			"MGR_EVT_MEDIUM_DATA_RECOVER",
			"MGR_EVT_INIT_FAIL",
			"MGR_EVT_CTRL_POWER_MODE_CHANGED",
		},
		{
			"MGR_EVT_PD_ATTR_START",
			"MGR_EVT_PD_INFO_CHANGE",
			"MGR_EVT_PD_STATE_CHANGE",
			"MGR_EVT_PD_MARKED_JBOD",
			"MGR_EVT_PD_MARKED_READY",
			"MGR_EVT_PD_MARKED_ONLINE",
			"MGR_EVT_PD_MARKED_OFFLINE",
			"MGR_EVT_PD_MARKED_FAILED",
			"MGR_EVT_PD_MARKED_MISSING",
			"MGR_EVT_PD_MARKED_REBUILD",
			"MGR_EVT_PD_MARKED_REPLACE",
			"MGR_EVT_PD_MARKED_UNCONFIGUREDBAD",
			"MGR_EVT_PD_MARKED_FOREIGN",
			"MGR_EVT_PD_NR_GLOBAL_SPARE_ADDED",
			"MGR_EVT_PD_NR_GLOBAL_SPARE_DELETED",
			"MGR_EVT_PD_NR_DEDICATED_SPARE_ADDED",
			"MGR_EVT_PD_NR_DEDICATED_SPARE_DELETED",
			"MGR_EVT_PD_R_GLOBAL_SPARE_ADDED",
			"MGR_EVT_PD_R_GLOBAL_SPARE_DELETED",
			"MGR_EVT_PD_R_DEDICATED_SPARE_ADDED",
			"MGR_EVT_PD_R_DEDICATED_SPARE_DELETED",
			"MGR_EVT_PD_RBLD_ABORT_BY_USER",
			"MGR_EVT_PD_RBLD_DONE_PD",
			"MGR_EVT_PD_RBLD_FAILED_BAD_SOURCE",
			"MGR_EVT_PD_RBLD_FAILED_BAD_TARGET",
			"MGR_EVT_PD_RBLD_PROGRESS",
			"MGR_EVT_PD_RBLD_SUSPENDED_REMINDER",
			"MGR_EVT_PD_RBLD_SUSPENDED",
			"MGR_EVT_PD_RBLD_RESUME",
			"MGR_EVT_PD_RBLD_START",
			"MGR_EVT_PD_RBLD_START_AUTO",
			"MGR_EVT_PD_RBLD_MEDIUM_ERROR",
			"MGR_EVT_PD_EMERGENCY_SPARE",
			"MGR_EVT_PD_RECOVER_MEDIUM_ERROR",
			"MGR_EVT_PD_MOVEBACK_START",
			"MGR_EVT_PD_MOVEBACK_ABORT",
			"MGR_EVT_PD_MOVEBACK_ABORT_FOR_REBUILD",
			"MGR_EVT_PD_MOVEBACK_DONE",
			"MGR_EVT_PD_MOVEBACK_PROGRESS",
			"MGR_EVT_PD_MOVEBACK_SUSPENDED",
			"MGR_EVT_PD_MOVEBACK_SUSPENDED_REMINDER",
			"MGR_EVT_PD_MOVEBACK_RESUME",
			"MGR_EVT_PD_MOVEBACK_START_AUTO",
			"MGR_EVT_PD_MOVEBACK_FAILED_BAD_SOURCE",
			"MGR_EVT_PD_MOVEBACK_FAILED_BAD_TARGET",
			"MGR_EVT_PD_MOVEBACK_ABORT_BY_USER",
			"MGR_EVT_PD_MOVEBACK_MEDIUM_ERROR",
			"MGR_EVT_PD_FGI_START",
			"MGR_EVT_PD_FGI_COMPLETE",
			"MGR_EVT_PD_FGI_FAILED",
			"MGR_EVT_PD_FGI_PROGRESS",
			"MGR_EVT_PD_FGI_ABORT",
			"MGR_EVT_PD_PR_ABORTED",
			"MGR_EVT_PD_PR_CORRECTED",
			"MGR_EVT_PD_PR_UNCORRECTABLE",
			"MGR_EVT_PD_PR_FOUND_MEDIUM_ERROR",
			"MGR_EVT_PD_PR_PROGRESS",
			"MGR_EVT_PD_SET_BOOT_DRIVE",
			"MGR_EVT_PD_RESET_BOOT_DRIVE",
			"MGR_EVT_PD_RESET_BOOT_DRIVE_WITH_DISK_OUT",
			"MGR_EVT_PD_SET_BOOT_DRIVE_WITH_DISK_IN",
			"MGR_EVT_PD_POWERSAVE_TO_ON",
			"MGR_EVT_PD_POWERSAVE_TO_TRANSITION",
			"MGR_EVT_PD_TRANSITION_TO_ON",
			"MGR_EVT_PD_TRANSITION_TO_POWERSAVE",
			"MGR_EVT_PD_ON_TO_POWERSAVE",
			"MGR_EVT_PD_START_LOCATE",
			"MGR_EVT_PD_STOP_LOCATE",
			"MGR_EVT_PD_PFA_ERROR",
			"MGR_EVT_PD_NOT_PRESENT",
			"MGR_EVT_DEVM_DISK_FAULT",
			"MGR_EVT_PHY_FLASHOFFLINE",
			"MGR_EVT_PHY_FLASHONLINE",
			"MGR_EVT_NFR_DONE",
			"MGR_EVT_NFR_REPAIRED",
			"MGR_EVT_NFR_REPORT",
			"MGR_EVT_NFR_STOP",
			"MGR_EVT_PD_DOWNLOAD_DONE",
			"MGR_EVT_PD_DOWNLOAD_START",
			"MGR_EVT_NVME_PHY_BAD",
		},
		{
			"MGR_EVT_VD_ATTR_START",
			"MGR_EVT_MULITPILE_VD_STATE_CHANGE",
			"MGR_EVT_VD_OFFLINE_OLD",
			"MGR_EVT_VD_LOCK",
			"MGR_EVT_VD_PASSWD_CHANGED",
			"MGR_EVT_VD_SETTINGS_CHANGE",
			"MGR_EVT_VD_PD_CHANGE",
			"MGR_EVT_VD_STATE_CHANGE",
			"MGR_EVT_PD_RBLD_DONE_LD",
			"MGR_EVT_VD_FGI_START",
			"MGR_EVT_VD_FGI_COMPLETE",
			"MGR_EVT_VD_FGI_FAILED",
			"MGR_EVT_VD_FGI_PROGRESS",
			"MGR_EVT_VD_FGI_ABORT",
			"MGR_EVT_VD_BGI_START",
			"MGR_EVT_VD_BGI_COMPLETE",
			"MGR_EVT_VD_BGI_FAILED",
			"MGR_EVT_VD_BGI_PROGRESS",
			"MGR_EVT_VD_BGI_ABORT",
			"MGR_EVT_VD_BGI_PAUSE",
			"MGR_EVT_VD_BGI_REMINDER_PAUSE",
			"MGR_EVT_VD_BGI_RESUME",
			"MGR_EVT_VD_BGI_CORRECTABLE_ERROR",
			"MGR_EVT_VD_BGI_UNCORRECTABLE_ERROR",
			"MGR_EVT_VD_ALTER_ATTR_BY_MIGRATION",
			"MGR_EVT_VD_BBM_CLEARED",
			"MGR_EVT_VD_BBM_PERCENT_FULL",
			"MGR_EVT_VD_BBM_100_FULL",
			"MGR_EVT_VD_BBM_LOG_FULL",
			"MGR_EVT_VD_BBM_LOG_RCT",
			"MGR_EVT_VD_BBM_LOG_WCT",
			"MGR_EVT_VD_BBM_DEL_RCT",
			"MGR_EVT_VD_CC_ABORTED",
			"MGR_EVT_VD_CC_CORRECTED_MEDIUM_ERROR",
			"MGR_EVT_VD_CC_DOUBLE_MEDIUM_ERRORS",
			"MGR_EVT_VD_CC_DONE",
			"MGR_EVT_VD_CC_DONE_INCON",
			"MGR_EVT_VD_CC_FAILED",
			"MGR_EVT_VD_CC_FAILED_UNCOR",
			"MGR_EVT_VD_CC_INCONSISTENT_PARITY",
			"MGR_EVT_VD_CC_INCONSISTENT_PARITY_LOGGING_DISABLED",
			"MGR_EVT_VD_CC_PROGRESS",
			"MGR_EVT_VD_CC_START",
			"MGR_EVT_VD_CC_PAUSE",
			"MGR_EVT_VD_CC_REMINDER_PAUSE",
			"MGR_EVT_VD_CC_RESUME",
			"MGR_EVT_VD_RW_RAID1X_WRITE_CARDBUSY",
			"MGR_EVT_VD_SET_BOOT_DRIVE",
			"MGR_EVT_VD_RESET_BOOT_DRIVE",
			"MGR_EVT_VD_RESET_BOOT_DRIVE_WITH_DISK_OUT",
			"MGR_EVT_VD_SET_BOOT_DRIVE_WITH_DISK_IN",
			"MGR_EVT_ALL_CONFIGS_MISSING",
			"MGR_EVT_PDS_MISSING",
			"MGR_EVT_NVSRAM_RECOVER_FAIL",
			"MGR_EVT_NVSRAM_UPDATE_FAIL",
			"MGR_EVT_VD_ERASE_ABORT",
			"MGR_EVT_VD_ERASE_COMPLETE",
			"MGR_EVT_VD_ERASE_DISK_FAILED",
			"MGR_EVT_VD_ERASE_FAILED",
			"MGR_EVT_VD_ERASE_PROGRESS",
			"MGR_EVT_VD_ERASE_START",
			"MGR_EVT_VD_EXPAND_FINISH",
			"MGR_EVT_VD_EXPAND_START",
			"MGR_EVT_VD_FLUSH_CLEAR_FAILED",
			"MGR_EVT_VD_FLUSH_RECORD_FAILED",
			"MGR_EVT_VD_FLUSH_SET_INCONSIST",
			"MGR_EVT_VDS_MISSING",
			"MGR_EVT_VD_BBM_UNCORRECTABLE_LOGGED",
			"MGR_EVT_VD_FLUSH_CACHE_PINNED",
			"MGR_EVT_VD_FLUSH_OCR_CACHE_PINNED",
			"MGR_EVT_VD_FLUSH_CACHE_DISCARDED",
			"MGR_EVT_VD_FLUSH_CACHE_DISCARDED_DEL",
			"MGR_EVT_VD_FLUSH_CACHE_DESTAGED",
			"MGR_EVT_VD_CM_RECOVERY_CRC_FAIL",
			"MGR_EVT_VD_BGI_COMPLETE_UNCOR",
		},
		{
			"MGR_EVT_DG_INFO_START",
			"MGR_EVT_DG_CREATED",
			"MGR_EVT_DG_DELETED",
			"MGR_EVT_DG_SETTING_CHANGE",
			"MGR_EVT_DG_MIGRATION_START",
			"MGR_EVT_DG_MIGRATION_RECOVER",
			"MGR_EVT_DG_MIGRATION_SUCCESS",
			"MGR_EVT_DG_MIGRATION_ALLOC_RESOURCE_FAILED",
			"MGR_EVT_DG_MIGRATION_FAILED",
			"MGR_EVT_DG_MIGRATION_RECOVER_FAILED",
			"MGR_EVT_DG_MIGRATION_PROGRESS",
			"MGR_EVT_DG_MIGRATION_INTERNAL_WARNING",
			"MGR_EVT_DG_PRSWITCH_CHANGE",
			"MGR_EVT_DG_PR_ABORTED_WM_FAILED",
			"MGR_EVT_DG_PR_ABORTED_SPINUP_FAILED",
		},
		{
			"MGR_EVT_BBU_START",
			"MGR_EVT_BBU_PRESENT",
			"MGR_EVT_BBU_NOT_PRESENT",
			"MGR_EVT_BBU_GOOD",
			"MGR_EVT_BBU_BAD",
			"MGR_EVT_BBU_CAP_BELOW_THRESHOLD",
			"MGR_EVT_BBU_CAP_ABOVE_THRESHOLD",
			"MGR_EVT_BBU_CHARGE_STATUS",
			"MGR_EVT_BBU_CHARGE_COMPLETE",
			"MGR_EVT_BBU_INSERT",
			"MGR_EVT_BBU_ABSENT",
			"MGR_EVT_BBU_TEMPERATURE_NORMAL",
			"MGR_EVT_BBU_TEMPERATURE_HIGH",
			"MGR_EVT_BBU_VOLTAGE_NORMAL",
			"MGR_EVT_BBU_VOLTAGE_HIGH",
			"MGR_EVT_BBU_CURRENT_NORMAL",
			"MGR_EVT_BBU_CURRENT_HIGH",
			"MGR_EVT_BBU_LOAD_NORMAL",
			"MGR_EVT_BBU_VOLTAGE_LOW",
			"MGR_EVT_BBU_BATTERY_CAP_ABOVE_SOH_THRESHOLD",
			"MGR_EVT_BBU_BATTERY_CAP_BELOW_SOH_THRESHOLD",
			"MGR_EVT_BBU_LEARN_STAGE",
			"MGR_EVT_BBU_LEARN_REQUESTED",
			"MGR_EVT_BBU_LEARN_POSTPONED",
			"MGR_EVT_BBU_LEARN_TIMEOUT",
			"MGR_EVT_BBU_LEARN_MANUAL",
			"MGR_EVT_BBU_LEARN_RESCHEDULED",
			"MGR_EVT_BBU_PROPERTIES_CHANGED",
		},
		{
			"MGR_EVT_CONFIG_START",
			"MGR_EVT_CONFIG_INFO",
			"MGR_EVT_CONFIG_FLASH_READ_FAIL",
			"MGR_EVT_CONFIG_FLASH_WRITE_FAIL",
			"MGR_EVT_CONFIG_NVSRAM_READ_FAIL",
			"MGR_EVT_CONFIG_NVSRAM_WRITE_FAIL",
			"MGR_EVT_CONFIG_VERSION_MISMATCH",
			"MGR_EVT_CONFIG_MEDIA_VALUE_CHECK_FAIL",
			"MGR_EVT_CONFIG_ERASE_NVSRAM",
			"MGR_EVT_PHY_LINKSPEED_CFG_CHANGE",
		},
		{
			"MGR_EVT_IO_START",
			"MGR_EVT_IO_TEST",
			"MGR_EVT_IO_SENSE_DATA",
			"MGR_EVT_DEVICE_RESET",
			"MGR_EVT_NVME_DEVICE_RESET",
			"MGR_EVT_DEVICE_ABNORMAL",
			"MGR_EVT_IO_SENSE",
		},
		{
			"MGR_EVT_UKEY_START",
			"MGR_EVT_UKEY_INSERT",
			"MGR_EVT_UKEY_DEGRADE",
			"MGR_EVT_RAID_KEY_OVERCURRENT",
			"MGR_EVT_RAID_KEY_OVERCURRENT_RECOVER",
		},
		{
			"MGR_EVT_HWR_START",
			"MGR_EVT_HWR_HAC_RESET_BEGIN",
			"MGR_EVT_HWR_HAC_RESET_END",
			"MGR_EVT_REPORT_HAC_ECC",
		},
		{
			"MGR_EVT_ALARM_START",
			"MGR_EVT_ALARM_ENABLED",
			"MGR_EVT_ALARM_DISABLED",
		},
		{
			"MGR_EVT_ECC_START",
			"MGR_EVT_ECC_CNT_EXCEED",
			"MGR_EVT_ECC_ERR_INTR",
			"MGR_EVT_ECC_CNT_CLEAR",
			"MGR_EVT_ECC_CLI_CHANGE",
			"MGR_EVT_ECC_FACTORY_CHANGE",
		},
		{
			"MGR_EVT_UPGRADE_START",
			"MGR_EVT_IMAGE_DOWNLOAD_ERROR",
			"MGR_EVT_IMAGE_AUTHENTICATION_FAIL",
			"MGR_EVT_IMAGE_VERSION_CHECK_FAIL",
			"MGR_EVT_IMAGE_CHECKSUM_CHECK_FAIL",
			"MGR_EVT_IMAGE_FROM_BACKUP",
			"MGR_EVT_DEV_OPEN_ERROR",
			"MGR_EVT_DEV_FLASH_ERROR",
			"MGR_EVT_DEV_ERASE_ERROR",
			"MGR_EVT_DEV_CLOSE_ERROR",
			"MGR_EVT_FLASH_GENERAL_ERROR",
			"MGR_EVT_FLASH_TIMEOUT",
			"MGR_EVT_UPGRADE_SUCCESS",
			"MGR_EVT_UPGRADE_SYNC_START",
			"MGR_EVT_UPGRADE_SYNC_FAILED",
			"MGR_EVT_UPGRADE_SYNC_SUCCESS",
		},
		{
			"MGR_EVT_TEMP_START",
			"MGR_EVT_TEMP_WITHIN_OPTIMAL_RANGE",
			"MGR_EVT_TEMP_ABOVE_OPTIMAL_RANGE",
			"MGR_EVT_TEMP_WARNING",
			"MGR_EVT_TEMP_CRITICAL",
		},
	};

	static const char *pEvtCodeExtInfo[PS3_EVT_EXT_NR][MGR_EVT_TYPE_EXTEND_OFFSET] = {
		{
			"MGR_EVT_PD_ATTR_EXTEND_START_START",
			"MGR_EVT_PD_ERASE_ABORT",
			"MGR_EVT_PD_ERASE_COMPLETE",
			"MGR_EVT_PD_ERASE_FAILED",
			"MGR_EVT_PD_ERASE_PROGRESS",
			"MGR_EVT_PD_ERASE_START",
			"MGR_EVT_PD_PDM_ABORT_BY_USER",
			"MGR_EVT_PD_PDM_ABORT_FOR_REBUILD",
			"MGR_EVT_PD_PDM_ABORT",
			"MGR_EVT_PD_PDM_DONE",
			"MGR_EVT_PD_PDM_FAILED_BAD_SOURCE",
			"MGR_EVT_PD_PDM_FAILED_BAD_TARGET",
			"MGR_EVT_PD_PDM_MEDIUM_ERROR",
			"MGR_EVT_PD_PDM_PROGRESS",
			"MGR_EVT_PD_PDM_REPLACED_SOURCE",
			"MGR_EVT_PD_PDM_RESUME",
			"MGR_EVT_PD_PDM_START_AUTO",
			"MGR_EVT_PD_PDM_START",
			"MGR_EVT_PD_PDM_SUSPENDED_REMINDER",
			"MGR_EVT_PD_PDM_SUSPENDED",
			"MGR_EVT_PD_PFA_ERROR_CLEAR",
			"MGR_EVT_PD_SANITIZE_START",
			"MGR_EVT_PD_FORMAT_START",
			"MGR_EVT_PD_SANITIZE_PROGRESS",
			"MGR_EVT_PD_SANITIZE_DONE",
			"MGR_EVT_PD_FORMAT_DONE",
			"MGR_EVT_PD_DPF_ERROR",
			"MGR_EVT_PD_MARKED_SHIELD",
			"MGR_EVT_PD_BBM_CORRECTED",
			"MGR_EVT_PD_BBM_UNRECOVERABLE",
			"MGR_EVT_PD_BBM_PUNCTURING",
			"MGR_EVT_PD_BBM_REASSIGN_WR_ERROR",
			"MGR_EVT_PD_UNABLE_ACCESS",
			"MGR_EVT_MULITPILE_PD_UNABLE_ACCESS",
			"MGR_EVT_PD_INSERT_FAIL",
			"MGR_EVT_PHY_SATA_D2H_FAIL",
			"MGR_EVT_PD_NOT_INSERTED",
			"MGR_EVT_PD_NOT_SUPPORT",
			"MGR_EVT_MULITPILE_PD_NOT_SUPPORT",
			"MGR_EVT_NVDATA_INVALID",
			"MGR_EVT_PD_RBLD_NON_UNMAP_PD",
			"MGR_EVT_PD_MOVEBACK_NON_UNMAP_PD",
			"MGR_EVT_PD_PDM_NON_UNMAP_PD",
			"MGR_EVT_PD_RBLD_FAILED",
			"MGR_EVT_PD_SANITIZE_FAILED",
			"MGR_EVT_PD_SPIN_FAIL",
			"MGR_EVT_PD_RBLD_MEDIA_MIX_NOT_SUPPORT",
			"MGR_EVT_PD_RBLD_DRIVE_MIX_NOT_SUPPORT",
			"MGR_EVT_PD_PDM_MEDIA_MIX_NOT_SUPPORT",
			"MGR_EVT_PD_PDM_DRIVE_MIX_NOT_SUPPORT",
			"MGR_EVT_PD_MOVEBACK_MEDIA_MIX_NOT_SUPPORT",
			"MGR_EVT_PD_MOVEBACK_DRIVE_MIX_NOT_SUPPORT",
			"MGR_EVT_NFR_FAILED",
			"MGR_EVT_PD_RBLD_SMALL_SIZE",
			"MGR_EVT_PD_MOVEBACK_SMALL_SIZE",
			"MGR_EVT_NEGO_LOWER_LINK_SPEED",
			"MGR_EVT_PD_NVME_CMD_ERR",
			"MGR_EVT_PD_NVME_CMD_TO",
			"MGR_EVT_PD_NVME_INSERT_FAIL",
			"MGR_EVT_PCIE_LINK_NEGO_ABNORMAL",
			"MGR_EVT_PD_ISOLATION",
			"MGR_EVT_PD_REPAIR_FAILED",
			"MGR_EVT_PD_PCIE_LINK_UP_WITHOUT_I2C",
			"MGR_EVT_PD_PCIE_ENUMERATE_FAILED",
			"MGR_EVT_PD_MISS_LIGHTING",
		},
	};

	if (opCode >= ((MGR_EVT_EXTEND_TYPE_START - 1) * MGR_EVT_TYPE_OFFSET) +
		 (PS3_EVT_MAX_TYPE_LOCAL - MGR_EVT_EXTEND_TYPE_START)
		 * MGR_EVT_TYPE_EXTEND_OFFSET) {
		goto end;
	};
	if (opCode < ((MGR_EVT_EXTEND_TYPE_START - 1) * MGR_EVT_TYPE_OFFSET)) {
		typeIndex = opCode / MGR_EVT_TYPE_OFFSET;
		codeIndex = opCode % MGR_EVT_TYPE_OFFSET;
		pEvtTransStr = pEvtCodeInfo[typeIndex][codeIndex];
	} else {
		typeIndex = (opCode - ((MGR_EVT_EXTEND_TYPE_START - 1) * MGR_EVT_TYPE_OFFSET))
				/ MGR_EVT_TYPE_EXTEND_OFFSET;
		codeIndex = (opCode - ((MGR_EVT_EXTEND_TYPE_START - 1) * MGR_EVT_TYPE_OFFSET))
				% MGR_EVT_TYPE_EXTEND_OFFSET;
		pEvtTransStr = pEvtCodeExtInfo[typeIndex][codeIndex];
};
end:
	return pEvtTransStr;
}

#else
static inline char const *mgrEvtCodeTrans(unsigned int opCode)
{
	const char * const pEvtTransStr = NULL;
	return pEvtTransStr;
}
#endif
#endif
