/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI service
type PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService service

type PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService
	distroBasePath string
	name string
	namespace string
	version string
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDelete Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDelete

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param name
 @param namespace
 @param version
 @return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDelete(ctx context.Context, distroBasePath string, name string, namespace string, version string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		name: name,
		namespace: namespace,
		version: version,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteExecute(r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"namespace"+"}", parameterValueToString(r.namespace, "namespace"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"version"+"}", parameterValueToString(r.version, "version"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService
	distroBasePath string
	name string
	namespace string
	isHighest *bool
	limit *int32
	name2 *string
	namespace2 *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	q *string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	tags *string
	version *string
	fields *[]string
	excludeFields *[]string
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) IsHighest(isHighest bool) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.isHighest = &isHighest
	return r
}

// Number of results to return per page.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Limit(limit int32) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.limit = &limit
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Name2(name2 string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.name2 = &name2
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Namespace2(namespace2 string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.namespace2 = &namespace2
	return r
}

// The initial index from which to return the results.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Offset(offset int32) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;authors&#x60; - Authors * &#x60;-authors&#x60; - Authors (descending) * &#x60;contents&#x60; - Contents * &#x60;-contents&#x60; - Contents (descending) * &#x60;dependencies&#x60; - Dependencies * &#x60;-dependencies&#x60; - Dependencies (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;docs_blob&#x60; - Docs blob * &#x60;-docs_blob&#x60; - Docs blob (descending) * &#x60;manifest&#x60; - Manifest * &#x60;-manifest&#x60; - Manifest (descending) * &#x60;files&#x60; - Files * &#x60;-files&#x60; - Files (descending) * &#x60;documentation&#x60; - Documentation * &#x60;-documentation&#x60; - Documentation (descending) * &#x60;homepage&#x60; - Homepage * &#x60;-homepage&#x60; - Homepage (descending) * &#x60;issues&#x60; - Issues * &#x60;-issues&#x60; - Issues (descending) * &#x60;license&#x60; - License * &#x60;-license&#x60; - License (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;namespace&#x60; - Namespace * &#x60;-namespace&#x60; - Namespace (descending) * &#x60;repository&#x60; - Repository * &#x60;-repository&#x60; - Repository (descending) * &#x60;requires_ansible&#x60; - Requires ansible * &#x60;-requires_ansible&#x60; - Requires ansible (descending) * &#x60;version&#x60; - Version * &#x60;-version&#x60; - Version (descending) * &#x60;version_major&#x60; - Version major * &#x60;-version_major&#x60; - Version major (descending) * &#x60;version_minor&#x60; - Version minor * &#x60;-version_minor&#x60; - Version minor (descending) * &#x60;version_patch&#x60; - Version patch * &#x60;-version_patch&#x60; - Version patch (descending) * &#x60;version_prerelease&#x60; - Version prerelease * &#x60;-version_prerelease&#x60; - Version prerelease (descending) * &#x60;is_highest&#x60; - Is highest * &#x60;-is_highest&#x60; - Is highest (descending) * &#x60;search_vector&#x60; - Search vector * &#x60;-search_vector&#x60; - Search vector (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Ordering(ordering []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) PulpHrefIn(pulpHrefIn []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) PulpIdIn(pulpIdIn []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Q(q string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.q = &q
	return r
}

// Repository Version referenced by HREF
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) RepositoryVersion(repositoryVersion string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) RepositoryVersionAdded(repositoryVersionAdded string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter by comma separate list of tags that must all be matched
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Tags(tags string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.tags = &tags
	return r
}

// Filter results where version matches value
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Version(version string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.version = &version
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Fields(fields []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) Execute() (*PaginatedCollectionVersionListResponseList, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsList Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsList

Returns paginated CollectionVersions list.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param name
 @param namespace
 @return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsList(ctx context.Context, distroBasePath string, name string, namespace string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		name: name,
		namespace: namespace,
	}
}

// Execute executes the request
//  @return PaginatedCollectionVersionListResponseList
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListExecute(r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsListRequest) (*PaginatedCollectionVersionListResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedCollectionVersionListResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"namespace"+"}", parameterValueToString(r.namespace, "namespace"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.isHighest != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_highest", r.isHighest, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name2 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name2, "")
	}
	if r.namespace2 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace", r.namespace2, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.q != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "q", r.q, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.tags != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "tags", r.tags, "")
	}
	if r.version != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version", r.version, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService
	distroBasePath string
	name string
	namespace string
	version string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest) Fields(fields []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest) Execute() (*CollectionVersionResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsRead Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsRead

Returns a CollectionVersion object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @param name
 @param namespace
 @param version
 @return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsRead(ctx context.Context, distroBasePath string, name string, namespace string, version string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
		name: name,
		namespace: namespace,
		version: version,
	}
}

// Execute executes the request
//  @return CollectionVersionResponse
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadExecute(r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsReadRequest) (*CollectionVersionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *CollectionVersionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"namespace"+"}", parameterValueToString(r.namespace, "namespace"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"version"+"}", parameterValueToString(r.version, "version"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
