/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the EvaluationResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EvaluationResponse{}

// EvaluationResponse Results from evaluating a proposed parameter to a PulpImport call.
type EvaluationResponse struct {
	// Parameter value being evaluated.
	Context string `json:"context"`
	// True if evaluation passed, false otherwise.
	IsValid bool `json:"is_valid"`
	// Messages describing results of all evaluations done. May be an empty list.
	Messages []string `json:"messages"`
	AdditionalProperties map[string]interface{}
}

type _EvaluationResponse EvaluationResponse

// NewEvaluationResponse instantiates a new EvaluationResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEvaluationResponse(context string, isValid bool, messages []string) *EvaluationResponse {
	this := EvaluationResponse{}
	this.Context = context
	this.IsValid = isValid
	this.Messages = messages
	return &this
}

// NewEvaluationResponseWithDefaults instantiates a new EvaluationResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEvaluationResponseWithDefaults() *EvaluationResponse {
	this := EvaluationResponse{}
	return &this
}

// GetContext returns the Context field value
func (o *EvaluationResponse) GetContext() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Context
}

// GetContextOk returns a tuple with the Context field value
// and a boolean to check if the value has been set.
func (o *EvaluationResponse) GetContextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Context, true
}

// SetContext sets field value
func (o *EvaluationResponse) SetContext(v string) {
	o.Context = v
}

// GetIsValid returns the IsValid field value
func (o *EvaluationResponse) GetIsValid() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsValid
}

// GetIsValidOk returns a tuple with the IsValid field value
// and a boolean to check if the value has been set.
func (o *EvaluationResponse) GetIsValidOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsValid, true
}

// SetIsValid sets field value
func (o *EvaluationResponse) SetIsValid(v bool) {
	o.IsValid = v
}

// GetMessages returns the Messages field value
func (o *EvaluationResponse) GetMessages() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Messages
}

// GetMessagesOk returns a tuple with the Messages field value
// and a boolean to check if the value has been set.
func (o *EvaluationResponse) GetMessagesOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Messages, true
}

// SetMessages sets field value
func (o *EvaluationResponse) SetMessages(v []string) {
	o.Messages = v
}

func (o EvaluationResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EvaluationResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["context"] = o.Context
	toSerialize["is_valid"] = o.IsValid
	toSerialize["messages"] = o.Messages

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *EvaluationResponse) UnmarshalJSON(bytes []byte) (err error) {
	varEvaluationResponse := _EvaluationResponse{}

	if err = json.Unmarshal(bytes, &varEvaluationResponse); err == nil {
		*o = EvaluationResponse(varEvaluationResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "context")
		delete(additionalProperties, "is_valid")
		delete(additionalProperties, "messages")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableEvaluationResponse struct {
	value *EvaluationResponse
	isSet bool
}

func (v NullableEvaluationResponse) Get() *EvaluationResponse {
	return v.value
}

func (v *NullableEvaluationResponse) Set(val *EvaluationResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableEvaluationResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableEvaluationResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEvaluationResponse(val *EvaluationResponse) *NullableEvaluationResponse {
	return &NullableEvaluationResponse{value: val, isSet: true}
}

func (v NullableEvaluationResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEvaluationResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


