/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RepositoryAddCachedContent type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RepositoryAddCachedContent{}

// RepositoryAddCachedContent A mixin for validating unknown serializers' fields.
type RepositoryAddCachedContent struct {
	// A remote to use to identify content that was cached. This will override a remote set on repository.
	Remote *string `json:"remote,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RepositoryAddCachedContent RepositoryAddCachedContent

// NewRepositoryAddCachedContent instantiates a new RepositoryAddCachedContent object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRepositoryAddCachedContent() *RepositoryAddCachedContent {
	this := RepositoryAddCachedContent{}
	return &this
}

// NewRepositoryAddCachedContentWithDefaults instantiates a new RepositoryAddCachedContent object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRepositoryAddCachedContentWithDefaults() *RepositoryAddCachedContent {
	this := RepositoryAddCachedContent{}
	return &this
}

// GetRemote returns the Remote field value if set, zero value otherwise.
func (o *RepositoryAddCachedContent) GetRemote() string {
	if o == nil || IsNil(o.Remote) {
		var ret string
		return ret
	}
	return *o.Remote
}

// GetRemoteOk returns a tuple with the Remote field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RepositoryAddCachedContent) GetRemoteOk() (*string, bool) {
	if o == nil || IsNil(o.Remote) {
		return nil, false
	}
	return o.Remote, true
}

// HasRemote returns a boolean if a field has been set.
func (o *RepositoryAddCachedContent) HasRemote() bool {
	if o != nil && !IsNil(o.Remote) {
		return true
	}

	return false
}

// SetRemote gets a reference to the given string and assigns it to the Remote field.
func (o *RepositoryAddCachedContent) SetRemote(v string) {
	o.Remote = &v
}

func (o RepositoryAddCachedContent) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RepositoryAddCachedContent) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Remote) {
		toSerialize["remote"] = o.Remote
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RepositoryAddCachedContent) UnmarshalJSON(bytes []byte) (err error) {
	varRepositoryAddCachedContent := _RepositoryAddCachedContent{}

	if err = json.Unmarshal(bytes, &varRepositoryAddCachedContent); err == nil {
		*o = RepositoryAddCachedContent(varRepositoryAddCachedContent)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "remote")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRepositoryAddCachedContent struct {
	value *RepositoryAddCachedContent
	isSet bool
}

func (v NullableRepositoryAddCachedContent) Get() *RepositoryAddCachedContent {
	return v.value
}

func (v *NullableRepositoryAddCachedContent) Set(val *RepositoryAddCachedContent) {
	v.value = val
	v.isSet = true
}

func (v NullableRepositoryAddCachedContent) IsSet() bool {
	return v.isSet
}

func (v *NullableRepositoryAddCachedContent) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRepositoryAddCachedContent(val *RepositoryAddCachedContent) *NullableRepositoryAddCachedContent {
	return &NullableRepositoryAddCachedContent{value: val, isSet: true}
}

func (v NullableRepositoryAddCachedContent) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRepositoryAddCachedContent) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


