/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the CollectionVersionSignatureResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CollectionVersionSignatureResponse{}

// CollectionVersionSignatureResponse A serializer for the signatures on a Collection Version.
type CollectionVersionSignatureResponse struct {
	Signature *string `json:"signature,omitempty"`
	PubkeyFingerprint string `json:"pubkey_fingerprint"`
	SigningService NullableString `json:"signing_service,omitempty"`
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CollectionVersionSignatureResponse CollectionVersionSignatureResponse

// NewCollectionVersionSignatureResponse instantiates a new CollectionVersionSignatureResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCollectionVersionSignatureResponse(pubkeyFingerprint string) *CollectionVersionSignatureResponse {
	this := CollectionVersionSignatureResponse{}
	this.PubkeyFingerprint = pubkeyFingerprint
	return &this
}

// NewCollectionVersionSignatureResponseWithDefaults instantiates a new CollectionVersionSignatureResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCollectionVersionSignatureResponseWithDefaults() *CollectionVersionSignatureResponse {
	this := CollectionVersionSignatureResponse{}
	return &this
}

// GetSignature returns the Signature field value if set, zero value otherwise.
func (o *CollectionVersionSignatureResponse) GetSignature() string {
	if o == nil || IsNil(o.Signature) {
		var ret string
		return ret
	}
	return *o.Signature
}

// GetSignatureOk returns a tuple with the Signature field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionSignatureResponse) GetSignatureOk() (*string, bool) {
	if o == nil || IsNil(o.Signature) {
		return nil, false
	}
	return o.Signature, true
}

// HasSignature returns a boolean if a field has been set.
func (o *CollectionVersionSignatureResponse) HasSignature() bool {
	if o != nil && !IsNil(o.Signature) {
		return true
	}

	return false
}

// SetSignature gets a reference to the given string and assigns it to the Signature field.
func (o *CollectionVersionSignatureResponse) SetSignature(v string) {
	o.Signature = &v
}

// GetPubkeyFingerprint returns the PubkeyFingerprint field value
func (o *CollectionVersionSignatureResponse) GetPubkeyFingerprint() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.PubkeyFingerprint
}

// GetPubkeyFingerprintOk returns a tuple with the PubkeyFingerprint field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionSignatureResponse) GetPubkeyFingerprintOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PubkeyFingerprint, true
}

// SetPubkeyFingerprint sets field value
func (o *CollectionVersionSignatureResponse) SetPubkeyFingerprint(v string) {
	o.PubkeyFingerprint = v
}

// GetSigningService returns the SigningService field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CollectionVersionSignatureResponse) GetSigningService() string {
	if o == nil || IsNil(o.SigningService.Get()) {
		var ret string
		return ret
	}
	return *o.SigningService.Get()
}

// GetSigningServiceOk returns a tuple with the SigningService field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CollectionVersionSignatureResponse) GetSigningServiceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.SigningService.Get(), o.SigningService.IsSet()
}

// HasSigningService returns a boolean if a field has been set.
func (o *CollectionVersionSignatureResponse) HasSigningService() bool {
	if o != nil && o.SigningService.IsSet() {
		return true
	}

	return false
}

// SetSigningService gets a reference to the given NullableString and assigns it to the SigningService field.
func (o *CollectionVersionSignatureResponse) SetSigningService(v string) {
	o.SigningService.Set(&v)
}
// SetSigningServiceNil sets the value for SigningService to be an explicit nil
func (o *CollectionVersionSignatureResponse) SetSigningServiceNil() {
	o.SigningService.Set(nil)
}

// UnsetSigningService ensures that no value is present for SigningService, not even an explicit nil
func (o *CollectionVersionSignatureResponse) UnsetSigningService() {
	o.SigningService.Unset()
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *CollectionVersionSignatureResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionSignatureResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *CollectionVersionSignatureResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *CollectionVersionSignatureResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

func (o CollectionVersionSignatureResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CollectionVersionSignatureResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Signature) {
		toSerialize["signature"] = o.Signature
	}
	toSerialize["pubkey_fingerprint"] = o.PubkeyFingerprint
	if o.SigningService.IsSet() {
		toSerialize["signing_service"] = o.SigningService.Get()
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CollectionVersionSignatureResponse) UnmarshalJSON(bytes []byte) (err error) {
	varCollectionVersionSignatureResponse := _CollectionVersionSignatureResponse{}

	if err = json.Unmarshal(bytes, &varCollectionVersionSignatureResponse); err == nil {
		*o = CollectionVersionSignatureResponse(varCollectionVersionSignatureResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "signature")
		delete(additionalProperties, "pubkey_fingerprint")
		delete(additionalProperties, "signing_service")
		delete(additionalProperties, "pulp_created")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCollectionVersionSignatureResponse struct {
	value *CollectionVersionSignatureResponse
	isSet bool
}

func (v NullableCollectionVersionSignatureResponse) Get() *CollectionVersionSignatureResponse {
	return v.value
}

func (v *NullableCollectionVersionSignatureResponse) Set(val *CollectionVersionSignatureResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableCollectionVersionSignatureResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableCollectionVersionSignatureResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCollectionVersionSignatureResponse(val *CollectionVersionSignatureResponse) *NullableCollectionVersionSignatureResponse {
	return &NullableCollectionVersionSignatureResponse{value: val, isSet: true}
}

func (v NullableCollectionVersionSignatureResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCollectionVersionSignatureResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


