# Go API client for pulpclient

Fetch, Upload, Organize, and Distribute Software Packages

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: v3
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import pulpclient "github.com/osbuild/pulp-client/pulpclient"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), pulpclient.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), pulpclient.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```golang
ctx := context.WithValue(context.Background(), pulpclient.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), pulpclient.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessPoliciesAPI* | [**AccessPoliciesList**](docs/AccessPoliciesAPI.md#accesspolicieslist) | **Get** /pulp/api/v3/access_policies/ | List access policys
*AccessPoliciesAPI* | [**AccessPoliciesPartialUpdate**](docs/AccessPoliciesAPI.md#accesspoliciespartialupdate) | **Patch** {access_policy_href} | Update an access policy
*AccessPoliciesAPI* | [**AccessPoliciesRead**](docs/AccessPoliciesAPI.md#accesspoliciesread) | **Get** {access_policy_href} | Inspect an access policy
*AccessPoliciesAPI* | [**AccessPoliciesReset**](docs/AccessPoliciesAPI.md#accesspoliciesreset) | **Post** {access_policy_href}reset/ | 
*AccessPoliciesAPI* | [**AccessPoliciesUpdate**](docs/AccessPoliciesAPI.md#accesspoliciesupdate) | **Put** {access_policy_href} | Update an access policy
*AcsFileAPI* | [**AcsFileFileAddRole**](docs/AcsFileAPI.md#acsfilefileaddrole) | **Post** {file_file_alternate_content_source_href}add_role/ | 
*AcsFileAPI* | [**AcsFileFileCreate**](docs/AcsFileAPI.md#acsfilefilecreate) | **Post** /pulp/api/v3/acs/file/file/ | Create a file alternate content source
*AcsFileAPI* | [**AcsFileFileDelete**](docs/AcsFileAPI.md#acsfilefiledelete) | **Delete** {file_file_alternate_content_source_href} | Delete a file alternate content source
*AcsFileAPI* | [**AcsFileFileList**](docs/AcsFileAPI.md#acsfilefilelist) | **Get** /pulp/api/v3/acs/file/file/ | List file alternate content sources
*AcsFileAPI* | [**AcsFileFileListRoles**](docs/AcsFileAPI.md#acsfilefilelistroles) | **Get** {file_file_alternate_content_source_href}list_roles/ | 
*AcsFileAPI* | [**AcsFileFileMyPermissions**](docs/AcsFileAPI.md#acsfilefilemypermissions) | **Get** {file_file_alternate_content_source_href}my_permissions/ | 
*AcsFileAPI* | [**AcsFileFilePartialUpdate**](docs/AcsFileAPI.md#acsfilefilepartialupdate) | **Patch** {file_file_alternate_content_source_href} | Update a file alternate content source
*AcsFileAPI* | [**AcsFileFileRead**](docs/AcsFileAPI.md#acsfilefileread) | **Get** {file_file_alternate_content_source_href} | Inspect a file alternate content source
*AcsFileAPI* | [**AcsFileFileRefresh**](docs/AcsFileAPI.md#acsfilefilerefresh) | **Post** {file_file_alternate_content_source_href}refresh/ | Refresh metadata
*AcsFileAPI* | [**AcsFileFileRemoveRole**](docs/AcsFileAPI.md#acsfilefileremoverole) | **Post** {file_file_alternate_content_source_href}remove_role/ | 
*AcsFileAPI* | [**AcsFileFileUpdate**](docs/AcsFileAPI.md#acsfilefileupdate) | **Put** {file_file_alternate_content_source_href} | Update a file alternate content source
*AcsRpmAPI* | [**AcsRpmRpmAddRole**](docs/AcsRpmAPI.md#acsrpmrpmaddrole) | **Post** {rpm_rpm_alternate_content_source_href}add_role/ | 
*AcsRpmAPI* | [**AcsRpmRpmCreate**](docs/AcsRpmAPI.md#acsrpmrpmcreate) | **Post** /pulp/api/v3/acs/rpm/rpm/ | Create a rpm alternate content source
*AcsRpmAPI* | [**AcsRpmRpmDelete**](docs/AcsRpmAPI.md#acsrpmrpmdelete) | **Delete** {rpm_rpm_alternate_content_source_href} | Delete a rpm alternate content source
*AcsRpmAPI* | [**AcsRpmRpmList**](docs/AcsRpmAPI.md#acsrpmrpmlist) | **Get** /pulp/api/v3/acs/rpm/rpm/ | List rpm alternate content sources
*AcsRpmAPI* | [**AcsRpmRpmListRoles**](docs/AcsRpmAPI.md#acsrpmrpmlistroles) | **Get** {rpm_rpm_alternate_content_source_href}list_roles/ | 
*AcsRpmAPI* | [**AcsRpmRpmMyPermissions**](docs/AcsRpmAPI.md#acsrpmrpmmypermissions) | **Get** {rpm_rpm_alternate_content_source_href}my_permissions/ | 
*AcsRpmAPI* | [**AcsRpmRpmPartialUpdate**](docs/AcsRpmAPI.md#acsrpmrpmpartialupdate) | **Patch** {rpm_rpm_alternate_content_source_href} | Update a rpm alternate content source
*AcsRpmAPI* | [**AcsRpmRpmRead**](docs/AcsRpmAPI.md#acsrpmrpmread) | **Get** {rpm_rpm_alternate_content_source_href} | Inspect a rpm alternate content source
*AcsRpmAPI* | [**AcsRpmRpmRefresh**](docs/AcsRpmAPI.md#acsrpmrpmrefresh) | **Post** {rpm_rpm_alternate_content_source_href}refresh/ | 
*AcsRpmAPI* | [**AcsRpmRpmRemoveRole**](docs/AcsRpmAPI.md#acsrpmrpmremoverole) | **Post** {rpm_rpm_alternate_content_source_href}remove_role/ | 
*AcsRpmAPI* | [**AcsRpmRpmUpdate**](docs/AcsRpmAPI.md#acsrpmrpmupdate) | **Put** {rpm_rpm_alternate_content_source_href} | Update a rpm alternate content source
*AnsibleCollectionsAPI* | [**AnsibleCollectionsAddRole**](docs/AnsibleCollectionsAPI.md#ansiblecollectionsaddrole) | **Post** {ansible_collection_href}add_role/ | 
*AnsibleCollectionsAPI* | [**AnsibleCollectionsList**](docs/AnsibleCollectionsAPI.md#ansiblecollectionslist) | **Get** /pulp/api/v3/ansible/collections/ | List collections
*AnsibleCollectionsAPI* | [**AnsibleCollectionsListRoles**](docs/AnsibleCollectionsAPI.md#ansiblecollectionslistroles) | **Get** {ansible_collection_href}list_roles/ | 
*AnsibleCollectionsAPI* | [**AnsibleCollectionsMyPermissions**](docs/AnsibleCollectionsAPI.md#ansiblecollectionsmypermissions) | **Get** {ansible_collection_href}my_permissions/ | 
*AnsibleCollectionsAPI* | [**AnsibleCollectionsRemoveRole**](docs/AnsibleCollectionsAPI.md#ansiblecollectionsremoverole) | **Post** {ansible_collection_href}remove_role/ | 
*AnsibleCollectionsAPI* | [**UploadCollection**](docs/AnsibleCollectionsAPI.md#uploadcollection) | **Post** /ansible/collections/ | Upload a collection
*AnsibleCopyAPI* | [**CopyContent**](docs/AnsibleCopyAPI.md#copycontent) | **Post** /pulp/api/v3/ansible/copy/ | Copy content
*ApiCollectionsAPI* | [**ApiV2CollectionsGet**](docs/ApiCollectionsAPI.md#apiv2collectionsget) | **Get** {ansible_collection_href}api/v2/collections/ | 
*ApiCollectionsAPI* | [**ApiV2CollectionsPost**](docs/ApiCollectionsAPI.md#apiv2collectionspost) | **Post** {ansible_collection_href}api/v2/collections/ | 
*ApiRolesAPI* | [**ApiV1RolesGet**](docs/ApiRolesAPI.md#apiv1rolesget) | **Get** {ansible_role_href}api/v1/roles/ | 
*ArtifactsAPI* | [**ArtifactsCreate**](docs/ArtifactsAPI.md#artifactscreate) | **Post** /pulp/api/v3/artifacts/ | Create an artifact
*ArtifactsAPI* | [**ArtifactsDelete**](docs/ArtifactsAPI.md#artifactsdelete) | **Delete** {artifact_href} | Delete an artifact
*ArtifactsAPI* | [**ArtifactsList**](docs/ArtifactsAPI.md#artifactslist) | **Get** /pulp/api/v3/artifacts/ | List artifacts
*ArtifactsAPI* | [**ArtifactsRead**](docs/ArtifactsAPI.md#artifactsread) | **Get** {artifact_href} | Inspect an artifact
*CollectionImportAPI* | [**CollectionImportRead**](docs/CollectionImportAPI.md#collectionimportread) | **Get** {ansible_collection_import_href} | Inspect a collection import
*ContentAPI* | [**ContentList**](docs/ContentAPI.md#contentlist) | **Get** /pulp/api/v3/content/ | List content
*ContentAdvisoriesAPI* | [**ContentRpmAdvisoriesCreate**](docs/ContentAdvisoriesAPI.md#contentrpmadvisoriescreate) | **Post** /pulp/api/v3/content/rpm/advisories/ | Create an update record
*ContentAdvisoriesAPI* | [**ContentRpmAdvisoriesList**](docs/ContentAdvisoriesAPI.md#contentrpmadvisorieslist) | **Get** /pulp/api/v3/content/rpm/advisories/ | List update records
*ContentAdvisoriesAPI* | [**ContentRpmAdvisoriesRead**](docs/ContentAdvisoriesAPI.md#contentrpmadvisoriesread) | **Get** {rpm_update_record_href} | Inspect an update record
*ContentArtifactAPI* | [**ContentMavenArtifactCreate**](docs/ContentArtifactAPI.md#contentmavenartifactcreate) | **Post** /pulp/api/v3/content/maven/artifact/ | Create a maven artifact
*ContentArtifactAPI* | [**ContentMavenArtifactList**](docs/ContentArtifactAPI.md#contentmavenartifactlist) | **Get** /pulp/api/v3/content/maven/artifact/ | List maven artifacts
*ContentArtifactAPI* | [**ContentMavenArtifactRead**](docs/ContentArtifactAPI.md#contentmavenartifactread) | **Get** {maven_maven_artifact_href} | Inspect a maven artifact
*ContentBlobsAPI* | [**ContentContainerBlobsList**](docs/ContentBlobsAPI.md#contentcontainerblobslist) | **Get** /pulp/api/v3/content/container/blobs/ | List blobs
*ContentBlobsAPI* | [**ContentContainerBlobsRead**](docs/ContentBlobsAPI.md#contentcontainerblobsread) | **Get** {container_blob_href} | Inspect a blob
*ContentCollectionDeprecationsAPI* | [**ContentAnsibleCollectionDeprecationsCreate**](docs/ContentCollectionDeprecationsAPI.md#contentansiblecollectiondeprecationscreate) | **Post** /pulp/api/v3/content/ansible/collection_deprecations/ | Create an ansible collection deprecated
*ContentCollectionDeprecationsAPI* | [**ContentAnsibleCollectionDeprecationsList**](docs/ContentCollectionDeprecationsAPI.md#contentansiblecollectiondeprecationslist) | **Get** /pulp/api/v3/content/ansible/collection_deprecations/ | List ansible collection deprecateds
*ContentCollectionDeprecationsAPI* | [**ContentAnsibleCollectionDeprecationsRead**](docs/ContentCollectionDeprecationsAPI.md#contentansiblecollectiondeprecationsread) | **Get** {ansible_ansible_collection_deprecated_href} | Inspect an ansible collection deprecated
*ContentCollectionMarksAPI* | [**ContentAnsibleCollectionMarksCreate**](docs/ContentCollectionMarksAPI.md#contentansiblecollectionmarkscreate) | **Post** /pulp/api/v3/content/ansible/collection_marks/ | Create a collection version mark
*ContentCollectionMarksAPI* | [**ContentAnsibleCollectionMarksList**](docs/ContentCollectionMarksAPI.md#contentansiblecollectionmarkslist) | **Get** /pulp/api/v3/content/ansible/collection_marks/ | List collection version marks
*ContentCollectionMarksAPI* | [**ContentAnsibleCollectionMarksRead**](docs/ContentCollectionMarksAPI.md#contentansiblecollectionmarksread) | **Get** {ansible_collection_version_mark_href} | Inspect a collection version mark
*ContentCollectionSignaturesAPI* | [**ContentAnsibleCollectionSignaturesCreate**](docs/ContentCollectionSignaturesAPI.md#contentansiblecollectionsignaturescreate) | **Post** /pulp/api/v3/content/ansible/collection_signatures/ | Create a collection version signature
*ContentCollectionSignaturesAPI* | [**ContentAnsibleCollectionSignaturesList**](docs/ContentCollectionSignaturesAPI.md#contentansiblecollectionsignatureslist) | **Get** /pulp/api/v3/content/ansible/collection_signatures/ | List collection version signatures
*ContentCollectionSignaturesAPI* | [**ContentAnsibleCollectionSignaturesRead**](docs/ContentCollectionSignaturesAPI.md#contentansiblecollectionsignaturesread) | **Get** {ansible_collection_version_signature_href} | Inspect a collection version signature
*ContentCollectionVersionsAPI* | [**ContentAnsibleCollectionVersionsCreate**](docs/ContentCollectionVersionsAPI.md#contentansiblecollectionversionscreate) | **Post** /pulp/api/v3/content/ansible/collection_versions/ | Create a collection version
*ContentCollectionVersionsAPI* | [**ContentAnsibleCollectionVersionsList**](docs/ContentCollectionVersionsAPI.md#contentansiblecollectionversionslist) | **Get** /pulp/api/v3/content/ansible/collection_versions/ | List collection versions
*ContentCollectionVersionsAPI* | [**ContentAnsibleCollectionVersionsRead**](docs/ContentCollectionVersionsAPI.md#contentansiblecollectionversionsread) | **Get** {ansible_collection_version_href} | Inspect a collection version
*ContentCommitsAPI* | [**ContentOstreeCommitsList**](docs/ContentCommitsAPI.md#contentostreecommitslist) | **Get** /pulp/api/v3/content/ostree/commits/ | List ostree commits
*ContentCommitsAPI* | [**ContentOstreeCommitsRead**](docs/ContentCommitsAPI.md#contentostreecommitsread) | **Get** {ostree_ostree_commit_href} | Inspect an ostree commit
*ContentConfigsAPI* | [**ContentOstreeConfigsList**](docs/ContentConfigsAPI.md#contentostreeconfigslist) | **Get** /pulp/api/v3/content/ostree/configs/ | List ostree configs
*ContentConfigsAPI* | [**ContentOstreeConfigsRead**](docs/ContentConfigsAPI.md#contentostreeconfigsread) | **Get** {ostree_ostree_config_href} | Inspect an ostree config
*ContentContentAPI* | [**ContentOstreeContentList**](docs/ContentContentAPI.md#contentostreecontentlist) | **Get** /pulp/api/v3/content/ostree/content/ | List ostree contents
*ContentContentAPI* | [**ContentOstreeContentRead**](docs/ContentContentAPI.md#contentostreecontentread) | **Get** {ostree_ostree_content_href} | Inspect an ostree content
*ContentDistributionTreesAPI* | [**ContentRpmDistributionTreesList**](docs/ContentDistributionTreesAPI.md#contentrpmdistributiontreeslist) | **Get** /pulp/api/v3/content/rpm/distribution_trees/ | List distribution trees
*ContentDistributionTreesAPI* | [**ContentRpmDistributionTreesRead**](docs/ContentDistributionTreesAPI.md#contentrpmdistributiontreesread) | **Get** {rpm_distribution_tree_href} | Inspect a distribution tree
*ContentFilesAPI* | [**ContentFileFilesCreate**](docs/ContentFilesAPI.md#contentfilefilescreate) | **Post** /pulp/api/v3/content/file/files/ | Create a file content
*ContentFilesAPI* | [**ContentFileFilesList**](docs/ContentFilesAPI.md#contentfilefileslist) | **Get** /pulp/api/v3/content/file/files/ | List file contents
*ContentFilesAPI* | [**ContentFileFilesRead**](docs/ContentFilesAPI.md#contentfilefilesread) | **Get** {file_file_content_href} | Inspect a file content
*ContentGemAPI* | [**ContentGemGemCreate**](docs/ContentGemAPI.md#contentgemgemcreate) | **Post** /pulp/api/v3/content/gem/gem/ | Create a gem content
*ContentGemAPI* | [**ContentGemGemList**](docs/ContentGemAPI.md#contentgemgemlist) | **Get** /pulp/api/v3/content/gem/gem/ | List gem contents
*ContentGemAPI* | [**ContentGemGemRead**](docs/ContentGemAPI.md#contentgemgemread) | **Get** {gem_gem_content_href} | Inspect a gem content
*ContentGenericContentsAPI* | [**ContentDebGenericContentsCreate**](docs/ContentGenericContentsAPI.md#contentdebgenericcontentscreate) | **Post** /pulp/api/v3/content/deb/generic_contents/ | Create a generic content
*ContentGenericContentsAPI* | [**ContentDebGenericContentsList**](docs/ContentGenericContentsAPI.md#contentdebgenericcontentslist) | **Get** /pulp/api/v3/content/deb/generic_contents/ | List generic contents
*ContentGenericContentsAPI* | [**ContentDebGenericContentsRead**](docs/ContentGenericContentsAPI.md#contentdebgenericcontentsread) | **Get** {deb_generic_content_href} | Inspect a generic content
*ContentInstallerFileIndicesAPI* | [**ContentDebInstallerFileIndicesCreate**](docs/ContentInstallerFileIndicesAPI.md#contentdebinstallerfileindicescreate) | **Post** /pulp/api/v3/content/deb/installer_file_indices/ | Create an installer file index
*ContentInstallerFileIndicesAPI* | [**ContentDebInstallerFileIndicesList**](docs/ContentInstallerFileIndicesAPI.md#contentdebinstallerfileindiceslist) | **Get** /pulp/api/v3/content/deb/installer_file_indices/ | List InstallerFileIndices
*ContentInstallerFileIndicesAPI* | [**ContentDebInstallerFileIndicesRead**](docs/ContentInstallerFileIndicesAPI.md#contentdebinstallerfileindicesread) | **Get** {deb_installer_file_index_href} | Inspect an installer file index
*ContentInstallerPackagesAPI* | [**ContentDebInstallerPackagesCreate**](docs/ContentInstallerPackagesAPI.md#contentdebinstallerpackagescreate) | **Post** /pulp/api/v3/content/deb/installer_packages/ | Create an installer package
*ContentInstallerPackagesAPI* | [**ContentDebInstallerPackagesList**](docs/ContentInstallerPackagesAPI.md#contentdebinstallerpackageslist) | **Get** /pulp/api/v3/content/deb/installer_packages/ | List installer packages
*ContentInstallerPackagesAPI* | [**ContentDebInstallerPackagesRead**](docs/ContentInstallerPackagesAPI.md#contentdebinstallerpackagesread) | **Get** {deb_installer_package_href} | Inspect an installer package
*ContentManifestsAPI* | [**ContentContainerManifestsList**](docs/ContentManifestsAPI.md#contentcontainermanifestslist) | **Get** /pulp/api/v3/content/container/manifests/ | List manifests
*ContentManifestsAPI* | [**ContentContainerManifestsRead**](docs/ContentManifestsAPI.md#contentcontainermanifestsread) | **Get** {container_manifest_href} | Inspect a manifest
*ContentModulemdDefaultsAPI* | [**ContentRpmModulemdDefaultsCreate**](docs/ContentModulemdDefaultsAPI.md#contentrpmmodulemddefaultscreate) | **Post** /pulp/api/v3/content/rpm/modulemd_defaults/ | Create a modulemd defaults
*ContentModulemdDefaultsAPI* | [**ContentRpmModulemdDefaultsList**](docs/ContentModulemdDefaultsAPI.md#contentrpmmodulemddefaultslist) | **Get** /pulp/api/v3/content/rpm/modulemd_defaults/ | List modulemd defaultss
*ContentModulemdDefaultsAPI* | [**ContentRpmModulemdDefaultsRead**](docs/ContentModulemdDefaultsAPI.md#contentrpmmodulemddefaultsread) | **Get** {rpm_modulemd_defaults_href} | Inspect a modulemd defaults
*ContentModulemdObsoletesAPI* | [**ContentRpmModulemdObsoletesCreate**](docs/ContentModulemdObsoletesAPI.md#contentrpmmodulemdobsoletescreate) | **Post** /pulp/api/v3/content/rpm/modulemd_obsoletes/ | Create a modulemd obsolete
*ContentModulemdObsoletesAPI* | [**ContentRpmModulemdObsoletesList**](docs/ContentModulemdObsoletesAPI.md#contentrpmmodulemdobsoleteslist) | **Get** /pulp/api/v3/content/rpm/modulemd_obsoletes/ | List modulemd obsoletes
*ContentModulemdObsoletesAPI* | [**ContentRpmModulemdObsoletesRead**](docs/ContentModulemdObsoletesAPI.md#contentrpmmodulemdobsoletesread) | **Get** {rpm_modulemd_obsolete_href} | Inspect a modulemd obsolete
*ContentModulemdsAPI* | [**ContentRpmModulemdsCreate**](docs/ContentModulemdsAPI.md#contentrpmmodulemdscreate) | **Post** /pulp/api/v3/content/rpm/modulemds/ | Create a modulemd
*ContentModulemdsAPI* | [**ContentRpmModulemdsList**](docs/ContentModulemdsAPI.md#contentrpmmodulemdslist) | **Get** /pulp/api/v3/content/rpm/modulemds/ | List modulemds
*ContentModulemdsAPI* | [**ContentRpmModulemdsRead**](docs/ContentModulemdsAPI.md#contentrpmmodulemdsread) | **Get** {rpm_modulemd_href} | Inspect a modulemd
*ContentNamespacesAPI* | [**ContentAnsibleNamespacesAvatar**](docs/ContentNamespacesAPI.md#contentansiblenamespacesavatar) | **Get** {ansible_ansible_namespace_metadata_href}avatar/ | 
*ContentNamespacesAPI* | [**ContentAnsibleNamespacesList**](docs/ContentNamespacesAPI.md#contentansiblenamespaceslist) | **Get** /pulp/api/v3/content/ansible/namespaces/ | List ansible namespace metadatas
*ContentNamespacesAPI* | [**ContentAnsibleNamespacesRead**](docs/ContentNamespacesAPI.md#contentansiblenamespacesread) | **Get** {ansible_ansible_namespace_metadata_href} | Inspect an ansible namespace metadata
*ContentObjectsAPI* | [**ContentOstreeObjectsList**](docs/ContentObjectsAPI.md#contentostreeobjectslist) | **Get** /pulp/api/v3/content/ostree/objects/ | List ostree objects
*ContentObjectsAPI* | [**ContentOstreeObjectsRead**](docs/ContentObjectsAPI.md#contentostreeobjectsread) | **Get** {ostree_ostree_object_href} | Inspect an ostree object
*ContentPackageIndicesAPI* | [**ContentDebPackageIndicesCreate**](docs/ContentPackageIndicesAPI.md#contentdebpackageindicescreate) | **Post** /pulp/api/v3/content/deb/package_indices/ | Create a package index
*ContentPackageIndicesAPI* | [**ContentDebPackageIndicesList**](docs/ContentPackageIndicesAPI.md#contentdebpackageindiceslist) | **Get** /pulp/api/v3/content/deb/package_indices/ | List PackageIndices
*ContentPackageIndicesAPI* | [**ContentDebPackageIndicesRead**](docs/ContentPackageIndicesAPI.md#contentdebpackageindicesread) | **Get** {deb_package_index_href} | Inspect a package index
*ContentPackageReleaseComponentsAPI* | [**ContentDebPackageReleaseComponentsCreate**](docs/ContentPackageReleaseComponentsAPI.md#contentdebpackagereleasecomponentscreate) | **Post** /pulp/api/v3/content/deb/package_release_components/ | Create a package release component
*ContentPackageReleaseComponentsAPI* | [**ContentDebPackageReleaseComponentsList**](docs/ContentPackageReleaseComponentsAPI.md#contentdebpackagereleasecomponentslist) | **Get** /pulp/api/v3/content/deb/package_release_components/ | List package release components
*ContentPackageReleaseComponentsAPI* | [**ContentDebPackageReleaseComponentsRead**](docs/ContentPackageReleaseComponentsAPI.md#contentdebpackagereleasecomponentsread) | **Get** {deb_package_release_component_href} | Inspect a package release component
*ContentPackagecategoriesAPI* | [**ContentRpmPackagecategoriesList**](docs/ContentPackagecategoriesAPI.md#contentrpmpackagecategorieslist) | **Get** /pulp/api/v3/content/rpm/packagecategories/ | List package categorys
*ContentPackagecategoriesAPI* | [**ContentRpmPackagecategoriesRead**](docs/ContentPackagecategoriesAPI.md#contentrpmpackagecategoriesread) | **Get** {rpm_package_category_href} | Inspect a package category
*ContentPackageenvironmentsAPI* | [**ContentRpmPackageenvironmentsList**](docs/ContentPackageenvironmentsAPI.md#contentrpmpackageenvironmentslist) | **Get** /pulp/api/v3/content/rpm/packageenvironments/ | List package environments
*ContentPackageenvironmentsAPI* | [**ContentRpmPackageenvironmentsRead**](docs/ContentPackageenvironmentsAPI.md#contentrpmpackageenvironmentsread) | **Get** {rpm_package_environment_href} | Inspect a package environment
*ContentPackagegroupsAPI* | [**ContentRpmPackagegroupsList**](docs/ContentPackagegroupsAPI.md#contentrpmpackagegroupslist) | **Get** /pulp/api/v3/content/rpm/packagegroups/ | List package groups
*ContentPackagegroupsAPI* | [**ContentRpmPackagegroupsRead**](docs/ContentPackagegroupsAPI.md#contentrpmpackagegroupsread) | **Get** {rpm_package_group_href} | Inspect a package group
*ContentPackagelangpacksAPI* | [**ContentRpmPackagelangpacksList**](docs/ContentPackagelangpacksAPI.md#contentrpmpackagelangpackslist) | **Get** /pulp/api/v3/content/rpm/packagelangpacks/ | List package langpackss
*ContentPackagelangpacksAPI* | [**ContentRpmPackagelangpacksRead**](docs/ContentPackagelangpacksAPI.md#contentrpmpackagelangpacksread) | **Get** {rpm_package_langpacks_href} | Inspect a package langpacks
*ContentPackagesAPI* | [**ContentDebPackagesCreate**](docs/ContentPackagesAPI.md#contentdebpackagescreate) | **Post** /pulp/api/v3/content/deb/packages/ | Create a package
*ContentPackagesAPI* | [**ContentDebPackagesList**](docs/ContentPackagesAPI.md#contentdebpackageslist) | **Get** /pulp/api/v3/content/deb/packages/ | List packages
*ContentPackagesAPI* | [**ContentDebPackagesRead**](docs/ContentPackagesAPI.md#contentdebpackagesread) | **Get** {deb_package_href} | Inspect a package
*ContentPackagesAPI* | [**ContentPythonPackagesCreate**](docs/ContentPackagesAPI.md#contentpythonpackagescreate) | **Post** /pulp/api/v3/content/python/packages/ | Create a python package content
*ContentPackagesAPI* | [**ContentPythonPackagesList**](docs/ContentPackagesAPI.md#contentpythonpackageslist) | **Get** /pulp/api/v3/content/python/packages/ | List python package contents
*ContentPackagesAPI* | [**ContentPythonPackagesRead**](docs/ContentPackagesAPI.md#contentpythonpackagesread) | **Get** {python_python_package_content_href} | Inspect a python package content
*ContentPackagesAPI* | [**ContentRpmPackagesCreate**](docs/ContentPackagesAPI.md#contentrpmpackagescreate) | **Post** /pulp/api/v3/content/rpm/packages/ | Create a package
*ContentPackagesAPI* | [**ContentRpmPackagesList**](docs/ContentPackagesAPI.md#contentrpmpackageslist) | **Get** /pulp/api/v3/content/rpm/packages/ | List packages
*ContentPackagesAPI* | [**ContentRpmPackagesRead**](docs/ContentPackagesAPI.md#contentrpmpackagesread) | **Get** {rpm_package_href} | Inspect a package
*ContentRefsAPI* | [**ContentOstreeRefsList**](docs/ContentRefsAPI.md#contentostreerefslist) | **Get** /pulp/api/v3/content/ostree/refs/ | List ostree refs
*ContentRefsAPI* | [**ContentOstreeRefsRead**](docs/ContentRefsAPI.md#contentostreerefsread) | **Get** {ostree_ostree_ref_href} | Inspect an ostree ref
*ContentReleaseArchitecturesAPI* | [**ContentDebReleaseArchitecturesCreate**](docs/ContentReleaseArchitecturesAPI.md#contentdebreleasearchitecturescreate) | **Post** /pulp/api/v3/content/deb/release_architectures/ | Create a release architecture
*ContentReleaseArchitecturesAPI* | [**ContentDebReleaseArchitecturesList**](docs/ContentReleaseArchitecturesAPI.md#contentdebreleasearchitectureslist) | **Get** /pulp/api/v3/content/deb/release_architectures/ | List release architectures
*ContentReleaseArchitecturesAPI* | [**ContentDebReleaseArchitecturesRead**](docs/ContentReleaseArchitecturesAPI.md#contentdebreleasearchitecturesread) | **Get** {deb_release_architecture_href} | Inspect a release architecture
*ContentReleaseComponentsAPI* | [**ContentDebReleaseComponentsCreate**](docs/ContentReleaseComponentsAPI.md#contentdebreleasecomponentscreate) | **Post** /pulp/api/v3/content/deb/release_components/ | Create a release component
*ContentReleaseComponentsAPI* | [**ContentDebReleaseComponentsList**](docs/ContentReleaseComponentsAPI.md#contentdebreleasecomponentslist) | **Get** /pulp/api/v3/content/deb/release_components/ | List release components
*ContentReleaseComponentsAPI* | [**ContentDebReleaseComponentsRead**](docs/ContentReleaseComponentsAPI.md#contentdebreleasecomponentsread) | **Get** {deb_release_component_href} | Inspect a release component
*ContentReleaseFilesAPI* | [**ContentDebReleaseFilesCreate**](docs/ContentReleaseFilesAPI.md#contentdebreleasefilescreate) | **Post** /pulp/api/v3/content/deb/release_files/ | Create a release file
*ContentReleaseFilesAPI* | [**ContentDebReleaseFilesList**](docs/ContentReleaseFilesAPI.md#contentdebreleasefileslist) | **Get** /pulp/api/v3/content/deb/release_files/ | List release files
*ContentReleaseFilesAPI* | [**ContentDebReleaseFilesRead**](docs/ContentReleaseFilesAPI.md#contentdebreleasefilesread) | **Get** {deb_release_file_href} | Inspect a release file
*ContentReleasesAPI* | [**ContentDebReleasesCreate**](docs/ContentReleasesAPI.md#contentdebreleasescreate) | **Post** /pulp/api/v3/content/deb/releases/ | Create a release
*ContentReleasesAPI* | [**ContentDebReleasesList**](docs/ContentReleasesAPI.md#contentdebreleaseslist) | **Get** /pulp/api/v3/content/deb/releases/ | List releases
*ContentReleasesAPI* | [**ContentDebReleasesRead**](docs/ContentReleasesAPI.md#contentdebreleasesread) | **Get** {deb_release_href} | Inspect a release
*ContentRepoMetadataFilesAPI* | [**ContentRpmRepoMetadataFilesList**](docs/ContentRepoMetadataFilesAPI.md#contentrpmrepometadatafileslist) | **Get** /pulp/api/v3/content/rpm/repo_metadata_files/ | List repo metadata files
*ContentRepoMetadataFilesAPI* | [**ContentRpmRepoMetadataFilesRead**](docs/ContentRepoMetadataFilesAPI.md#contentrpmrepometadatafilesread) | **Get** {rpm_repo_metadata_file_href} | Inspect a repo metadata file
*ContentRolesAPI* | [**ContentAnsibleRolesCreate**](docs/ContentRolesAPI.md#contentansiblerolescreate) | **Post** /pulp/api/v3/content/ansible/roles/ | Create a role
*ContentRolesAPI* | [**ContentAnsibleRolesList**](docs/ContentRolesAPI.md#contentansibleroleslist) | **Get** /pulp/api/v3/content/ansible/roles/ | List roles
*ContentRolesAPI* | [**ContentAnsibleRolesRead**](docs/ContentRolesAPI.md#contentansiblerolesread) | **Get** {ansible_role_href} | Inspect a role
*ContentSignaturesAPI* | [**ContentContainerSignaturesList**](docs/ContentSignaturesAPI.md#contentcontainersignatureslist) | **Get** /pulp/api/v3/content/container/signatures/ | List manifest signatures
*ContentSignaturesAPI* | [**ContentContainerSignaturesRead**](docs/ContentSignaturesAPI.md#contentcontainersignaturesread) | **Get** {container_manifest_signature_href} | Inspect a manifest signature
*ContentSummariesAPI* | [**ContentOstreeSummariesList**](docs/ContentSummariesAPI.md#contentostreesummarieslist) | **Get** /pulp/api/v3/content/ostree/summaries/ | List ostree summarys
*ContentSummariesAPI* | [**ContentOstreeSummariesRead**](docs/ContentSummariesAPI.md#contentostreesummariesread) | **Get** {ostree_ostree_summary_href} | Inspect an ostree summary
*ContentTagsAPI* | [**ContentContainerTagsList**](docs/ContentTagsAPI.md#contentcontainertagslist) | **Get** /pulp/api/v3/content/container/tags/ | List tags
*ContentTagsAPI* | [**ContentContainerTagsRead**](docs/ContentTagsAPI.md#contentcontainertagsread) | **Get** {container_tag_href} | Inspect a tag
*ContentguardsAPI* | [**ContentguardsList**](docs/ContentguardsAPI.md#contentguardslist) | **Get** /pulp/api/v3/contentguards/ | List content guards
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectAddRole**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectaddrole) | **Post** {content_redirect_content_guard_href}add_role/ | 
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectCreate**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectcreate) | **Post** /pulp/api/v3/contentguards/core/content_redirect/ | Create a content redirect content guard
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectDelete**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectdelete) | **Delete** {content_redirect_content_guard_href} | Delete a content redirect content guard
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectList**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectlist) | **Get** /pulp/api/v3/contentguards/core/content_redirect/ | List content redirect content guards
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectListRoles**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectlistroles) | **Get** {content_redirect_content_guard_href}list_roles/ | 
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectMyPermissions**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectmypermissions) | **Get** {content_redirect_content_guard_href}my_permissions/ | 
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectPartialUpdate**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectpartialupdate) | **Patch** {content_redirect_content_guard_href} | Update a content redirect content guard
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectRead**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectread) | **Get** {content_redirect_content_guard_href} | Inspect a content redirect content guard
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectRemoveRole**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectremoverole) | **Post** {content_redirect_content_guard_href}remove_role/ | 
*ContentguardsContentRedirectAPI* | [**ContentguardsCoreContentRedirectUpdate**](docs/ContentguardsContentRedirectAPI.md#contentguardscorecontentredirectupdate) | **Put** {content_redirect_content_guard_href} | Update a content redirect content guard
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacAddRole**](docs/ContentguardsRbacAPI.md#contentguardscorerbacaddrole) | **Post** {r_b_a_c_content_guard_href}add_role/ | 
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacCreate**](docs/ContentguardsRbacAPI.md#contentguardscorerbaccreate) | **Post** /pulp/api/v3/contentguards/core/rbac/ | Create a rbac content guard
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacDelete**](docs/ContentguardsRbacAPI.md#contentguardscorerbacdelete) | **Delete** {r_b_a_c_content_guard_href} | Delete a rbac content guard
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacList**](docs/ContentguardsRbacAPI.md#contentguardscorerbaclist) | **Get** /pulp/api/v3/contentguards/core/rbac/ | List rbac content guards
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacListRoles**](docs/ContentguardsRbacAPI.md#contentguardscorerbaclistroles) | **Get** {r_b_a_c_content_guard_href}list_roles/ | 
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacMyPermissions**](docs/ContentguardsRbacAPI.md#contentguardscorerbacmypermissions) | **Get** {r_b_a_c_content_guard_href}my_permissions/ | 
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacPartialUpdate**](docs/ContentguardsRbacAPI.md#contentguardscorerbacpartialupdate) | **Patch** {r_b_a_c_content_guard_href} | Update a rbac content guard
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacRead**](docs/ContentguardsRbacAPI.md#contentguardscorerbacread) | **Get** {r_b_a_c_content_guard_href} | Inspect a rbac content guard
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacRemoveRole**](docs/ContentguardsRbacAPI.md#contentguardscorerbacremoverole) | **Post** {r_b_a_c_content_guard_href}remove_role/ | 
*ContentguardsRbacAPI* | [**ContentguardsCoreRbacUpdate**](docs/ContentguardsRbacAPI.md#contentguardscorerbacupdate) | **Put** {r_b_a_c_content_guard_href} | Update a rbac content guard
*ContentguardsRhsmAPI* | [**ContentguardsCertguardRhsmCreate**](docs/ContentguardsRhsmAPI.md#contentguardscertguardrhsmcreate) | **Post** /pulp/api/v3/contentguards/certguard/rhsm/ | Create a rhsm cert guard
*ContentguardsRhsmAPI* | [**ContentguardsCertguardRhsmDelete**](docs/ContentguardsRhsmAPI.md#contentguardscertguardrhsmdelete) | **Delete** {certguard_r_h_s_m_cert_guard_href} | Delete a rhsm cert guard
*ContentguardsRhsmAPI* | [**ContentguardsCertguardRhsmList**](docs/ContentguardsRhsmAPI.md#contentguardscertguardrhsmlist) | **Get** /pulp/api/v3/contentguards/certguard/rhsm/ | List rhsm cert guards
*ContentguardsRhsmAPI* | [**ContentguardsCertguardRhsmPartialUpdate**](docs/ContentguardsRhsmAPI.md#contentguardscertguardrhsmpartialupdate) | **Patch** {certguard_r_h_s_m_cert_guard_href} | Update a rhsm cert guard
*ContentguardsRhsmAPI* | [**ContentguardsCertguardRhsmRead**](docs/ContentguardsRhsmAPI.md#contentguardscertguardrhsmread) | **Get** {certguard_r_h_s_m_cert_guard_href} | Inspect a rhsm cert guard
*ContentguardsRhsmAPI* | [**ContentguardsCertguardRhsmUpdate**](docs/ContentguardsRhsmAPI.md#contentguardscertguardrhsmupdate) | **Put** {certguard_r_h_s_m_cert_guard_href} | Update a rhsm cert guard
*ContentguardsX509API* | [**ContentguardsCertguardX509Create**](docs/ContentguardsX509API.md#contentguardscertguardx509create) | **Post** /pulp/api/v3/contentguards/certguard/x509/ | Create a x509 cert guard
*ContentguardsX509API* | [**ContentguardsCertguardX509Delete**](docs/ContentguardsX509API.md#contentguardscertguardx509delete) | **Delete** {certguard_x509_cert_guard_href} | Delete a x509 cert guard
*ContentguardsX509API* | [**ContentguardsCertguardX509List**](docs/ContentguardsX509API.md#contentguardscertguardx509list) | **Get** /pulp/api/v3/contentguards/certguard/x509/ | List x509 cert guards
*ContentguardsX509API* | [**ContentguardsCertguardX509PartialUpdate**](docs/ContentguardsX509API.md#contentguardscertguardx509partialupdate) | **Patch** {certguard_x509_cert_guard_href} | Update a x509 cert guard
*ContentguardsX509API* | [**ContentguardsCertguardX509Read**](docs/ContentguardsX509API.md#contentguardscertguardx509read) | **Get** {certguard_x509_cert_guard_href} | Inspect a x509 cert guard
*ContentguardsX509API* | [**ContentguardsCertguardX509Update**](docs/ContentguardsX509API.md#contentguardscertguardx509update) | **Put** {certguard_x509_cert_guard_href} | Update a x509 cert guard
*DebCopyAPI* | [**CopyContent**](docs/DebCopyAPI.md#copycontent) | **Post** /pulp/api/v3/deb/copy/ | Copy content
*DistributionsAPI* | [**DistributionsList**](docs/DistributionsAPI.md#distributionslist) | **Get** /pulp/api/v3/distributions/ | List distributions
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleAddRole**](docs/DistributionsAnsibleAPI.md#distributionsansibleansibleaddrole) | **Post** {ansible_ansible_distribution_href}add_role/ | 
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleCreate**](docs/DistributionsAnsibleAPI.md#distributionsansibleansiblecreate) | **Post** /pulp/api/v3/distributions/ansible/ansible/ | Create an ansible distribution
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleDelete**](docs/DistributionsAnsibleAPI.md#distributionsansibleansibledelete) | **Delete** {ansible_ansible_distribution_href} | Delete an ansible distribution
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleList**](docs/DistributionsAnsibleAPI.md#distributionsansibleansiblelist) | **Get** /pulp/api/v3/distributions/ansible/ansible/ | List ansible distributions
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleListRoles**](docs/DistributionsAnsibleAPI.md#distributionsansibleansiblelistroles) | **Get** {ansible_ansible_distribution_href}list_roles/ | 
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleMyPermissions**](docs/DistributionsAnsibleAPI.md#distributionsansibleansiblemypermissions) | **Get** {ansible_ansible_distribution_href}my_permissions/ | 
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsiblePartialUpdate**](docs/DistributionsAnsibleAPI.md#distributionsansibleansiblepartialupdate) | **Patch** {ansible_ansible_distribution_href} | Update an ansible distribution
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleRead**](docs/DistributionsAnsibleAPI.md#distributionsansibleansibleread) | **Get** {ansible_ansible_distribution_href} | Inspect an ansible distribution
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleRemoveRole**](docs/DistributionsAnsibleAPI.md#distributionsansibleansibleremoverole) | **Post** {ansible_ansible_distribution_href}remove_role/ | 
*DistributionsAnsibleAPI* | [**DistributionsAnsibleAnsibleUpdate**](docs/DistributionsAnsibleAPI.md#distributionsansibleansibleupdate) | **Put** {ansible_ansible_distribution_href} | Update an ansible distribution
*DistributionsAptAPI* | [**DistributionsDebAptCreate**](docs/DistributionsAptAPI.md#distributionsdebaptcreate) | **Post** /pulp/api/v3/distributions/deb/apt/ | Create an apt distribution
*DistributionsAptAPI* | [**DistributionsDebAptDelete**](docs/DistributionsAptAPI.md#distributionsdebaptdelete) | **Delete** {deb_apt_distribution_href} | Delete an apt distribution
*DistributionsAptAPI* | [**DistributionsDebAptList**](docs/DistributionsAptAPI.md#distributionsdebaptlist) | **Get** /pulp/api/v3/distributions/deb/apt/ | List apt distributions
*DistributionsAptAPI* | [**DistributionsDebAptPartialUpdate**](docs/DistributionsAptAPI.md#distributionsdebaptpartialupdate) | **Patch** {deb_apt_distribution_href} | Update an apt distribution
*DistributionsAptAPI* | [**DistributionsDebAptRead**](docs/DistributionsAptAPI.md#distributionsdebaptread) | **Get** {deb_apt_distribution_href} | Inspect an apt distribution
*DistributionsAptAPI* | [**DistributionsDebAptUpdate**](docs/DistributionsAptAPI.md#distributionsdebaptupdate) | **Put** {deb_apt_distribution_href} | Update an apt distribution
*DistributionsArtifactsAPI* | [**DistributionsCoreArtifactsList**](docs/DistributionsArtifactsAPI.md#distributionscoreartifactslist) | **Get** /pulp/api/v3/distributions/core/artifacts/ | List artifact distributions
*DistributionsArtifactsAPI* | [**DistributionsCoreArtifactsRead**](docs/DistributionsArtifactsAPI.md#distributionscoreartifactsread) | **Get** {artifact_distribution_href} | Inspect an artifact distribution
*DistributionsContainerAPI* | [**DistributionsContainerContainerAddRole**](docs/DistributionsContainerAPI.md#distributionscontainercontaineraddrole) | **Post** {container_container_distribution_href}add_role/ | 
*DistributionsContainerAPI* | [**DistributionsContainerContainerCreate**](docs/DistributionsContainerAPI.md#distributionscontainercontainercreate) | **Post** /pulp/api/v3/distributions/container/container/ | Create a container distribution
*DistributionsContainerAPI* | [**DistributionsContainerContainerDelete**](docs/DistributionsContainerAPI.md#distributionscontainercontainerdelete) | **Delete** {container_container_distribution_href} | Delete a container distribution
*DistributionsContainerAPI* | [**DistributionsContainerContainerList**](docs/DistributionsContainerAPI.md#distributionscontainercontainerlist) | **Get** /pulp/api/v3/distributions/container/container/ | List container distributions
*DistributionsContainerAPI* | [**DistributionsContainerContainerListRoles**](docs/DistributionsContainerAPI.md#distributionscontainercontainerlistroles) | **Get** {container_container_distribution_href}list_roles/ | 
*DistributionsContainerAPI* | [**DistributionsContainerContainerMyPermissions**](docs/DistributionsContainerAPI.md#distributionscontainercontainermypermissions) | **Get** {container_container_distribution_href}my_permissions/ | 
*DistributionsContainerAPI* | [**DistributionsContainerContainerPartialUpdate**](docs/DistributionsContainerAPI.md#distributionscontainercontainerpartialupdate) | **Patch** {container_container_distribution_href} | Update a container distribution
*DistributionsContainerAPI* | [**DistributionsContainerContainerRead**](docs/DistributionsContainerAPI.md#distributionscontainercontainerread) | **Get** {container_container_distribution_href} | Inspect a container distribution
*DistributionsContainerAPI* | [**DistributionsContainerContainerRemoveRole**](docs/DistributionsContainerAPI.md#distributionscontainercontainerremoverole) | **Post** {container_container_distribution_href}remove_role/ | 
*DistributionsContainerAPI* | [**DistributionsContainerContainerUpdate**](docs/DistributionsContainerAPI.md#distributionscontainercontainerupdate) | **Put** {container_container_distribution_href} | Update a container distribution
*DistributionsFileAPI* | [**DistributionsFileFileAddRole**](docs/DistributionsFileAPI.md#distributionsfilefileaddrole) | **Post** {file_file_distribution_href}add_role/ | 
*DistributionsFileAPI* | [**DistributionsFileFileCreate**](docs/DistributionsFileAPI.md#distributionsfilefilecreate) | **Post** /pulp/api/v3/distributions/file/file/ | Create a file distribution
*DistributionsFileAPI* | [**DistributionsFileFileDelete**](docs/DistributionsFileAPI.md#distributionsfilefiledelete) | **Delete** {file_file_distribution_href} | Delete a file distribution
*DistributionsFileAPI* | [**DistributionsFileFileList**](docs/DistributionsFileAPI.md#distributionsfilefilelist) | **Get** /pulp/api/v3/distributions/file/file/ | List file distributions
*DistributionsFileAPI* | [**DistributionsFileFileListRoles**](docs/DistributionsFileAPI.md#distributionsfilefilelistroles) | **Get** {file_file_distribution_href}list_roles/ | 
*DistributionsFileAPI* | [**DistributionsFileFileMyPermissions**](docs/DistributionsFileAPI.md#distributionsfilefilemypermissions) | **Get** {file_file_distribution_href}my_permissions/ | 
*DistributionsFileAPI* | [**DistributionsFileFilePartialUpdate**](docs/DistributionsFileAPI.md#distributionsfilefilepartialupdate) | **Patch** {file_file_distribution_href} | Update a file distribution
*DistributionsFileAPI* | [**DistributionsFileFileRead**](docs/DistributionsFileAPI.md#distributionsfilefileread) | **Get** {file_file_distribution_href} | Inspect a file distribution
*DistributionsFileAPI* | [**DistributionsFileFileRemoveRole**](docs/DistributionsFileAPI.md#distributionsfilefileremoverole) | **Post** {file_file_distribution_href}remove_role/ | 
*DistributionsFileAPI* | [**DistributionsFileFileUpdate**](docs/DistributionsFileAPI.md#distributionsfilefileupdate) | **Put** {file_file_distribution_href} | Update a file distribution
*DistributionsGemAPI* | [**DistributionsGemGemCreate**](docs/DistributionsGemAPI.md#distributionsgemgemcreate) | **Post** /pulp/api/v3/distributions/gem/gem/ | Create a gem distribution
*DistributionsGemAPI* | [**DistributionsGemGemDelete**](docs/DistributionsGemAPI.md#distributionsgemgemdelete) | **Delete** {gem_gem_distribution_href} | Delete a gem distribution
*DistributionsGemAPI* | [**DistributionsGemGemList**](docs/DistributionsGemAPI.md#distributionsgemgemlist) | **Get** /pulp/api/v3/distributions/gem/gem/ | List gem distributions
*DistributionsGemAPI* | [**DistributionsGemGemPartialUpdate**](docs/DistributionsGemAPI.md#distributionsgemgempartialupdate) | **Patch** {gem_gem_distribution_href} | Update a gem distribution
*DistributionsGemAPI* | [**DistributionsGemGemRead**](docs/DistributionsGemAPI.md#distributionsgemgemread) | **Get** {gem_gem_distribution_href} | Inspect a gem distribution
*DistributionsGemAPI* | [**DistributionsGemGemUpdate**](docs/DistributionsGemAPI.md#distributionsgemgemupdate) | **Put** {gem_gem_distribution_href} | Update a gem distribution
*DistributionsMavenAPI* | [**DistributionsMavenMavenCreate**](docs/DistributionsMavenAPI.md#distributionsmavenmavencreate) | **Post** /pulp/api/v3/distributions/maven/maven/ | Create a maven distribution
*DistributionsMavenAPI* | [**DistributionsMavenMavenDelete**](docs/DistributionsMavenAPI.md#distributionsmavenmavendelete) | **Delete** {maven_maven_distribution_href} | Delete a maven distribution
*DistributionsMavenAPI* | [**DistributionsMavenMavenList**](docs/DistributionsMavenAPI.md#distributionsmavenmavenlist) | **Get** /pulp/api/v3/distributions/maven/maven/ | List maven distributions
*DistributionsMavenAPI* | [**DistributionsMavenMavenPartialUpdate**](docs/DistributionsMavenAPI.md#distributionsmavenmavenpartialupdate) | **Patch** {maven_maven_distribution_href} | Update a maven distribution
*DistributionsMavenAPI* | [**DistributionsMavenMavenRead**](docs/DistributionsMavenAPI.md#distributionsmavenmavenread) | **Get** {maven_maven_distribution_href} | Inspect a maven distribution
*DistributionsMavenAPI* | [**DistributionsMavenMavenUpdate**](docs/DistributionsMavenAPI.md#distributionsmavenmavenupdate) | **Put** {maven_maven_distribution_href} | Update a maven distribution
*DistributionsOstreeAPI* | [**DistributionsOstreeOstreeCreate**](docs/DistributionsOstreeAPI.md#distributionsostreeostreecreate) | **Post** /pulp/api/v3/distributions/ostree/ostree/ | Create an ostree distribution
*DistributionsOstreeAPI* | [**DistributionsOstreeOstreeDelete**](docs/DistributionsOstreeAPI.md#distributionsostreeostreedelete) | **Delete** {ostree_ostree_distribution_href} | Delete an ostree distribution
*DistributionsOstreeAPI* | [**DistributionsOstreeOstreeList**](docs/DistributionsOstreeAPI.md#distributionsostreeostreelist) | **Get** /pulp/api/v3/distributions/ostree/ostree/ | List ostree distributions
*DistributionsOstreeAPI* | [**DistributionsOstreeOstreePartialUpdate**](docs/DistributionsOstreeAPI.md#distributionsostreeostreepartialupdate) | **Patch** {ostree_ostree_distribution_href} | Update an ostree distribution
*DistributionsOstreeAPI* | [**DistributionsOstreeOstreeRead**](docs/DistributionsOstreeAPI.md#distributionsostreeostreeread) | **Get** {ostree_ostree_distribution_href} | Inspect an ostree distribution
*DistributionsOstreeAPI* | [**DistributionsOstreeOstreeUpdate**](docs/DistributionsOstreeAPI.md#distributionsostreeostreeupdate) | **Put** {ostree_ostree_distribution_href} | Update an ostree distribution
*DistributionsPypiAPI* | [**DistributionsPythonPypiCreate**](docs/DistributionsPypiAPI.md#distributionspythonpypicreate) | **Post** /pulp/api/v3/distributions/python/pypi/ | Create a python distribution
*DistributionsPypiAPI* | [**DistributionsPythonPypiDelete**](docs/DistributionsPypiAPI.md#distributionspythonpypidelete) | **Delete** {python_python_distribution_href} | Delete a python distribution
*DistributionsPypiAPI* | [**DistributionsPythonPypiList**](docs/DistributionsPypiAPI.md#distributionspythonpypilist) | **Get** /pulp/api/v3/distributions/python/pypi/ | List python distributions
*DistributionsPypiAPI* | [**DistributionsPythonPypiPartialUpdate**](docs/DistributionsPypiAPI.md#distributionspythonpypipartialupdate) | **Patch** {python_python_distribution_href} | Update a python distribution
*DistributionsPypiAPI* | [**DistributionsPythonPypiRead**](docs/DistributionsPypiAPI.md#distributionspythonpypiread) | **Get** {python_python_distribution_href} | Inspect a python distribution
*DistributionsPypiAPI* | [**DistributionsPythonPypiUpdate**](docs/DistributionsPypiAPI.md#distributionspythonpypiupdate) | **Put** {python_python_distribution_href} | Update a python distribution
*DistributionsRpmAPI* | [**DistributionsRpmRpmAddRole**](docs/DistributionsRpmAPI.md#distributionsrpmrpmaddrole) | **Post** {rpm_rpm_distribution_href}add_role/ | 
*DistributionsRpmAPI* | [**DistributionsRpmRpmCreate**](docs/DistributionsRpmAPI.md#distributionsrpmrpmcreate) | **Post** /pulp/api/v3/distributions/rpm/rpm/ | Create a rpm distribution
*DistributionsRpmAPI* | [**DistributionsRpmRpmDelete**](docs/DistributionsRpmAPI.md#distributionsrpmrpmdelete) | **Delete** {rpm_rpm_distribution_href} | Delete a rpm distribution
*DistributionsRpmAPI* | [**DistributionsRpmRpmList**](docs/DistributionsRpmAPI.md#distributionsrpmrpmlist) | **Get** /pulp/api/v3/distributions/rpm/rpm/ | List rpm distributions
*DistributionsRpmAPI* | [**DistributionsRpmRpmListRoles**](docs/DistributionsRpmAPI.md#distributionsrpmrpmlistroles) | **Get** {rpm_rpm_distribution_href}list_roles/ | 
*DistributionsRpmAPI* | [**DistributionsRpmRpmMyPermissions**](docs/DistributionsRpmAPI.md#distributionsrpmrpmmypermissions) | **Get** {rpm_rpm_distribution_href}my_permissions/ | 
*DistributionsRpmAPI* | [**DistributionsRpmRpmPartialUpdate**](docs/DistributionsRpmAPI.md#distributionsrpmrpmpartialupdate) | **Patch** {rpm_rpm_distribution_href} | Update a rpm distribution
*DistributionsRpmAPI* | [**DistributionsRpmRpmRead**](docs/DistributionsRpmAPI.md#distributionsrpmrpmread) | **Get** {rpm_rpm_distribution_href} | Inspect a rpm distribution
*DistributionsRpmAPI* | [**DistributionsRpmRpmRemoveRole**](docs/DistributionsRpmAPI.md#distributionsrpmrpmremoverole) | **Post** {rpm_rpm_distribution_href}remove_role/ | 
*DistributionsRpmAPI* | [**DistributionsRpmRpmUpdate**](docs/DistributionsRpmAPI.md#distributionsrpmrpmupdate) | **Put** {rpm_rpm_distribution_href} | Update a rpm distribution
*DocsApiJsonAPI* | [**DocsApiJsonGet**](docs/DocsApiJsonAPI.md#docsapijsonget) | **Get** /pulp/api/v3/docs/api.json | 
*DocsApiYamlAPI* | [**DocsApiYamlGet**](docs/DocsApiYamlAPI.md#docsapiyamlget) | **Get** /pulp/api/v3/docs/api.yaml | 
*DomainsAPI* | [**DomainsCreate**](docs/DomainsAPI.md#domainscreate) | **Post** /pulp/api/v3/domains/ | Create a domain
*DomainsAPI* | [**DomainsDelete**](docs/DomainsAPI.md#domainsdelete) | **Delete** {domain_href} | Delete a domain
*DomainsAPI* | [**DomainsList**](docs/DomainsAPI.md#domainslist) | **Get** /pulp/api/v3/domains/ | List domains
*DomainsAPI* | [**DomainsPartialUpdate**](docs/DomainsAPI.md#domainspartialupdate) | **Patch** {domain_href} | Update a domain
*DomainsAPI* | [**DomainsRead**](docs/DomainsAPI.md#domainsread) | **Get** {domain_href} | Inspect a domain
*DomainsAPI* | [**DomainsUpdate**](docs/DomainsAPI.md#domainsupdate) | **Put** {domain_href} | Update a domain
*ExportersFilesystemAPI* | [**ExportersCoreFilesystemCreate**](docs/ExportersFilesystemAPI.md#exporterscorefilesystemcreate) | **Post** /pulp/api/v3/exporters/core/filesystem/ | Create a filesystem exporter
*ExportersFilesystemAPI* | [**ExportersCoreFilesystemDelete**](docs/ExportersFilesystemAPI.md#exporterscorefilesystemdelete) | **Delete** {filesystem_exporter_href} | Delete a filesystem exporter
*ExportersFilesystemAPI* | [**ExportersCoreFilesystemList**](docs/ExportersFilesystemAPI.md#exporterscorefilesystemlist) | **Get** /pulp/api/v3/exporters/core/filesystem/ | List filesystem exporters
*ExportersFilesystemAPI* | [**ExportersCoreFilesystemPartialUpdate**](docs/ExportersFilesystemAPI.md#exporterscorefilesystempartialupdate) | **Patch** {filesystem_exporter_href} | Update a filesystem exporter
*ExportersFilesystemAPI* | [**ExportersCoreFilesystemRead**](docs/ExportersFilesystemAPI.md#exporterscorefilesystemread) | **Get** {filesystem_exporter_href} | Inspect a filesystem exporter
*ExportersFilesystemAPI* | [**ExportersCoreFilesystemUpdate**](docs/ExportersFilesystemAPI.md#exporterscorefilesystemupdate) | **Put** {filesystem_exporter_href} | Update a filesystem exporter
*ExportersFilesystemExportsAPI* | [**ExportersCoreFilesystemExportsCreate**](docs/ExportersFilesystemExportsAPI.md#exporterscorefilesystemexportscreate) | **Post** {filesystem_exporter_href}exports/ | Create a filesystem export
*ExportersFilesystemExportsAPI* | [**ExportersCoreFilesystemExportsDelete**](docs/ExportersFilesystemExportsAPI.md#exporterscorefilesystemexportsdelete) | **Delete** {filesystem_filesystem_export_href} | Delete a filesystem export
*ExportersFilesystemExportsAPI* | [**ExportersCoreFilesystemExportsList**](docs/ExportersFilesystemExportsAPI.md#exporterscorefilesystemexportslist) | **Get** {filesystem_exporter_href}exports/ | List filesystem exports
*ExportersFilesystemExportsAPI* | [**ExportersCoreFilesystemExportsRead**](docs/ExportersFilesystemExportsAPI.md#exporterscorefilesystemexportsread) | **Get** {filesystem_filesystem_export_href} | Inspect a filesystem export
*ExportersPulpAPI* | [**ExportersCorePulpCreate**](docs/ExportersPulpAPI.md#exporterscorepulpcreate) | **Post** /pulp/api/v3/exporters/core/pulp/ | Create a pulp exporter
*ExportersPulpAPI* | [**ExportersCorePulpDelete**](docs/ExportersPulpAPI.md#exporterscorepulpdelete) | **Delete** {pulp_exporter_href} | Delete a pulp exporter
*ExportersPulpAPI* | [**ExportersCorePulpList**](docs/ExportersPulpAPI.md#exporterscorepulplist) | **Get** /pulp/api/v3/exporters/core/pulp/ | List pulp exporters
*ExportersPulpAPI* | [**ExportersCorePulpPartialUpdate**](docs/ExportersPulpAPI.md#exporterscorepulppartialupdate) | **Patch** {pulp_exporter_href} | Update a pulp exporter
*ExportersPulpAPI* | [**ExportersCorePulpRead**](docs/ExportersPulpAPI.md#exporterscorepulpread) | **Get** {pulp_exporter_href} | Inspect a pulp exporter
*ExportersPulpAPI* | [**ExportersCorePulpUpdate**](docs/ExportersPulpAPI.md#exporterscorepulpupdate) | **Put** {pulp_exporter_href} | Update a pulp exporter
*ExportersPulpExportsAPI* | [**ExportersCorePulpExportsCreate**](docs/ExportersPulpExportsAPI.md#exporterscorepulpexportscreate) | **Post** {pulp_exporter_href}exports/ | Create a pulp export
*ExportersPulpExportsAPI* | [**ExportersCorePulpExportsDelete**](docs/ExportersPulpExportsAPI.md#exporterscorepulpexportsdelete) | **Delete** {pulp_pulp_export_href} | Delete a pulp export
*ExportersPulpExportsAPI* | [**ExportersCorePulpExportsList**](docs/ExportersPulpExportsAPI.md#exporterscorepulpexportslist) | **Get** {pulp_exporter_href}exports/ | List pulp exports
*ExportersPulpExportsAPI* | [**ExportersCorePulpExportsRead**](docs/ExportersPulpExportsAPI.md#exporterscorepulpexportsread) | **Get** {pulp_pulp_export_href} | Inspect a pulp export
*GalaxyDetailAPI* | [**GalaxyCollectionDetailGet**](docs/GalaxyDetailAPI.md#galaxycollectiondetailget) | **Get** {ansible_collection_href} | 
*GroupsAPI* | [**GroupsAddRole**](docs/GroupsAPI.md#groupsaddrole) | **Post** {group_href}add_role/ | 
*GroupsAPI* | [**GroupsCreate**](docs/GroupsAPI.md#groupscreate) | **Post** /pulp/api/v3/groups/ | Create a group
*GroupsAPI* | [**GroupsDelete**](docs/GroupsAPI.md#groupsdelete) | **Delete** {group_href} | Delete a group
*GroupsAPI* | [**GroupsList**](docs/GroupsAPI.md#groupslist) | **Get** /pulp/api/v3/groups/ | List groups
*GroupsAPI* | [**GroupsListRoles**](docs/GroupsAPI.md#groupslistroles) | **Get** {group_href}list_roles/ | 
*GroupsAPI* | [**GroupsMyPermissions**](docs/GroupsAPI.md#groupsmypermissions) | **Get** {group_href}my_permissions/ | 
*GroupsAPI* | [**GroupsPartialUpdate**](docs/GroupsAPI.md#groupspartialupdate) | **Patch** {group_href} | Update a group
*GroupsAPI* | [**GroupsRead**](docs/GroupsAPI.md#groupsread) | **Get** {group_href} | Inspect a group
*GroupsAPI* | [**GroupsRemoveRole**](docs/GroupsAPI.md#groupsremoverole) | **Post** {group_href}remove_role/ | 
*GroupsAPI* | [**GroupsUpdate**](docs/GroupsAPI.md#groupsupdate) | **Put** {group_href} | Update a group
*GroupsRolesAPI* | [**GroupsRolesCreate**](docs/GroupsRolesAPI.md#groupsrolescreate) | **Post** {group_href}roles/ | Create a group role
*GroupsRolesAPI* | [**GroupsRolesDelete**](docs/GroupsRolesAPI.md#groupsrolesdelete) | **Delete** {groups_group_role_href} | Delete a group role
*GroupsRolesAPI* | [**GroupsRolesList**](docs/GroupsRolesAPI.md#groupsroleslist) | **Get** {group_href}roles/ | List group roles
*GroupsRolesAPI* | [**GroupsRolesRead**](docs/GroupsRolesAPI.md#groupsrolesread) | **Get** {groups_group_role_href} | Inspect a group role
*GroupsUsersAPI* | [**GroupsUsersCreate**](docs/GroupsUsersAPI.md#groupsuserscreate) | **Post** {group_href}users/ | Create an user
*GroupsUsersAPI* | [**GroupsUsersDelete**](docs/GroupsUsersAPI.md#groupsusersdelete) | **Delete** {groups_user_href} | Delete an user
*GroupsUsersAPI* | [**GroupsUsersList**](docs/GroupsUsersAPI.md#groupsuserslist) | **Get** {group_href}users/ | List users
*ImportersPulpAPI* | [**ImportersCorePulpCreate**](docs/ImportersPulpAPI.md#importerscorepulpcreate) | **Post** /pulp/api/v3/importers/core/pulp/ | Create a pulp importer
*ImportersPulpAPI* | [**ImportersCorePulpDelete**](docs/ImportersPulpAPI.md#importerscorepulpdelete) | **Delete** {pulp_importer_href} | Delete a pulp importer
*ImportersPulpAPI* | [**ImportersCorePulpList**](docs/ImportersPulpAPI.md#importerscorepulplist) | **Get** /pulp/api/v3/importers/core/pulp/ | List pulp importers
*ImportersPulpAPI* | [**ImportersCorePulpPartialUpdate**](docs/ImportersPulpAPI.md#importerscorepulppartialupdate) | **Patch** {pulp_importer_href} | Update a pulp importer
*ImportersPulpAPI* | [**ImportersCorePulpRead**](docs/ImportersPulpAPI.md#importerscorepulpread) | **Get** {pulp_importer_href} | Inspect a pulp importer
*ImportersPulpAPI* | [**ImportersCorePulpUpdate**](docs/ImportersPulpAPI.md#importerscorepulpupdate) | **Put** {pulp_importer_href} | Update a pulp importer
*ImportersPulpImportCheckAPI* | [**PulpImportCheckPost**](docs/ImportersPulpImportCheckAPI.md#pulpimportcheckpost) | **Post** /pulp/api/v3/importers/core/pulp/import-check/ | Validate the parameters to be used for a PulpImport call
*ImportersPulpImportsAPI* | [**ImportersCorePulpImportsCreate**](docs/ImportersPulpImportsAPI.md#importerscorepulpimportscreate) | **Post** {pulp_importer_href}imports/ | Create a pulp import
*ImportersPulpImportsAPI* | [**ImportersCorePulpImportsDelete**](docs/ImportersPulpImportsAPI.md#importerscorepulpimportsdelete) | **Delete** {pulp_pulp_import_href} | Delete a pulp import
*ImportersPulpImportsAPI* | [**ImportersCorePulpImportsList**](docs/ImportersPulpImportsAPI.md#importerscorepulpimportslist) | **Get** {pulp_importer_href}imports/ | List pulp imports
*ImportersPulpImportsAPI* | [**ImportersCorePulpImportsRead**](docs/ImportersPulpImportsAPI.md#importerscorepulpimportsread) | **Get** {pulp_pulp_import_href} | Inspect a pulp import
*OrphansAPI* | [**OrphansDelete**](docs/OrphansAPI.md#orphansdelete) | **Delete** /pulp/api/v3/orphans/ | Delete orphans
*OrphansCleanupAPI* | [**OrphansCleanupCleanup**](docs/OrphansCleanupAPI.md#orphanscleanupcleanup) | **Post** /pulp/api/v3/orphans/cleanup/ | 
*PublicationsAPI* | [**PublicationsList**](docs/PublicationsAPI.md#publicationslist) | **Get** /pulp/api/v3/publications/ | List publications
*PublicationsAptAPI* | [**PublicationsDebAptCreate**](docs/PublicationsAptAPI.md#publicationsdebaptcreate) | **Post** /pulp/api/v3/publications/deb/apt/ | Create an apt publication
*PublicationsAptAPI* | [**PublicationsDebAptDelete**](docs/PublicationsAptAPI.md#publicationsdebaptdelete) | **Delete** {deb_apt_publication_href} | Delete an apt publication
*PublicationsAptAPI* | [**PublicationsDebAptList**](docs/PublicationsAptAPI.md#publicationsdebaptlist) | **Get** /pulp/api/v3/publications/deb/apt/ | List apt publications
*PublicationsAptAPI* | [**PublicationsDebAptRead**](docs/PublicationsAptAPI.md#publicationsdebaptread) | **Get** {deb_apt_publication_href} | Inspect an apt publication
*PublicationsFileAPI* | [**PublicationsFileFileAddRole**](docs/PublicationsFileAPI.md#publicationsfilefileaddrole) | **Post** {file_file_publication_href}add_role/ | 
*PublicationsFileAPI* | [**PublicationsFileFileCreate**](docs/PublicationsFileAPI.md#publicationsfilefilecreate) | **Post** /pulp/api/v3/publications/file/file/ | Create a file publication
*PublicationsFileAPI* | [**PublicationsFileFileDelete**](docs/PublicationsFileAPI.md#publicationsfilefiledelete) | **Delete** {file_file_publication_href} | Delete a file publication
*PublicationsFileAPI* | [**PublicationsFileFileList**](docs/PublicationsFileAPI.md#publicationsfilefilelist) | **Get** /pulp/api/v3/publications/file/file/ | List file publications
*PublicationsFileAPI* | [**PublicationsFileFileListRoles**](docs/PublicationsFileAPI.md#publicationsfilefilelistroles) | **Get** {file_file_publication_href}list_roles/ | 
*PublicationsFileAPI* | [**PublicationsFileFileMyPermissions**](docs/PublicationsFileAPI.md#publicationsfilefilemypermissions) | **Get** {file_file_publication_href}my_permissions/ | 
*PublicationsFileAPI* | [**PublicationsFileFileRead**](docs/PublicationsFileAPI.md#publicationsfilefileread) | **Get** {file_file_publication_href} | Inspect a file publication
*PublicationsFileAPI* | [**PublicationsFileFileRemoveRole**](docs/PublicationsFileAPI.md#publicationsfilefileremoverole) | **Post** {file_file_publication_href}remove_role/ | 
*PublicationsGemAPI* | [**PublicationsGemGemCreate**](docs/PublicationsGemAPI.md#publicationsgemgemcreate) | **Post** /pulp/api/v3/publications/gem/gem/ | Create a gem publication
*PublicationsGemAPI* | [**PublicationsGemGemDelete**](docs/PublicationsGemAPI.md#publicationsgemgemdelete) | **Delete** {gem_gem_publication_href} | Delete a gem publication
*PublicationsGemAPI* | [**PublicationsGemGemList**](docs/PublicationsGemAPI.md#publicationsgemgemlist) | **Get** /pulp/api/v3/publications/gem/gem/ | List gem publications
*PublicationsGemAPI* | [**PublicationsGemGemRead**](docs/PublicationsGemAPI.md#publicationsgemgemread) | **Get** {gem_gem_publication_href} | Inspect a gem publication
*PublicationsPypiAPI* | [**PublicationsPythonPypiCreate**](docs/PublicationsPypiAPI.md#publicationspythonpypicreate) | **Post** /pulp/api/v3/publications/python/pypi/ | Create a python publication
*PublicationsPypiAPI* | [**PublicationsPythonPypiDelete**](docs/PublicationsPypiAPI.md#publicationspythonpypidelete) | **Delete** {python_python_publication_href} | Delete a python publication
*PublicationsPypiAPI* | [**PublicationsPythonPypiList**](docs/PublicationsPypiAPI.md#publicationspythonpypilist) | **Get** /pulp/api/v3/publications/python/pypi/ | List python publications
*PublicationsPypiAPI* | [**PublicationsPythonPypiRead**](docs/PublicationsPypiAPI.md#publicationspythonpypiread) | **Get** {python_python_publication_href} | Inspect a python publication
*PublicationsRpmAPI* | [**PublicationsRpmRpmAddRole**](docs/PublicationsRpmAPI.md#publicationsrpmrpmaddrole) | **Post** {rpm_rpm_publication_href}add_role/ | 
*PublicationsRpmAPI* | [**PublicationsRpmRpmCreate**](docs/PublicationsRpmAPI.md#publicationsrpmrpmcreate) | **Post** /pulp/api/v3/publications/rpm/rpm/ | Create a rpm publication
*PublicationsRpmAPI* | [**PublicationsRpmRpmDelete**](docs/PublicationsRpmAPI.md#publicationsrpmrpmdelete) | **Delete** {rpm_rpm_publication_href} | Delete a rpm publication
*PublicationsRpmAPI* | [**PublicationsRpmRpmList**](docs/PublicationsRpmAPI.md#publicationsrpmrpmlist) | **Get** /pulp/api/v3/publications/rpm/rpm/ | List rpm publications
*PublicationsRpmAPI* | [**PublicationsRpmRpmListRoles**](docs/PublicationsRpmAPI.md#publicationsrpmrpmlistroles) | **Get** {rpm_rpm_publication_href}list_roles/ | 
*PublicationsRpmAPI* | [**PublicationsRpmRpmMyPermissions**](docs/PublicationsRpmAPI.md#publicationsrpmrpmmypermissions) | **Get** {rpm_rpm_publication_href}my_permissions/ | 
*PublicationsRpmAPI* | [**PublicationsRpmRpmRead**](docs/PublicationsRpmAPI.md#publicationsrpmrpmread) | **Get** {rpm_rpm_publication_href} | Inspect a rpm publication
*PublicationsRpmAPI* | [**PublicationsRpmRpmRemoveRole**](docs/PublicationsRpmAPI.md#publicationsrpmrpmremoverole) | **Post** {rpm_rpm_publication_href}remove_role/ | 
*PublicationsVerbatimAPI* | [**PublicationsDebVerbatimCreate**](docs/PublicationsVerbatimAPI.md#publicationsdebverbatimcreate) | **Post** /pulp/api/v3/publications/deb/verbatim/ | Create a verbatim publication
*PublicationsVerbatimAPI* | [**PublicationsDebVerbatimDelete**](docs/PublicationsVerbatimAPI.md#publicationsdebverbatimdelete) | **Delete** {deb_verbatim_publication_href} | Delete a verbatim publication
*PublicationsVerbatimAPI* | [**PublicationsDebVerbatimList**](docs/PublicationsVerbatimAPI.md#publicationsdebverbatimlist) | **Get** /pulp/api/v3/publications/deb/verbatim/ | List verbatim publications
*PublicationsVerbatimAPI* | [**PublicationsDebVerbatimRead**](docs/PublicationsVerbatimAPI.md#publicationsdebverbatimread) | **Get** {deb_verbatim_publication_href} | Inspect a verbatim publication
*PulpAnsibleApiAPI* | [**PulpAnsibleGalaxyApiGet**](docs/PulpAnsibleApiAPI.md#pulpansiblegalaxyapiget) | **Get** /pulp_ansible/galaxy/{path}/api/ | 
*PulpAnsibleApiV2CollectionsVersionsAPI* | [**PulpAnsibleGalaxyApiV2CollectionsVersionsGet**](docs/PulpAnsibleApiV2CollectionsVersionsAPI.md#pulpansiblegalaxyapiv2collectionsversionsget) | **Get** /pulp_ansible/galaxy/{path}/api/v2/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3API* | [**PulpAnsibleGalaxyApiV3Read**](docs/PulpAnsibleApiV3API.md#pulpansiblegalaxyapiv3read) | **Get** /pulp_ansible/galaxy/{path}/api/v3/ | 
*PulpAnsibleApiV3ArtifactsCollectionsAPI* | [**PulpAnsibleGalaxyApiV3ArtifactsCollectionsGet**](docs/PulpAnsibleApiV3ArtifactsCollectionsAPI.md#pulpansiblegalaxyapiv3artifactscollectionsget) | **Get** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/{path}/{filename} | 
*PulpAnsibleApiV3CollectionVersionsAllAPI* | [**PulpAnsibleGalaxyApiV3CollectionVersionsAllList**](docs/PulpAnsibleApiV3CollectionVersionsAllAPI.md#pulpansiblegalaxyapiv3collectionversionsalllist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collection_versions/all/ | 
*PulpAnsibleApiV3CollectionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsDelete**](docs/PulpAnsibleApiV3CollectionsAPI.md#pulpansiblegalaxyapiv3collectionsdelete) | **Delete** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsList**](docs/PulpAnsibleApiV3CollectionsAPI.md#pulpansiblegalaxyapiv3collectionslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collections/ | 
*PulpAnsibleApiV3CollectionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsRead**](docs/PulpAnsibleApiV3CollectionsAPI.md#pulpansiblegalaxyapiv3collectionsread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsUpdate**](docs/PulpAnsibleApiV3CollectionsAPI.md#pulpansiblegalaxyapiv3collectionsupdate) | **Patch** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsAllAPI* | [**PulpAnsibleGalaxyApiV3CollectionsAllList**](docs/PulpAnsibleApiV3CollectionsAllAPI.md#pulpansiblegalaxyapiv3collectionsalllist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collections/all/ | 
*PulpAnsibleApiV3CollectionsVersionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsVersionsDelete**](docs/PulpAnsibleApiV3CollectionsVersionsAPI.md#pulpansiblegalaxyapiv3collectionsversionsdelete) | **Delete** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3CollectionsVersionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsVersionsList**](docs/PulpAnsibleApiV3CollectionsVersionsAPI.md#pulpansiblegalaxyapiv3collectionsversionslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleApiV3CollectionsVersionsAPI* | [**PulpAnsibleGalaxyApiV3CollectionsVersionsRead**](docs/PulpAnsibleApiV3CollectionsVersionsAPI.md#pulpansiblegalaxyapiv3collectionsversionsread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3CollectionsVersionsDocsBlobAPI* | [**PulpAnsibleGalaxyApiV3CollectionsVersionsDocsBlobRead**](docs/PulpAnsibleApiV3CollectionsVersionsDocsBlobAPI.md#pulpansiblegalaxyapiv3collectionsversionsdocsblobread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleApiV3NamespacesAPI* | [**PulpAnsibleGalaxyApiV3NamespacesList**](docs/PulpAnsibleApiV3NamespacesAPI.md#pulpansiblegalaxyapiv3namespaceslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/namespaces/ | 
*PulpAnsibleApiV3NamespacesAPI* | [**PulpAnsibleGalaxyApiV3NamespacesRead**](docs/PulpAnsibleApiV3NamespacesAPI.md#pulpansiblegalaxyapiv3namespacesread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleClientConfigurationAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleClientConfigurationRead**](docs/PulpAnsibleApiV3PluginAnsibleClientConfigurationAPI.md#pulpansiblegalaxyapiv3pluginansibleclientconfigurationread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/client-configuration/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsRead**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsAllCollectionsList**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsallcollectionslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsAllVersionsList**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsallversionslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-versions/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsArtifactsDownload**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsartifactsdownload) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/{filename} | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexDelete**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexdelete) | **Delete** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexList**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexlist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexRead**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexUpdate**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexupdate) | **Patch** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexVersionsDelete**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexversionsdelete) | **Delete** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexVersionsList**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexversionslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexVersionsRead**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexversionsread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobRead**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsindexversionsdocsblobread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesCreate**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentnamespacescreate) | **Post** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesDelete**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentnamespacesdelete) | **Delete** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesList**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentnamespaceslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesPartialUpdate**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentnamespacespartialupdate) | **Patch** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentNamespacesRead**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxyapiv3pluginansiblecontentnamespacesread) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleSearchCollectionVersionsList**](docs/PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPI.md#pulpansiblegalaxyapiv3pluginansiblesearchcollectionversionslist) | **Get** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPI* | [**PulpAnsibleGalaxyApiV3PluginAnsibleSearchCollectionVersionsRebuild**](docs/PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsAPI.md#pulpansiblegalaxyapiv3pluginansiblesearchcollectionversionsrebuild) | **Post** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleArtifactsCollectionsV3API* | [**PulpAnsibleGalaxyApiV3ArtifactsCollectionsCreate**](docs/PulpAnsibleArtifactsCollectionsV3API.md#pulpansiblegalaxyapiv3artifactscollectionscreate) | **Post** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3API* | [**PulpAnsibleGalaxyApiV3PluginAnsibleContentCollectionsArtifactsCreate**](docs/PulpAnsibleArtifactsCollectionsV3API.md#pulpansiblegalaxyapiv3pluginansiblecontentcollectionsartifactscreate) | **Post** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3API* | [**PulpAnsibleGalaxyDefaultApiV3ArtifactsCollectionsCreate**](docs/PulpAnsibleArtifactsCollectionsV3API.md#pulpansiblegalaxydefaultapiv3artifactscollectionscreate) | **Post** /pulp_ansible/galaxy/default/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3API* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsArtifactsCreate**](docs/PulpAnsibleArtifactsCollectionsV3API.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsartifactscreate) | **Post** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/ | Upload a collection
*PulpAnsibleDefaultApiAPI* | [**PulpAnsibleGalaxyDefaultApiGet**](docs/PulpAnsibleDefaultApiAPI.md#pulpansiblegalaxydefaultapiget) | **Get** /pulp_ansible/galaxy/default/api/ | 
*PulpAnsibleDefaultApiV3API* | [**PulpAnsibleGalaxyDefaultApiV3Read**](docs/PulpAnsibleDefaultApiV3API.md#pulpansiblegalaxydefaultapiv3read) | **Get** /pulp_ansible/galaxy/default/api/v3/ | 
*PulpAnsibleDefaultApiV3ArtifactsCollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3ArtifactsCollectionsGet**](docs/PulpAnsibleDefaultApiV3ArtifactsCollectionsAPI.md#pulpansiblegalaxydefaultapiv3artifactscollectionsget) | **Get** /pulp_ansible/galaxy/default/api/v3/artifacts/collections/{path}/{filename} | 
*PulpAnsibleDefaultApiV3CollectionVersionsAllAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionVersionsAllList**](docs/PulpAnsibleDefaultApiV3CollectionVersionsAllAPI.md#pulpansiblegalaxydefaultapiv3collectionversionsalllist) | **Get** /pulp_ansible/galaxy/default/api/v3/collection_versions/all/ | 
*PulpAnsibleDefaultApiV3CollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsDelete**](docs/PulpAnsibleDefaultApiV3CollectionsAPI.md#pulpansiblegalaxydefaultapiv3collectionsdelete) | **Delete** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsList**](docs/PulpAnsibleDefaultApiV3CollectionsAPI.md#pulpansiblegalaxydefaultapiv3collectionslist) | **Get** /pulp_ansible/galaxy/default/api/v3/collections/ | 
*PulpAnsibleDefaultApiV3CollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsRead**](docs/PulpAnsibleDefaultApiV3CollectionsAPI.md#pulpansiblegalaxydefaultapiv3collectionsread) | **Get** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsUpdate**](docs/PulpAnsibleDefaultApiV3CollectionsAPI.md#pulpansiblegalaxydefaultapiv3collectionsupdate) | **Patch** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsAllAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsAllList**](docs/PulpAnsibleDefaultApiV3CollectionsAllAPI.md#pulpansiblegalaxydefaultapiv3collectionsalllist) | **Get** /pulp_ansible/galaxy/default/api/v3/collections/all/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsVersionsDelete**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsAPI.md#pulpansiblegalaxydefaultapiv3collectionsversionsdelete) | **Delete** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsVersionsList**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsAPI.md#pulpansiblegalaxydefaultapiv3collectionsversionslist) | **Get** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsVersionsRead**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsAPI.md#pulpansiblegalaxydefaultapiv3collectionsversionsread) | **Get** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobAPI* | [**PulpAnsibleGalaxyDefaultApiV3CollectionsVersionsDocsBlobRead**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobAPI.md#pulpansiblegalaxydefaultapiv3collectionsversionsdocsblobread) | **Get** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleDefaultApiV3NamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3NamespacesList**](docs/PulpAnsibleDefaultApiV3NamespacesAPI.md#pulpansiblegalaxydefaultapiv3namespaceslist) | **Get** /pulp_ansible/galaxy/default/api/v3/namespaces/ | 
*PulpAnsibleDefaultApiV3NamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3NamespacesRead**](docs/PulpAnsibleDefaultApiV3NamespacesAPI.md#pulpansiblegalaxydefaultapiv3namespacesread) | **Get** /pulp_ansible/galaxy/default/api/v3/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationRead**](docs/PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPI.md#pulpansiblegalaxydefaultapiv3pluginansibleclientconfigurationread) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/client-configuration/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsRead**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsread) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsList**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsallcollectionslist) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllVersionsList**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsallversionslist) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsArtifactsDownload**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsartifactsdownload) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/{filename} | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexDelete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexdelete) | **Delete** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexList**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexlist) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexRead**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexread) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexUpdate**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexupdate) | **Patch** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDelete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexversionsdelete) | **Delete** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsList**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexversionslist) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsRead**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexversionsread) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobRead**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentcollectionsindexversionsdocsblobread) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentNamespacesCreate**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentnamespacescreate) | **Post** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentNamespacesDelete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentnamespacesdelete) | **Delete** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentNamespacesList**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentnamespaceslist) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentNamespacesPartialUpdate**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentnamespacespartialupdate) | **Patch** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentNamespacesRead**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblecontentnamespacesread) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsList**](docs/PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblesearchcollectionversionslist) | **Get** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI* | [**PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuild**](docs/PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI.md#pulpansiblegalaxydefaultapiv3pluginansiblesearchcollectionversionsrebuild) | **Post** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleTagsAPI* | [**PulpAnsibleTagsList**](docs/PulpAnsibleTagsAPI.md#pulpansibletagslist) | **Get** /pulp/api/v3/pulp_ansible/tags/ | List tags
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesAddRole**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespacesaddrole) | **Post** {container_container_namespace_href}add_role/ | 
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesCreate**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespacescreate) | **Post** /pulp/api/v3/pulp_container/namespaces/ | Create a container namespace
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesDelete**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespacesdelete) | **Delete** {container_container_namespace_href} | Delete a container namespace
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesList**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespaceslist) | **Get** /pulp/api/v3/pulp_container/namespaces/ | List container namespaces
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesListRoles**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespaceslistroles) | **Get** {container_container_namespace_href}list_roles/ | 
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesMyPermissions**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespacesmypermissions) | **Get** {container_container_namespace_href}my_permissions/ | 
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesRead**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespacesread) | **Get** {container_container_namespace_href} | Inspect a container namespace
*PulpContainerNamespacesAPI* | [**PulpContainerNamespacesRemoveRole**](docs/PulpContainerNamespacesAPI.md#pulpcontainernamespacesremoverole) | **Post** {container_container_namespace_href}remove_role/ | 
*PulpMavenAPI* | [**PulpMavenGet**](docs/PulpMavenAPI.md#pulpmavenget) | **Get** /pulp/maven/{name}/{path} | 
*PulpMavenAPI* | [**PulpMavenPut**](docs/PulpMavenAPI.md#pulpmavenput) | **Put** /pulp/maven/{name}/{path} | 
*PypiAPI* | [**PypiRead**](docs/PypiAPI.md#pypiread) | **Get** /pypi/{path}/ | Get index summary
*PypiLegacyAPI* | [**PypiLegacyCreate**](docs/PypiLegacyAPI.md#pypilegacycreate) | **Post** /pypi/{path}/legacy/ | Upload a package
*PypiMetadataAPI* | [**PypiPypiRead**](docs/PypiMetadataAPI.md#pypipypiread) | **Get** /pypi/{path}/pypi/{meta}/ | Get package metadata
*PypiSimpleAPI* | [**PypiSimpleCreate**](docs/PypiSimpleAPI.md#pypisimplecreate) | **Post** /pypi/{path}/simple/ | Upload a package
*PypiSimpleAPI* | [**PypiSimplePackageRead**](docs/PypiSimpleAPI.md#pypisimplepackageread) | **Get** /pypi/{path}/simple/{package}/ | Get package simple page
*PypiSimpleAPI* | [**PypiSimpleRead**](docs/PypiSimpleAPI.md#pypisimpleread) | **Get** /pypi/{path}/simple/ | Get index simple page
*RemotesAPI* | [**RemotesList**](docs/RemotesAPI.md#remoteslist) | **Get** /pulp/api/v3/remotes/ | List remotes
*RemotesAptAPI* | [**RemotesDebAptCreate**](docs/RemotesAptAPI.md#remotesdebaptcreate) | **Post** /pulp/api/v3/remotes/deb/apt/ | Create an apt remote
*RemotesAptAPI* | [**RemotesDebAptDelete**](docs/RemotesAptAPI.md#remotesdebaptdelete) | **Delete** {deb_apt_remote_href} | Delete an apt remote
*RemotesAptAPI* | [**RemotesDebAptList**](docs/RemotesAptAPI.md#remotesdebaptlist) | **Get** /pulp/api/v3/remotes/deb/apt/ | List apt remotes
*RemotesAptAPI* | [**RemotesDebAptPartialUpdate**](docs/RemotesAptAPI.md#remotesdebaptpartialupdate) | **Patch** {deb_apt_remote_href} | Update an apt remote
*RemotesAptAPI* | [**RemotesDebAptRead**](docs/RemotesAptAPI.md#remotesdebaptread) | **Get** {deb_apt_remote_href} | Inspect an apt remote
*RemotesAptAPI* | [**RemotesDebAptUpdate**](docs/RemotesAptAPI.md#remotesdebaptupdate) | **Put** {deb_apt_remote_href} | Update an apt remote
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionAddRole**](docs/RemotesCollectionAPI.md#remotesansiblecollectionaddrole) | **Post** {ansible_collection_remote_href}add_role/ | 
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionCreate**](docs/RemotesCollectionAPI.md#remotesansiblecollectioncreate) | **Post** /pulp/api/v3/remotes/ansible/collection/ | Create a collection remote
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionDelete**](docs/RemotesCollectionAPI.md#remotesansiblecollectiondelete) | **Delete** {ansible_collection_remote_href} | Delete a collection remote
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionList**](docs/RemotesCollectionAPI.md#remotesansiblecollectionlist) | **Get** /pulp/api/v3/remotes/ansible/collection/ | List collection remotes
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionListRoles**](docs/RemotesCollectionAPI.md#remotesansiblecollectionlistroles) | **Get** {ansible_collection_remote_href}list_roles/ | 
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionMyPermissions**](docs/RemotesCollectionAPI.md#remotesansiblecollectionmypermissions) | **Get** {ansible_collection_remote_href}my_permissions/ | 
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionPartialUpdate**](docs/RemotesCollectionAPI.md#remotesansiblecollectionpartialupdate) | **Patch** {ansible_collection_remote_href} | Update a collection remote
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionRead**](docs/RemotesCollectionAPI.md#remotesansiblecollectionread) | **Get** {ansible_collection_remote_href} | Inspect a collection remote
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionRemoveRole**](docs/RemotesCollectionAPI.md#remotesansiblecollectionremoverole) | **Post** {ansible_collection_remote_href}remove_role/ | 
*RemotesCollectionAPI* | [**RemotesAnsibleCollectionUpdate**](docs/RemotesCollectionAPI.md#remotesansiblecollectionupdate) | **Put** {ansible_collection_remote_href} | Update a collection remote
*RemotesContainerAPI* | [**RemotesContainerContainerAddRole**](docs/RemotesContainerAPI.md#remotescontainercontaineraddrole) | **Post** {container_container_remote_href}add_role/ | 
*RemotesContainerAPI* | [**RemotesContainerContainerCreate**](docs/RemotesContainerAPI.md#remotescontainercontainercreate) | **Post** /pulp/api/v3/remotes/container/container/ | Create a container remote
*RemotesContainerAPI* | [**RemotesContainerContainerDelete**](docs/RemotesContainerAPI.md#remotescontainercontainerdelete) | **Delete** {container_container_remote_href} | Delete a container remote
*RemotesContainerAPI* | [**RemotesContainerContainerList**](docs/RemotesContainerAPI.md#remotescontainercontainerlist) | **Get** /pulp/api/v3/remotes/container/container/ | List container remotes
*RemotesContainerAPI* | [**RemotesContainerContainerListRoles**](docs/RemotesContainerAPI.md#remotescontainercontainerlistroles) | **Get** {container_container_remote_href}list_roles/ | 
*RemotesContainerAPI* | [**RemotesContainerContainerMyPermissions**](docs/RemotesContainerAPI.md#remotescontainercontainermypermissions) | **Get** {container_container_remote_href}my_permissions/ | 
*RemotesContainerAPI* | [**RemotesContainerContainerPartialUpdate**](docs/RemotesContainerAPI.md#remotescontainercontainerpartialupdate) | **Patch** {container_container_remote_href} | Update a container remote
*RemotesContainerAPI* | [**RemotesContainerContainerRead**](docs/RemotesContainerAPI.md#remotescontainercontainerread) | **Get** {container_container_remote_href} | Inspect a container remote
*RemotesContainerAPI* | [**RemotesContainerContainerRemoveRole**](docs/RemotesContainerAPI.md#remotescontainercontainerremoverole) | **Post** {container_container_remote_href}remove_role/ | 
*RemotesContainerAPI* | [**RemotesContainerContainerUpdate**](docs/RemotesContainerAPI.md#remotescontainercontainerupdate) | **Put** {container_container_remote_href} | Update a container remote
*RemotesFileAPI* | [**RemotesFileFileAddRole**](docs/RemotesFileAPI.md#remotesfilefileaddrole) | **Post** {file_file_remote_href}add_role/ | 
*RemotesFileAPI* | [**RemotesFileFileCreate**](docs/RemotesFileAPI.md#remotesfilefilecreate) | **Post** /pulp/api/v3/remotes/file/file/ | Create a file remote
*RemotesFileAPI* | [**RemotesFileFileDelete**](docs/RemotesFileAPI.md#remotesfilefiledelete) | **Delete** {file_file_remote_href} | Delete a file remote
*RemotesFileAPI* | [**RemotesFileFileList**](docs/RemotesFileAPI.md#remotesfilefilelist) | **Get** /pulp/api/v3/remotes/file/file/ | List file remotes
*RemotesFileAPI* | [**RemotesFileFileListRoles**](docs/RemotesFileAPI.md#remotesfilefilelistroles) | **Get** {file_file_remote_href}list_roles/ | 
*RemotesFileAPI* | [**RemotesFileFileMyPermissions**](docs/RemotesFileAPI.md#remotesfilefilemypermissions) | **Get** {file_file_remote_href}my_permissions/ | 
*RemotesFileAPI* | [**RemotesFileFilePartialUpdate**](docs/RemotesFileAPI.md#remotesfilefilepartialupdate) | **Patch** {file_file_remote_href} | Update a file remote
*RemotesFileAPI* | [**RemotesFileFileRead**](docs/RemotesFileAPI.md#remotesfilefileread) | **Get** {file_file_remote_href} | Inspect a file remote
*RemotesFileAPI* | [**RemotesFileFileRemoveRole**](docs/RemotesFileAPI.md#remotesfilefileremoverole) | **Post** {file_file_remote_href}remove_role/ | 
*RemotesFileAPI* | [**RemotesFileFileUpdate**](docs/RemotesFileAPI.md#remotesfilefileupdate) | **Put** {file_file_remote_href} | Update a file remote
*RemotesGemAPI* | [**RemotesGemGemCreate**](docs/RemotesGemAPI.md#remotesgemgemcreate) | **Post** /pulp/api/v3/remotes/gem/gem/ | Create a gem remote
*RemotesGemAPI* | [**RemotesGemGemDelete**](docs/RemotesGemAPI.md#remotesgemgemdelete) | **Delete** {gem_gem_remote_href} | Delete a gem remote
*RemotesGemAPI* | [**RemotesGemGemList**](docs/RemotesGemAPI.md#remotesgemgemlist) | **Get** /pulp/api/v3/remotes/gem/gem/ | List gem remotes
*RemotesGemAPI* | [**RemotesGemGemPartialUpdate**](docs/RemotesGemAPI.md#remotesgemgempartialupdate) | **Patch** {gem_gem_remote_href} | Update a gem remote
*RemotesGemAPI* | [**RemotesGemGemRead**](docs/RemotesGemAPI.md#remotesgemgemread) | **Get** {gem_gem_remote_href} | Inspect a gem remote
*RemotesGemAPI* | [**RemotesGemGemUpdate**](docs/RemotesGemAPI.md#remotesgemgemupdate) | **Put** {gem_gem_remote_href} | Update a gem remote
*RemotesGitAPI* | [**RemotesAnsibleGitAddRole**](docs/RemotesGitAPI.md#remotesansiblegitaddrole) | **Post** {ansible_git_remote_href}add_role/ | 
*RemotesGitAPI* | [**RemotesAnsibleGitCreate**](docs/RemotesGitAPI.md#remotesansiblegitcreate) | **Post** /pulp/api/v3/remotes/ansible/git/ | Create a git remote
*RemotesGitAPI* | [**RemotesAnsibleGitDelete**](docs/RemotesGitAPI.md#remotesansiblegitdelete) | **Delete** {ansible_git_remote_href} | Delete a git remote
*RemotesGitAPI* | [**RemotesAnsibleGitList**](docs/RemotesGitAPI.md#remotesansiblegitlist) | **Get** /pulp/api/v3/remotes/ansible/git/ | List git remotes
*RemotesGitAPI* | [**RemotesAnsibleGitListRoles**](docs/RemotesGitAPI.md#remotesansiblegitlistroles) | **Get** {ansible_git_remote_href}list_roles/ | 
*RemotesGitAPI* | [**RemotesAnsibleGitMyPermissions**](docs/RemotesGitAPI.md#remotesansiblegitmypermissions) | **Get** {ansible_git_remote_href}my_permissions/ | 
*RemotesGitAPI* | [**RemotesAnsibleGitPartialUpdate**](docs/RemotesGitAPI.md#remotesansiblegitpartialupdate) | **Patch** {ansible_git_remote_href} | Update a git remote
*RemotesGitAPI* | [**RemotesAnsibleGitRead**](docs/RemotesGitAPI.md#remotesansiblegitread) | **Get** {ansible_git_remote_href} | Inspect a git remote
*RemotesGitAPI* | [**RemotesAnsibleGitRemoveRole**](docs/RemotesGitAPI.md#remotesansiblegitremoverole) | **Post** {ansible_git_remote_href}remove_role/ | 
*RemotesGitAPI* | [**RemotesAnsibleGitUpdate**](docs/RemotesGitAPI.md#remotesansiblegitupdate) | **Put** {ansible_git_remote_href} | Update a git remote
*RemotesMavenAPI* | [**RemotesMavenMavenCreate**](docs/RemotesMavenAPI.md#remotesmavenmavencreate) | **Post** /pulp/api/v3/remotes/maven/maven/ | Create a maven remote
*RemotesMavenAPI* | [**RemotesMavenMavenDelete**](docs/RemotesMavenAPI.md#remotesmavenmavendelete) | **Delete** {maven_maven_remote_href} | Delete a maven remote
*RemotesMavenAPI* | [**RemotesMavenMavenList**](docs/RemotesMavenAPI.md#remotesmavenmavenlist) | **Get** /pulp/api/v3/remotes/maven/maven/ | List maven remotes
*RemotesMavenAPI* | [**RemotesMavenMavenPartialUpdate**](docs/RemotesMavenAPI.md#remotesmavenmavenpartialupdate) | **Patch** {maven_maven_remote_href} | Update a maven remote
*RemotesMavenAPI* | [**RemotesMavenMavenRead**](docs/RemotesMavenAPI.md#remotesmavenmavenread) | **Get** {maven_maven_remote_href} | Inspect a maven remote
*RemotesMavenAPI* | [**RemotesMavenMavenUpdate**](docs/RemotesMavenAPI.md#remotesmavenmavenupdate) | **Put** {maven_maven_remote_href} | Update a maven remote
*RemotesOstreeAPI* | [**RemotesOstreeOstreeCreate**](docs/RemotesOstreeAPI.md#remotesostreeostreecreate) | **Post** /pulp/api/v3/remotes/ostree/ostree/ | Create an ostree remote
*RemotesOstreeAPI* | [**RemotesOstreeOstreeDelete**](docs/RemotesOstreeAPI.md#remotesostreeostreedelete) | **Delete** {ostree_ostree_remote_href} | Delete an ostree remote
*RemotesOstreeAPI* | [**RemotesOstreeOstreeList**](docs/RemotesOstreeAPI.md#remotesostreeostreelist) | **Get** /pulp/api/v3/remotes/ostree/ostree/ | List ostree remotes
*RemotesOstreeAPI* | [**RemotesOstreeOstreePartialUpdate**](docs/RemotesOstreeAPI.md#remotesostreeostreepartialupdate) | **Patch** {ostree_ostree_remote_href} | Update an ostree remote
*RemotesOstreeAPI* | [**RemotesOstreeOstreeRead**](docs/RemotesOstreeAPI.md#remotesostreeostreeread) | **Get** {ostree_ostree_remote_href} | Inspect an ostree remote
*RemotesOstreeAPI* | [**RemotesOstreeOstreeUpdate**](docs/RemotesOstreeAPI.md#remotesostreeostreeupdate) | **Put** {ostree_ostree_remote_href} | Update an ostree remote
*RemotesPythonAPI* | [**RemotesPythonPythonCreate**](docs/RemotesPythonAPI.md#remotespythonpythoncreate) | **Post** /pulp/api/v3/remotes/python/python/ | Create a python remote
*RemotesPythonAPI* | [**RemotesPythonPythonDelete**](docs/RemotesPythonAPI.md#remotespythonpythondelete) | **Delete** {python_python_remote_href} | Delete a python remote
*RemotesPythonAPI* | [**RemotesPythonPythonFromBandersnatch**](docs/RemotesPythonAPI.md#remotespythonpythonfrombandersnatch) | **Post** /pulp/api/v3/remotes/python/python/from_bandersnatch/ | Create from Bandersnatch
*RemotesPythonAPI* | [**RemotesPythonPythonList**](docs/RemotesPythonAPI.md#remotespythonpythonlist) | **Get** /pulp/api/v3/remotes/python/python/ | List python remotes
*RemotesPythonAPI* | [**RemotesPythonPythonPartialUpdate**](docs/RemotesPythonAPI.md#remotespythonpythonpartialupdate) | **Patch** {python_python_remote_href} | Update a python remote
*RemotesPythonAPI* | [**RemotesPythonPythonRead**](docs/RemotesPythonAPI.md#remotespythonpythonread) | **Get** {python_python_remote_href} | Inspect a python remote
*RemotesPythonAPI* | [**RemotesPythonPythonUpdate**](docs/RemotesPythonAPI.md#remotespythonpythonupdate) | **Put** {python_python_remote_href} | Update a python remote
*RemotesRoleAPI* | [**RemotesAnsibleRoleAddRole**](docs/RemotesRoleAPI.md#remotesansibleroleaddrole) | **Post** {ansible_role_remote_href}add_role/ | 
*RemotesRoleAPI* | [**RemotesAnsibleRoleCreate**](docs/RemotesRoleAPI.md#remotesansiblerolecreate) | **Post** /pulp/api/v3/remotes/ansible/role/ | Create a role remote
*RemotesRoleAPI* | [**RemotesAnsibleRoleDelete**](docs/RemotesRoleAPI.md#remotesansibleroledelete) | **Delete** {ansible_role_remote_href} | Delete a role remote
*RemotesRoleAPI* | [**RemotesAnsibleRoleList**](docs/RemotesRoleAPI.md#remotesansiblerolelist) | **Get** /pulp/api/v3/remotes/ansible/role/ | List role remotes
*RemotesRoleAPI* | [**RemotesAnsibleRoleListRoles**](docs/RemotesRoleAPI.md#remotesansiblerolelistroles) | **Get** {ansible_role_remote_href}list_roles/ | 
*RemotesRoleAPI* | [**RemotesAnsibleRoleMyPermissions**](docs/RemotesRoleAPI.md#remotesansiblerolemypermissions) | **Get** {ansible_role_remote_href}my_permissions/ | 
*RemotesRoleAPI* | [**RemotesAnsibleRolePartialUpdate**](docs/RemotesRoleAPI.md#remotesansiblerolepartialupdate) | **Patch** {ansible_role_remote_href} | Update a role remote
*RemotesRoleAPI* | [**RemotesAnsibleRoleRead**](docs/RemotesRoleAPI.md#remotesansibleroleread) | **Get** {ansible_role_remote_href} | Inspect a role remote
*RemotesRoleAPI* | [**RemotesAnsibleRoleRemoveRole**](docs/RemotesRoleAPI.md#remotesansibleroleremoverole) | **Post** {ansible_role_remote_href}remove_role/ | 
*RemotesRoleAPI* | [**RemotesAnsibleRoleUpdate**](docs/RemotesRoleAPI.md#remotesansibleroleupdate) | **Put** {ansible_role_remote_href} | Update a role remote
*RemotesRpmAPI* | [**RemotesRpmRpmAddRole**](docs/RemotesRpmAPI.md#remotesrpmrpmaddrole) | **Post** {rpm_rpm_remote_href}add_role/ | 
*RemotesRpmAPI* | [**RemotesRpmRpmCreate**](docs/RemotesRpmAPI.md#remotesrpmrpmcreate) | **Post** /pulp/api/v3/remotes/rpm/rpm/ | Create a rpm remote
*RemotesRpmAPI* | [**RemotesRpmRpmDelete**](docs/RemotesRpmAPI.md#remotesrpmrpmdelete) | **Delete** {rpm_rpm_remote_href} | Delete a rpm remote
*RemotesRpmAPI* | [**RemotesRpmRpmList**](docs/RemotesRpmAPI.md#remotesrpmrpmlist) | **Get** /pulp/api/v3/remotes/rpm/rpm/ | List rpm remotes
*RemotesRpmAPI* | [**RemotesRpmRpmListRoles**](docs/RemotesRpmAPI.md#remotesrpmrpmlistroles) | **Get** {rpm_rpm_remote_href}list_roles/ | 
*RemotesRpmAPI* | [**RemotesRpmRpmMyPermissions**](docs/RemotesRpmAPI.md#remotesrpmrpmmypermissions) | **Get** {rpm_rpm_remote_href}my_permissions/ | 
*RemotesRpmAPI* | [**RemotesRpmRpmPartialUpdate**](docs/RemotesRpmAPI.md#remotesrpmrpmpartialupdate) | **Patch** {rpm_rpm_remote_href} | Update a rpm remote
*RemotesRpmAPI* | [**RemotesRpmRpmRead**](docs/RemotesRpmAPI.md#remotesrpmrpmread) | **Get** {rpm_rpm_remote_href} | Inspect a rpm remote
*RemotesRpmAPI* | [**RemotesRpmRpmRemoveRole**](docs/RemotesRpmAPI.md#remotesrpmrpmremoverole) | **Post** {rpm_rpm_remote_href}remove_role/ | 
*RemotesRpmAPI* | [**RemotesRpmRpmUpdate**](docs/RemotesRpmAPI.md#remotesrpmrpmupdate) | **Put** {rpm_rpm_remote_href} | Update a rpm remote
*RemotesUlnAPI* | [**RemotesRpmUlnAddRole**](docs/RemotesUlnAPI.md#remotesrpmulnaddrole) | **Post** {rpm_uln_remote_href}add_role/ | 
*RemotesUlnAPI* | [**RemotesRpmUlnCreate**](docs/RemotesUlnAPI.md#remotesrpmulncreate) | **Post** /pulp/api/v3/remotes/rpm/uln/ | Create an uln remote
*RemotesUlnAPI* | [**RemotesRpmUlnDelete**](docs/RemotesUlnAPI.md#remotesrpmulndelete) | **Delete** {rpm_uln_remote_href} | Delete an uln remote
*RemotesUlnAPI* | [**RemotesRpmUlnList**](docs/RemotesUlnAPI.md#remotesrpmulnlist) | **Get** /pulp/api/v3/remotes/rpm/uln/ | List uln remotes
*RemotesUlnAPI* | [**RemotesRpmUlnListRoles**](docs/RemotesUlnAPI.md#remotesrpmulnlistroles) | **Get** {rpm_uln_remote_href}list_roles/ | 
*RemotesUlnAPI* | [**RemotesRpmUlnMyPermissions**](docs/RemotesUlnAPI.md#remotesrpmulnmypermissions) | **Get** {rpm_uln_remote_href}my_permissions/ | 
*RemotesUlnAPI* | [**RemotesRpmUlnPartialUpdate**](docs/RemotesUlnAPI.md#remotesrpmulnpartialupdate) | **Patch** {rpm_uln_remote_href} | Update an uln remote
*RemotesUlnAPI* | [**RemotesRpmUlnRead**](docs/RemotesUlnAPI.md#remotesrpmulnread) | **Get** {rpm_uln_remote_href} | Inspect an uln remote
*RemotesUlnAPI* | [**RemotesRpmUlnRemoveRole**](docs/RemotesUlnAPI.md#remotesrpmulnremoverole) | **Post** {rpm_uln_remote_href}remove_role/ | 
*RemotesUlnAPI* | [**RemotesRpmUlnUpdate**](docs/RemotesUlnAPI.md#remotesrpmulnupdate) | **Put** {rpm_uln_remote_href} | Update an uln remote
*RepairAPI* | [**RepairPost**](docs/RepairAPI.md#repairpost) | **Post** /pulp/api/v3/repair/ | Repair Artifact Storage
*RepositoriesAPI* | [**RepositoriesList**](docs/RepositoriesAPI.md#repositorieslist) | **Get** /pulp/api/v3/repositories/ | List repositories
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleAddRole**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansibleaddrole) | **Post** {ansible_ansible_repository_href}add_role/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleCopyCollectionVersion**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblecopycollectionversion) | **Post** {ansible_ansible_repository_href}copy_collection_version/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleCreate**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblecreate) | **Post** /pulp/api/v3/repositories/ansible/ansible/ | Create an ansible repository
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleDelete**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansibledelete) | **Delete** {ansible_ansible_repository_href} | Delete an ansible repository
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleList**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblelist) | **Get** /pulp/api/v3/repositories/ansible/ansible/ | List ansible repositorys
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleListRoles**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblelistroles) | **Get** {ansible_ansible_repository_href}list_roles/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleMark**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblemark) | **Post** {ansible_ansible_repository_href}mark/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleModify**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblemodify) | **Post** {ansible_ansible_repository_href}modify/ | Modify Repository Content
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleMoveCollectionVersion**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblemovecollectionversion) | **Post** {ansible_ansible_repository_href}move_collection_version/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleMyPermissions**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblemypermissions) | **Get** {ansible_ansible_repository_href}my_permissions/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsiblePartialUpdate**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblepartialupdate) | **Patch** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleRead**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansibleread) | **Get** {ansible_ansible_repository_href} | Inspect an ansible repository
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleRebuildMetadata**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblerebuildmetadata) | **Post** {ansible_ansible_repository_href}rebuild_metadata/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleRemoveRole**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansibleremoverole) | **Post** {ansible_ansible_repository_href}remove_role/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleSign**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblesign) | **Post** {ansible_ansible_repository_href}sign/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleSync**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansiblesync) | **Post** {ansible_ansible_repository_href}sync/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleUnmark**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansibleunmark) | **Post** {ansible_ansible_repository_href}unmark/ | 
*RepositoriesAnsibleAPI* | [**RepositoriesAnsibleAnsibleUpdate**](docs/RepositoriesAnsibleAPI.md#repositoriesansibleansibleupdate) | **Put** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleVersionsAPI* | [**RepositoriesAnsibleAnsibleVersionsDelete**](docs/RepositoriesAnsibleVersionsAPI.md#repositoriesansibleansibleversionsdelete) | **Delete** {ansible_ansible_repository_version_href} | Delete a repository version
*RepositoriesAnsibleVersionsAPI* | [**RepositoriesAnsibleAnsibleVersionsList**](docs/RepositoriesAnsibleVersionsAPI.md#repositoriesansibleansibleversionslist) | **Get** {ansible_ansible_repository_href}versions/ | List repository versions
*RepositoriesAnsibleVersionsAPI* | [**RepositoriesAnsibleAnsibleVersionsRead**](docs/RepositoriesAnsibleVersionsAPI.md#repositoriesansibleansibleversionsread) | **Get** {ansible_ansible_repository_version_href} | Inspect a repository version
*RepositoriesAnsibleVersionsAPI* | [**RepositoriesAnsibleAnsibleVersionsRebuildMetadata**](docs/RepositoriesAnsibleVersionsAPI.md#repositoriesansibleansibleversionsrebuildmetadata) | **Post** {ansible_ansible_repository_version_href}rebuild_metadata/ | 
*RepositoriesAnsibleVersionsAPI* | [**RepositoriesAnsibleAnsibleVersionsRepair**](docs/RepositoriesAnsibleVersionsAPI.md#repositoriesansibleansibleversionsrepair) | **Post** {ansible_ansible_repository_version_href}repair/ | 
*RepositoriesAptAPI* | [**RepositoriesDebAptCreate**](docs/RepositoriesAptAPI.md#repositoriesdebaptcreate) | **Post** /pulp/api/v3/repositories/deb/apt/ | Create an apt repository
*RepositoriesAptAPI* | [**RepositoriesDebAptDelete**](docs/RepositoriesAptAPI.md#repositoriesdebaptdelete) | **Delete** {deb_apt_repository_href} | Delete an apt repository
*RepositoriesAptAPI* | [**RepositoriesDebAptList**](docs/RepositoriesAptAPI.md#repositoriesdebaptlist) | **Get** /pulp/api/v3/repositories/deb/apt/ | List apt repositorys
*RepositoriesAptAPI* | [**RepositoriesDebAptModify**](docs/RepositoriesAptAPI.md#repositoriesdebaptmodify) | **Post** {deb_apt_repository_href}modify/ | Modify Repository Content
*RepositoriesAptAPI* | [**RepositoriesDebAptPartialUpdate**](docs/RepositoriesAptAPI.md#repositoriesdebaptpartialupdate) | **Patch** {deb_apt_repository_href} | Update an apt repository
*RepositoriesAptAPI* | [**RepositoriesDebAptRead**](docs/RepositoriesAptAPI.md#repositoriesdebaptread) | **Get** {deb_apt_repository_href} | Inspect an apt repository
*RepositoriesAptAPI* | [**RepositoriesDebAptSync**](docs/RepositoriesAptAPI.md#repositoriesdebaptsync) | **Post** {deb_apt_repository_href}sync/ | Sync from remote
*RepositoriesAptAPI* | [**RepositoriesDebAptUpdate**](docs/RepositoriesAptAPI.md#repositoriesdebaptupdate) | **Put** {deb_apt_repository_href} | Update an apt repository
*RepositoriesAptVersionsAPI* | [**RepositoriesDebAptVersionsDelete**](docs/RepositoriesAptVersionsAPI.md#repositoriesdebaptversionsdelete) | **Delete** {deb_apt_repository_version_href} | Delete a repository version
*RepositoriesAptVersionsAPI* | [**RepositoriesDebAptVersionsList**](docs/RepositoriesAptVersionsAPI.md#repositoriesdebaptversionslist) | **Get** {deb_apt_repository_href}versions/ | List repository versions
*RepositoriesAptVersionsAPI* | [**RepositoriesDebAptVersionsRead**](docs/RepositoriesAptVersionsAPI.md#repositoriesdebaptversionsread) | **Get** {deb_apt_repository_version_href} | Inspect a repository version
*RepositoriesAptVersionsAPI* | [**RepositoriesDebAptVersionsRepair**](docs/RepositoriesAptVersionsAPI.md#repositoriesdebaptversionsrepair) | **Post** {deb_apt_repository_version_href}repair/ | 
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerAdd**](docs/RepositoriesContainerAPI.md#repositoriescontainercontaineradd) | **Post** {container_container_repository_href}add/ | Add content
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerAddRole**](docs/RepositoriesContainerAPI.md#repositoriescontainercontaineraddrole) | **Post** {container_container_repository_href}add_role/ | 
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerBuildImage**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerbuildimage) | **Post** {container_container_repository_href}build_image/ | Build an Image
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerCopyManifests**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainercopymanifests) | **Post** {container_container_repository_href}copy_manifests/ | Copy manifests
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerCopyTags**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainercopytags) | **Post** {container_container_repository_href}copy_tags/ | Copy tags
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerCreate**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainercreate) | **Post** /pulp/api/v3/repositories/container/container/ | Create a container repository
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerDelete**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerdelete) | **Delete** {container_container_repository_href} | Delete a container repository
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerList**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerlist) | **Get** /pulp/api/v3/repositories/container/container/ | List container repositorys
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerListRoles**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerlistroles) | **Get** {container_container_repository_href}list_roles/ | 
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerMyPermissions**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainermypermissions) | **Get** {container_container_repository_href}my_permissions/ | 
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerPartialUpdate**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerpartialupdate) | **Patch** {container_container_repository_href} | Update a container repository
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerRead**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerread) | **Get** {container_container_repository_href} | Inspect a container repository
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerRemove**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerremove) | **Post** {container_container_repository_href}remove/ | Remove content
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerRemoveRole**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerremoverole) | **Post** {container_container_repository_href}remove_role/ | 
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerSign**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainersign) | **Post** {container_container_repository_href}sign/ | Sign images in the repo
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerSync**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainersync) | **Post** {container_container_repository_href}sync/ | Sync from a remote
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerTag**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainertag) | **Post** {container_container_repository_href}tag/ | Create a Tag
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerUntag**](docs/RepositoriesContainerAPI.md#repositoriescontainercontaineruntag) | **Post** {container_container_repository_href}untag/ | Delete a tag
*RepositoriesContainerAPI* | [**RepositoriesContainerContainerUpdate**](docs/RepositoriesContainerAPI.md#repositoriescontainercontainerupdate) | **Put** {container_container_repository_href} | Update a container repository
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushAddRole**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushaddrole) | **Post** {container_container_push_repository_href}add_role/ | 
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushList**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushlist) | **Get** /pulp/api/v3/repositories/container/container-push/ | List container push repositorys
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushListRoles**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushlistroles) | **Get** {container_container_push_repository_href}list_roles/ | 
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushMyPermissions**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushmypermissions) | **Get** {container_container_push_repository_href}my_permissions/ | 
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushPartialUpdate**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushpartialupdate) | **Patch** {container_container_push_repository_href} | Update a container push repository
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushRead**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushread) | **Get** {container_container_push_repository_href} | Inspect a container push repository
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushRemoveImage**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushremoveimage) | **Post** {container_container_push_repository_href}remove_image/ | Delete an image from a repository
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushRemoveRole**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushremoverole) | **Post** {container_container_push_repository_href}remove_role/ | 
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushRemoveSignatures**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushremovesignatures) | **Post** {container_container_push_repository_href}remove_signatures/ | 
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushSign**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushsign) | **Post** {container_container_push_repository_href}sign/ | Sign images in the repo
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushTag**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushtag) | **Post** {container_container_push_repository_href}tag/ | Create a Tag
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushUntag**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushuntag) | **Post** {container_container_push_repository_href}untag/ | Delete a tag
*RepositoriesContainerPushAPI* | [**RepositoriesContainerContainerPushUpdate**](docs/RepositoriesContainerPushAPI.md#repositoriescontainercontainerpushupdate) | **Put** {container_container_push_repository_href} | Update a container push repository
*RepositoriesContainerPushVersionsAPI* | [**RepositoriesContainerContainerPushVersionsDelete**](docs/RepositoriesContainerPushVersionsAPI.md#repositoriescontainercontainerpushversionsdelete) | **Delete** {container_container_push_repository_version_href} | Delete a repository version
*RepositoriesContainerPushVersionsAPI* | [**RepositoriesContainerContainerPushVersionsList**](docs/RepositoriesContainerPushVersionsAPI.md#repositoriescontainercontainerpushversionslist) | **Get** {container_container_push_repository_href}versions/ | List repository versions
*RepositoriesContainerPushVersionsAPI* | [**RepositoriesContainerContainerPushVersionsRead**](docs/RepositoriesContainerPushVersionsAPI.md#repositoriescontainercontainerpushversionsread) | **Get** {container_container_push_repository_version_href} | Inspect a repository version
*RepositoriesContainerPushVersionsAPI* | [**RepositoriesContainerContainerPushVersionsRepair**](docs/RepositoriesContainerPushVersionsAPI.md#repositoriescontainercontainerpushversionsrepair) | **Post** {container_container_push_repository_version_href}repair/ | 
*RepositoriesContainerVersionsAPI* | [**RepositoriesContainerContainerVersionsDelete**](docs/RepositoriesContainerVersionsAPI.md#repositoriescontainercontainerversionsdelete) | **Delete** {container_container_repository_version_href} | Delete a repository version
*RepositoriesContainerVersionsAPI* | [**RepositoriesContainerContainerVersionsList**](docs/RepositoriesContainerVersionsAPI.md#repositoriescontainercontainerversionslist) | **Get** {container_container_repository_href}versions/ | List repository versions
*RepositoriesContainerVersionsAPI* | [**RepositoriesContainerContainerVersionsRead**](docs/RepositoriesContainerVersionsAPI.md#repositoriescontainercontainerversionsread) | **Get** {container_container_repository_version_href} | Inspect a repository version
*RepositoriesContainerVersionsAPI* | [**RepositoriesContainerContainerVersionsRepair**](docs/RepositoriesContainerVersionsAPI.md#repositoriescontainercontainerversionsrepair) | **Post** {container_container_repository_version_href}repair/ | 
*RepositoriesFileAPI* | [**RepositoriesFileFileAddRole**](docs/RepositoriesFileAPI.md#repositoriesfilefileaddrole) | **Post** {file_file_repository_href}add_role/ | 
*RepositoriesFileAPI* | [**RepositoriesFileFileCreate**](docs/RepositoriesFileAPI.md#repositoriesfilefilecreate) | **Post** /pulp/api/v3/repositories/file/file/ | Create a file repository
*RepositoriesFileAPI* | [**RepositoriesFileFileDelete**](docs/RepositoriesFileAPI.md#repositoriesfilefiledelete) | **Delete** {file_file_repository_href} | Delete a file repository
*RepositoriesFileAPI* | [**RepositoriesFileFileList**](docs/RepositoriesFileAPI.md#repositoriesfilefilelist) | **Get** /pulp/api/v3/repositories/file/file/ | List file repositorys
*RepositoriesFileAPI* | [**RepositoriesFileFileListRoles**](docs/RepositoriesFileAPI.md#repositoriesfilefilelistroles) | **Get** {file_file_repository_href}list_roles/ | 
*RepositoriesFileAPI* | [**RepositoriesFileFileModify**](docs/RepositoriesFileAPI.md#repositoriesfilefilemodify) | **Post** {file_file_repository_href}modify/ | Modify Repository Content
*RepositoriesFileAPI* | [**RepositoriesFileFileMyPermissions**](docs/RepositoriesFileAPI.md#repositoriesfilefilemypermissions) | **Get** {file_file_repository_href}my_permissions/ | 
*RepositoriesFileAPI* | [**RepositoriesFileFilePartialUpdate**](docs/RepositoriesFileAPI.md#repositoriesfilefilepartialupdate) | **Patch** {file_file_repository_href} | Update a file repository
*RepositoriesFileAPI* | [**RepositoriesFileFileRead**](docs/RepositoriesFileAPI.md#repositoriesfilefileread) | **Get** {file_file_repository_href} | Inspect a file repository
*RepositoriesFileAPI* | [**RepositoriesFileFileRemoveRole**](docs/RepositoriesFileAPI.md#repositoriesfilefileremoverole) | **Post** {file_file_repository_href}remove_role/ | 
*RepositoriesFileAPI* | [**RepositoriesFileFileSync**](docs/RepositoriesFileAPI.md#repositoriesfilefilesync) | **Post** {file_file_repository_href}sync/ | Sync from a remote
*RepositoriesFileAPI* | [**RepositoriesFileFileUpdate**](docs/RepositoriesFileAPI.md#repositoriesfilefileupdate) | **Put** {file_file_repository_href} | Update a file repository
*RepositoriesFileVersionsAPI* | [**RepositoriesFileFileVersionsDelete**](docs/RepositoriesFileVersionsAPI.md#repositoriesfilefileversionsdelete) | **Delete** {file_file_repository_version_href} | Delete a repository version
*RepositoriesFileVersionsAPI* | [**RepositoriesFileFileVersionsList**](docs/RepositoriesFileVersionsAPI.md#repositoriesfilefileversionslist) | **Get** {file_file_repository_href}versions/ | List repository versions
*RepositoriesFileVersionsAPI* | [**RepositoriesFileFileVersionsRead**](docs/RepositoriesFileVersionsAPI.md#repositoriesfilefileversionsread) | **Get** {file_file_repository_version_href} | Inspect a repository version
*RepositoriesFileVersionsAPI* | [**RepositoriesFileFileVersionsRepair**](docs/RepositoriesFileVersionsAPI.md#repositoriesfilefileversionsrepair) | **Post** {file_file_repository_version_href}repair/ | 
*RepositoriesGemAPI* | [**RepositoriesGemGemCreate**](docs/RepositoriesGemAPI.md#repositoriesgemgemcreate) | **Post** /pulp/api/v3/repositories/gem/gem/ | Create a gem repository
*RepositoriesGemAPI* | [**RepositoriesGemGemDelete**](docs/RepositoriesGemAPI.md#repositoriesgemgemdelete) | **Delete** {gem_gem_repository_href} | Delete a gem repository
*RepositoriesGemAPI* | [**RepositoriesGemGemList**](docs/RepositoriesGemAPI.md#repositoriesgemgemlist) | **Get** /pulp/api/v3/repositories/gem/gem/ | List gem repositorys
*RepositoriesGemAPI* | [**RepositoriesGemGemModify**](docs/RepositoriesGemAPI.md#repositoriesgemgemmodify) | **Post** {gem_gem_repository_href}modify/ | Modify Repository Content
*RepositoriesGemAPI* | [**RepositoriesGemGemPartialUpdate**](docs/RepositoriesGemAPI.md#repositoriesgemgempartialupdate) | **Patch** {gem_gem_repository_href} | Update a gem repository
*RepositoriesGemAPI* | [**RepositoriesGemGemRead**](docs/RepositoriesGemAPI.md#repositoriesgemgemread) | **Get** {gem_gem_repository_href} | Inspect a gem repository
*RepositoriesGemAPI* | [**RepositoriesGemGemSync**](docs/RepositoriesGemAPI.md#repositoriesgemgemsync) | **Post** {gem_gem_repository_href}sync/ | Sync from a remote
*RepositoriesGemAPI* | [**RepositoriesGemGemUpdate**](docs/RepositoriesGemAPI.md#repositoriesgemgemupdate) | **Put** {gem_gem_repository_href} | Update a gem repository
*RepositoriesGemVersionsAPI* | [**RepositoriesGemGemVersionsDelete**](docs/RepositoriesGemVersionsAPI.md#repositoriesgemgemversionsdelete) | **Delete** {gem_gem_repository_version_href} | Delete a repository version
*RepositoriesGemVersionsAPI* | [**RepositoriesGemGemVersionsList**](docs/RepositoriesGemVersionsAPI.md#repositoriesgemgemversionslist) | **Get** {gem_gem_repository_href}versions/ | List repository versions
*RepositoriesGemVersionsAPI* | [**RepositoriesGemGemVersionsRead**](docs/RepositoriesGemVersionsAPI.md#repositoriesgemgemversionsread) | **Get** {gem_gem_repository_version_href} | Inspect a repository version
*RepositoriesGemVersionsAPI* | [**RepositoriesGemGemVersionsRepair**](docs/RepositoriesGemVersionsAPI.md#repositoriesgemgemversionsrepair) | **Post** {gem_gem_repository_version_href}repair/ | 
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenAddCachedContent**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavenaddcachedcontent) | **Post** {maven_maven_repository_href}add_cached_content/ | Add cached content
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenCreate**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavencreate) | **Post** /pulp/api/v3/repositories/maven/maven/ | Create a maven repository
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenDelete**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavendelete) | **Delete** {maven_maven_repository_href} | Delete a maven repository
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenList**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavenlist) | **Get** /pulp/api/v3/repositories/maven/maven/ | List maven repositorys
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenPartialUpdate**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavenpartialupdate) | **Patch** {maven_maven_repository_href} | Update a maven repository
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenRead**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavenread) | **Get** {maven_maven_repository_href} | Inspect a maven repository
*RepositoriesMavenAPI* | [**RepositoriesMavenMavenUpdate**](docs/RepositoriesMavenAPI.md#repositoriesmavenmavenupdate) | **Put** {maven_maven_repository_href} | Update a maven repository
*RepositoriesMavenVersionsAPI* | [**RepositoriesMavenMavenVersionsDelete**](docs/RepositoriesMavenVersionsAPI.md#repositoriesmavenmavenversionsdelete) | **Delete** {maven_maven_repository_version_href} | Delete a repository version
*RepositoriesMavenVersionsAPI* | [**RepositoriesMavenMavenVersionsList**](docs/RepositoriesMavenVersionsAPI.md#repositoriesmavenmavenversionslist) | **Get** {maven_maven_repository_href}versions/ | List repository versions
*RepositoriesMavenVersionsAPI* | [**RepositoriesMavenMavenVersionsRead**](docs/RepositoriesMavenVersionsAPI.md#repositoriesmavenmavenversionsread) | **Get** {maven_maven_repository_version_href} | Inspect a repository version
*RepositoriesMavenVersionsAPI* | [**RepositoriesMavenMavenVersionsRepair**](docs/RepositoriesMavenVersionsAPI.md#repositoriesmavenmavenversionsrepair) | **Post** {maven_maven_repository_version_href}repair/ | 
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeCreate**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreecreate) | **Post** /pulp/api/v3/repositories/ostree/ostree/ | Create an ostree repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeDelete**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreedelete) | **Delete** {ostree_ostree_repository_href} | Delete an ostree repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeImportAll**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreeimportall) | **Post** {ostree_ostree_repository_href}import_all/ | Import refs and commits to a repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeImportCommits**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreeimportcommits) | **Post** {ostree_ostree_repository_href}import_commits/ | Append child commits to a repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeList**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreelist) | **Get** /pulp/api/v3/repositories/ostree/ostree/ | List ostree repositorys
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeModify**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreemodify) | **Post** {ostree_ostree_repository_href}modify/ | Modify repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreePartialUpdate**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreepartialupdate) | **Patch** {ostree_ostree_repository_href} | Update an ostree repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeRead**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreeread) | **Get** {ostree_ostree_repository_href} | Inspect an ostree repository
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeSync**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreesync) | **Post** {ostree_ostree_repository_href}sync/ | Sync from remote
*RepositoriesOstreeAPI* | [**RepositoriesOstreeOstreeUpdate**](docs/RepositoriesOstreeAPI.md#repositoriesostreeostreeupdate) | **Put** {ostree_ostree_repository_href} | Update an ostree repository
*RepositoriesOstreeVersionsAPI* | [**RepositoriesOstreeOstreeVersionsDelete**](docs/RepositoriesOstreeVersionsAPI.md#repositoriesostreeostreeversionsdelete) | **Delete** {ostree_ostree_repository_version_href} | Delete a repository version
*RepositoriesOstreeVersionsAPI* | [**RepositoriesOstreeOstreeVersionsList**](docs/RepositoriesOstreeVersionsAPI.md#repositoriesostreeostreeversionslist) | **Get** {ostree_ostree_repository_href}versions/ | List repository versions
*RepositoriesOstreeVersionsAPI* | [**RepositoriesOstreeOstreeVersionsRead**](docs/RepositoriesOstreeVersionsAPI.md#repositoriesostreeostreeversionsread) | **Get** {ostree_ostree_repository_version_href} | Inspect a repository version
*RepositoriesOstreeVersionsAPI* | [**RepositoriesOstreeOstreeVersionsRepair**](docs/RepositoriesOstreeVersionsAPI.md#repositoriesostreeostreeversionsrepair) | **Post** {ostree_ostree_repository_version_href}repair/ | 
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonCreate**](docs/RepositoriesPythonAPI.md#repositoriespythonpythoncreate) | **Post** /pulp/api/v3/repositories/python/python/ | Create a python repository
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonDelete**](docs/RepositoriesPythonAPI.md#repositoriespythonpythondelete) | **Delete** {python_python_repository_href} | Delete a python repository
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonList**](docs/RepositoriesPythonAPI.md#repositoriespythonpythonlist) | **Get** /pulp/api/v3/repositories/python/python/ | List python repositorys
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonModify**](docs/RepositoriesPythonAPI.md#repositoriespythonpythonmodify) | **Post** {python_python_repository_href}modify/ | Modify Repository Content
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonPartialUpdate**](docs/RepositoriesPythonAPI.md#repositoriespythonpythonpartialupdate) | **Patch** {python_python_repository_href} | Update a python repository
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonRead**](docs/RepositoriesPythonAPI.md#repositoriespythonpythonread) | **Get** {python_python_repository_href} | Inspect a python repository
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonSync**](docs/RepositoriesPythonAPI.md#repositoriespythonpythonsync) | **Post** {python_python_repository_href}sync/ | Sync from remote
*RepositoriesPythonAPI* | [**RepositoriesPythonPythonUpdate**](docs/RepositoriesPythonAPI.md#repositoriespythonpythonupdate) | **Put** {python_python_repository_href} | Update a python repository
*RepositoriesPythonVersionsAPI* | [**RepositoriesPythonPythonVersionsDelete**](docs/RepositoriesPythonVersionsAPI.md#repositoriespythonpythonversionsdelete) | **Delete** {python_python_repository_version_href} | Delete a repository version
*RepositoriesPythonVersionsAPI* | [**RepositoriesPythonPythonVersionsList**](docs/RepositoriesPythonVersionsAPI.md#repositoriespythonpythonversionslist) | **Get** {python_python_repository_href}versions/ | List repository versions
*RepositoriesPythonVersionsAPI* | [**RepositoriesPythonPythonVersionsRead**](docs/RepositoriesPythonVersionsAPI.md#repositoriespythonpythonversionsread) | **Get** {python_python_repository_version_href} | Inspect a repository version
*RepositoriesPythonVersionsAPI* | [**RepositoriesPythonPythonVersionsRepair**](docs/RepositoriesPythonVersionsAPI.md#repositoriespythonpythonversionsrepair) | **Post** {python_python_repository_version_href}repair/ | 
*RepositoriesReclaimSpaceAPI* | [**RepositoriesReclaimSpaceReclaim**](docs/RepositoriesReclaimSpaceAPI.md#repositoriesreclaimspacereclaim) | **Post** /pulp/api/v3/repositories/reclaim_space/ | 
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmAddRole**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmaddrole) | **Post** {rpm_rpm_repository_href}add_role/ | 
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmCreate**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmcreate) | **Post** /pulp/api/v3/repositories/rpm/rpm/ | Create a rpm repository
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmDelete**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmdelete) | **Delete** {rpm_rpm_repository_href} | Delete a rpm repository
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmList**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmlist) | **Get** /pulp/api/v3/repositories/rpm/rpm/ | List rpm repositorys
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmListRoles**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmlistroles) | **Get** {rpm_rpm_repository_href}list_roles/ | 
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmModify**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmmodify) | **Post** {rpm_rpm_repository_href}modify/ | Modify Repository Content
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmMyPermissions**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmmypermissions) | **Get** {rpm_rpm_repository_href}my_permissions/ | 
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmPartialUpdate**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmpartialupdate) | **Patch** {rpm_rpm_repository_href} | Update a rpm repository
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmRead**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmread) | **Get** {rpm_rpm_repository_href} | Inspect a rpm repository
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmRemoveRole**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmremoverole) | **Post** {rpm_rpm_repository_href}remove_role/ | 
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmSync**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmsync) | **Post** {rpm_rpm_repository_href}sync/ | Sync from remote
*RepositoriesRpmAPI* | [**RepositoriesRpmRpmUpdate**](docs/RepositoriesRpmAPI.md#repositoriesrpmrpmupdate) | **Put** {rpm_rpm_repository_href} | Update a rpm repository
*RepositoriesRpmVersionsAPI* | [**RepositoriesRpmRpmVersionsDelete**](docs/RepositoriesRpmVersionsAPI.md#repositoriesrpmrpmversionsdelete) | **Delete** {rpm_rpm_repository_version_href} | Delete a repository version
*RepositoriesRpmVersionsAPI* | [**RepositoriesRpmRpmVersionsList**](docs/RepositoriesRpmVersionsAPI.md#repositoriesrpmrpmversionslist) | **Get** {rpm_rpm_repository_href}versions/ | List repository versions
*RepositoriesRpmVersionsAPI* | [**RepositoriesRpmRpmVersionsRead**](docs/RepositoriesRpmVersionsAPI.md#repositoriesrpmrpmversionsread) | **Get** {rpm_rpm_repository_version_href} | Inspect a repository version
*RepositoriesRpmVersionsAPI* | [**RepositoriesRpmRpmVersionsRepair**](docs/RepositoriesRpmVersionsAPI.md#repositoriesrpmrpmversionsrepair) | **Post** {rpm_rpm_repository_version_href}repair/ | 
*RepositoryVersionsAPI* | [**RepositoryVersionsList**](docs/RepositoryVersionsAPI.md#repositoryversionslist) | **Get** /pulp/api/v3/repository_versions/ | List repository versions
*RolesAPI* | [**RolesCreate**](docs/RolesAPI.md#rolescreate) | **Post** /pulp/api/v3/roles/ | Create a role
*RolesAPI* | [**RolesDelete**](docs/RolesAPI.md#rolesdelete) | **Delete** {role_href} | Delete a role
*RolesAPI* | [**RolesList**](docs/RolesAPI.md#roleslist) | **Get** /pulp/api/v3/roles/ | List roles
*RolesAPI* | [**RolesPartialUpdate**](docs/RolesAPI.md#rolespartialupdate) | **Patch** {role_href} | Update a role
*RolesAPI* | [**RolesRead**](docs/RolesAPI.md#rolesread) | **Get** {role_href} | Inspect a role
*RolesAPI* | [**RolesUpdate**](docs/RolesAPI.md#rolesupdate) | **Put** {role_href} | Update a role
*RpmCompsAPI* | [**RpmCompsUpload**](docs/RpmCompsAPI.md#rpmcompsupload) | **Post** /pulp/api/v3/rpm/comps/ | Upload comps.xml
*RpmCopyAPI* | [**CopyContent**](docs/RpmCopyAPI.md#copycontent) | **Post** /pulp/api/v3/rpm/copy/ | Copy content
*SigningServicesAPI* | [**SigningServicesList**](docs/SigningServicesAPI.md#signingserviceslist) | **Get** /pulp/api/v3/signing-services/ | List signing services
*SigningServicesAPI* | [**SigningServicesRead**](docs/SigningServicesAPI.md#signingservicesread) | **Get** {signing_service_href} | Inspect a signing service
*StatusAPI* | [**StatusRead**](docs/StatusAPI.md#statusread) | **Get** /pulp/api/v3/status/ | Inspect status of Pulp
*TaskGroupsAPI* | [**TaskGroupsList**](docs/TaskGroupsAPI.md#taskgroupslist) | **Get** /pulp/api/v3/task-groups/ | List task groups
*TaskGroupsAPI* | [**TaskGroupsRead**](docs/TaskGroupsAPI.md#taskgroupsread) | **Get** {task_group_href} | Inspect a task group
*TaskSchedulesAPI* | [**TaskSchedulesAddRole**](docs/TaskSchedulesAPI.md#taskschedulesaddrole) | **Post** {task_schedule_href}add_role/ | 
*TaskSchedulesAPI* | [**TaskSchedulesList**](docs/TaskSchedulesAPI.md#taskscheduleslist) | **Get** /pulp/api/v3/task-schedules/ | List task schedules
*TaskSchedulesAPI* | [**TaskSchedulesListRoles**](docs/TaskSchedulesAPI.md#taskscheduleslistroles) | **Get** {task_schedule_href}list_roles/ | 
*TaskSchedulesAPI* | [**TaskSchedulesMyPermissions**](docs/TaskSchedulesAPI.md#taskschedulesmypermissions) | **Get** {task_schedule_href}my_permissions/ | 
*TaskSchedulesAPI* | [**TaskSchedulesRead**](docs/TaskSchedulesAPI.md#taskschedulesread) | **Get** {task_schedule_href} | Inspect a task schedule
*TaskSchedulesAPI* | [**TaskSchedulesRemoveRole**](docs/TaskSchedulesAPI.md#taskschedulesremoverole) | **Post** {task_schedule_href}remove_role/ | 
*TasksAPI* | [**TasksAddRole**](docs/TasksAPI.md#tasksaddrole) | **Post** {task_href}add_role/ | 
*TasksAPI* | [**TasksCancel**](docs/TasksAPI.md#taskscancel) | **Patch** {task_href} | Cancel a task
*TasksAPI* | [**TasksDelete**](docs/TasksAPI.md#tasksdelete) | **Delete** {task_href} | Delete a task
*TasksAPI* | [**TasksList**](docs/TasksAPI.md#taskslist) | **Get** /pulp/api/v3/tasks/ | List tasks
*TasksAPI* | [**TasksListRoles**](docs/TasksAPI.md#taskslistroles) | **Get** {task_href}list_roles/ | 
*TasksAPI* | [**TasksMyPermissions**](docs/TasksAPI.md#tasksmypermissions) | **Get** {task_href}my_permissions/ | 
*TasksAPI* | [**TasksPurge**](docs/TasksAPI.md#taskspurge) | **Post** /pulp/api/v3/tasks/purge/ | Purge Completed Tasks
*TasksAPI* | [**TasksRead**](docs/TasksAPI.md#tasksread) | **Get** {task_href} | Inspect a task
*TasksAPI* | [**TasksRemoveRole**](docs/TasksAPI.md#tasksremoverole) | **Post** {task_href}remove_role/ | 
*TokenAPI* | [**TokenGet**](docs/TokenAPI.md#tokenget) | **Get** /token/ | 
*UploadsAPI* | [**UploadsAddRole**](docs/UploadsAPI.md#uploadsaddrole) | **Post** {upload_href}add_role/ | 
*UploadsAPI* | [**UploadsCommit**](docs/UploadsAPI.md#uploadscommit) | **Post** {upload_href}commit/ | Finish an Upload
*UploadsAPI* | [**UploadsCreate**](docs/UploadsAPI.md#uploadscreate) | **Post** /pulp/api/v3/uploads/ | Create an upload
*UploadsAPI* | [**UploadsDelete**](docs/UploadsAPI.md#uploadsdelete) | **Delete** {upload_href} | Delete an upload
*UploadsAPI* | [**UploadsList**](docs/UploadsAPI.md#uploadslist) | **Get** /pulp/api/v3/uploads/ | List uploads
*UploadsAPI* | [**UploadsListRoles**](docs/UploadsAPI.md#uploadslistroles) | **Get** {upload_href}list_roles/ | 
*UploadsAPI* | [**UploadsMyPermissions**](docs/UploadsAPI.md#uploadsmypermissions) | **Get** {upload_href}my_permissions/ | 
*UploadsAPI* | [**UploadsRead**](docs/UploadsAPI.md#uploadsread) | **Get** {upload_href} | Inspect an upload
*UploadsAPI* | [**UploadsRemoveRole**](docs/UploadsAPI.md#uploadsremoverole) | **Post** {upload_href}remove_role/ | 
*UploadsAPI* | [**UploadsUpdate**](docs/UploadsAPI.md#uploadsupdate) | **Put** {upload_href} | Upload a file chunk
*UpstreamPulpsAPI* | [**UpstreamPulpsCreate**](docs/UpstreamPulpsAPI.md#upstreampulpscreate) | **Post** /pulp/api/v3/upstream-pulps/ | Create an upstream pulp
*UpstreamPulpsAPI* | [**UpstreamPulpsDelete**](docs/UpstreamPulpsAPI.md#upstreampulpsdelete) | **Delete** {upstream_pulp_href} | Delete an upstream pulp
*UpstreamPulpsAPI* | [**UpstreamPulpsList**](docs/UpstreamPulpsAPI.md#upstreampulpslist) | **Get** /pulp/api/v3/upstream-pulps/ | List upstream pulps
*UpstreamPulpsAPI* | [**UpstreamPulpsPartialUpdate**](docs/UpstreamPulpsAPI.md#upstreampulpspartialupdate) | **Patch** {upstream_pulp_href} | Update an upstream pulp
*UpstreamPulpsAPI* | [**UpstreamPulpsRead**](docs/UpstreamPulpsAPI.md#upstreampulpsread) | **Get** {upstream_pulp_href} | Inspect an upstream pulp
*UpstreamPulpsAPI* | [**UpstreamPulpsReplicate**](docs/UpstreamPulpsAPI.md#upstreampulpsreplicate) | **Post** {upstream_pulp_href}replicate/ | Replicate
*UpstreamPulpsAPI* | [**UpstreamPulpsUpdate**](docs/UpstreamPulpsAPI.md#upstreampulpsupdate) | **Put** {upstream_pulp_href} | Update an upstream pulp
*UsersAPI* | [**UsersCreate**](docs/UsersAPI.md#userscreate) | **Post** /pulp/api/v3/users/ | Create an user
*UsersAPI* | [**UsersDelete**](docs/UsersAPI.md#usersdelete) | **Delete** {auth_user_href} | Delete an user
*UsersAPI* | [**UsersList**](docs/UsersAPI.md#userslist) | **Get** /pulp/api/v3/users/ | List users
*UsersAPI* | [**UsersPartialUpdate**](docs/UsersAPI.md#userspartialupdate) | **Patch** {auth_user_href} | Update an user
*UsersAPI* | [**UsersRead**](docs/UsersAPI.md#usersread) | **Get** {auth_user_href} | Inspect an user
*UsersAPI* | [**UsersUpdate**](docs/UsersAPI.md#usersupdate) | **Put** {auth_user_href} | Update an user
*UsersRolesAPI* | [**UsersRolesCreate**](docs/UsersRolesAPI.md#usersrolescreate) | **Post** {auth_user_href}roles/ | Create an user role
*UsersRolesAPI* | [**UsersRolesDelete**](docs/UsersRolesAPI.md#usersrolesdelete) | **Delete** {auth_users_user_role_href} | Delete an user role
*UsersRolesAPI* | [**UsersRolesList**](docs/UsersRolesAPI.md#usersroleslist) | **Get** {auth_user_href}roles/ | List user roles
*UsersRolesAPI* | [**UsersRolesRead**](docs/UsersRolesAPI.md#usersrolesread) | **Get** {auth_users_user_role_href} | Inspect an user role
*VersionsAPI* | [**ApiV1RolesVersionsList**](docs/VersionsAPI.md#apiv1rolesversionslist) | **Get** {ansible_role_href}versions/ | 
*VersionsAPI* | [**ApiV2CollectionVersionsList**](docs/VersionsAPI.md#apiv2collectionversionslist) | **Get** {ansible_collection_version_href}versions/ | 
*WorkersAPI* | [**WorkersList**](docs/WorkersAPI.md#workerslist) | **Get** /pulp/api/v3/workers/ | List workers
*WorkersAPI* | [**WorkersRead**](docs/WorkersAPI.md#workersread) | **Get** {worker_href} | Inspect a worker


## Documentation For Models

 - [AccessPolicy](docs/AccessPolicy.md)
 - [AccessPolicyResponse](docs/AccessPolicyResponse.md)
 - [AddonResponse](docs/AddonResponse.md)
 - [AnsibleAnsibleDistribution](docs/AnsibleAnsibleDistribution.md)
 - [AnsibleAnsibleDistributionResponse](docs/AnsibleAnsibleDistributionResponse.md)
 - [AnsibleAnsibleNamespaceMetadata](docs/AnsibleAnsibleNamespaceMetadata.md)
 - [AnsibleAnsibleNamespaceMetadataResponse](docs/AnsibleAnsibleNamespaceMetadataResponse.md)
 - [AnsibleAnsibleRepository](docs/AnsibleAnsibleRepository.md)
 - [AnsibleAnsibleRepositoryResponse](docs/AnsibleAnsibleRepositoryResponse.md)
 - [AnsibleCollection](docs/AnsibleCollection.md)
 - [AnsibleCollectionRemote](docs/AnsibleCollectionRemote.md)
 - [AnsibleCollectionRemoteResponse](docs/AnsibleCollectionRemoteResponse.md)
 - [AnsibleCollectionResponse](docs/AnsibleCollectionResponse.md)
 - [AnsibleCollectionVersion](docs/AnsibleCollectionVersion.md)
 - [AnsibleCollectionVersionMark](docs/AnsibleCollectionVersionMark.md)
 - [AnsibleCollectionVersionMarkResponse](docs/AnsibleCollectionVersionMarkResponse.md)
 - [AnsibleCollectionVersionResponse](docs/AnsibleCollectionVersionResponse.md)
 - [AnsibleCollectionVersionSignature](docs/AnsibleCollectionVersionSignature.md)
 - [AnsibleCollectionVersionSignatureResponse](docs/AnsibleCollectionVersionSignatureResponse.md)
 - [AnsibleGitRemote](docs/AnsibleGitRemote.md)
 - [AnsibleGitRemoteResponse](docs/AnsibleGitRemoteResponse.md)
 - [AnsibleRepositoryMark](docs/AnsibleRepositoryMark.md)
 - [AnsibleRepositoryRebuild](docs/AnsibleRepositoryRebuild.md)
 - [AnsibleRepositorySignature](docs/AnsibleRepositorySignature.md)
 - [AnsibleRepositorySyncURL](docs/AnsibleRepositorySyncURL.md)
 - [AnsibleRole](docs/AnsibleRole.md)
 - [AnsibleRoleRemote](docs/AnsibleRoleRemote.md)
 - [AnsibleRoleRemoteResponse](docs/AnsibleRoleRemoteResponse.md)
 - [AnsibleRoleResponse](docs/AnsibleRoleResponse.md)
 - [AnsibleTagResponse](docs/AnsibleTagResponse.md)
 - [AptRepositorySyncURL](docs/AptRepositorySyncURL.md)
 - [Artifact](docs/Artifact.md)
 - [ArtifactDistributionResponse](docs/ArtifactDistributionResponse.md)
 - [ArtifactRefResponse](docs/ArtifactRefResponse.md)
 - [ArtifactResponse](docs/ArtifactResponse.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [CertguardRHSMCertGuard](docs/CertguardRHSMCertGuard.md)
 - [CertguardRHSMCertGuardResponse](docs/CertguardRHSMCertGuardResponse.md)
 - [CertguardX509CertGuard](docs/CertguardX509CertGuard.md)
 - [CertguardX509CertGuardResponse](docs/CertguardX509CertGuardResponse.md)
 - [ChecksumResponse](docs/ChecksumResponse.md)
 - [ClientConfigurationResponse](docs/ClientConfigurationResponse.md)
 - [CollectionImportDetailResponse](docs/CollectionImportDetailResponse.md)
 - [CollectionMetadataResponse](docs/CollectionMetadataResponse.md)
 - [CollectionNamespaceResponse](docs/CollectionNamespaceResponse.md)
 - [CollectionOneShot](docs/CollectionOneShot.md)
 - [CollectionRefResponse](docs/CollectionRefResponse.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionSummaryResponse](docs/CollectionSummaryResponse.md)
 - [CollectionVersionCopyMove](docs/CollectionVersionCopyMove.md)
 - [CollectionVersionDocsResponse](docs/CollectionVersionDocsResponse.md)
 - [CollectionVersionListResponse](docs/CollectionVersionListResponse.md)
 - [CollectionVersionResponse](docs/CollectionVersionResponse.md)
 - [CollectionVersionSearchList](docs/CollectionVersionSearchList.md)
 - [CollectionVersionSearchListResponse](docs/CollectionVersionSearchListResponse.md)
 - [CollectionVersionSignatureResponse](docs/CollectionVersionSignatureResponse.md)
 - [CompsXml](docs/CompsXml.md)
 - [ContainerBlobResponse](docs/ContainerBlobResponse.md)
 - [ContainerContainerDistribution](docs/ContainerContainerDistribution.md)
 - [ContainerContainerDistributionResponse](docs/ContainerContainerDistributionResponse.md)
 - [ContainerContainerNamespace](docs/ContainerContainerNamespace.md)
 - [ContainerContainerNamespaceResponse](docs/ContainerContainerNamespaceResponse.md)
 - [ContainerContainerPushRepository](docs/ContainerContainerPushRepository.md)
 - [ContainerContainerPushRepositoryResponse](docs/ContainerContainerPushRepositoryResponse.md)
 - [ContainerContainerRemote](docs/ContainerContainerRemote.md)
 - [ContainerContainerRemoteResponse](docs/ContainerContainerRemoteResponse.md)
 - [ContainerContainerRepository](docs/ContainerContainerRepository.md)
 - [ContainerContainerRepositoryResponse](docs/ContainerContainerRepositoryResponse.md)
 - [ContainerManifestResponse](docs/ContainerManifestResponse.md)
 - [ContainerManifestSignatureResponse](docs/ContainerManifestSignatureResponse.md)
 - [ContainerRepositorySyncURL](docs/ContainerRepositorySyncURL.md)
 - [ContainerTagResponse](docs/ContainerTagResponse.md)
 - [ContentAppStatusResponse](docs/ContentAppStatusResponse.md)
 - [ContentGuardResponse](docs/ContentGuardResponse.md)
 - [ContentRedirectContentGuard](docs/ContentRedirectContentGuard.md)
 - [ContentRedirectContentGuardResponse](docs/ContentRedirectContentGuardResponse.md)
 - [ContentSettingsResponse](docs/ContentSettingsResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [Copy](docs/Copy.md)
 - [DatabaseConnectionResponse](docs/DatabaseConnectionResponse.md)
 - [DebAptDistribution](docs/DebAptDistribution.md)
 - [DebAptDistributionResponse](docs/DebAptDistributionResponse.md)
 - [DebAptPublication](docs/DebAptPublication.md)
 - [DebAptPublicationResponse](docs/DebAptPublicationResponse.md)
 - [DebAptRemote](docs/DebAptRemote.md)
 - [DebAptRemoteResponse](docs/DebAptRemoteResponse.md)
 - [DebAptRepository](docs/DebAptRepository.md)
 - [DebAptRepositoryResponse](docs/DebAptRepositoryResponse.md)
 - [DebGenericContent](docs/DebGenericContent.md)
 - [DebGenericContentResponse](docs/DebGenericContentResponse.md)
 - [DebInstallerFileIndex](docs/DebInstallerFileIndex.md)
 - [DebInstallerFileIndexResponse](docs/DebInstallerFileIndexResponse.md)
 - [DebInstallerPackage](docs/DebInstallerPackage.md)
 - [DebInstallerPackageResponse](docs/DebInstallerPackageResponse.md)
 - [DebPackage](docs/DebPackage.md)
 - [DebPackageIndex](docs/DebPackageIndex.md)
 - [DebPackageIndexResponse](docs/DebPackageIndexResponse.md)
 - [DebPackageReleaseComponent](docs/DebPackageReleaseComponent.md)
 - [DebPackageReleaseComponentResponse](docs/DebPackageReleaseComponentResponse.md)
 - [DebPackageResponse](docs/DebPackageResponse.md)
 - [DebRelease](docs/DebRelease.md)
 - [DebReleaseArchitecture](docs/DebReleaseArchitecture.md)
 - [DebReleaseArchitectureResponse](docs/DebReleaseArchitectureResponse.md)
 - [DebReleaseComponent](docs/DebReleaseComponent.md)
 - [DebReleaseComponentResponse](docs/DebReleaseComponentResponse.md)
 - [DebReleaseFile](docs/DebReleaseFile.md)
 - [DebReleaseFileResponse](docs/DebReleaseFileResponse.md)
 - [DebReleaseResponse](docs/DebReleaseResponse.md)
 - [DebVerbatimPublication](docs/DebVerbatimPublication.md)
 - [DebVerbatimPublicationResponse](docs/DebVerbatimPublicationResponse.md)
 - [DistributionResponse](docs/DistributionResponse.md)
 - [Domain](docs/Domain.md)
 - [DomainResponse](docs/DomainResponse.md)
 - [EvaluationResponse](docs/EvaluationResponse.md)
 - [ExcludePlatformsEnum](docs/ExcludePlatformsEnum.md)
 - [FileFileAlternateContentSource](docs/FileFileAlternateContentSource.md)
 - [FileFileAlternateContentSourceResponse](docs/FileFileAlternateContentSourceResponse.md)
 - [FileFileContent](docs/FileFileContent.md)
 - [FileFileContentResponse](docs/FileFileContentResponse.md)
 - [FileFileDistribution](docs/FileFileDistribution.md)
 - [FileFileDistributionResponse](docs/FileFileDistributionResponse.md)
 - [FileFilePublication](docs/FileFilePublication.md)
 - [FileFilePublicationResponse](docs/FileFilePublicationResponse.md)
 - [FileFileRemote](docs/FileFileRemote.md)
 - [FileFileRemoteResponse](docs/FileFileRemoteResponse.md)
 - [FileFileRepository](docs/FileFileRepository.md)
 - [FileFileRepositoryResponse](docs/FileFileRepositoryResponse.md)
 - [FilesystemExport](docs/FilesystemExport.md)
 - [FilesystemExportResponse](docs/FilesystemExportResponse.md)
 - [FilesystemExporter](docs/FilesystemExporter.md)
 - [FilesystemExporterResponse](docs/FilesystemExporterResponse.md)
 - [GalaxyCollection](docs/GalaxyCollection.md)
 - [GalaxyCollectionResponse](docs/GalaxyCollectionResponse.md)
 - [GalaxyCollectionVersionResponse](docs/GalaxyCollectionVersionResponse.md)
 - [GalaxyRoleResponse](docs/GalaxyRoleResponse.md)
 - [GalaxyRoleVersionResponse](docs/GalaxyRoleVersionResponse.md)
 - [GemGemContent](docs/GemGemContent.md)
 - [GemGemContentResponse](docs/GemGemContentResponse.md)
 - [GemGemDistribution](docs/GemGemDistribution.md)
 - [GemGemDistributionResponse](docs/GemGemDistributionResponse.md)
 - [GemGemPublication](docs/GemGemPublication.md)
 - [GemGemPublicationResponse](docs/GemGemPublicationResponse.md)
 - [GemGemRemote](docs/GemGemRemote.md)
 - [GemGemRemoteResponse](docs/GemGemRemoteResponse.md)
 - [GemGemRepository](docs/GemGemRepository.md)
 - [GemGemRepositoryResponse](docs/GemGemRepositoryResponse.md)
 - [Group](docs/Group.md)
 - [GroupProgressReportResponse](docs/GroupProgressReportResponse.md)
 - [GroupResponse](docs/GroupResponse.md)
 - [GroupRole](docs/GroupRole.md)
 - [GroupRoleResponse](docs/GroupRoleResponse.md)
 - [GroupUser](docs/GroupUser.md)
 - [GroupUserResponse](docs/GroupUserResponse.md)
 - [ImageResponse](docs/ImageResponse.md)
 - [ImportResponse](docs/ImportResponse.md)
 - [ManifestCopy](docs/ManifestCopy.md)
 - [MavenMavenArtifact](docs/MavenMavenArtifact.md)
 - [MavenMavenArtifactResponse](docs/MavenMavenArtifactResponse.md)
 - [MavenMavenDistribution](docs/MavenMavenDistribution.md)
 - [MavenMavenDistributionResponse](docs/MavenMavenDistributionResponse.md)
 - [MavenMavenRemote](docs/MavenMavenRemote.md)
 - [MavenMavenRemoteResponse](docs/MavenMavenRemoteResponse.md)
 - [MavenMavenRepository](docs/MavenMavenRepository.md)
 - [MavenMavenRepositoryResponse](docs/MavenMavenRepositoryResponse.md)
 - [MediaTypesEnum](docs/MediaTypesEnum.md)
 - [MetadataChecksumTypeEnum](docs/MetadataChecksumTypeEnum.md)
 - [MethodEnum](docs/MethodEnum.md)
 - [MinimalTaskResponse](docs/MinimalTaskResponse.md)
 - [MultipleArtifactContentResponse](docs/MultipleArtifactContentResponse.md)
 - [MyPermissionsResponse](docs/MyPermissionsResponse.md)
 - [NamespaceLink](docs/NamespaceLink.md)
 - [NamespaceLinkResponse](docs/NamespaceLinkResponse.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedRoleResponse](docs/NestedRoleResponse.md)
 - [OCIBuildImage](docs/OCIBuildImage.md)
 - [ObjectRolesResponse](docs/ObjectRolesResponse.md)
 - [OrphansCleanup](docs/OrphansCleanup.md)
 - [OstreeImportAll](docs/OstreeImportAll.md)
 - [OstreeImportCommitsToRef](docs/OstreeImportCommitsToRef.md)
 - [OstreeOstreeCommitResponse](docs/OstreeOstreeCommitResponse.md)
 - [OstreeOstreeConfigResponse](docs/OstreeOstreeConfigResponse.md)
 - [OstreeOstreeContentResponse](docs/OstreeOstreeContentResponse.md)
 - [OstreeOstreeDistribution](docs/OstreeOstreeDistribution.md)
 - [OstreeOstreeDistributionResponse](docs/OstreeOstreeDistributionResponse.md)
 - [OstreeOstreeObjectResponse](docs/OstreeOstreeObjectResponse.md)
 - [OstreeOstreeRefResponse](docs/OstreeOstreeRefResponse.md)
 - [OstreeOstreeRemote](docs/OstreeOstreeRemote.md)
 - [OstreeOstreeRemoteResponse](docs/OstreeOstreeRemoteResponse.md)
 - [OstreeOstreeRepository](docs/OstreeOstreeRepository.md)
 - [OstreeOstreeRepositoryResponse](docs/OstreeOstreeRepositoryResponse.md)
 - [OstreeOstreeSummaryResponse](docs/OstreeOstreeSummaryResponse.md)
 - [PackageChecksumTypeEnum](docs/PackageChecksumTypeEnum.md)
 - [PackageMetadataResponse](docs/PackageMetadataResponse.md)
 - [PackageTypesEnum](docs/PackageTypesEnum.md)
 - [PackageUpload](docs/PackageUpload.md)
 - [PackageUploadTaskResponse](docs/PackageUploadTaskResponse.md)
 - [PaginatedAccessPolicyResponseList](docs/PaginatedAccessPolicyResponseList.md)
 - [PaginatedArtifactDistributionResponseList](docs/PaginatedArtifactDistributionResponseList.md)
 - [PaginatedArtifactResponseList](docs/PaginatedArtifactResponseList.md)
 - [PaginatedCollectionResponseList](docs/PaginatedCollectionResponseList.md)
 - [PaginatedCollectionResponseListLinks](docs/PaginatedCollectionResponseListLinks.md)
 - [PaginatedCollectionResponseListMeta](docs/PaginatedCollectionResponseListMeta.md)
 - [PaginatedCollectionVersionListResponseList](docs/PaginatedCollectionVersionListResponseList.md)
 - [PaginatedCollectionVersionSearchListResponseList](docs/PaginatedCollectionVersionSearchListResponseList.md)
 - [PaginatedContentGuardResponseList](docs/PaginatedContentGuardResponseList.md)
 - [PaginatedContentRedirectContentGuardResponseList](docs/PaginatedContentRedirectContentGuardResponseList.md)
 - [PaginatedDistributionResponseList](docs/PaginatedDistributionResponseList.md)
 - [PaginatedDomainResponseList](docs/PaginatedDomainResponseList.md)
 - [PaginatedFilesystemExportResponseList](docs/PaginatedFilesystemExportResponseList.md)
 - [PaginatedFilesystemExporterResponseList](docs/PaginatedFilesystemExporterResponseList.md)
 - [PaginatedGalaxyCollectionResponseList](docs/PaginatedGalaxyCollectionResponseList.md)
 - [PaginatedGalaxyCollectionVersionResponseList](docs/PaginatedGalaxyCollectionVersionResponseList.md)
 - [PaginatedGalaxyRoleResponseList](docs/PaginatedGalaxyRoleResponseList.md)
 - [PaginatedGalaxyRoleVersionResponseList](docs/PaginatedGalaxyRoleVersionResponseList.md)
 - [PaginatedGroupResponseList](docs/PaginatedGroupResponseList.md)
 - [PaginatedGroupRoleResponseList](docs/PaginatedGroupRoleResponseList.md)
 - [PaginatedGroupUserResponseList](docs/PaginatedGroupUserResponseList.md)
 - [PaginatedImportResponseList](docs/PaginatedImportResponseList.md)
 - [PaginatedMultipleArtifactContentResponseList](docs/PaginatedMultipleArtifactContentResponseList.md)
 - [PaginatedPublicationResponseList](docs/PaginatedPublicationResponseList.md)
 - [PaginatedPulpExportResponseList](docs/PaginatedPulpExportResponseList.md)
 - [PaginatedPulpExporterResponseList](docs/PaginatedPulpExporterResponseList.md)
 - [PaginatedPulpImporterResponseList](docs/PaginatedPulpImporterResponseList.md)
 - [PaginatedRBACContentGuardResponseList](docs/PaginatedRBACContentGuardResponseList.md)
 - [PaginatedRemoteResponseList](docs/PaginatedRemoteResponseList.md)
 - [PaginatedRepositoryResponseList](docs/PaginatedRepositoryResponseList.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedRoleResponseList](docs/PaginatedRoleResponseList.md)
 - [PaginatedSigningServiceResponseList](docs/PaginatedSigningServiceResponseList.md)
 - [PaginatedTagResponseList](docs/PaginatedTagResponseList.md)
 - [PaginatedTaskGroupResponseList](docs/PaginatedTaskGroupResponseList.md)
 - [PaginatedTaskResponseList](docs/PaginatedTaskResponseList.md)
 - [PaginatedTaskScheduleResponseList](docs/PaginatedTaskScheduleResponseList.md)
 - [PaginatedUploadResponseList](docs/PaginatedUploadResponseList.md)
 - [PaginatedUpstreamPulpResponseList](docs/PaginatedUpstreamPulpResponseList.md)
 - [PaginatedUserResponseList](docs/PaginatedUserResponseList.md)
 - [PaginatedUserRoleResponseList](docs/PaginatedUserRoleResponseList.md)
 - [PaginatedWorkerResponseList](docs/PaginatedWorkerResponseList.md)
 - [PaginatedansibleAnsibleDistributionResponseList](docs/PaginatedansibleAnsibleDistributionResponseList.md)
 - [PaginatedansibleAnsibleNamespaceMetadataResponseList](docs/PaginatedansibleAnsibleNamespaceMetadataResponseList.md)
 - [PaginatedansibleAnsibleRepositoryResponseList](docs/PaginatedansibleAnsibleRepositoryResponseList.md)
 - [PaginatedansibleCollectionRemoteResponseList](docs/PaginatedansibleCollectionRemoteResponseList.md)
 - [PaginatedansibleCollectionResponseList](docs/PaginatedansibleCollectionResponseList.md)
 - [PaginatedansibleCollectionVersionMarkResponseList](docs/PaginatedansibleCollectionVersionMarkResponseList.md)
 - [PaginatedansibleCollectionVersionResponseList](docs/PaginatedansibleCollectionVersionResponseList.md)
 - [PaginatedansibleCollectionVersionSignatureResponseList](docs/PaginatedansibleCollectionVersionSignatureResponseList.md)
 - [PaginatedansibleGitRemoteResponseList](docs/PaginatedansibleGitRemoteResponseList.md)
 - [PaginatedansibleRoleRemoteResponseList](docs/PaginatedansibleRoleRemoteResponseList.md)
 - [PaginatedansibleRoleResponseList](docs/PaginatedansibleRoleResponseList.md)
 - [PaginatedcertguardRHSMCertGuardResponseList](docs/PaginatedcertguardRHSMCertGuardResponseList.md)
 - [PaginatedcertguardX509CertGuardResponseList](docs/PaginatedcertguardX509CertGuardResponseList.md)
 - [PaginatedcontainerBlobResponseList](docs/PaginatedcontainerBlobResponseList.md)
 - [PaginatedcontainerContainerDistributionResponseList](docs/PaginatedcontainerContainerDistributionResponseList.md)
 - [PaginatedcontainerContainerNamespaceResponseList](docs/PaginatedcontainerContainerNamespaceResponseList.md)
 - [PaginatedcontainerContainerPushRepositoryResponseList](docs/PaginatedcontainerContainerPushRepositoryResponseList.md)
 - [PaginatedcontainerContainerRemoteResponseList](docs/PaginatedcontainerContainerRemoteResponseList.md)
 - [PaginatedcontainerContainerRepositoryResponseList](docs/PaginatedcontainerContainerRepositoryResponseList.md)
 - [PaginatedcontainerManifestResponseList](docs/PaginatedcontainerManifestResponseList.md)
 - [PaginatedcontainerManifestSignatureResponseList](docs/PaginatedcontainerManifestSignatureResponseList.md)
 - [PaginatedcontainerTagResponseList](docs/PaginatedcontainerTagResponseList.md)
 - [PaginateddebAptDistributionResponseList](docs/PaginateddebAptDistributionResponseList.md)
 - [PaginateddebAptPublicationResponseList](docs/PaginateddebAptPublicationResponseList.md)
 - [PaginateddebAptRemoteResponseList](docs/PaginateddebAptRemoteResponseList.md)
 - [PaginateddebAptRepositoryResponseList](docs/PaginateddebAptRepositoryResponseList.md)
 - [PaginateddebGenericContentResponseList](docs/PaginateddebGenericContentResponseList.md)
 - [PaginateddebInstallerFileIndexResponseList](docs/PaginateddebInstallerFileIndexResponseList.md)
 - [PaginateddebInstallerPackageResponseList](docs/PaginateddebInstallerPackageResponseList.md)
 - [PaginateddebPackageIndexResponseList](docs/PaginateddebPackageIndexResponseList.md)
 - [PaginateddebPackageReleaseComponentResponseList](docs/PaginateddebPackageReleaseComponentResponseList.md)
 - [PaginateddebPackageResponseList](docs/PaginateddebPackageResponseList.md)
 - [PaginateddebReleaseArchitectureResponseList](docs/PaginateddebReleaseArchitectureResponseList.md)
 - [PaginateddebReleaseComponentResponseList](docs/PaginateddebReleaseComponentResponseList.md)
 - [PaginateddebReleaseFileResponseList](docs/PaginateddebReleaseFileResponseList.md)
 - [PaginateddebReleaseResponseList](docs/PaginateddebReleaseResponseList.md)
 - [PaginateddebVerbatimPublicationResponseList](docs/PaginateddebVerbatimPublicationResponseList.md)
 - [PaginatedfileFileAlternateContentSourceResponseList](docs/PaginatedfileFileAlternateContentSourceResponseList.md)
 - [PaginatedfileFileContentResponseList](docs/PaginatedfileFileContentResponseList.md)
 - [PaginatedfileFileDistributionResponseList](docs/PaginatedfileFileDistributionResponseList.md)
 - [PaginatedfileFilePublicationResponseList](docs/PaginatedfileFilePublicationResponseList.md)
 - [PaginatedfileFileRemoteResponseList](docs/PaginatedfileFileRemoteResponseList.md)
 - [PaginatedfileFileRepositoryResponseList](docs/PaginatedfileFileRepositoryResponseList.md)
 - [PaginatedgemGemContentResponseList](docs/PaginatedgemGemContentResponseList.md)
 - [PaginatedgemGemDistributionResponseList](docs/PaginatedgemGemDistributionResponseList.md)
 - [PaginatedgemGemPublicationResponseList](docs/PaginatedgemGemPublicationResponseList.md)
 - [PaginatedgemGemRemoteResponseList](docs/PaginatedgemGemRemoteResponseList.md)
 - [PaginatedgemGemRepositoryResponseList](docs/PaginatedgemGemRepositoryResponseList.md)
 - [PaginatedmavenMavenArtifactResponseList](docs/PaginatedmavenMavenArtifactResponseList.md)
 - [PaginatedmavenMavenDistributionResponseList](docs/PaginatedmavenMavenDistributionResponseList.md)
 - [PaginatedmavenMavenRemoteResponseList](docs/PaginatedmavenMavenRemoteResponseList.md)
 - [PaginatedmavenMavenRepositoryResponseList](docs/PaginatedmavenMavenRepositoryResponseList.md)
 - [PaginatedostreeOstreeCommitResponseList](docs/PaginatedostreeOstreeCommitResponseList.md)
 - [PaginatedostreeOstreeConfigResponseList](docs/PaginatedostreeOstreeConfigResponseList.md)
 - [PaginatedostreeOstreeContentResponseList](docs/PaginatedostreeOstreeContentResponseList.md)
 - [PaginatedostreeOstreeDistributionResponseList](docs/PaginatedostreeOstreeDistributionResponseList.md)
 - [PaginatedostreeOstreeObjectResponseList](docs/PaginatedostreeOstreeObjectResponseList.md)
 - [PaginatedostreeOstreeRefResponseList](docs/PaginatedostreeOstreeRefResponseList.md)
 - [PaginatedostreeOstreeRemoteResponseList](docs/PaginatedostreeOstreeRemoteResponseList.md)
 - [PaginatedostreeOstreeRepositoryResponseList](docs/PaginatedostreeOstreeRepositoryResponseList.md)
 - [PaginatedostreeOstreeSummaryResponseList](docs/PaginatedostreeOstreeSummaryResponseList.md)
 - [PaginatedpythonPythonDistributionResponseList](docs/PaginatedpythonPythonDistributionResponseList.md)
 - [PaginatedpythonPythonPackageContentResponseList](docs/PaginatedpythonPythonPackageContentResponseList.md)
 - [PaginatedpythonPythonPublicationResponseList](docs/PaginatedpythonPythonPublicationResponseList.md)
 - [PaginatedpythonPythonRemoteResponseList](docs/PaginatedpythonPythonRemoteResponseList.md)
 - [PaginatedpythonPythonRepositoryResponseList](docs/PaginatedpythonPythonRepositoryResponseList.md)
 - [PaginatedrpmDistributionTreeResponseList](docs/PaginatedrpmDistributionTreeResponseList.md)
 - [PaginatedrpmModulemdDefaultsResponseList](docs/PaginatedrpmModulemdDefaultsResponseList.md)
 - [PaginatedrpmModulemdObsoleteResponseList](docs/PaginatedrpmModulemdObsoleteResponseList.md)
 - [PaginatedrpmModulemdResponseList](docs/PaginatedrpmModulemdResponseList.md)
 - [PaginatedrpmPackageCategoryResponseList](docs/PaginatedrpmPackageCategoryResponseList.md)
 - [PaginatedrpmPackageEnvironmentResponseList](docs/PaginatedrpmPackageEnvironmentResponseList.md)
 - [PaginatedrpmPackageGroupResponseList](docs/PaginatedrpmPackageGroupResponseList.md)
 - [PaginatedrpmPackageLangpacksResponseList](docs/PaginatedrpmPackageLangpacksResponseList.md)
 - [PaginatedrpmPackageResponseList](docs/PaginatedrpmPackageResponseList.md)
 - [PaginatedrpmRepoMetadataFileResponseList](docs/PaginatedrpmRepoMetadataFileResponseList.md)
 - [PaginatedrpmRpmAlternateContentSourceResponseList](docs/PaginatedrpmRpmAlternateContentSourceResponseList.md)
 - [PaginatedrpmRpmDistributionResponseList](docs/PaginatedrpmRpmDistributionResponseList.md)
 - [PaginatedrpmRpmPublicationResponseList](docs/PaginatedrpmRpmPublicationResponseList.md)
 - [PaginatedrpmRpmRemoteResponseList](docs/PaginatedrpmRpmRemoteResponseList.md)
 - [PaginatedrpmRpmRepositoryResponseList](docs/PaginatedrpmRpmRepositoryResponseList.md)
 - [PaginatedrpmUlnRemoteResponseList](docs/PaginatedrpmUlnRemoteResponseList.md)
 - [PaginatedrpmUpdateRecordResponseList](docs/PaginatedrpmUpdateRecordResponseList.md)
 - [PatchedAccessPolicy](docs/PatchedAccessPolicy.md)
 - [PatchedCollection](docs/PatchedCollection.md)
 - [PatchedContentRedirectContentGuard](docs/PatchedContentRedirectContentGuard.md)
 - [PatchedDomain](docs/PatchedDomain.md)
 - [PatchedFilesystemExporter](docs/PatchedFilesystemExporter.md)
 - [PatchedGroup](docs/PatchedGroup.md)
 - [PatchedPulpExporter](docs/PatchedPulpExporter.md)
 - [PatchedPulpImporter](docs/PatchedPulpImporter.md)
 - [PatchedRBACContentGuard](docs/PatchedRBACContentGuard.md)
 - [PatchedRole](docs/PatchedRole.md)
 - [PatchedTaskCancel](docs/PatchedTaskCancel.md)
 - [PatchedUpstreamPulp](docs/PatchedUpstreamPulp.md)
 - [PatchedUser](docs/PatchedUser.md)
 - [PatchedansibleAnsibleDistribution](docs/PatchedansibleAnsibleDistribution.md)
 - [PatchedansibleAnsibleNamespaceMetadata](docs/PatchedansibleAnsibleNamespaceMetadata.md)
 - [PatchedansibleAnsibleRepository](docs/PatchedansibleAnsibleRepository.md)
 - [PatchedansibleCollectionRemote](docs/PatchedansibleCollectionRemote.md)
 - [PatchedansibleGitRemote](docs/PatchedansibleGitRemote.md)
 - [PatchedansibleRoleRemote](docs/PatchedansibleRoleRemote.md)
 - [PatchedcertguardRHSMCertGuard](docs/PatchedcertguardRHSMCertGuard.md)
 - [PatchedcertguardX509CertGuard](docs/PatchedcertguardX509CertGuard.md)
 - [PatchedcontainerContainerDistribution](docs/PatchedcontainerContainerDistribution.md)
 - [PatchedcontainerContainerPushRepository](docs/PatchedcontainerContainerPushRepository.md)
 - [PatchedcontainerContainerRemote](docs/PatchedcontainerContainerRemote.md)
 - [PatchedcontainerContainerRepository](docs/PatchedcontainerContainerRepository.md)
 - [PatcheddebAptDistribution](docs/PatcheddebAptDistribution.md)
 - [PatcheddebAptRemote](docs/PatcheddebAptRemote.md)
 - [PatcheddebAptRepository](docs/PatcheddebAptRepository.md)
 - [PatchedfileFileAlternateContentSource](docs/PatchedfileFileAlternateContentSource.md)
 - [PatchedfileFileDistribution](docs/PatchedfileFileDistribution.md)
 - [PatchedfileFileRemote](docs/PatchedfileFileRemote.md)
 - [PatchedfileFileRepository](docs/PatchedfileFileRepository.md)
 - [PatchedgemGemDistribution](docs/PatchedgemGemDistribution.md)
 - [PatchedgemGemRemote](docs/PatchedgemGemRemote.md)
 - [PatchedgemGemRepository](docs/PatchedgemGemRepository.md)
 - [PatchedmavenMavenDistribution](docs/PatchedmavenMavenDistribution.md)
 - [PatchedmavenMavenRemote](docs/PatchedmavenMavenRemote.md)
 - [PatchedmavenMavenRepository](docs/PatchedmavenMavenRepository.md)
 - [PatchedostreeOstreeDistribution](docs/PatchedostreeOstreeDistribution.md)
 - [PatchedostreeOstreeRemote](docs/PatchedostreeOstreeRemote.md)
 - [PatchedostreeOstreeRepository](docs/PatchedostreeOstreeRepository.md)
 - [PatchedpythonPythonDistribution](docs/PatchedpythonPythonDistribution.md)
 - [PatchedpythonPythonRemote](docs/PatchedpythonPythonRemote.md)
 - [PatchedpythonPythonRepository](docs/PatchedpythonPythonRepository.md)
 - [PatchedrpmRpmAlternateContentSource](docs/PatchedrpmRpmAlternateContentSource.md)
 - [PatchedrpmRpmDistribution](docs/PatchedrpmRpmDistribution.md)
 - [PatchedrpmRpmRemote](docs/PatchedrpmRpmRemote.md)
 - [PatchedrpmRpmRepository](docs/PatchedrpmRpmRepository.md)
 - [PatchedrpmUlnRemote](docs/PatchedrpmUlnRemote.md)
 - [Policy462Enum](docs/Policy462Enum.md)
 - [Policy762Enum](docs/Policy762Enum.md)
 - [PolicyDb6Enum](docs/PolicyDb6Enum.md)
 - [ProgressReportResponse](docs/ProgressReportResponse.md)
 - [PublicationResponse](docs/PublicationResponse.md)
 - [PulpExport](docs/PulpExport.md)
 - [PulpExportResponse](docs/PulpExportResponse.md)
 - [PulpExporter](docs/PulpExporter.md)
 - [PulpExporterResponse](docs/PulpExporterResponse.md)
 - [PulpImport](docs/PulpImport.md)
 - [PulpImportCheck](docs/PulpImportCheck.md)
 - [PulpImportCheckResponse](docs/PulpImportCheckResponse.md)
 - [PulpImporter](docs/PulpImporter.md)
 - [PulpImporterResponse](docs/PulpImporterResponse.md)
 - [Purge](docs/Purge.md)
 - [PythonBanderRemote](docs/PythonBanderRemote.md)
 - [PythonPythonDistribution](docs/PythonPythonDistribution.md)
 - [PythonPythonDistributionResponse](docs/PythonPythonDistributionResponse.md)
 - [PythonPythonPackageContent](docs/PythonPythonPackageContent.md)
 - [PythonPythonPackageContentResponse](docs/PythonPythonPackageContentResponse.md)
 - [PythonPythonPublication](docs/PythonPythonPublication.md)
 - [PythonPythonPublicationResponse](docs/PythonPythonPublicationResponse.md)
 - [PythonPythonRemote](docs/PythonPythonRemote.md)
 - [PythonPythonRemoteResponse](docs/PythonPythonRemoteResponse.md)
 - [PythonPythonRepository](docs/PythonPythonRepository.md)
 - [PythonPythonRepositoryResponse](docs/PythonPythonRepositoryResponse.md)
 - [RBACContentGuard](docs/RBACContentGuard.md)
 - [RBACContentGuardResponse](docs/RBACContentGuardResponse.md)
 - [ReclaimSpace](docs/ReclaimSpace.md)
 - [RecursiveManage](docs/RecursiveManage.md)
 - [RedisConnectionResponse](docs/RedisConnectionResponse.md)
 - [RemoteResponse](docs/RemoteResponse.md)
 - [RemoteResponseHiddenFieldsInner](docs/RemoteResponseHiddenFieldsInner.md)
 - [RemoveImage](docs/RemoveImage.md)
 - [RemoveSignatures](docs/RemoveSignatures.md)
 - [RemoveSignaturesResponse](docs/RemoveSignaturesResponse.md)
 - [Repair](docs/Repair.md)
 - [RepoMetadataResponse](docs/RepoMetadataResponse.md)
 - [Repository](docs/Repository.md)
 - [RepositoryAddCachedContent](docs/RepositoryAddCachedContent.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositoryResponse](docs/RepositoryResponse.md)
 - [RepositorySign](docs/RepositorySign.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [RepositoryVersionResponseContentSummary](docs/RepositoryVersionResponseContentSummary.md)
 - [Role](docs/Role.md)
 - [RoleResponse](docs/RoleResponse.md)
 - [RpmDistributionTreeResponse](docs/RpmDistributionTreeResponse.md)
 - [RpmModulemd](docs/RpmModulemd.md)
 - [RpmModulemdDefaults](docs/RpmModulemdDefaults.md)
 - [RpmModulemdDefaultsResponse](docs/RpmModulemdDefaultsResponse.md)
 - [RpmModulemdObsolete](docs/RpmModulemdObsolete.md)
 - [RpmModulemdObsoleteResponse](docs/RpmModulemdObsoleteResponse.md)
 - [RpmModulemdResponse](docs/RpmModulemdResponse.md)
 - [RpmPackage](docs/RpmPackage.md)
 - [RpmPackageCategoryResponse](docs/RpmPackageCategoryResponse.md)
 - [RpmPackageEnvironmentResponse](docs/RpmPackageEnvironmentResponse.md)
 - [RpmPackageGroupResponse](docs/RpmPackageGroupResponse.md)
 - [RpmPackageLangpacksResponse](docs/RpmPackageLangpacksResponse.md)
 - [RpmPackageResponse](docs/RpmPackageResponse.md)
 - [RpmRepoMetadataFileResponse](docs/RpmRepoMetadataFileResponse.md)
 - [RpmRepositorySyncURL](docs/RpmRepositorySyncURL.md)
 - [RpmRpmAlternateContentSource](docs/RpmRpmAlternateContentSource.md)
 - [RpmRpmAlternateContentSourceResponse](docs/RpmRpmAlternateContentSourceResponse.md)
 - [RpmRpmDistribution](docs/RpmRpmDistribution.md)
 - [RpmRpmDistributionResponse](docs/RpmRpmDistributionResponse.md)
 - [RpmRpmPublication](docs/RpmRpmPublication.md)
 - [RpmRpmPublicationResponse](docs/RpmRpmPublicationResponse.md)
 - [RpmRpmRemote](docs/RpmRpmRemote.md)
 - [RpmRpmRemoteResponse](docs/RpmRpmRemoteResponse.md)
 - [RpmRpmRepository](docs/RpmRpmRepository.md)
 - [RpmRpmRepositoryResponse](docs/RpmRpmRepositoryResponse.md)
 - [RpmUlnRemote](docs/RpmUlnRemote.md)
 - [RpmUlnRemoteResponse](docs/RpmUlnRemoteResponse.md)
 - [RpmUpdateCollection](docs/RpmUpdateCollection.md)
 - [RpmUpdateCollectionResponse](docs/RpmUpdateCollectionResponse.md)
 - [RpmUpdateRecord](docs/RpmUpdateRecord.md)
 - [RpmUpdateRecordResponse](docs/RpmUpdateRecordResponse.md)
 - [SigningServiceResponse](docs/SigningServiceResponse.md)
 - [SkipTypesEnum](docs/SkipTypesEnum.md)
 - [StatesEnum](docs/StatesEnum.md)
 - [StatusResponse](docs/StatusResponse.md)
 - [StorageClassEnum](docs/StorageClassEnum.md)
 - [StorageResponse](docs/StorageResponse.md)
 - [SummaryResponse](docs/SummaryResponse.md)
 - [SyncPolicyEnum](docs/SyncPolicyEnum.md)
 - [TagCopy](docs/TagCopy.md)
 - [TagImage](docs/TagImage.md)
 - [TagResponse](docs/TagResponse.md)
 - [Task](docs/Task.md)
 - [TaskGroupOperationResponse](docs/TaskGroupOperationResponse.md)
 - [TaskGroupResponse](docs/TaskGroupResponse.md)
 - [TaskResponse](docs/TaskResponse.md)
 - [TaskScheduleResponse](docs/TaskScheduleResponse.md)
 - [UnTagImage](docs/UnTagImage.md)
 - [UnpaginatedCollectionVersionResponse](docs/UnpaginatedCollectionVersionResponse.md)
 - [Upload](docs/Upload.md)
 - [UploadChunk](docs/UploadChunk.md)
 - [UploadChunkResponse](docs/UploadChunkResponse.md)
 - [UploadCommit](docs/UploadCommit.md)
 - [UploadDetailResponse](docs/UploadDetailResponse.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [UpstreamPulp](docs/UpstreamPulp.md)
 - [UpstreamPulpResponse](docs/UpstreamPulpResponse.md)
 - [User](docs/User.md)
 - [UserGroup](docs/UserGroup.md)
 - [UserGroupResponse](docs/UserGroupResponse.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserRole](docs/UserRole.md)
 - [UserRoleResponse](docs/UserRoleResponse.md)
 - [VariantResponse](docs/VariantResponse.md)
 - [VersionResponse](docs/VersionResponse.md)
 - [WorkerResponse](docs/WorkerResponse.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### basicAuth

- **Type**: HTTP basic authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextBasicAuth, sw.BasicAuth{
    UserName: "username",
    Password: "password",
})
r, err := client.Service.Operation(auth, args)
```

### cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 

Note, each API key must be added to a map of `map[string]APIKey` where the key is: sessionid and passed in as the auth context for each request.

Example

```golang
auth := context.WithValue(
		context.Background(),
		sw.ContextAPIKeys,
		map[string]sw.APIKey{
			"sessionid": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author

pulp-list@redhat.com

