/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RpmRepositorySyncURL type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmRepositorySyncURL{}

// RpmRepositorySyncURL Serializer for RPM Sync.
type RpmRepositorySyncURL struct {
	// A remote to sync from. This will override a remote set on repository.
	Remote *string `json:"remote,omitempty"`
	// DEPRECATED: If ``True``, ``sync_policy`` will default to 'mirror_complete' instead of 'additive'.
	Mirror NullableBool `json:"mirror,omitempty"`
	SyncPolicy NullableSyncPolicyEnum `json:"sync_policy,omitempty"`
	// List of content types to skip during sync.
	SkipTypes []SkipTypesEnum `json:"skip_types,omitempty"`
	// Whether or not to optimize sync.
	Optimize *bool `json:"optimize,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RpmRepositorySyncURL RpmRepositorySyncURL

// NewRpmRepositorySyncURL instantiates a new RpmRepositorySyncURL object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmRepositorySyncURL() *RpmRepositorySyncURL {
	this := RpmRepositorySyncURL{}
	var optimize bool = true
	this.Optimize = &optimize
	return &this
}

// NewRpmRepositorySyncURLWithDefaults instantiates a new RpmRepositorySyncURL object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmRepositorySyncURLWithDefaults() *RpmRepositorySyncURL {
	this := RpmRepositorySyncURL{}
	var optimize bool = true
	this.Optimize = &optimize
	return &this
}

// GetRemote returns the Remote field value if set, zero value otherwise.
func (o *RpmRepositorySyncURL) GetRemote() string {
	if o == nil || IsNil(o.Remote) {
		var ret string
		return ret
	}
	return *o.Remote
}

// GetRemoteOk returns a tuple with the Remote field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRepositorySyncURL) GetRemoteOk() (*string, bool) {
	if o == nil || IsNil(o.Remote) {
		return nil, false
	}
	return o.Remote, true
}

// HasRemote returns a boolean if a field has been set.
func (o *RpmRepositorySyncURL) HasRemote() bool {
	if o != nil && !IsNil(o.Remote) {
		return true
	}

	return false
}

// SetRemote gets a reference to the given string and assigns it to the Remote field.
func (o *RpmRepositorySyncURL) SetRemote(v string) {
	o.Remote = &v
}

// GetMirror returns the Mirror field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRepositorySyncURL) GetMirror() bool {
	if o == nil || IsNil(o.Mirror.Get()) {
		var ret bool
		return ret
	}
	return *o.Mirror.Get()
}

// GetMirrorOk returns a tuple with the Mirror field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRepositorySyncURL) GetMirrorOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.Mirror.Get(), o.Mirror.IsSet()
}

// HasMirror returns a boolean if a field has been set.
func (o *RpmRepositorySyncURL) HasMirror() bool {
	if o != nil && o.Mirror.IsSet() {
		return true
	}

	return false
}

// SetMirror gets a reference to the given NullableBool and assigns it to the Mirror field.
func (o *RpmRepositorySyncURL) SetMirror(v bool) {
	o.Mirror.Set(&v)
}
// SetMirrorNil sets the value for Mirror to be an explicit nil
func (o *RpmRepositorySyncURL) SetMirrorNil() {
	o.Mirror.Set(nil)
}

// UnsetMirror ensures that no value is present for Mirror, not even an explicit nil
func (o *RpmRepositorySyncURL) UnsetMirror() {
	o.Mirror.Unset()
}

// GetSyncPolicy returns the SyncPolicy field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RpmRepositorySyncURL) GetSyncPolicy() SyncPolicyEnum {
	if o == nil || IsNil(o.SyncPolicy.Get()) {
		var ret SyncPolicyEnum
		return ret
	}
	return *o.SyncPolicy.Get()
}

// GetSyncPolicyOk returns a tuple with the SyncPolicy field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmRepositorySyncURL) GetSyncPolicyOk() (*SyncPolicyEnum, bool) {
	if o == nil {
		return nil, false
	}
	return o.SyncPolicy.Get(), o.SyncPolicy.IsSet()
}

// HasSyncPolicy returns a boolean if a field has been set.
func (o *RpmRepositorySyncURL) HasSyncPolicy() bool {
	if o != nil && o.SyncPolicy.IsSet() {
		return true
	}

	return false
}

// SetSyncPolicy gets a reference to the given NullableSyncPolicyEnum and assigns it to the SyncPolicy field.
func (o *RpmRepositorySyncURL) SetSyncPolicy(v SyncPolicyEnum) {
	o.SyncPolicy.Set(&v)
}
// SetSyncPolicyNil sets the value for SyncPolicy to be an explicit nil
func (o *RpmRepositorySyncURL) SetSyncPolicyNil() {
	o.SyncPolicy.Set(nil)
}

// UnsetSyncPolicy ensures that no value is present for SyncPolicy, not even an explicit nil
func (o *RpmRepositorySyncURL) UnsetSyncPolicy() {
	o.SyncPolicy.Unset()
}

// GetSkipTypes returns the SkipTypes field value if set, zero value otherwise.
func (o *RpmRepositorySyncURL) GetSkipTypes() []SkipTypesEnum {
	if o == nil || IsNil(o.SkipTypes) {
		var ret []SkipTypesEnum
		return ret
	}
	return o.SkipTypes
}

// GetSkipTypesOk returns a tuple with the SkipTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRepositorySyncURL) GetSkipTypesOk() ([]SkipTypesEnum, bool) {
	if o == nil || IsNil(o.SkipTypes) {
		return nil, false
	}
	return o.SkipTypes, true
}

// HasSkipTypes returns a boolean if a field has been set.
func (o *RpmRepositorySyncURL) HasSkipTypes() bool {
	if o != nil && !IsNil(o.SkipTypes) {
		return true
	}

	return false
}

// SetSkipTypes gets a reference to the given []SkipTypesEnum and assigns it to the SkipTypes field.
func (o *RpmRepositorySyncURL) SetSkipTypes(v []SkipTypesEnum) {
	o.SkipTypes = v
}

// GetOptimize returns the Optimize field value if set, zero value otherwise.
func (o *RpmRepositorySyncURL) GetOptimize() bool {
	if o == nil || IsNil(o.Optimize) {
		var ret bool
		return ret
	}
	return *o.Optimize
}

// GetOptimizeOk returns a tuple with the Optimize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRepositorySyncURL) GetOptimizeOk() (*bool, bool) {
	if o == nil || IsNil(o.Optimize) {
		return nil, false
	}
	return o.Optimize, true
}

// HasOptimize returns a boolean if a field has been set.
func (o *RpmRepositorySyncURL) HasOptimize() bool {
	if o != nil && !IsNil(o.Optimize) {
		return true
	}

	return false
}

// SetOptimize gets a reference to the given bool and assigns it to the Optimize field.
func (o *RpmRepositorySyncURL) SetOptimize(v bool) {
	o.Optimize = &v
}

func (o RpmRepositorySyncURL) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmRepositorySyncURL) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Remote) {
		toSerialize["remote"] = o.Remote
	}
	if o.Mirror.IsSet() {
		toSerialize["mirror"] = o.Mirror.Get()
	}
	if o.SyncPolicy.IsSet() {
		toSerialize["sync_policy"] = o.SyncPolicy.Get()
	}
	if !IsNil(o.SkipTypes) {
		toSerialize["skip_types"] = o.SkipTypes
	}
	if !IsNil(o.Optimize) {
		toSerialize["optimize"] = o.Optimize
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmRepositorySyncURL) UnmarshalJSON(bytes []byte) (err error) {
	varRpmRepositorySyncURL := _RpmRepositorySyncURL{}

	if err = json.Unmarshal(bytes, &varRpmRepositorySyncURL); err == nil {
		*o = RpmRepositorySyncURL(varRpmRepositorySyncURL)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "remote")
		delete(additionalProperties, "mirror")
		delete(additionalProperties, "sync_policy")
		delete(additionalProperties, "skip_types")
		delete(additionalProperties, "optimize")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmRepositorySyncURL struct {
	value *RpmRepositorySyncURL
	isSet bool
}

func (v NullableRpmRepositorySyncURL) Get() *RpmRepositorySyncURL {
	return v.value
}

func (v *NullableRpmRepositorySyncURL) Set(val *RpmRepositorySyncURL) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmRepositorySyncURL) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmRepositorySyncURL) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmRepositorySyncURL(val *RpmRepositorySyncURL) *NullableRpmRepositorySyncURL {
	return &NullableRpmRepositorySyncURL{value: val, isSet: true}
}

func (v NullableRpmRepositorySyncURL) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmRepositorySyncURL) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


