#
# Copyright 2014-2021 the Pacemaker project contributors
#
# The version control history for this file may have further details.
#
# This source code is licensed under the GNU General Public License version 2
# or later (GPLv2+) WITHOUT ANY WARRANTY.
#

#
# Man page builders
#
# We have three types of man pages:
# - man pages for the tools
# - man pages for OCF agents
# - man pages for cluster properties used by daemons
#
# "BUILD_HELP" actually means "help2man is available", so it only controls the
# tool man pages, which are generated by help2man. The other man pages are
# generated via XSL transforms.
#

if BUILD_HELP
man8_MANS		= $(sbin_PROGRAMS:%=%.8) $(sbin_SCRIPTS:%=%.8)

HELP2MAN_ARGS = -N --section 8 --name "Part of the Pacemaker cluster resource manager"

# Some of our tools' help are just shell script invocations of another tool's
# help. Putting the real tool in MAN8DEPS helps detect when the wrapped help
# needs updating.
#
# If a ".inc" file exists, the tool has been converted to use glib for
# argument parsing, otherwise it still uses the libcrmcommon functions.
#
# @TODO Drop MAN8DEPS once we've converted all tools to libpacemaker API calls
#       and all wrappers to C code.
%.8:	% $(MAN8DEPS)
	$(AM_V_at)chmod a+x $(abs_builddir)/$<
	PATH=$(abs_builddir):$$PATH $(abs_builddir)/$< --version >/dev/null
	if [ -f $(abs_srcdir)/$@.inc ]; then \
		PATH=$(abs_builddir):$$PATH $(abs_builddir)/$< --help-all >/dev/null; \
	else \
		PATH=$(abs_builddir):$$PATH $(abs_builddir)/$< --help >/dev/null; \
	fi
	$(AM_V_MAN)if [ -f $(abs_srcdir)/$@.inc ]; then			\
		PATH=$(abs_builddir):$$PATH $(HELP2MAN) $(HELP2MAN_ARGS)	\
			-h --help-all 						\
			--no-discard-stderr 					\
			-i $(abs_srcdir)/$@.inc $(abs_builddir)/$<		\
			| sed -f $(top_srcdir)/tools/fix-manpages > $@ ; \
	else									\
		PATH=$(abs_builddir):$$PATH $(HELP2MAN) $(HELP2MAN_ARGS)	\
			--no-discard-stderr 					\
			$(abs_builddir)/$< --output $@ ;			\
	fi
endif

# Save raw XML meta-data from daemon executables, for later conversion into man
# pages. (Note that more specific rules may override this for creating other
# types of XML files.)
%.xml:  %
	$(AM_V_at)$(abs_builddir)/$< metadata > $@

# Process the raw daemon and OCF agent meta-data output using our
# meta-data-to-docbook-XML tranform.
%.dbook: %.xml
	$(AM_V_at)$(XSLTPROC) --nonet --novalid --stringparam man.name $* \
		$(DBOOK_OPTS) $(top_srcdir)/xml/ocf-meta2man.xsl \
		$(abs_builddir)/$< > $(abs_builddir)/$@

# Generate the actual man page for an OCF resource agent from the intermediate
# docbook XML.
%.7:	%.dbook
	$(AM_V_MAN)$(XSLTPROC) $(MANPAGE_XSLT) $(abs_builddir)/$< $(PCMK_quiet)
