/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tks.servlet;

import com.netscape.certsrv.base.EBaseException;
import java.security.InvalidKeyException;
import org.dogtagpki.server.tks.servlet.KDF;
import org.dogtagpki.server.tks.servlet.SecureChannelProtocol;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.SymmetricKeyDeriver;
import org.mozilla.jss.crypto.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardKDF
extends KDF {
    public static Logger logger = LoggerFactory.getLogger(StandardKDF.class);
    SecureChannelProtocol protocol = null;

    StandardKDF(SecureChannelProtocol protocol) {
        this.protocol = protocol;
    }

    public SymmetricKey computeCardKey_SCP03_WithDES3(SymmetricKey masterKey, byte[] derivationData, CryptoToken token) throws EBaseException {
        byte[] encrypted;
        String method = "StandardKDF.computeCardKey_SCP03_WithDES3:";
        logger.debug(method + " entering ...");
        if (masterKey == null || token == null || derivationData == null || derivationData.length != 16 && derivationData.length != 24 && derivationData.length != 32) {
            logger.error(method + " Invalid input parameters!");
            throw new EBaseException(method + " Invalid input parameters!");
        }
        try {
            encrypted = this.protocol.computeDes3EcbEncryption(masterKey, token.getName(), derivationData);
        }
        catch (TokenException e) {
            throw new EBaseException(method + "Can't derive key data!");
        }
        return this.protocol.unwrapAESSymKeyOnToken(token, encrypted, false);
    }

    public SymmetricKey computeCardKey(SymmetricKey masterKey, byte[] derivationData, CryptoToken token, int protocol) throws EBaseException {
        String method = "StandardKDF.computeCardKeys:";
        SymmetricKey result = null;
        logger.debug(method + " entering ...");
        if (masterKey == null || derivationData == null || derivationData.length != 16 || token == null) {
            throw new EBaseException(method + " Invlalid input parameters!");
        }
        try {
            SymmetricKeyDeriver encryptDes3 = token.getSymmetricKeyDeriver();
            encryptDes3.initDerive(masterKey, 4354L, derivationData, null, 306L, 268L, 16L);
            SymmetricKey derivedKey = null;
            try {
                derivedKey = encryptDes3.derive();
            }
            catch (TokenException e) {
                logger.error(method + "Unable to derive the key with the proper mechanism!");
                logger.warn(method + "Now try this the old fashioned way");
                byte[] encrypted = this.protocol.computeDes3EcbEncryption(masterKey, token.getName(), derivationData);
                logger.debug(method + "done computeDes3EcbEncryptiong");
                derivedKey = this.protocol.unwrapSymKeyOnToken(token, null, encrypted, false, SymmetricKey.DES3);
                return derivedKey;
            }
            logger.debug(method + " derived card key first 16 :" + derivedKey);
            logger.debug(method + " derivedKey 16: owning token: " + derivedKey.getOwningToken().getName());
            long bitPosition = 0L;
            byte[] param = SecureChannelProtocol.longToBytes(bitPosition);
            SymmetricKeyDeriver extract8 = token.getSymmetricKeyDeriver();
            extract8.initDerive(derivedKey, 869L, param, null, 260L, 268L, 8L);
            SymmetricKey extracted8 = extract8.derive();
            SymmetricKeyDeriver concat = token.getSymmetricKeyDeriver();
            concat.initDerive(derivedKey, extracted8, 864L, null, null, 306L, 268L, 0L);
            result = concat.derive();
            logger.debug(method + " final 24 byte key: " + result);
        }
        catch (InvalidKeyException | TokenException e) {
            logger.error(method + "Unable to derive the key with the proper mechanism: " + e.getMessage(), e);
            throw new EBaseException((Exception)e);
        }
        return result;
    }

    public SymmetricKey computeCardKeyOnSoftToken(SymmetricKey masterKey, byte[] data, int protocol) throws EBaseException {
        String method = "StandardKDF.computeCardKeys:";
        logger.debug(method + " entering...");
        if (masterKey == null || data == null) {
            throw new EBaseException(method + " Invlalid input parameters!");
        }
        CryptoToken token = this.protocol.getCryptoManger().getInternalKeyStorageToken();
        return this.computeCardKey(masterKey, data, token, protocol);
    }

    public SymmetricKey computeCardKeyOnToken(SymmetricKey masterKey, byte[] data, int protocol) throws EBaseException {
        String method = "StandardKDF.computeCardKeys:";
        if (masterKey == null || data == null) {
            throw new EBaseException(method + " Invlalid input parameters!");
        }
        CryptoToken token = masterKey.getOwningToken();
        return this.computeCardKey(masterKey, data, token, protocol);
    }
}

