/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.issuer;

import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PlainPasswordFile;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.dogtagpki.acme.ACMECertificate;
import org.dogtagpki.acme.database.ACMEDatabase;
import org.dogtagpki.acme.issuer.ACMEIssuer;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.nss.NSSDatabase;
import org.dogtagpki.nss.NSSExtensionGenerator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSIssuer
extends ACMEIssuer {
    public static Logger logger = LoggerFactory.getLogger(NSSIssuer.class);
    NSSDatabase nssDatabase;
    PasswordStore passwordStore;
    X509Certificate issuer;
    NSSExtensionGenerator extGenerator;
    Integer monthsValid;
    String hash;

    @Override
    public void init() throws Exception {
        String extensions;
        logger.info("Initializing NSS issuer");
        Path instanceDir = Paths.get(CMS.getInstanceDir(), new String[0]);
        String database = this.config.getParameter("database");
        if (database == null) {
            database = "conf/alias";
        }
        Path databasePath = instanceDir.resolve(database);
        logger.info("- database: " + databasePath);
        this.nssDatabase = new NSSDatabase(databasePath);
        String passwords = this.config.getParameter("passwords");
        if (passwords == null) {
            passwords = "conf/password.conf";
        }
        Path passwordsPath = instanceDir.resolve(passwords);
        logger.info("- passwords: " + passwordsPath);
        this.passwordStore = new PlainPasswordFile();
        this.passwordStore.init(passwordsPath.toString());
        this.nssDatabase.setPasswordStore(this.passwordStore);
        String nickname = this.config.getParameter("nickname");
        if (nickname == null) {
            nickname = "ca_signing";
        }
        logger.info("- nickname: " + nickname);
        CryptoManager cm = CryptoManager.getInstance();
        this.issuer = cm.findCertByNickname(nickname);
        String monthsValid = this.config.getParameter("monthsValid");
        this.monthsValid = monthsValid == null ? 3 : Integer.valueOf(monthsValid);
        logger.info("- months valid: " + monthsValid);
        String hash = this.config.getParameter("hash");
        if (hash != null) {
            logger.info("- hash: " + hash);
            this.hash = hash;
        }
        if ((extensions = this.config.getParameter("extensions")) == null) {
            extensions = "/usr/share/pki/acme/issuer/nss/sslserver.conf";
        }
        logger.info("- extensions: " + extensions);
        Path extPath = instanceDir.resolve(extensions);
        this.extGenerator = new NSSExtensionGenerator();
        this.extGenerator.init(extPath.toString());
    }

    @Override
    public String issueCertificate(PKCS10 pkcs10) throws Exception {
        logger.info("Issuing certificate");
        Date currentTime = new Date();
        ACMEEngine engine = ACMEEngine.getInstance();
        ACMEDatabase acmeDatabase = engine.getDatabase();
        Extensions extensions = null;
        if (this.extGenerator != null) {
            extensions = this.extGenerator.createExtensions(this.issuer, pkcs10);
        }
        java.security.cert.X509Certificate cert = this.nssDatabase.createCertificate(this.issuer, pkcs10, this.monthsValid, this.hash, extensions);
        BigInteger serialNumber = cert.getSerialNumber();
        String certID = Base64.encodeBase64URLSafeString((byte[])serialNumber.toByteArray());
        ACMECertificate certificate = new ACMECertificate();
        certificate.setID(certID);
        certificate.setCreationTime(currentTime);
        certificate.setData(cert.getEncoded());
        Date expirationTime = engine.getPolicy().getCertificateExpirationTime(cert.getNotAfter());
        certificate.setExpirationTime(expirationTime);
        acmeDatabase.addCertificate(certID, certificate);
        return certID;
    }

    public java.security.cert.X509Certificate[] getCACertificateChain() throws Exception {
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate[] caCertChain = cm.buildCertificateChain(this.issuer);
        java.security.cert.X509Certificate[] caCertChainImpl = new java.security.cert.X509Certificate[caCertChain.length];
        for (int i = 0; i < caCertChain.length; ++i) {
            X509Certificate cert = caCertChain[i];
            caCertChainImpl[i] = new X509CertImpl(cert.getEncoded());
        }
        return caCertChainImpl;
    }

    @Override
    public String getCertificateChain(String certID) throws Exception {
        logger.info("Retrieving certificate");
        ACMEEngine engine = ACMEEngine.getInstance();
        ACMEDatabase acmeDatabase = engine.getDatabase();
        ACMECertificate certificate = acmeDatabase.getCertificate(certID);
        X509CertImpl cert = new X509CertImpl(certificate.getData());
        java.security.cert.X509Certificate[] certChain = this.getCACertificateChain();
        StringWriter sw = new StringWriter();
        try (PrintWriter out = new PrintWriter((Writer)sw, true);){
            out.println("-----BEGIN CERTIFICATE-----");
            out.print(Utils.base64encodeMultiLine((byte[])cert.getEncoded()));
            out.println("-----END CERTIFICATE-----");
            for (java.security.cert.X509Certificate caCert : certChain) {
                out.println("-----BEGIN CERTIFICATE-----");
                out.print(Utils.base64encodeMultiLine((byte[])caCert.getEncoded()));
                out.println("-----END CERTIFICATE-----");
            }
        }
        return sw.toString();
    }
}

