/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.issuer;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.cert.CertRevokeRequest;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.dogtagpki.acme.ACMERevocation;
import org.dogtagpki.acme.issuer.ACMEIssuer;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIIssuer
extends ACMEIssuer {
    public static Logger logger = LoggerFactory.getLogger(PKIIssuer.class);
    private ClientConfig clientConfig = new ClientConfig();
    private String profile;

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    public void init() throws Exception {
        String username;
        logger.info("Initializing PKI issuer");
        String url = this.config.getParameter("url");
        logger.info("- URL: " + url);
        this.clientConfig.setServerURL(url);
        String nickname = this.config.getParameter("nickname");
        if (nickname != null) {
            logger.info("- nickname: " + nickname);
            this.clientConfig.setCertNickname(nickname);
        }
        if ((username = this.config.getParameter("username")) != null) {
            logger.info("- username: " + username);
            this.clientConfig.setUsername(username);
        }
        String password = null;
        String passwordFilename = this.config.getParameter("passwordFile");
        if (passwordFilename != null) {
            File passwordFile = new File(passwordFilename);
            logger.info("Loading password file " + passwordFilename);
            Properties props = new Properties();
            try (FileReader reader = new FileReader(passwordFile);){
                props.load(reader);
            }
            password = props.getProperty("acmeUserPassword");
            if (password == null) {
                throw new RuntimeException("PKIIssuer: 'acmeUserPassword' property not present in file " + passwordFilename);
            }
        } else {
            password = this.config.getParameter("password");
        }
        if (password != null) {
            this.clientConfig.setPassword(password);
        }
        this.profile = this.config.getParameter("profile");
        logger.info("- profile: " + this.profile);
    }

    @Override
    public String issueCertificate(PKCS10 pkcs10) throws Exception {
        logger.info("Issuing certificate");
        try (PKIClient pkiClient = new PKIClient(this.clientConfig);){
            CAClient caClient = new CAClient(pkiClient);
            caClient.login();
            CACertClient certClient = new CACertClient((SubsystemClient)caClient);
            CertEnrollmentRequest certEnrollmentRequest = certClient.getEnrollmentTemplate(this.profile);
            for (ProfileInput input : certEnrollmentRequest.getInputs()) {
                ProfileAttribute csrAttr;
                ProfileAttribute typeAttr = input.getAttribute("cert_request_type");
                if (typeAttr != null) {
                    typeAttr.setValue("pkcs10");
                }
                if ((csrAttr = input.getAttribute("cert_request")) == null) continue;
                csrAttr.setValue(Utils.base64encodeSingleLine((byte[])pkcs10.toByteArray()));
            }
            logger.info("Request:\n" + certEnrollmentRequest);
            CertRequestInfos infos = certClient.enrollRequest(certEnrollmentRequest, null, null);
            logger.info("Responses:");
            CertRequestInfo info = (CertRequestInfo)infos.getEntries().iterator().next();
            RequestId requestId = info.getRequestID();
            logger.info("- Request ID: " + requestId.toHexString());
            logger.info("  Type: " + info.getRequestType());
            logger.info("  Request Status: " + info.getRequestStatus());
            logger.info("  Operation Result: " + info.getOperationResult());
            String error = info.getErrorMessage();
            if (error != null) {
                throw new Exception("Unable to generate certificate: " + error);
            }
            CertId id = null;
            if (info.getRequestStatus() == RequestStatus.COMPLETE) {
                id = info.getCertId();
            } else {
                CertReviewResponse reviewInfo = certClient.reviewRequest(requestId);
                certClient.approveRequest(requestId, reviewInfo);
                info = certClient.getRequest(requestId);
                id = info.getCertId();
            }
            logger.info("Serial number: " + id.toHexString());
            BigInteger serialNumber = id.toBigInteger();
            String string = Base64.encodeBase64URLSafeString((byte[])serialNumber.toByteArray());
            return string;
        }
    }

    @Override
    public String getCertificateChain(String certID) throws Exception {
        CertId id = new CertId(new BigInteger(1, Base64.decodeBase64((String)certID)));
        logger.info("Serial number: " + id.toHexString());
        try (PKIClient pkiClient = new PKIClient(this.clientConfig);){
            CAClient caClient = new CAClient(pkiClient);
            CACertClient certClient = new CACertClient((SubsystemClient)caClient);
            CertData certData = certClient.getCert(id);
            String pkcs7Chain = certData.getPkcs7CertChain();
            logger.info("Cert chain:\n" + pkcs7Chain);
            PKCS7 pkcs7 = new PKCS7(Utils.base64decode((String)pkcs7Chain));
            X509Certificate[] certs = pkcs7.getCertificates();
            if (certs == null || certs.length == 0) {
                throw new Error("PKCS #7 data contains no certificates");
            }
            certs = Cert.sortCertificateChain((X509Certificate[])certs, (boolean)true);
            StringWriter sw = new StringWriter();
            try (PrintWriter out = new PrintWriter((Writer)sw, true);){
                for (X509Certificate cert : certs) {
                    out.println("-----BEGIN CERTIFICATE-----");
                    out.print(Utils.base64encode((byte[])cert.getEncoded(), (boolean)true));
                    out.println("-----END CERTIFICATE-----");
                }
            }
            String string = sw.toString();
            return string;
        }
    }

    @Override
    public void revokeCertificate(ACMERevocation revocation) throws Exception {
        String certBase64 = revocation.getCertificate();
        byte[] certBytes = Utils.base64decode((String)certBase64);
        Integer reason = revocation.getReason();
        StringWriter sw = new StringWriter();
        try (PrintWriter out = new PrintWriter((Writer)sw, true);){
            out.println("-----BEGIN CERTIFICATE-----");
            out.print(Utils.base64encode((byte[])certBytes, (boolean)true));
            out.println("-----END CERTIFICATE-----");
        }
        String certPEM = sw.toString();
        logger.info("Certificate:\n" + certPEM);
        logger.info("Reason: " + reason);
        X509CertImpl certImpl = new X509CertImpl(certBytes);
        CertId certID = new CertId(certImpl.getSerialNumber());
        logger.info("Serial number: " + certID.toHexString());
        logger.info("Reviewing certificate");
        try (PKIClient pkiClient = new PKIClient(this.clientConfig);){
            CAClient caClient = new CAClient(pkiClient);
            CACertClient certClient = new CACertClient((SubsystemClient)caClient);
            CertData certData = certClient.reviewCert(certID);
            String certFromIssuerPEM = certData.getEncoded();
            if (null == certFromIssuerPEM) {
                throw new Exception("Unable to revoke certificate: failed to retrieve cert from PKI");
            }
            byte[] certFromIssuerDER = Cert.parseCertificate((String)certFromIssuerPEM);
            if (!Arrays.equals(certBytes, certFromIssuerDER)) {
                throw new Exception("Unable to revoke certificate: cert in request was not issued by this PKI");
            }
            CertRevokeRequest request = new CertRevokeRequest();
            request.setReason(RevocationReason.valueOf((int)reason).getLabel());
            request.setNonce(certData.getNonce());
            logger.info("Revoking certificate");
            CertRequestInfo certRequestInfo = certClient.revokeCert(certID, request);
            RequestStatus status = certRequestInfo.getRequestStatus();
            if (status != RequestStatus.COMPLETE) {
                throw new Exception("Unable to revoke certificate: " + status);
            }
            if (certRequestInfo.getOperationResult().equals("error")) {
                String error = certRequestInfo.getErrorMessage();
                throw new Exception("Unable to revoke certificate: " + error);
            }
        }
    }
}

