/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMEChallenge;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.server.ACMEChallengeProcessor;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.dogtagpki.acme.validator.ACMEValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="chall/{id}")
@ACMEManagedService
public class ACMEChallengeService {
    public static Logger logger = LoggerFactory.getLogger(ACMEChallengeService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response handlePOST(@PathParam(value="id") String challengeID, JWS jws) throws Exception {
        logger.info("Validating challenge " + challengeID);
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        URI kid = header.getKid();
        String kidPath = kid.getPath();
        String accountID = kidPath.substring(kidPath.lastIndexOf(47) + 1);
        logger.info("Account ID: " + accountID);
        ACMEAccount account = engine.getAccount(accountID);
        engine.validateJWS(jws, header.getAlg(), account.getJWK());
        String payload = new String(jws.getPayloadAsBytes(), "UTF-8");
        logger.info("Payload: " + payload);
        ACMEAuthorization authorization = engine.getAuthorizationByChallenge(account, challengeID);
        String authzID = authorization.getID();
        ACMEChallenge challenge = authorization.getChallenge(challengeID);
        if (challenge == null) {
            throw new Exception("Unknown challenge: " + challengeID);
        }
        String challengeStatus = challenge.getStatus();
        if (challengeStatus.equals("pending")) {
            String type = challenge.getType();
            logger.info("Challenge Type: " + type);
            ACMEValidator validator = engine.getValidator(type);
            if (validator == null) {
                throw new Exception("Unsupported challenge type: " + type);
            }
            challenge.setStatus("processing");
            engine.updateAuthorization(account, authorization);
            ACMEChallengeProcessor processor = new ACMEChallengeProcessor(account, authorization, challenge, validator);
            new Thread(processor).start();
        } else if (!challengeStatus.equals("processing")) {
            if (challengeStatus.equals("valid")) {
                logger.info("Challenge is already valid");
            } else {
                throw new Exception("Challenge is already " + challengeStatus);
            }
        }
        URI challengeURL = this.uriInfo.getBaseUriBuilder().path("chall").path(challengeID).build(new Object[0]);
        challenge.setURL(challengeURL);
        Response.ResponseBuilder builder = Response.ok();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
        URI authzURL = this.uriInfo.getBaseUriBuilder().path("authz").path(authzID).build(new Object[0]);
        builder.link(authzURL, "up");
        builder.entity((Object)challenge);
        return builder.build();
    }
}

