/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmstools.PWsdrCache;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.util.Base64OutputStream;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class PasswordCache {
    public static final String PROP_PWC_NICKNAME = "sso_key";
    public static final String PW_TAG_INTERNAL_LDAP_DB = "Internal LDAP Database";
    private static boolean debugMode = false;

    private static void usage() {
        System.out.println("This tool has to be run from the same directory where pwcache.db file resides, normally <cms instance>/config directory, unless the file's full path is specified in the -c option..\nUsage: PasswordCache <SSO_PASSWORD> <-d cert/key db directory> <-h tokenName> <-P cert/key db prefix> <-c pwcache.db_file_full_path> <-k file containing Base64EncodedKeyID> <COMMAND> ...");
        System.out.println("  commands:");
        System.out.println("     'add <password_name> <password>'");
        System.out.println("     'change <password_name> <password>'");
        System.out.println("     'delete <password_name>'");
        System.out.println("     'rekey'");
        System.out.println("     'list'");
        System.out.println("\nExample:\n\tPasswordCache thePassword1 -d /usr/netscape/servers/cms/alias -P cert-instance1-machine1- -c pwcache.db -k keyidFile list");
        System.exit(1);
    }

    private static void debug(String s) {
        if (debugMode) {
            System.out.println("PasswordCache debug: " + s);
        }
    }

    private static String[] cleanArgs(String[] s) {
        int i;
        int length = s.length;
        PasswordCache.debug("before cleanArgs argv length =" + length);
        for (i = length - 1; i >= 0 && s[i].equals(""); --i) {
            --length;
        }
        String[] new_av = new String[length];
        for (i = 0; i < length; ++i) {
            new_av[i] = s[i];
            PasswordCache.debug("arg " + i + " is " + new_av[i]);
        }
        PasswordCache.debug("after cleanArgs argv length =" + length);
        return new_av;
    }

    public static byte[] base64Decode(String s) throws IOException {
        byte[] d = Utils.base64decode((String)s);
        return d;
    }

    public static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] av) {
        PWsdrCache cache;
        String mPath = ".";
        String mTokenName = null;
        String mPrefix = "";
        String mKeyIdString = null;
        byte[] mKeyId = null;
        String mCacheFile = "pwcache.db";
        String pwdPath = null;
        String instancePath = null;
        String instanceName = null;
        String[] argv = PasswordCache.cleanArgs(av);
        if (argv.length < 2) {
            PasswordCache.usage();
        }
        String pw = argv[0];
        char[] testpw = pw.toCharArray();
        String command = "";
        String aTag = "";
        String aPasswd = "";
        int i = 0;
        for (i = 1; i < argv.length; ++i) {
            if (argv[i].equals("-d")) {
                if (++i >= argv.length) {
                    PasswordCache.usage();
                }
                mPath = argv[i];
                continue;
            }
            if (argv[i].equals("-h")) {
                if (++i >= argv.length) {
                    PasswordCache.usage();
                }
                mTokenName = argv[i];
                continue;
            }
            if (argv[i].equals("-P")) {
                if (++i >= argv.length) {
                    PasswordCache.usage();
                }
                mPrefix = argv[i];
                continue;
            }
            if (argv[i].equals("-c")) {
                if (++i >= argv.length) {
                    PasswordCache.usage();
                }
                mCacheFile = argv[i];
                continue;
            }
            if (argv[i].equals("-k")) {
                if (++i >= argv.length) {
                    PasswordCache.usage();
                }
                String keyFile = argv[i];
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(keyFile));
                    mKeyIdString = r.readLine();
                }
                catch (Exception e) {
                    System.out.println("Error: " + e.toString());
                    System.exit(1);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (mKeyIdString == null) continue;
                try {
                    mKeyId = PasswordCache.base64Decode(mKeyIdString);
                    PasswordCache.debug("base64Decode of key id string successful");
                }
                catch (IOException e) {
                    System.out.println("base64Decode of key id string failed");
                    System.exit(1);
                }
                continue;
            }
            command = argv[i++];
            PasswordCache.debug("command = " + command);
            if (command.equals("add") || command.equals("change")) {
                aTag = argv[i++];
                aPasswd = argv[i];
                PasswordCache.debug("command is " + command + " " + aTag + ":" + aPasswd);
                break;
            }
            if (command.equals("delete")) {
                aTag = argv[i];
                break;
            }
            if (command.equals("list") || !command.equals("rekey")) break;
            break;
        }
        Password pass = new Password(testpw);
        try {
            System.out.println("cert/key prefix = " + mPrefix);
            System.out.println("cert/key db path = " + mPath);
            System.out.println("password cache file = " + mCacheFile);
            InitializationValues vals = new InitializationValues(mPath, mPrefix, mPrefix, "secmod.db");
            CryptoManager.initialize((InitializationValues)vals);
            CryptoToken token = CryptoUtil.getKeyStorageToken((String)mTokenName);
            System.out.println("token: " + token.getName());
            token.login((PasswordCallback)pass);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            pass.clear();
        }
        if (command.equals("rekey")) {
            System.out.println("generating new key...");
            cache = null;
            try {
                File passwordCacheDB = new File(mCacheFile);
                pwdPath = passwordCacheDB.getAbsolutePath();
                int beginIndex = pwdPath.lastIndexOf("cert-");
                instancePath = pwdPath.substring(beginIndex);
                int endIndex = 0;
                endIndex = instancePath.lastIndexOf("config");
                instanceName = instancePath.substring(0, endIndex - 1);
                cache = new PWsdrCache(mCacheFile, mTokenName, null, true);
                cache.deleteUniqueNamedKey("sso_key " + instanceName);
                byte[] newKeyId = cache.generateSDRKeyWithNickName("sso_key " + instanceName);
                if (newKeyId != null) {
                    String newKeyIDString = PasswordCache.base64Encode(newKeyId);
                    System.out.println("key generated successfully with key id = " + newKeyIDString);
                    System.out.println("Save the VALUE portion of this key id in a local file,");
                    System.out.println("and under variable \"pwcKeyid\" in CS.cfg !!");
                    System.out.println("If you have not already done so,");
                    System.out.println("remove the old pwcache.db and use this local file to add passwords.");
                    System.exit(0);
                } else {
                    System.out.println("key expected to be generated but wasn't");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.exit(1);
            }
        }
        cache = null;
        try {
            cache = new PWsdrCache(mCacheFile, mTokenName, mKeyId, true);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(1);
        }
        if (command.equals("add") || command.equals("change")) {
            if (mKeyId == null) {
                System.out.println("operation failed: no key id specified");
                System.exit(1);
            }
            try {
                System.out.println("adding " + aTag + ":" + aPasswd);
                cache.addEntry(aTag, aPasswd);
            }
            catch (Exception e) {
                System.out.println("--failed--" + e.toString());
            }
        } else if (command.equals("list")) {
            cache.pprint();
        } else if (command.equals("delete")) {
            if (mKeyId == null) {
                System.out.println("operation failed: no key id specified");
                System.exit(1);
            }
            try {
                cache.deleteEntry(aTag);
            }
            catch (Exception e) {
                System.out.println("User not found");
            }
        } else {
            System.out.println("Illegal command: " + command);
            System.exit(1);
        }
    }
}

