/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertCLI;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.codec.binary.Hex;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS12Util;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.util.Password;

public class PKCS12CertExportCLI
extends CommandCLI {
    public PKCS12CertCLI certCLI;

    public PKCS12CertExportCLI(PKCS12CertCLI certCLI) {
        super("export", "Export certificate from PKCS #12 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nickname]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs12-file", true, "PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password-file", true, "PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "cert-file", true, "Certificate file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "cert-id", true, "Certificate ID to export");
        option.setArgName("ID");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String passwordFile;
        String[] cmdArgs = cmd.getArgs();
        String id = cmd.getOptionValue("cert-id");
        if (cmdArgs.length < 1 && id == null) {
            throw new Exception("Missing certificate nickname or ID.");
        }
        if (cmdArgs.length >= 1 && id != null) {
            throw new Exception("Certificate nickname and ID are mutually exclusive.");
        }
        String nickname = null;
        byte[] certID = null;
        if (cmdArgs.length >= 1) {
            nickname = cmdArgs[0];
        } else {
            if (id.startsWith("0x")) {
                id = id.substring(2);
            }
            certID = Hex.decodeHex((String)id);
        }
        String pkcs12File = cmd.getOptionValue("pkcs12-file");
        if (pkcs12File == null) {
            throw new Exception("Missing PKCS #12 file.");
        }
        String passwordString = cmd.getOptionValue("pkcs12-password");
        if (passwordString == null && (passwordFile = cmd.getOptionValue("pkcs12-password-file")) != null) {
            try (BufferedReader in = new BufferedReader(new FileReader(passwordFile));){
                passwordString = in.readLine();
            }
        }
        if (passwordString == null) {
            throw new Exception("Missing PKCS #12 password.");
        }
        String certFile = cmd.getOptionValue("cert-file");
        if (certFile == null) {
            throw new Exception("Missing certificate file.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        Password password = new Password(passwordString.toCharArray());
        try {
            PKCS12Util util = new PKCS12Util();
            PKCS12 pkcs12 = util.loadFromFile(pkcs12File, password);
            ArrayList<PKCS12CertInfo> certInfos = new ArrayList<PKCS12CertInfo>();
            if (nickname != null) {
                certInfos.addAll(pkcs12.getCertInfosByFriendlyName(nickname));
            } else {
                PKCS12CertInfo certInfo = pkcs12.getCertInfoByID(certID);
                if (certInfo != null) {
                    certInfos.add(certInfo);
                }
            }
            if (certInfos.isEmpty()) {
                throw new Exception("Certificate not found.");
            }
            try (PrintStream os = new PrintStream(new FileOutputStream(certFile));){
                for (PKCS12CertInfo certInfo : certInfos) {
                    X509CertImpl cert = certInfo.getCert();
                    os.println("-----BEGIN CERTIFICATE-----");
                    os.print(Utils.base64encode((byte[])cert.getEncoded(), (boolean)true));
                    os.println("-----END CERTIFICATE-----");
                }
            }
        }
        finally {
            password.clear();
        }
    }
}

