/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserKeyDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.provider.DSAPublicKey;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(KeyConstraint.class);
    public static final String CONFIG_KEY_TYPE = "keyType";
    public static final String CONFIG_KEY_PARAMETERS = "keyParameters";
    private static String[] cfgECCurves = null;
    private static String keyType = "";
    private static String keyParams = "";

    public KeyConstraint() {
        this.addConfigName(CONFIG_KEY_TYPE);
        this.addConfigName(CONFIG_KEY_PARAMETERS);
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
        super.init(config);
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        String ecNames = "";
        try {
            ecNames = cs.getString("keys.ecc.curve.list");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("KeyConstraint.init ecNames: " + ecNames);
        if (ecNames != null && ecNames.length() != 0) {
            cfgECCurves = ecNames.split(",");
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_KEY_TYPE)) {
            return new Descriptor("choice", "-,RSA,EC", "RSA", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_TYPE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_KEY_PARAMETERS)) {
            return new Descriptor("string", null, "", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_PARAMETERS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        block18: {
            try {
                CertificateX509Key infokey = (CertificateX509Key)info.get("key");
                X509Key key = (X509Key)infokey.get("value");
                String alg = key.getAlgorithmId().getName().toUpperCase();
                logger.info("KeyConstraint: Key algorithnm: " + alg);
                String value = this.getConfig(CONFIG_KEY_TYPE);
                logger.info("KeyConstraint: Key type: " + value);
                String keyType = value;
                if (!this.isOptional(value) && !alg.equals(value)) {
                    logger.error("Invalid key type: " + value);
                    throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_TYPE_NOT_MATCHED", (String[])new String[]{value}));
                }
                int keySize = 0;
                if (alg.equals("RSA")) {
                    keySize = this.getRSAKeyLen(key);
                } else if (alg.equals("DSA")) {
                    keySize = this.getDSAKeyLen(key);
                } else if (!alg.equals("EC")) {
                    throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_KEY_TYPE", (String[])new String[]{alg}));
                }
                value = this.getConfig(CONFIG_KEY_PARAMETERS);
                String[] keyParams = value.split(",");
                if (alg.equals("EC")) {
                    if (!alg.equals(keyType) && !this.isOptional(keyType)) {
                        logger.error("Invalid key type: " + keyType);
                        throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_PARAMS_NOT_MATCHED", (String[])new String[]{value}));
                    }
                    Vector vect = CryptoUtil.getECKeyCurve((X509Key)key);
                    boolean curveFound = false;
                    if (vect != null) {
                        logger.debug("vect: " + vect);
                        if (!this.isOptional(keyType)) {
                            for (int i = 0; i < keyParams.length; ++i) {
                                String ecParam = keyParams[i];
                                logger.debug("keyParams[i]: " + i + " param: " + ecParam);
                                if (!vect.contains(ecParam)) continue;
                                curveFound = true;
                                logger.debug("KeyConstraint.validate: EC key constrainst passed.");
                                break;
                            }
                        } else {
                            curveFound = true;
                        }
                    }
                    if (!curveFound) {
                        String message = CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_PARAMS_NOT_MATCHED", (String[])new String[]{value});
                        logger.error("KeyConstraint.validate: EC key constrainst failed: " + message);
                        throw new ERejectException(message);
                    }
                    break block18;
                }
                if (!this.arrayContainsString(keyParams, Integer.toString(keySize))) {
                    throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_PARAMS_NOT_MATCHED", (String[])new String[]{value}));
                }
                logger.debug("KeyConstraint.validate: RSA key contraints passed.");
            }
            catch (Exception e) {
                if (e instanceof ERejectException) {
                    throw (ERejectException)e;
                }
                logger.error("KeyConstraint: " + e.getMessage(), (Throwable)e);
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_NOT_FOUND", (String[])new String[0]));
            }
        }
    }

    public int getRSAKeyLen(X509Key key) throws Exception {
        X509Key newkey = null;
        try {
            newkey = new X509Key(AlgorithmId.get((String)"RSA"), key.getKey());
        }
        catch (Exception e) {
            logger.error("KeyConstraint: getRSAKey Len " + e.getMessage(), (Throwable)e);
            return -1;
        }
        RSAPublicKey rsaKey = new RSAPublicKey(newkey.getEncoded());
        return rsaKey.getKeySize();
    }

    public int getDSAKeyLen(X509Key key) throws Exception {
        DSAPublicKey dsaKey = new DSAPublicKey(key.getEncoded());
        DSAParams keyParams = dsaKey.getParams();
        BigInteger p = keyParams.getP();
        int len = p.bitLength();
        return len;
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_KEY_TYPE), this.getConfig(CONFIG_KEY_PARAMETERS)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_KEY_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        return def instanceof UserKeyDefault;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        logger.info("KeyConstraint: Setting " + name + ": " + value);
        if (name.equals(CONFIG_KEY_TYPE)) {
            keyType = value;
            if (keyParams.equals("")) {
                return;
            }
        }
        if (name.equals(CONFIG_KEY_PARAMETERS)) {
            keyParams = value;
            if (keyType.equals("")) {
                return;
            }
        }
        if (keyType.length() > 0 && keyParams.length() > 0) {
            String[] params = keyParams.split(",");
            boolean isECCurve = false;
            int keySize = 0;
            if (keyType.equals("EC")) {
                for (String param : params) {
                    logger.info("KeyConstraint: EC curve: " + param);
                    isECCurve = cfgECCurves == null ? this.arrayContainsString(CryptoUtil.getECcurves(), param) : this.arrayContainsString(cfgECCurves, param);
                    if (isECCurve) continue;
                    logger.error("Invalid EC curve: " + param);
                    keyType = "";
                    keyParams = "";
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            } else {
                for (String param : params) {
                    try {
                        logger.info("KeyConstraint: RSA key size: " + param);
                        keySize = Integer.parseInt(param);
                    }
                    catch (NumberFormatException e) {
                        if (this.isOptional(keyType)) {
                            logger.info("KeyConstraint: EC curve: " + param);
                            isECCurve = this.arrayContainsString(CryptoUtil.getECcurves(), param);
                        }
                        keySize = 0;
                    }
                    if (keySize > 0 || isECCurve) continue;
                    logger.error("Invalid EC curve: " + param);
                    keyType = "";
                    keyParams = "";
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
        }
        super.setConfig(CONFIG_KEY_TYPE, keyType);
        super.setConfig(CONFIG_KEY_PARAMETERS, keyParams);
        keyType = "";
        keyParams = "";
    }

    private boolean arrayContainsString(String[] array, String value) {
        if (array == null || value == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }
}

