/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.EnrollProfile;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import java.util.Map;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class nsHKeyCertReqInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(nsHKeyCertReqInput.class);
    public static final String VAL_TOKEN_CUID = "tokencuid";
    public static final String VAL_PUBLIC_KEY = "publickey";
    public EnrollProfile mEnrollProfile = null;

    public nsHKeyCertReqInput() {
        this.addValueName(VAL_TOKEN_CUID);
        this.addValueName(VAL_PUBLIC_KEY);
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
        this.mEnrollProfile = (EnrollProfile)profile;
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_TOKENKEY_CERT_REQ_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_TOKENKEY_CERT_REQ_TEXT", (String[])new String[0]);
    }

    public String toPrettyPrint(String cuid) {
        if (cuid == null) {
            return null;
        }
        if (cuid.length() != 20) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cuid.length(); ++i) {
            if (i == 4 || i == 8 || i == 12 || i == 16) {
                sb.append("-");
            }
            sb.append(cuid.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        String tcuid = ctx.get(VAL_TOKEN_CUID);
        String prettyPrintCuid = this.toPrettyPrint(tcuid);
        if (prettyPrintCuid == null) {
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_TOKENKEY_NO_TOKENCUID", (String[])new String[]{""}));
        }
        request.setExtData("pretty_print_tokencuid", prettyPrintCuid);
        String pk = ctx.get(VAL_PUBLIC_KEY);
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        if (tcuid == null) {
            logger.error("nsHKeyCertReqInput: populate - tokencuid not found");
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_TOKENKEY_NO_TOKENCUID", (String[])new String[]{""}));
        }
        if (pk == null) {
            logger.error("nsHKeyCertReqInput: populate - public key not found");
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_TOKENKEY_NO_PUBLIC_KEY", (String[])new String[]{""}));
        }
        this.mEnrollProfile.fillNSHKEY(this.getLocale(request), tcuid, pk, info, request);
        request.setExtData("req_x509info", info);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_TOKEN_CUID)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_TOKENKEY_CERT_REQ_TOKEN_CUID", (String[])new String[0]));
        }
        if (name.equals(VAL_PUBLIC_KEY)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_TOKENKEY_CERT_REQ_PK", (String[])new String[0]));
        }
        return null;
    }
}

