/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.template.ArgList;
import com.netscape.certsrv.template.ArgSet;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.profile.common.ProfileOutput;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.security.JssSubsystem;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caProfileReview", urlPatterns={"/agent/ca/profileReview"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authorityId", value="ca"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caProfileReview"), @WebInitParam(name="unauthorizedTemplate", value="/agent/GenUnauthorized.template"), @WebInitParam(name="templatePath", value="/agent/ca/ProfileReview.template"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.request.profile")})
public class ProfileReviewServlet
extends ProfileServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileReviewServlet.class);
    private static final long serialVersionUID = -6559751428547928511L;
    private static final String PROP_AUTHORITY_ID = "authorityId";
    private String mAuthorityId = null;
    CertificateAuthority authority;
    private SecureRandom mRandom = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.mAuthorityId = sc.getInitParameter(PROP_AUTHORITY_ID);
        if (this.mAuthorityId != null) {
            this.authority = (CertificateAuthority)engine.getSubsystem(this.mAuthorityId);
        }
        if (this.authority != null && engine.getEnableNonces()) {
            this.mRandom = jssSubsystem.getRandomNumberGenerator();
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        logger.debug("ProfileReviewServlet: start serving");
        CAEngine engine = CAEngine.getInstance();
        Locale locale = this.getLocale(request);
        ArgSet args = new ArgSet();
        AuthToken authToken = null;
        if (this.mAuthMgr != null) {
            try {
                authToken = this.authenticate(request);
            }
            catch (EBaseException e) {
                logger.error("ReviewReqServlet: " + e.getMessage(), (Throwable)e);
                logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}));
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                return;
            }
        }
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHORIZATION_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        if (this.mProfileSubId == null || this.mProfileSubId.equals("")) {
            this.mProfileSubId = "profile";
        }
        logger.debug("ProfileReviewServlet: SubId=" + this.mProfileSubId);
        ProfileSubsystem ps = engine.getProfileSubsystem(this.mProfileSubId);
        if (ps == null) {
            logger.error("ProfileReviewServlet: ProfileSubsystem not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        if (this.authority == null) {
            logger.error("ProfileReviewServlet: Authority " + this.mAuthorityId + " not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        RequestQueue queue = engine.getRequestQueue();
        if (queue == null) {
            logger.error("ProfileReviewServlet: Request Queue of " + this.mAuthorityId + " not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        String requestId = request.getParameter("requestId");
        Request req = null;
        logger.debug("ProfileReviewServlet: requestId=" + requestId);
        try {
            req = this.requestRepository.readRequest(new RequestId(requestId));
        }
        catch (EBaseException e) {
            logger.warn("ProfileReviewServlet: request not found requestId=" + requestId + ": " + e.getMessage(), (Throwable)e);
        }
        if (req == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_REQUEST_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)requestId)}));
            this.outputTemplate(request, response, args);
            return;
        }
        String profileId = req.getExtDataInString("profileId");
        logger.debug("ProfileReviewServlet: requestId=" + requestId + " profileId=" + profileId);
        Profile profile = null;
        try {
            profile = ps.getProfile(profileId);
        }
        catch (EProfileException e) {
            logger.warn("ProfileReviewServlet: profile not found requestId=" + requestId + " profileId=" + profileId + ": " + e.getMessage(), (Throwable)e);
        }
        if (profile == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
            this.outputTemplate(request, response, args);
            return;
        }
        String profileSetId = req.getExtDataInString("profileSetId");
        logger.debug("ProfileReviewServlet: profileSetId=" + profileSetId);
        Enumeration<String> policyIds = profileSetId != null && profileSetId.length() > 0 ? profile.getProfilePolicyIds(profileSetId) : null;
        ArgList list = new ArgList();
        if (policyIds != null) {
            while (policyIds.hasMoreElements()) {
                String id = policyIds.nextElement();
                ProfilePolicy policy = profile.getProfilePolicy(req.getExtDataInString("profileSetId"), id);
                this.handlePolicy(list, (ServletResponse)response, locale, id, policy, req);
            }
        }
        if (this.authority != null && engine.getEnableNonces()) {
            long n = this.mRandom.nextLong();
            Map<Object, Long> nonces = engine.getNonces(request, "cert-request");
            nonces.put(req.getRequestId().toBigInteger(), n);
            args.set("nonce", Long.toString(n));
        }
        args.set("requestId", req.getRequestId().toString());
        args.set("requestType", req.getRequestType());
        args.set("requestStatus", req.getRequestStatus().toString());
        if (req.getRequestOwner() == null) {
            args.set("requestOwner", "");
        } else {
            args.set("requestOwner", req.getRequestOwner());
        }
        args.set("requestCreationTime", req.getCreationTime().toString());
        args.set("requestModificationTime", req.getModificationTime().toString());
        args.set("profileId", profileId);
        args.set("profileApprovedBy", req.getExtDataInString("profileApprovedBy"));
        args.set("profileSetId", req.getExtDataInString("profileSetId"));
        if (profile.isVisible()) {
            args.set("profileIsVisible", "true");
        } else {
            args.set("profileIsVisible", "false");
        }
        args.set("profileName", profile.getName(locale));
        args.set("profileDesc", profile.getDescription(locale));
        args.set("profileRemoteHost", req.getExtDataInString("profileRemoteHost"));
        args.set("profileRemoteAddr", req.getExtDataInString("profileRemoteAddr"));
        if (req.getExtDataInString("requestNotes") == null) {
            args.set("requestNotes", "");
        } else {
            args.set("requestNotes", CMSTemplate.escapeJavaScriptStringHTML((String)req.getExtDataInString("requestNotes")));
        }
        args.set("record", list);
        args.set("errorCode", "0");
        args.set("errorReason", "");
        ArgList inputlist = new ArgList();
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                if (inputNames == null) continue;
                while (inputNames.hasMoreElements()) {
                    ArgSet inputset = new ArgSet();
                    String inputName = inputNames.nextElement();
                    IDescriptor inputDesc = profileInput.getValueDescriptor(locale, inputName);
                    if (inputDesc == null) continue;
                    String inputSyntax = inputDesc.getSyntax();
                    String inputConstraint = inputDesc.getConstraint();
                    String inputValueName = inputDesc.getDescription(locale);
                    String inputValue = null;
                    try {
                        inputValue = profileInput.getValue(inputName, locale, req);
                    }
                    catch (EBaseException e) {
                        logger.warn("ProfileReviewServlet: " + e.getMessage(), (Throwable)e);
                    }
                    inputset.set("inputId", inputName);
                    inputset.set("inputSyntax", inputSyntax);
                    inputset.set("inputConstraint", inputConstraint);
                    inputset.set("inputName", inputValueName);
                    inputset.set("inputVal", inputValue);
                    inputlist.add(inputset);
                }
            }
        }
        args.set("inputList", inputlist);
        ArgList outputlist = new ArgList();
        Enumeration<String> outputIds = profile.getProfileOutputIds();
        if (outputIds != null) {
            while (outputIds.hasMoreElements()) {
                String outputId = outputIds.nextElement();
                ProfileOutput profileOutput = profile.getProfileOutput(outputId);
                Enumeration<String> outputNames = profileOutput.getValueNames();
                if (outputNames == null) continue;
                while (outputNames.hasMoreElements()) {
                    ArgSet outputset = new ArgSet();
                    String outputName = outputNames.nextElement();
                    IDescriptor outputDesc = profileOutput.getValueDescriptor(locale, outputName);
                    if (outputDesc == null) continue;
                    String outputSyntax = outputDesc.getSyntax();
                    String outputConstraint = outputDesc.getConstraint();
                    String outputValueName = outputDesc.getDescription(locale);
                    String outputValue = null;
                    try {
                        outputValue = profileOutput.getValue(outputName, locale, req);
                    }
                    catch (EProfileException e) {
                        logger.warn("ProfileReviewServlet: " + e.getMessage(), (Throwable)e);
                    }
                    outputset.set("outputId", outputName);
                    outputset.set("outputSyntax", outputSyntax);
                    outputset.set("outputConstraint", outputConstraint);
                    outputset.set("outputName", outputValueName);
                    outputset.set("outputVal", outputValue);
                    outputlist.add(outputset);
                }
            }
        }
        args.set("outputList", outputlist);
        this.outputTemplate(request, response, args);
    }

    private void handlePolicy(ArgList list, ServletResponse response, Locale locale, String id, ProfilePolicy policy, Request req) {
        ArgSet set = new ArgSet();
        set.set("policyId", id);
        PolicyDefault def = policy.getDefault();
        String dDesc = def.getText(locale);
        set.set("defDesc", dDesc);
        ArgList deflist = new ArgList();
        Enumeration<String> defNames = def.getValueNames();
        if (defNames != null) {
            while (defNames.hasMoreElements()) {
                ArgSet defset = new ArgSet();
                String defName = defNames.nextElement();
                IDescriptor defDesc = def.getValueDescriptor(locale, defName);
                if (defDesc == null) continue;
                String defSyntax = defDesc.getSyntax();
                String defConstraint = defDesc.getConstraint();
                String defValueName = defDesc.getDescription(locale);
                String defValue = null;
                try {
                    defValue = def.getValue(defName, locale, req);
                }
                catch (Exception exp) {
                    logger.warn("ProfileReviewServlet: " + exp.getMessage(), (Throwable)exp);
                }
                defset.set("defId", defName);
                defset.set("defSyntax", defSyntax);
                defset.set("defConstraint", defConstraint);
                defset.set("defName", defValueName);
                defset.set("defVal", defValue != null ? defValue : "");
                deflist.add(defset);
            }
        }
        set.set("defList", deflist);
        PolicyConstraint con = policy.getConstraint();
        if (con != null) {
            String conDesc = con.getText(locale);
            set.set("conDesc", conDesc);
        }
        list.add(set);
    }
}

