/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.RevocationInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveModificationsTask
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(RetrieveModificationsTask.class);
    CertificateRepository repository;
    DBSSession session;
    LDAPSearchResults results;
    ScheduledExecutorService executorService;

    public RetrieveModificationsTask(CertificateRepository repository) {
        this.repository = repository;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "RetrieveModificationsTask");
            }
        });
    }

    public void start() {
        this.executorService.schedule(this, 0L, TimeUnit.MINUTES);
    }

    public void connect() throws EBaseException {
        if (this.session != null) {
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        DBSubsystem dbSubsystem = engine.getDBSubsystem();
        try {
            this.session = dbSubsystem.createSession();
            this.results = this.repository.searchForModifiedCertificateRecords(this.session);
        }
        catch (EBaseException e) {
            this.close();
            throw e;
        }
    }

    public void retrieveModifications(LDAPEntry entry) {
        if (entry == null) {
            logger.warn("RetrieveModificationsTask: Missing LDAP entry");
            return;
        }
        logger.info("RetrieveModificationsTask: dn: " + entry.getDN());
        CAEngine engine = CAEngine.getInstance();
        DBSubsystem dbSubsystem = engine.getDBSubsystem();
        LDAPAttributeSet entryAttrs = entry.getAttributeSet();
        CertRecord certRecord = null;
        try {
            certRecord = (CertRecord)dbSubsystem.getRegistry().createObject(entryAttrs);
        }
        catch (Exception e) {
            logger.warn("RetrieveModificationsTask: " + e.getMessage(), (Throwable)e);
        }
        if (certRecord == null) {
            logger.warn("RetrieveModificationsTask: Unable to create certificate record");
            return;
        }
        String status = certRecord.getStatus();
        logger.info("RetrieveModificationsTask: status: " + status);
        if (status == null) {
            return;
        }
        if (!status.equals("VALID") && !status.equals("REVOKED")) {
            return;
        }
        for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
            if (ip == null) continue;
            if (!status.equals("REVOKED")) {
                ip.addUnrevokedCert(certRecord.getSerialNumber());
                continue;
            }
            RevocationInfo rInfo = certRecord.getRevocationInfo();
            if (rInfo == null) continue;
            RevokedCertImpl revokedCert = new RevokedCertImpl(certRecord.getSerialNumber(), rInfo.getRevocationDate(), rInfo.getCRLEntryExtensions());
            ip.addRevokedCert(certRecord.getSerialNumber(), revokedCert);
        }
    }

    public void close() {
        if (this.session == null) {
            return;
        }
        if (this.results != null) {
            try {
                this.session.abandon(this.results);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.session = null;
    }

    @Override
    public void run() {
        try {
            this.connect();
            logger.debug("Waiting for next result.");
            if (this.results.hasMoreElements()) {
                LDAPEntry entry = this.results.next();
                logger.debug("Processing " + entry.getDN() + ".");
                this.retrieveModifications(entry);
                logger.debug("Done processing " + entry.getDN() + ".");
                this.executorService.schedule(this, 0L, TimeUnit.MINUTES);
            } else if (this.executorService.isShutdown()) {
                logger.debug("Task has been shutdown.");
            } else {
                logger.debug("Persistence search ended.");
                this.close();
                logger.debug("Retrying in 1 minute.");
                this.executorService.schedule(this, 1L, TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            logger.warn("RetrieveModificationsTask: " + e.getMessage(), (Throwable)e);
            this.close();
            logger.warn("Retrying in 1 minute.");
            this.executorService.schedule(this, 1L, TimeUnit.MINUTES);
        }
    }

    public void stop() {
        this.executorService.shutdown();
        this.close();
    }
}

