/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.SecureRandom;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRequestRepository
extends RequestRepository {
    public static Logger logger = LoggerFactory.getLogger(CertRequestRepository.class);

    public CertRequestRepository(SecureRandom secureRandom, DBSubsystem dbSubsystem) {
        super(secureRandom, dbSubsystem, "(requeststate=*)");
    }

    public Request createRequest(RequestId requestID, String requestType) throws EBaseException {
        logger.debug("CertRequestRepository: Creating request " + requestID.toHexString());
        Request request = super.createRequest(requestID, requestType);
        request.setExtData("profile", "true");
        request.setExtData("requestversion", "1.0.0");
        request.setExtData("req_seq_num", "0");
        request.setExtData("requesttype", "enrollment");
        request.setExtData("requestor_name", "");
        request.setExtData("requestor_email", "");
        request.setExtData("requestor_phone", "");
        request.setExtData("profileRemoteHost", "");
        request.setExtData("profileRemoteAddr", "");
        request.setExtData("requestnotes", "");
        request.setExtData("isencryptioncert", "false");
        request.setExtData("profileapprovedby", "system");
        return request;
    }

    public void updateRequest(Request request, String requestType, byte[] binRequest, String[] dnsNames) throws Exception {
        CertificateExtensions requestExtensions;
        X509Key x509key;
        X500Name subjectName;
        logger.debug("CertRequestRepository: Updating request " + request.getRequestId().toHexString());
        logger.debug("CertRequestRepository: - type: " + requestType);
        request.setExtData("cert_request_type", requestType);
        String b64CertRequest = CryptoUtil.base64Encode((byte[])binRequest);
        String pemCertRequest = CryptoUtil.reqFormat((String)b64CertRequest);
        logger.debug("CertRequestRepository: - request:\n" + pemCertRequest);
        request.setExtData("cert_request", pemCertRequest);
        if (requestType.equals("crmf")) {
            SEQUENCE crmfMsgs = CryptoUtil.parseCRMFMsgs((byte[])binRequest);
            subjectName = CryptoUtil.getSubjectName((SEQUENCE)crmfMsgs);
            x509key = CryptoUtil.getX509KeyFromCRMFMsgs((SEQUENCE)crmfMsgs);
            requestExtensions = new CertificateExtensions();
        } else if (requestType.equals("pkcs10")) {
            PKCS10 pkcs10 = new PKCS10(binRequest);
            subjectName = pkcs10.getSubjectName();
            x509key = pkcs10.getSubjectPublicKeyInfo();
            requestExtensions = CertUtil.createRequestExtensions((PKCS10)pkcs10);
        } else {
            throw new Exception("Unsupported certificate request type: " + requestType);
        }
        logger.debug("CertRequestRepository: - subject: " + subjectName);
        request.setExtData("subject", subjectName.toString());
        request.setExtData("req_key", x509key.toString());
        request.setExtData("req_extensions", requestExtensions);
        if (dnsNames != null) {
            logger.debug("CertRequestRepository: - DNS names:");
            int i = 0;
            for (String dnsName : dnsNames) {
                logger.debug("CertRequestRepository:   - " + dnsName);
                request.setExtData("req_san_pattern_" + i, dnsName);
                ++i;
            }
        }
    }

    public void updateRequest(Request request, String profileID, String profileIDMapping, String profileSetIDMapping, boolean installAdjustValidity) throws Exception {
        logger.debug("CertRequestRepository: Updating profile for request " + request.getRequestId().toHexString());
        logger.debug("CertRequestRepository: - profile: " + profileID);
        logger.debug("CertRequestRepository: - adjust validity: " + installAdjustValidity);
        String origProfileID = profileID;
        int idx = origProfileID.lastIndexOf(46);
        if (idx > 0) {
            origProfileID = origProfileID.substring(0, idx);
        }
        request.setExtData("origprofileid", origProfileID);
        request.setExtData("profileid", profileIDMapping);
        request.setExtData("profilesetid", profileSetIDMapping);
        if (installAdjustValidity) {
            request.setExtData("installAdjustValidity", "true");
        }
    }

    public void updateRequest(Request request, X509CertImpl cert) throws Exception {
        logger.debug("CertRequestRepository: Updating cert for request " + request.getRequestId().toHexString());
        logger.debug("CertRequestRepository: - cert serial number: 0x" + cert.getSerialNumber().toString(16));
        request.setExtData("req_x509info", cert.getInfo());
        request.setExtData("req_issued_cert", cert);
    }
}

