/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.system.KRAConnectorInfo;
import com.netscape.cms.servlet.admin.KRAConnectorProcessor;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.crypto.CryptoUtil;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.dogtagpki.common.CAInfo;
import org.dogtagpki.common.CAInfoResource;
import org.dogtagpki.common.KRAInfo;
import org.dogtagpki.common.KRAInfoClient;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAInfoService
extends PKIService
implements CAInfoResource {
    private static Logger logger = LoggerFactory.getLogger(CAInfoService.class);
    private static boolean kraInfoAuthoritative = false;
    private static String archivalMechanism = "keywrap";
    private static String encryptAlgorithm;
    private static String keyWrapAlgorithm;
    private static String rsaPublicKeyWrapAlgorithm;
    private static String caRsaPublicKeyWrapAlgorithm;

    public Response getInfo() throws Exception {
        HttpSession session = this.servletRequest.getSession();
        logger.debug("CAInfoService.getInfo(): session: " + session.getId());
        CAInfo info = new CAInfo();
        this.addKRAInfo(info);
        info.setCaRsaPublicKeyWrapAlgorithm(caRsaPublicKeyWrapAlgorithm);
        return this.createOKResponse(info);
    }

    private void addKRAInfo(CAInfo info) throws Exception {
        boolean kraEnabled;
        CAEngine engine = (CAEngine)this.getCMSEngine();
        KRAConnectorInfo connInfo = null;
        try {
            KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            connInfo = processor.getConnectorInfo();
        }
        catch (Throwable processor) {
            // empty catch block
        }
        boolean bl = kraEnabled = connInfo != null && "true".equalsIgnoreCase(connInfo.getEnable());
        if (kraEnabled) {
            if (!kraInfoAuthoritative) {
                CAInfoService.queryKRAInfo(connInfo);
            }
            info.setArchivalMechanism(archivalMechanism);
            info.setEncryptAlgorithm(encryptAlgorithm);
            info.setKeyWrapAlgorithm(keyWrapAlgorithm);
            info.setRsaPublicKeyWrapAlgorithm(rsaPublicKeyWrapAlgorithm);
        }
    }

    private static void queryKRAInfo(KRAConnectorInfo connInfo) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        try (PKIClient client = CAInfoService.createPKIClient(connInfo);){
            KRAInfoClient kraInfoClient = new KRAInfoClient(client, "kra");
            KRAInfo kraInfo = kraInfoClient.getInfo();
            archivalMechanism = kraInfo.getArchivalMechanism();
            encryptAlgorithm = kraInfo.getEncryptAlgorithm();
            keyWrapAlgorithm = kraInfo.getWrapAlgorithm();
            rsaPublicKeyWrapAlgorithm = kraInfo.getRsaPublicKeyWrapAlgorithm();
            caRsaPublicKeyWrapAlgorithm = CAInfoService.getCaRsaPublicKeyWrapAlgorithm();
            kraInfoAuthoritative = true;
        }
        catch (PKIException e) {
            if (e.getCode() == 404) {
                boolean encrypt_archival;
                encryptAlgorithm = EncryptionAlgorithm.DES3_CBC_PAD.toString();
                keyWrapAlgorithm = KeyWrapAlgorithm.DES3_CBC_PAD.toString();
                try {
                    encrypt_archival = cs.getBoolean("kra.allowEncDecrypt.archival", false);
                }
                catch (EBaseException e1) {
                    encrypt_archival = false;
                }
                archivalMechanism = encrypt_archival ? "encrypt" : "keywrap";
                kraInfoAuthoritative = true;
            }
            logger.warn("Failed to retrieve archive wrapping information from the CA: " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.warn("Failed to retrieve archive wrapping information from the CA: " + e.getMessage(), e);
        }
    }

    private static PKIClient createPKIClient(KRAConnectorInfo connInfo) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        CAConfig caConfig = cs.getCAConfig();
        ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
        ConnectorConfig kraConnectorConfig = connectorsConfig.getConnectorConfig("KRA");
        ClientConfig config = new ClientConfig();
        int port = Integer.parseInt(connInfo.getPort());
        config.setServerURL("https", connInfo.getHost(), port);
        config.setNSSDatabase(CMS.getInstanceDir() + "/alias");
        Object nickname = kraConnectorConfig.getString("nickName", null);
        if (nickname == null) {
            nickname = cs.getString("ca.subsystem.nickname");
            String tokenname = cs.getString("ca.subsystem.tokenname", "");
            if (!CryptoUtil.isInternalToken((String)tokenname)) {
                nickname = tokenname + ":" + (String)nickname;
            }
        }
        config.setCertNickname((String)nickname);
        return new PKIClient(config);
    }

    private static String getCaRsaPublicKeyWrapAlgorithm() throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        boolean useOAEP = cs.getUseOAEPKeyWrap();
        return useOAEP ? "RSA_OAEP" : "RSA";
    }
}

